<?php
/**
 * um_installer
 * @author Ambroise Maupate
 * @package rezozerocms
 */
class um_installer extends rz_abstract_plugin 
{
	public static $name = "um_installer"; // Must be the same as the plugin folder name
	public static $author = "Ambroise Maupate";
	public static $version = "1.2";
	public static $description = "Ultramedia Emag system installer.(needs Ultramedia templates)";
	public static $plugin_class = "um_installer"; 
	

	/**
	 * node_types
	 *
	 * Array of rz_node_type objects to be created when plugin is installing
	 * 
	 * (default value: array())
	 * 
	 * @var array
	 * @access public
	 * @static
	 */
	public static $node_types = array(
		"amorces.rzt",
		"article.rzt",
		"asides.rzt",
		"carrousel.rzt",
		"editos.rzt",
		"embed_object.rzt",
		"events.rzt",
		"gallery.rzt",
		"issue.rzt",
		"ours.rzt",
		"quotes.rzt",
		"summary.rzt",
		"pub.rzt",
		"topic.rzt",
		"figures.rzt",
		"external_link.rzt",
		"full_images.rzt"
	);
	/**
	 * Update Um_template settings and add new node_types
	 * 
	 */
	public static function registerHooks()
	{
		rz_hook::$postCMSUpdate->registerObserver( function ()
		{	
			static::installParameters();
			rz_log::wizardLog(_('[UM Installer Plugin] Updated UM Installer parameters.'), rz_log::CONFIRM_MESSAGE);
			static::installNodeTypes();
			rz_log::wizardLog(_('[UM Installer Plugin] Updated UM Node types'), rz_log::CONFIRM_MESSAGE);
		});

		return true;
	}
	
	public static function postinstall_script () 
	{
		if(static::is_ready())
		{
			foreach(static::$custom_types as $key => $classname){
				if(!class_exists($classname)) {
					return false;
				}
			}

			$neutralT = new rz_node_type(array('name'=>'neutral'));

			/*
			 * Add column documents to neutral type
			 */
			$neutralDocuments = new rz_node_type_field();
			$neutralDocuments->node_type_id = $neutralT->node_type_id;
			$neutralDocuments->name = 'documents';
			$neutralDocuments->description = 'Documents du magazine';
			$neutralDocuments->type = rz_node_type_field::DOCUMENTS_T;
			$neutralDocuments->default_values = '';
			$neutralDocuments->group = '';

			if ($neutralDocuments->insertIntoDB() !== false && $neutralDocuments->persistField() !== false) {
					

				/* --------------------
				 * Change default template to the portfolio one
				 * -------------------- */
				$dtemplate = rz_template::get_default_template();
				if ($dtemplate !== false) {
					$dtemplate->template_folder = "um_template";
					$dtemplate->updateDB();
					rz_log::register_message(_("Switched to 'um_template' template !"), CONFIRM);
				}
			}
			else {
				rz_log::register_message(_("Impossible to add “documents” field to “neutral” node-type!"), ERROR);
			} 
		}
	}
}
?>