<?php
/**
 * portfolio_kit
 * @author Ambroise Maupate
 * @package rezozerocms
 */
class portfolio_kit extends rz_abstract_plugin 
{
	public static $name = "portfolio_kit"; // Must be the same as the plugin folder name
	public static $author = "Ambroise Maupate";
	public static $version = "0.01";
	public static $description = "Portfolio kit with basic node types and nodes";
	public static $plugin_class = "portfolio_kit"; 
	

	/**
	 * node_types
	 *
	 * Array of rz_node_type objects to be created when plugin is installing
	 * 
	 * (default value: array())
	 * 
	 * @var array
	 * @access public
	 * @static
	 */
	public static $node_types = array(
		"neutral.rzt",
		"project.rzt",
		"static_pages.rzt"
	);

	/**
	 * Array of RZC Clipboards with node to be added after plugin installation
	 * 
	 * @var array
	 */
	public static $nodes = array(
		"clipboard_home.rzc",
		"clipboard_pages_root.rzc",
		"clipboard_projects_root.rzc"
	);
	
	public static function postinstall_script () {
		if(static::is_ready())
		{
			foreach(static::$custom_types as $key => $classname){
				if(!class_exists($classname)) {
					return false;
				}
			}
			/* --------------------
			 * Change default template to the portfolio one
			 * -------------------- */
			$dtemplate = rz_template::get_default_template();
			$dtemplate->template_folder = "portfolio";
			$dtemplate->updateDB();
			rz_log::register_message(_("Switched to 'portfolio' template !"), CONFIRM);
		}
	}
}
?>