<?php
/**
 * gestion_posting
 * @author Ambroise Maupate
 * @package rezozerocms
 */
class gestion_posting extends rz_db_object 
{
	public static $primaryKey = "posting_id";
	public static $table_name = "_gestion_posting";
	public static $db_columns = array(
		"posting_id",
		"ref_posting_id",
		"contact_id",
		"reference",
		"title",
		"type",
		"creation_date",
		"lastmod_date",
		"due_date",
		"paid_date",
		"created_by",
		"lastmod_by",
		"status",
		"vat_rate",
		"currency",
		"documents_id",
		"amount",
		"vat",
		"payment_way",
		"checked",
		"bank_date",
		"ghost"
	);
	public static $db_column_types = array(
		"bigint(20) unsigned NOT NULL AUTO_INCREMENT",
		"bigint(20) unsigned NOT NULL DEFAULT '0'",
		"bigint(20) unsigned NOT NULL",
		"varchar(255) NOT NULL DEFAULT ''",
		"varchar(255) NOT NULL DEFAULT ''",
		"ENUM('note','estimate','invoice','prepaid','letter','payment','other') NOT NULL",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"bigint(20) unsigned NOT NULL",
		"bigint(20) unsigned NOT NULL",
		"ENUM('pending','paid','cancelled','draft') NOT NULL",
		"DECIMAL(15,3) NOT NULL DEFAULT '0.0'",
		"varchar(10) NOT NULL DEFAULT 'EUR'",
		"varchar(255) NOT NULL",
		"DECIMAL(15,3) NOT NULL DEFAULT '0.0'",
		"DECIMAL(15,3) NOT NULL DEFAULT '0.0'",
		"ENUM('unknown','card','cash','cheque','transfer')",
		"varchar(255) NOT NULL",
		"datetime NOT NULL",
		"boolean NOT NULL DEFAULT FALSE"
	);
	public static $db_keys = "
PRIMARY KEY (\"posting_id\"), 
KEY \"contact_id\" (\"contact_id\"), 
KEY \"type\" (\"type\"), 
KEY \"status\" (\"status\"), 
KEY \"ghost\" (\"ghost\")";
	public static $db_post = "ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Posting table for Gestion plugin'";

	private static $types = array(
		'note',
		'estimate',
		'invoice',
		'prepaid',
		'letter',
		'payment',
		'other'
	);

	private static $payments = array(
		'unknown',
		'card',
		'cash',
		'cheque',
		'transfer'
	);

	private static $statuses = array(
		'draft',
		'pending',
		'paid',
		'cancelled'
	);

	public static function getTypes()
	{
		return static::$types;
	}
	public static function getStatuses()
	{
		return static::$statuses;
	}

	public static function getPaymentsWays()
	{
		return static::$payments;
	}

	public static function getLatestInvoiceReference()
	{
		$latest = new gestion_posting(array('type'=>array("'invoice'","'prepaid'"), 'order_by'=>'due_date', 'order_direction'=>'DESC'));
		if (is_object($latest) && $latest->exists()) {
			return $latest->reference.'-copy';
		}
	}

	/**
	 * Get posting total amount VAT excluded.
	 * @return float Total amount VAT excluded
	 */
	public function getTotalAmount()
	{
		$query = "
SELECT SUM(\"amount\"*\"quantity\") as \"totalAmount\" 
FROM ".get_table_prefix()."_gestion_object 
WHERE \"posting_id\"=:posting_id 
AND \"optional\"=:optional AND \"spliter\"=:spliter";

		try {
			$preparation = db_controller::getDriver()->prepare($query);
			$preparation->execute(array(
				':posting_id'=>$this->posting_id,
				':optional'=>0,
				':spliter'=>0,
			));

			if (is_object($preparation)) {
				$result = $preparation->fetchAll(PDO::FETCH_COLUMN, 0);

				return $result[0];
			}
			else {
				return 0.0;
			}
		} catch (PDOException $e) {
			return 0.0;
		}
	}

	public function getTotalVATAmount()
	{
		return $this->getTotalVAT()+$this->getTotalAmount();
	}

	public function getTotalVAT()
	{
		$objects_vat= 0;
		$objects = gestion_object::get_rows(array(
			'posting_id'=>$this->posting_id, 
			'optional'=>0, 
			'spliter'=>0,
			'order_by'=>"order"
		));
		while ($object = gestion_object::hydrate($objects)) {
			$objects_vat += $object->getVAT();
		}

		return $objects_vat;
	}


	public function getPrepaids()
	{	
		if ($this->type == 'invoice' && $this->ref_posting_id > 0) {
			
			return gestion_posting::get_rows(array("ref_posting_id"=>$this->ref_posting_id, 'type'=>'prepaid', "order_by"=>'due_date'));
		}
		else { return null; }
	}

	public function getViewableObjects( $optional )
	{	
		if ($this->type == 'prepaid' && $this->ref_posting_id > 0) {
			
			return gestion_object::get_rows(array("posting_id"=>$this->ref_posting_id, "order_by"=>'order', 'optional'=>intval($optional)));
		}
		else { return gestion_object::get_rows(array("posting_id"=>$this->posting_id, "order_by"=>'order', 'optional'=>intval($optional))); }
	}
	public function getViewableTotal( $optional )
	{	
		if ($this->type == 'prepaid' && $this->ref_posting_id > 0) {
			
			$query = "
SELECT SUM(\"amount\"*\"quantity\") as \"totalAmount\" 
FROM ".get_table_prefix()."_gestion_object 
WHERE \"posting_id\"=:posting_id 
AND \"optional\"=:optional 
AND \"spliter\"=:spliter";

			try {
				$preparation = db_controller::getDriver()->prepare($query);
				$preparation->execute(array(
					':posting_id'=>$this->ref_posting_id,
					':optional'=>$optional,
					':spliter'=>0,
				));

				if (is_object($preparation)) {
					$result = $preparation->fetchAll(PDO::FETCH_COLUMN, 0);

					return $result[0];
				}
				else {
					return 0.0;
				}
			} catch (PDOException $e) {
				return 0.0;
			}
		}
	}
	/**
	 * Get prepaid total amount VAT excluded for this posting.
	 * @return float Total prepaid VAT included
	 */
	public function getTotalPrepaidAmount()
	{
		$total = 0;

		if ($this->type == 'invoice' && $this->ref_posting_id > 0) {
			$prepaids = gestion_posting::get_rows(array("ref_posting_id"=>$this->ref_posting_id, 'type'=>'prepaid'));

			while ($prepaid = gestion_posting::hydrate($prepaids)) {
				$total += $prepaid->getTotalAmount();
			}
		}

		return $total;
	}
	/**
	 * Get prepaid total amount VAT included for this posting.
	 * @return float Total prepaid VAT included
	 */
	public function getVATPrepaid()
	{
		$total = 0;

		if ($this->type == 'invoice' && $this->ref_posting_id > 0) {
			$prepaids = gestion_posting::get_rows(array("ref_posting_id"=>$this->ref_posting_id, 'type'=>'prepaid'));

			while ($prepaid = gestion_posting::hydrate($prepaids)) {
				$total += $prepaid->getTotalVAT();
			}
		}

		return $total;
	}
	/**
	 * Get prepaid total amount VAT included for this posting.
	 * @return float Total prepaid VAT included
	 */
	public function getTotalVATPrepaidAmount()
	{
		$total = 0;

		if ($this->type == 'invoice' && $this->ref_posting_id > 0) {
			$prepaids = gestion_posting::get_rows(array("ref_posting_id"=>$this->ref_posting_id, 'type'=>'prepaid'));

			while ($prepaid = gestion_posting::hydrate($prepaids)) {
				$total += $prepaid->getTotalVATAmount();
			}
		}

		return $total;
	}

	/**
	 * Duplicate current posting to create an invoice
	 * @return boolean TRUE if succeded
	 */
	public function transformEstimateToInvoice()
	{
		/* Duplicate posting to invoice */
		$user = rz_user::get_current_user();
		$invoice = new gestion_posting();
		$invoice->ref_posting_id 	= $this->posting_id;
		$invoice->contact_id 		= $this->contact_id;
		$invoice->title 			= $this->title;
		$invoice->reference 		= static::getLatestInvoiceReference();
		$invoice->type				= 'invoice';
		$invoice->due_date 			= date("Y-m-d H:i:s");
		$invoice->paid_date 		= $this->paid_date;
		$invoice->created_by 		= $user->user_id;
		$invoice->lastmod_by 		= $user->user_id;
		$invoice->status 			= 'draft';
		$invoice->vat_rate 			= $this->vat_rate;
		$invoice->currency 			= $this->currency;
		// $invoice->documents_id 		= $this->documents_id;

		if ($invoice->insertIntoDB() !== false) 
		{
			/* Duplicate objects */
			$objects = gestion_object::get_rows(array("posting_id"=>$this->posting_id));
			while ($object = gestion_object::hydrate($objects)) {
				$object->unset_primary_key();
				$object->posting_id = $invoice->posting_id;

				$object->insertIntoDB();
			}
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * Duplicate current posting to create a prepaid invoice
	 * @return boolean TRUE if succeded
	 */
	public function transformEstimateToPrepaidInvoice()
	{
		/* Duplicate posting to invoice */
		$user = rz_user::get_current_user();
		$invoice = new gestion_posting();
		$invoice->ref_posting_id 	= $this->posting_id;
		$invoice->contact_id 		= $this->contact_id;
		$invoice->title 			= $this->title;
		$invoice->reference 		= static::getLatestInvoiceReference();
		$invoice->type				= 'prepaid';
		$invoice->due_date 			= date("Y-m-d H:i:s");
		$invoice->paid_date 		= $this->paid_date;
		$invoice->created_by 		= $user->user_id;
		$invoice->lastmod_by 		= $user->user_id;
		$invoice->status 			= 'draft';
		$invoice->vat_rate 			= $this->vat_rate;
		$invoice->currency 			= $this->currency;
		// $invoice->documents_id 		= $this->documents_id;

		if ($invoice->insertIntoDB() !== false) 
		{	
			return true;
		}
		else { return false; }
	}


	/**
	 * deleteFromDB
	 * @author Ambroise Maupate
	 */
	public function deleteFromDB( $key="" )
	{		
		$objects = gestion_object::get_rows(array("posting_id"=>$this->posting_id));
		while ($object = gestion_object::hydrate($objects)) {
			$object->deleteFromDB();
		}

		if (parent::deleteFromDB($key)) {
			return true;
		}
		else {
			return false;
		}
	}

	public function getNoteAmount()
	{
		if ($this->getTotalVATAmount() > 0.0) {
			return $this->getTotalVATAmount();
		}
		else {
			return $this->amount;
		}
	}
	public function getNoteVATAmount()
	{
		if ($this->getTotalVATAmount() > 0.0) {
			return $this->getTotalVAT();
		}
		else {
			return $this->vat;
		}
	}
	public function getPaymentWay()
	{
		return $this->payment_way;
	}
	public function checked()
	{
		return $this->checked;
	}

	public function displayCheckStatusRow()
	{	
		$displayDate = "";
		if (!empty($this->bank_date) && $this->bank_date != "0000-00-00 00:00:00") {
			$displayDate = strftime("%d/%m/%Y", strtotime($this->bank_date));
		}
		?>
		<!-- Bank checking -->
		<td class="checked <?php echo ($this->checked != "0" && $this->checked != "")?"yes":"no" ?>"><!-- 
			 --><span class='icon'></span><!-- 
			 --><span class="date"><?php echo ($this->checked != "0" && $this->checked != "")?$displayDate:"" ?></span><!-- 
			 --><span class="reference"><?php echo ($this->checked != "0" && $this->checked != "")?$this->checked:"" ?></span>
		</td>
		<?php
	}

	public function displayCheckStatusForm()
	{	
		$formName = $this->type;
		if ($this->type == "prepaid") {
			$this->type = "invoice";
		}
		?>
		<!-- Bank checking -->
		<fieldset class="check_form">
			<legend><?php echo(dgettext("template", "Checked")); ?></legend>

			<label for="<?php echo $this->type ?>_checked">
				<?php echo(dgettext("template", "Listing reference")); ?>
			</label>
			<input id="<?php echo $this->type ?>_checked" 
				type="text" 
				name="<?php echo $this->type ?>[checked]" 
				value="<?php echo($this->checked) ?>" />
			<label for="<?php echo $this->type ?>_bank_date">
				<?php echo(dgettext("template", "Bank date")); ?>
			</label>
			<input id="<?php echo $this->type ?>_bank_date"
				type="datetime" 
				name="<?php echo $this->type ?>[bank_date]" 
				value="<?php echo($this->bank_date) ?>" />
		</fieldset>
		<?php
	}
}

?>