<?php
/**
 * gestion_object
 * @author Ambroise Maupate
 * @package rezozerocms
 */
class gestion_object extends rz_db_object 
{
	public static $primaryKey = "object_id";
	public static $table_name = "_gestion_object";
	public static $db_columns = array(
		"object_id",
		"title",
		"description",
		"quantity",
		"vat_rate",
		"amount",
		"quantity_type",
		"optional",
		"posting_id",
		"creation_date",
		"lastmod_date",
		"spliter",
		"order"
	);
	public static $db_column_types = array(
		"bigint(20) unsigned NOT NULL AUTO_INCREMENT",
		"varchar(255) NOT NULL",
		"text NOT NULL",
		"DECIMAL(15,5) NOT NULL DEFAULT '1'",
		"DECIMAL(15,3) NOT NULL DEFAULT '20.0'",
		"DECIMAL(15,3) NOT NULL DEFAULT '0'",
		"ENUM('day','hour','item','constant', 'percent') NOT NULL",
		"tinyint(1) unsigned NOT NULL DEFAULT '0'",
		"bigint(20) unsigned NOT NULL",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"tinyint(1) unsigned NOT NULL DEFAULT '0'",
		"bigint(20) unsigned NOT NULL"
	);
	public static $db_keys = "PRIMARY KEY (\"object_id\"), KEY \"posting_id\" (\"posting_id\"), KEY \"order\" (\"order\")";
	public static $db_post = "ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Object table for Gestion plugin'";

	/**
	 * Get object total amount with VAT
	 * @return [type] [description]
	 */
	public function getVATTotal()
	{
		return ($this->amount*$this->quantity)*(1+($this->vat_rate/100.0));
	}

	/**
	 * Get object total VAT
	 * @return [type] [description]
	 */
	public function getVAT()
	{
		return ($this->amount*$this->quantity)*(($this->vat_rate/100.0));
	}

	public function getTotal()
	{
		return ($this->amount*$this->quantity);
	}

	/**
	 * Get max order for a given posting id
	 * @param  [type] $posting_id [description]
	 * @return [type]             [description]
	 */
	public static function getLastOrder( $posting_id )
	{
		if (is_numeric($posting_id) && $posting_id > 0) {

			$query = "SELECT MAX(\"order\") as maxorder FROM ".rz_core::getTablePrefix()."_gestion_object WHERE \"posting_id\"='".intval($posting_id)."' ";

			try {
				$result = db_controller::getDriver()->query($query);
				if (is_object($result)) {
					$result = $result->fetchObject();
					return $result->maxorder;
				}
				else {
					return false;
				}
			} catch (PDOException $e) {
				return false;
			}
		}
		else {
			return false;
		}
	}

	/**
	 * Clean objects order in a given posting
	 * @param  [type] $posting_id [description]
	 * @return [type]             [description]
	 */
	public static function cleanOrders( $posting_id )
	{
		$iOrder = 1;

		$objects = static::get_rows(array("posting_id"=>intval($posting_id), "order_by"=>'order'));
		while ($object = static::hydrate($objects)) {
			$object->order = $iOrder;
			$object->updateDB();

			$iOrder++;
		}

		return true;
	}

	/**
	 * setOrderInPosting
	 * @author Ambroise Maupate
	 */
	public function setOrderInPosting( $posting_id, $new_order)
	{		
		$new_order = intval($new_order);
		$posting_id = intval($posting_id);

		if ($new_order > 0 && $this->exists()) {

			// Go back in order
			if ($this->order > $new_order) {

				// 2. Add 1 to following works
				$query = db_controller::getDriver()->exec("UPDATE ".get_table_prefix()."_gestion_object 
									SET \"order\" = \"order\" + 1
									WHERE (posting_id = ".$posting_id." AND \"order\" >= ".$new_order." AND \"order\" < ".$this->order.")");

				// 3. Set the work at the new order
				$this->order = $new_order;
			}
			// Go further in order
			else if ($this->order < $new_order) {

				// 2. Substract 1 to previous works
				$query = db_controller::getDriver()->exec("UPDATE ".get_table_prefix()."_gestion_object 
									SET \"order\" = \"order\" - 1
									WHERE (posting_id = ".$posting_id." AND \"order\" <= ".$new_order." AND \"order\" > ".$this->order.")");

				// 3. Set the work at the new order
				$this->order = $new_order;
			}
			$this->updateDB();
			static::cleanOrders($posting_id);

			clean_pear_cache();
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * get edit form 
	 * @return [type] [description]
	 */
	public function getEditForm( $readOnly=false )
	{
		ob_start();
		if ($this->spliter == 0) 
		{
		
		?><fieldset id="object_<?php echo($this->object_id); ?>">

			<div class='title'>
			<label><?php echo(dgettext("template", "Title")); ?></label>
			<textarea  
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				placeholder="<?php echo(dgettext("template", "Title")); ?>"  
				class='title'  
				name='object[<?php echo($this->object_id); ?>][title]'><?php echo($this->title); ?></textarea>
			</div>

			<div class='description'>
			<label><?php echo(dgettext("template", "Description")); ?></label>
			<textarea 
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				placeholder="<?php echo(dgettext("template", "Description")); ?>"  
				class='description'  
				name='object[<?php echo($this->object_id); ?>][description]'><?php echo($this->description); ?></textarea>
			</div>

			<div class='quantity'>
			<label><?php echo(dgettext("template", "Quantity")); ?></label>
			<input 
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				placeholder="<?php echo(dgettext("template", "Quantity")); ?>"  
				type='number' 
				class='quantity'  
				step='any' 
				name='object[<?php echo($this->object_id); ?>][quantity]' 
				value='<?php echo($this->quantity); ?>' />
			</div>

			<div class='quantity_type'>
			<label><?php echo(dgettext("template", "Type")); ?></label>
			<select
				<?php echo(($readOnly)?('disabled '):('')) ?> 
				name="object[<?php echo($this->object_id); ?>][quantity_type]">
				<option <?php echo(($this->quantity_type == 'day')?('selected'):('')) ?> 
					value="day"><?php echo(dgettext("template", "Day")); ?></option>
				<option <?php echo(($this->quantity_type == 'hour')?('selected'):('')) ?> 
					value="hour"><?php echo(dgettext("template", "Hour")); ?></option>
				<option <?php echo(($this->quantity_type == 'item')?('selected'):('')) ?> 
					value="item"><?php echo(dgettext("template", "Item")); ?></option>
				<option <?php echo(($this->quantity_type == 'constant')?('selected'):('')) ?> 
					value="constant"><?php echo(dgettext("template", "Fixed")); ?></option>
				<option <?php echo(($this->quantity_type == 'percent')?('selected'):('')) ?> 
					value="percent"><?php echo(dgettext("template", "Percent")); ?></option>
			</select>
			</div>

			<div class='amount'>
			<label><?php echo(dgettext("template", "Amount")); ?></label>
			<input 
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				placeholder="<?php echo(dgettext("template", "Amount")); ?>"  
				type='number' 
				class='amount'  
				step='any' 
				name='object[<?php echo($this->object_id); ?>][amount]' 
				value='<?php echo($this->amount); ?>' />
			</div>

			<div class='vat_rate'>
			<label><?php echo(dgettext("template", "VAT")); ?></label>
			<input 
				type='number' 
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				class='vat_rate'  
				placeholder="<?php echo(dgettext("template", "VAT")); ?>"  
				step='any' 
				name='object[<?php echo($this->object_id); ?>][vat_rate]' 
				value='<?php echo($this->vat_rate); ?>' />
			</div>

			<div class='optional'>
			<label><?php echo(dgettext("template", "Optional")); ?></label>
			<input type='checkbox' 
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				name='object[<?php echo($this->object_id); ?>][optional]' 
				<?php echo(($this->optional == 1)?('checked'):''); ?> 
				value='1' />
			</div>

			<?php if (!$readOnly): ?>
			<div class='order'>			
			<span class="object_handle"><?php echo(dgettext("template", "Order")); ?><span class='icon'></span></span>
			</div>
			<div class='delete'>
			<a href="#" onclick="$('#delete_object_<?php echo($this->object_id) ?>').submit(); return false;" class="object_delete"><?php echo(dgettext("template", "Delete")); ?><span class='icon'></span></a>
			</div>
			<?php endif ?>
		</fieldset><?php

		}
		/*
		 * ============================================================================
		 * Splitter
		 * ============================================================================
		 */
		else 
		{ 
		?><fieldset id="object_<?php echo($this->object_id); ?>">
			<div class='spliter'>	
			<label><?php echo(dgettext("template", "Spliter")); ?></label>
			</div>
			<div class='optional'>
			<label><?php echo(dgettext("template", "Optional")); ?></label>
			<input type='checkbox' 
				<?php echo(($readOnly)?('disabled  '):('')) ?>
				name='object[<?php echo($this->object_id); ?>][optional]' 
				<?php echo(($this->optional == 1)?('checked'):''); ?> 
				value='1' />
			</div>

			<?php if (!$readOnly): ?>				
			<div class='order'>			
			<span class="object_handle"><?php echo(dgettext("template", "Order")); ?><span class='icon'></span></span>
			</div>
			<div class='delete'>
			<a href="#" onclick="$('#delete_object_<?php echo($this->object_id) ?>').submit(); return false;" class="object_delete"><?php echo(dgettext("template", "Delete")); ?><span class='icon'></span></a>
			</div>
			<?php endif ?>
		</fieldset><?php
		}
		$html = ob_get_contents();
		ob_end_clean();

		return $html;
	}

	/**
	 * get delete form in HTML
	 * @return [type] [description]
	 */
	public function getDeleteForm( $formType = "estimate" )
	{
		ob_start();

		?><form 
			id="delete_object_<?php echo($this->object_id) ?>"  
			method="post" 
			action="<?php echo rz_core::getBaseFolder()."edit_".$formType."/?posting_id=".$this->posting_id ?>">

			<input type="hidden" name="object[delete]" value="1" />
			<input type="hidden" name="object[object_id]" value="<?php echo($this->object_id) ?>" />
			<input type="hidden" name="object[posting_id]" value="<?php echo($this->posting_id) ?>" />
			<input type="hidden" name="object[checksum]" value="<?php echo rz_user::get_checksum(); ?>" />
		</form><?php

		$html = ob_get_contents();
		ob_end_clean();

		return $html;
	}


	public function getDisplayRow( $quantity_type_text )
	{
		$quantity_type_trans = array(
			'day' => dgettext("template", "day"),
			'hour' => dgettext("template", "hour"),
			'item' => dgettext("template", "item"),
			'constant' => dgettext("template", "Fixed"),
			'percent' => dgettext("template", "Percent"),
		);
		
		ob_start();

		?><tr>
			<td class="title <?php echo $this->quantity_type ?>" <?php if ($this->quantity == 0): ?>colspan="3"<?php endif; ?>>
				<h4><?php echo($this->title); ?></h4>
				<div class="description"><?php echo(Markdown($this->description)); ?></div>
			</td>
			<?php if ($this->quantity == 0): ?>
			<td colspan="2" class='void'></td>
			<?php else: ?>
				<?php if ($this->quantity_type == 'percent'): ?>	
				<td class="amount"></td>
				<td class="quantity"><?php printf("%.1f %%", $this->quantity*100); ?></td>
				<td class="vat_rate"></td>
				<?php elseif ($this->quantity_type == 'constant'): ?>	
				<td class="amount"><?php printf("%.2f", $this->amount); ?></td>
				<td class="quantity"><?php echo($quantity_type_trans[$this->quantity_type]); ?></td>
				<td class="vat_rate"><?php printf("%.2f", $this->vat_rate); ?></td>
				<?php else: ?>
				<td class="amount"><?php printf("%.2f", $this->amount); ?></td>
				<td class="quantity"><?php printf("%.1f", $this->quantity); ?> <?php echo($quantity_type_text); ?></td>
				<td class="vat_rate"><?php printf("%.2f", $this->vat_rate); ?></td>
				<?php endif; ?>
				
				<td class="total amount"><?php printf("%.2f", $this->getTotal()); ?></td>
			<?php endif; ?>
		</tr><?php

		$html = ob_get_contents();
		ob_end_clean();

		return $html;
	}
}

?>