<?php
/**
 * gestion_prepaid
 * @author Ambroise Maupate
 * @package rezozerocms
 */
class gestion_prepaid extends rz_db_object 
{
	public static $primaryKey = "prepaid_id";
	public static $table_name = "_gestion_prepaid";
	public static $db_columns = array(
		"prepaid_id",
		"creation_date",
		"lastmod_date",
		"due_date",
		"paid_date",
		"vat_rate",
		"amount",
		"posting_id",
	);
	public static $db_column_types = array(
		"bigint(20) unsigned NOT NULL AUTO_INCREMENT",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"datetime NOT NULL",
		"DECIMAL(15,5) NOT NULL DEFAULT '0.0'",
		"DECIMAL(15,5) NOT NULL DEFAULT '0'",
		"bigint(20) unsigned NOT NULL"
	);
	public static $db_keys = "PRIMARY KEY (\"prepaid_id\"), KEY \"posting_id\" (\"posting_id\")";
	public static $db_post = "ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Prepaid table for Gestion plugin'";

	
	public function getAmountVATIncluded()
	{
		return $this->amount*(1+($this->vat_rate/100.0));
	}
}

?>