<?php

/**
 * gestion
 * @author Ambroise Maupate
 * @package rezozerocms
 */
class gestion extends rz_abstract_plugin 
{
	public static $name = "gestion"; // Must be the same as the plugin folder name
	public static $author = "Ambroise Maupate";
	public static $version = "1.1";
	public static $description = "Gestion plugin";
	public static $plugin_class = "gestion"; 
	
	/**
	 * files
	 * List all plugin files to check integrity
	 * 
	 * (default value: array())
	 * 
	 * @var array
	 * @access public
	 */
	public static $files = array();
	public static $js_files = array();
	public static $css_files = array();
	
	/**
	 * custom_types
	 *
	 * Array of rz_db_object objects to be created when plugin is installing
	 * 
	 * (default value: array())
	 * 
	 * @var array
	 * @access public
	 * @static
	 */
	public static $custom_types = array(
		"gestion_posting", 
		"gestion_object", 
		"gestion_contact", 
		"gestion_fixed_asset", 
		"gestion_prepaid"
	);

	public static function registerHooks()
	{
		/*rz_hook::$preTemplate->registerObserver(function(){
			rz_log::postSystemLog('Hook preTemplate');
		});*/
		/*rz_hook::$postGlobalVars->registerObserver(function(){
			global $admin_entries, $users_ranks;

			$admin_entries['gestion'] = dgettext("template", "Gestion plugin");
			$users_ranks[] = dgettext("template", "Financial director");
		});*/
	}
	

	public static function postinstall_script () {
		if(static::is_ready()){
			foreach(static::$custom_types as $key => $classname){
				if(!class_exists($classname)) {
					return false;
				}
			}

			/* --------------------
			 * Change default template to the portfolio one
			 * -------------------- */
			$dtemplate = rz_template::get_default_template();
			$dtemplate->template_folder = "gestion";
			$dtemplate->updateDB();
			rz_log::register_message(_("Switched to 'gestion' template !"), CONFIRM);

			/*
			 * ============================================================================
			 * Create permissions and roles
			 * ============================================================================
			 */
			$readFinancialDetail = new rz_permission();
			$readFinancialDetail->description = 'viewFinancialDetails';

			$writeFinancialDetail = new rz_permission();
			$writeFinancialDetail->description = 'editFinancialDetails';

			if ($readFinancialDetail->insertIntoDB() !== false && 
				$writeFinancialDetail->insertIntoDB() !== false) {
				/*
				 * Financial view can only view financial records
				 */
				$financialViewer = new rz_role();
				$financialViewer->name = 'Financial viewer';
				if ($financialViewer->insertIntoDB() !== false) 
				{
					$readRolePerms = new roles_permissions_joint();
					$readRolePerms->role_id = 		$financialViewer->role_id;
					$readRolePerms->permission_id = $readFinancialDetail->permission_id;
					$readRolePerms->insertIntoDB();
				}

				/*
				 * Financial editor manage records
				 */
				$financialEditor = new rz_role();
				$financialEditor->name = 'Financial editor';
				if ($financialEditor->insertIntoDB() !== false) 
				{
					$readRolePerms = new roles_permissions_joint();
					$readRolePerms->role_id = 		$financialEditor->role_id;
					$readRolePerms->permission_id = $readFinancialDetail->permission_id;
					$readRolePerms->insertIntoDB();

					$writeRolePerms = new roles_permissions_joint();
					$writeRolePerms->role_id = 			$financialEditor->role_id;
					$writeRolePerms->permission_id = 	$writeFinancialDetail->permission_id;
					$writeRolePerms->insertIntoDB();
				}
			}

		}
	}
}