#!/bin/bash
#
export DEBIAN_FRONTEND=noninteractive

DBHOST=localhost
DBNAME=rzcms
DBUSER=rzcms
DBPASSWD=rzcms

echo -e "\n--- Okay, installing now... ---\n"
echo -e "\n--- Updating packages list ---\n"
sudo apt-get -qq update;

echo -e "\n--- Install base packages ---\n"
sudo locale-gen fr_FR.utf8;

echo -e "\n--- Add some repos to update our distro ---\n"
sudo add-apt-repository ppa:ondrej/php5 > /dev/null 2>&1

echo -e "\n--- Updating packages list ---\n"
sudo apt-get -qq update;

echo -e "\n--- Install MySQL specific packages and settings ---\n"
sudo debconf-set-selections <<< "mariadb-server-10.0 mysql-server/root_password password $DBPASSWD"
sudo debconf-set-selections <<< "mariadb-server-10.0 mysql-server/root_password_again password $DBPASSWD"
sudo debconf-set-selections <<< "phpmyadmin phpmyadmin/dbconfig-install boolean true"
sudo debconf-set-selections <<< "phpmyadmin phpmyadmin/app-password-confirm password $DBPASSWD"
sudo debconf-set-selections <<< "phpmyadmin phpmyadmin/mysql/admin-pass password $DBPASSWD"
sudo debconf-set-selections <<< "phpmyadmin phpmyadmin/mysql/app-pass password $DBPASSWD"
sudo debconf-set-selections <<< "phpmyadmin phpmyadmin/reconfigure-webserver multiselect none"

echo -e "\n--- Install base servers and packages ---\n"
sudo apt-get -qq -f -y install git nginx mariadb-server mariadb-client php5-fpm curl > /dev/null 2>&1;
echo -e "\n--- Install all php5 extensions ---\n"
sudo apt-get -qq -f -y install php5-cli php5-mysqlnd php5-curl php5-gd php5-intl php5-imagick php5-imap php5-mcrypt php5-memcached php5-ming php5-ps php5-pspell php5-recode php5-sqlite php5-tidy php5-xmlrpc php5-xsl php5-xcache php5-xdebug phpmyadmin > /dev/null 2>&1;

echo -e "\n--- Setting up our MySQL user and db ---\n"
sudo mysql -uroot -p$DBPASSWD -e "CREATE DATABASE $DBNAME"
mysql -uroot -p$DBPASSWD -e "grant all privileges on $DBNAME.* to '$DBUSER'@'localhost' identified by '$DBPASSWD'"

echo -e "\n--- We definitly need to see the PHP errors, turning them on ---\n"
sed -i "s/error_reporting = .*/error_reporting = E_ALL/" /etc/php5/fpm/php.ini
sed -i "s/display_errors = .*/display_errors = On/" /etc/php5/fpm/php.ini

echo -e "\n--- We definitly need to upload large files ---\n"
sed -i "s/server_tokens off;/server_tokens off;\\n\\tclient_max_body_size 256M;/" /etc/nginx/nginx.conf

echo -e "\n--- Configure Nginx virtual host for Roadiz and phpmyadmin ---\n"
sudo rm /etc/nginx/sites-available/default;
sudo touch /etc/nginx/sites-available/default;
sudo cat >> /etc/nginx/sites-available/default <<'EOF'
server {
    listen   80;
    root /var/www;
    index index.php index.html index.htm;
    # Make site accessible from every domains
    server_name _;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-XSS-Protection "1; mode=block";
    add_header X-Content-Type-Options "nosniff";

    # Specify a character set
    charset utf-8;

    # Use Front-end controller pattern for RZ-CMS, Wordpress and others CMS…
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    # Don't log robots.txt or favicon.ico files
    location = /favicon.ico { log_not_found off; access_log off; }
    location = /robots.txt  { allow all; access_log off; log_not_found off; }

    # pass the PHP scripts to FastCGI server
    location ~ \.php$ {
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        fastcgi_split_path_info ^(.+\.php)(/.+)$;
        fastcgi_pass unix:/var/run/php5-fpm.sock;
        include fastcgi_params;
    }

    # deny access to .htaccess files, if Apache's document root
    # concurs with nginx's one
    #
    location ~ /\.ht {
        deny all;
    }

    # Deny acces to private folders
    location /fonts {
        deny all;
    }
    location /rz-core {
        deny all;
    }
    location /private_documents {
        deny all;
    }
    location /cache {
        deny all;
    }
    location /rz-conf {
        deny all;
    }

    ### phpMyAdmin ###
    location /phpmyadmin {
      root /usr/share/;
      index index.php index.html index.htm;
      location ~ ^/phpmyadmin/(.+\.php)$ {
        client_max_body_size 4M;
        client_body_buffer_size 128k;
        try_files $uri =404;
        root /usr/share/;
        # Point it to the fpm socket;
        fastcgi_pass unix:/var/run/php5-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include /etc/nginx/fastcgi_params;
      }
      location ~* ^/phpmyadmin/(.+\.(jpg|jpeg|gif|css|png|js|ico|html|xml|txt)) {
        root /usr/share/;
      }
    }
    location /phpMyAdmin {
      rewrite ^/* /phpmyadmin last;
    }
}
server {
    listen   80;
    root /var/www;
    index index.php index.html index.htm;
    # Make site accessible from http://m.localhost/
    server_name m.localhost;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-XSS-Protection "1; mode=block";
    add_header X-Content-Type-Options "nosniff";

    # Specify a character set
    charset utf-8;

    # Use Front-end controller pattern for RZ-CMS, Wordpress and others CMS…
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    # Don't log robots.txt or favicon.ico files
    location = /favicon.ico { log_not_found off; access_log off; }
    location = /robots.txt  { allow all; access_log off; log_not_found off; }

    # pass the PHP scripts to FastCGI server
    location ~ \.php$ {
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        fastcgi_split_path_info ^(.+\.php)(/.+)$;
        fastcgi_pass unix:/var/run/php5-fpm.sock;
        include fastcgi_params;
    }

    # deny access to .htaccess files, if Apache's document root
    # concurs with nginx's one
    #
    location ~ /\.ht {
        deny all;
    }

    # Deny acces to private folders
    location /fonts {
        deny all;
    }
    location /rz-core {
        deny all;
    }
    location /private_documents {
        deny all;
    }
    location /cache {
        deny all;
    }
    location /rz-conf {
        deny all;
    }
}
EOF

echo -e "\n--- Configure PHP-FPM default pool ---\n"
sudo rm /etc/php5/fpm/pool.d/www.conf;
sudo touch /etc/php5/fpm/pool.d/www.conf;
sudo cat >> /etc/php5/fpm/pool.d/www.conf <<'EOF'
[www]
user = www-data
group = www-data
listen = /var/run/php5-fpm.sock
listen.owner = www-data
listen.group = www-data
pm = ondemand
pm.max_children = 4
php_value[max_execution_time] = 120
php_value[post_max_size] = 256M
php_value[upload_max_filesize] = 256M
php_value[display_errors] = On
php_value[error_reporting] = E_ALL
EOF

echo -e "\n--- Restarting servers ---\n"
sudo service nginx restart
sudo service php5-fpm restart

# Set envvars
export DB_HOST=$DBHOST
export DB_NAME=$DBNAME
export DB_USER=$DBUSER
export DB_PASS=$DBPASSWD

echo -e "\n--------------------------------------------------------------------"
echo -e "\n------------- Your RZCMS Vagrant is ready in /var/www --------------"
echo -e "\n--------------------------------------------------------------------"
echo -e "\nDo not forget to create rz-conf/INSTALL file to enable install mode."
echo -e "\n* Type http://localhost:8080 to proceed to install."
echo -e "\n* Type http://localhost:8080/phpmyadmin for your MySQL db admin."
echo -e "\n* MySQL User: $DBUSER"
echo -e "\n* MySQL Password: $DBPASSWD"
echo -e "\n* MySQL Database: $DBNAME"
echo -e "\n--------------------------------------------------------------------"
