<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');

// Active color
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$couleur = "background-color:rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ",  0.14) !important";


$post_ID = get_post($id);

$title_actu = $post_ID->post_title;
$content_actu = $post_ID->post_content;

$terms_actu = get_the_terms($post_ID, 'etiquette_actu', array('hide_empty' => false));
?>

<main role="main">
    <section>
        <div class="viewport news-article">
            <style>
                body{
                    background: none;
                }
                h2.over-title, .tag-container h3{
                    font-weight: bold;
                }
                .news-article .tag-container .return {
                    color:#666;
                    transition: color 0.3s linear, border-color 0.3s linear;
                }
                .news-article .tag-container .return:hover {
                    color:#000;
                    transition: color 0.3s linear, border-color 0.3s linear;
                }
                nav[role="social"]{
                    display: none;
                }
                .page_navigation{
                    position: fixed;
                    left: 1018.5px;
                    top: 236px;
                    right: auto;
                }

                .page_navigation ul{
                    float:left;
                    margin:5px;
                }

                .page_navigation li.share-ico{
                    background-image: url(../img/set_icons.png);
                    background-repeat: no-repeat;
                    background-size: 690px 480px;
                    image-rendering: optimizeSpeed;
                    image-rendering: pixellated;
                    image-rendering: -o-crisp-edges;
                    image-rendering: -webkit-optimize-contrast;
                    image-rendering: optimize-contrast;
                    -ms-interpolation-mode: nearest-neighbor;
                    display: block;
                    float: left;
                    width: 60px;
                    height: 50px;
                    cursor: pointer;
                    background-position: -240px -360px;
                    margin-right: -15px;
                }
                .page_navigation li.share-ico:hover{
                    background-position: -240px -420px;
                }

                .page_navigation li span.count{
                    display:none;
                    position: absolute;
                    width: 25px;
                    height: 25px;
                    text-indent: 0;
                    right: 5px;
                    top: 5px;
                    color: white;
                    border-radius: 12px;
                    text-align: center;
                    padding: 3px;
                    border: 2px solid rgba(0,0,0,.14);
                }

                .submenusocial{
                    margin-left:-1px;
                    margin-top: 60px;
                    position:absolute;
                    width:65px;
                    z-index:1;
                }

                .submenusocial li{
                    display:block;
                    background-image: url(../img/set_icons.png);
                    background-repeat: no-repeat;
                    background-size: 690px 480px;
                    image-rendering: optimizeSpeed;
                    image-rendering: pixellated;
                    image-rendering: -o-crisp-edges;
                    image-rendering: -webkit-optimize-contrast;
                    image-rendering: optimize-contrast;
                    -ms-interpolation-mode: nearest-neighbor;
                    display: block;
                    float: left;
                    width: 60px;
                    height: 50px;
                    cursor: pointer;
                }
                .submenusocial a{
                    width: 50px;
                    height: 40px;
                    display: block;
                    margin-top: 10px;
                    margin-left: 5px;
                    text-decoration: none;
                }

                .submenusocial a.ico-share-facebook{
                    background-position: -120px -180px;
                }
                .submenusocial a:hover{
                    background-position: -120px -240px;
                }

                .submenusocial a.ico-share-twitter{
                    background-position: -180px -180px;
                }
                .submenusocial a:hover{
                    background-position: -180px -240px;
                }

                .submenusocial a.ico-share-scoopit{
                    background-position: -480px -240px;
                }
                .submenusocial a:hover{
                    background-position: -480px -300px;
                }

                .submenusocial a.ico-share-google{
                    background-position: -420px -240px;
                }
                .submenusocial a:hover{
                    background-position: -420px -300px;
                }

                .submenusocial a.ico-share-linkedin{
                    background-position: -600px -240px;
                }
                .submenusocial a:hover{
                    background-position: -600px -300px;
                }

                .submenusocial a.ico-share-mail{
                    background-position: -480px -120px;
                }
                .submenusocial a:hover{
                    background-position: -480px -180px;
                }

                .submenusocial a.ico-share-print{
                    background-position: -360px -120px;
                    width: 50px;
                    height: 40px;
                    display: block;
                    margin-top: 10px;
                    margin-left: 5px;
                }
                .submenusocial a:hover{
                    background-position: -360px -180px;
                }

                ul li ul{
                    overflow:hidden;
                    height:0px;
                    opacity:0;
                }

                .share-open{
                    height:500px !important;
                    opacity:1 !important;
                    overflow:hidden;
                }
                .article-title {
                    color:#C40053;
                }
                .article-content > blockquote {
                    background-color:#C40053;
                }
                .article-excerpt {
                    border-left-color:#C40053;
                }
                .article-filters ul li a {
                    background-color:#C40053;
                }
                .article-body .cover {
                    background-color:#C40053;
                }
                .news-article .page_navigation a{
                    background:none;
                }
                .page_navigation{
                    position:fixed!important;
                    top:236px!important;
                    left:50%!important;
                }
            </style>
            <div class="news-columned-container">
                <article class="article-body">
                    <figure class="cover"></figure>
                    <div class="tag-container">
                        <?php $post_id_parent = get_field('wall_dactualites', false, false); ?>
                        <h3><?php echo get_the_title($post_id_parent); ?></h3>
                        <?php
                        if (!empty($terms_actu)) {
                            foreach ($terms_actu as $term_actu) {
                                ?><h3><?php echo $term_actu->name ?></h3><?php
                            }
                            ?>
                            <a href="<?php the_field('wall_dactualites'); ?>?tagged=<?php echo $terms_actu[0]->slug ?>" class="return">Retour à <em><?php echo $terms_actu[0]->name ?></em></a>
                            <?php
                        } else {
                            ?>
                            <a href="<?php the_field('wall_dactualites'); ?>" class="return">Retour</a>
                            <?php
                        }
                        ?>
                        <span class="line"></span>
                    </div>
                    <header class="article-header">
                        <?php if (get_field('sous_titre_actu')) { ?>
                            <h2 class="over-title"><?php the_field('sous_titre_actu', $post_ID); ?></h2>
                        <?php } ?>
                        <?php if (!empty($content_actu)) { ?>
                            <h1 class="article-title"><?php echo $title_actu; ?></h1>
                        <?php } ?>
                        <?php if (get_field('auteur_actu')) { ?>
                            <p class="author">par <span class="author_name"><?php the_field('auteur_actu', $post_ID); ?></span></p>
                        <?php } ?>
                        <?php
                        if (get_field('date_actu')) {
                            $date = get_field('date_actu', false, false);
                            $date = new DateTime($date);
                            ?>
                            <time class="article-date" datetime="<?php echo $date->format('j/m/y'); ?>">le <?php echo $date->format('j/m/y'); ?></time>
                        <?php } ?>

                        <nav class="page_navigation" role='social'>
                            <ul>
                                <li class="share-ico">
                                    <ul class="submenusocial">
                                        <li class="ico-share-facebook">
                                            <a href="http://www.facebook.com/dialog/feed?app_id=<?php echo $fb_app_id; ?>&link=<?php echo $share_url; ?>" data-original-title="Facebook" target="_blank">&nbsp;</a>
                                        </li>
                                        <li class="ico-share-twitter">
                                            <a href="https://twitter.com/share?url=<?php echo $share_url; ?>" data-original-title="Twitter" target="_blank">&nbsp;</a>
                                        </li>
                                        <li class="ico-share-scoopit">
                                            <a href="http://www.scoop.it/bookmarklet?url=<?php echo $share_url; ?>" data-original-title="Scoop it !" target="_blank">&nbsp;</a>
                                        </li>
                                        <li class="ico-share-google">
                                            <a href="https://plus.google.com/share?url=<?php echo $share_url; ?>" data-original-title="Google+" target="_blank">&nbsp;</a>
                                        </li>
                                        <li class="ico-share-linkedin">
                                            <a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo $share_url; ?>&amp;title=<?php echo $share_title; ?>" data-original-title="LinkedIn" target="_blank">&nbsp;</a>
                                        </li>
                                        <li class="ico-share-mail">
                                            <a href="mailto:?subject=<?php echo $share_title; ?>&body=<?php echo $content; ?>" data-original-title="Mail">&nbsp;</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </nav>

                    </header>
                    <?php
                    if (has_post_thumbnail()) { // Vérifies qu'une miniature est associée à l'article.
                        $title_img = get_post(get_post_thumbnail_id())->post_title;
                        $bg_cat = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
                        ?>
                        <div class="img-container">
                            <figure>
                                <img alt="<?php echo $title_img; ?>" width="<?php echo $bg_cat[1]; ?>" src="<?php echo $bg_cat[0]; ?>">
                            </figure>
                        </div>
                        <?php
                    }
                    ?>
                    <div class="article-container">
                        <?php if (get_field('chapo_actu')) { ?>
                            <div class="article-excerpt"><?php the_field('chapo_actu', $post_ID); ?></div>
                        <?php } ?>
                        <?php if (!empty($content_actu)) { ?>
                            <div class="article-content"><?php echo $content_actu; ?></div>
                        <?php } ?>
                    </div>


                    <!--                    <div class="article-read-also article-references">
                                            <h4></h4>
                                            <ul>
                                                <li class="article">
                                                    <a href="#">

                                                        <figure><figure>

                                                        <div class="article-text">

                                                            <h4 class="over-title"><span class="over-title-wrap"></span></h4>

                                                            <h3 class="article-title"></h3>
                                                        </div>
                                                    </a>
                                                </li>
                                            </ul>
                                        </div>-->
                    <?php
                    $articles_en_relation_actu = get_field("articles_en_relation_actu", false, false);
//                    get($articles_en_relation_actu);
                    if ($articles_en_relation_actu) {
                        ?>
                        <div class = "article-same-topic article-references">
                            <h4>Sur le même sujet</h4>
                            <ul>
                                <?php
                                foreach ($articles_en_relation_actu as $post) {
                                    setup_postdata( $post );
                                    $thumb = get_the_post_thumbnail($post, 'thumbnail');
                                    $bg_relat = wp_get_attachment_image_src(get_post_thumbnail_id($post), 'thumbnail');
                                    $link = get_permalink($post);
                                    $category = get_the_category($post);
                                    $id_cat = (int) $category[0]->cat_ID;
                                    $lib_cat = (!empty($category[0]->name)) ? $category[0]->name : "";
                                    $cat_colors_css = ($id_cat != 0) ? "color:" . $cat_colors[$id_cat] . ";" : "";
                                    $sous_titre_actu = get_field("sous_titre_actu");
                                    ?>
                                    <li class = "article">
                                        <a href = "<?php echo $link; ?>">
                                            <?php if ($bg_relat) { ?>
                                                <figure style="background-image:url(<?php echo $bg_relat[0]; ?>);"></figure>
                                            <?php } ?>
                                            <div class = "article-text">
                                                <?php if($sous_titre_actu != ''){ ?>
                                                    <h4 class = "over-title"><span class = "over-title-wrap"><?php print($sous_titre_actu); ?></span></h4>
                                               <?php } ?>

                                                <h3 class = "article-title"><?php the_title(); ?></h3>
                                            </div>
                                        </a>
                                    </li>
                                    <?php

                                    wp_reset_postdata();
                                }
                                ?>
                            </ul>
                        </div>
                        <?php
                    }
                    ?>
                </article>
            </div>
        </div>
    </section>
</main>
<script>
jQuery( document ).ready(function($) {
repositionner();
$(window).resize(function () {
    repositionner();
    setMenuToScroll();
});
function repositionner() {
    heightEcran = $(window).height();
    widthArticle = $('.article-header').width();
    heightContainer = heightEcran - 91;
    $(".stop-fluid").css("height", heightContainer + "px");
    $(".page_navigation").css("margin-left", widthArticle/2-60 + "px");
}
});
</script>
<?php get_footer();
?>