<?php

//------------------------------------------------------------------------------
//    Widget Ours
//------------------------------------------------------------------------------

class Dh_Widget_Perso_Ours extends WP_Widget {

    public function __construct() {
        parent::__construct('dh_ours', 'Ours', array('description' => 'Widget Ours'));
        $this->alt_option_name = 'dh_ours_attachements';

        add_action('save_post', array(&$this, 'flush_widget_cache'));
        add_action('deleted_post', array(&$this, 'flush_widget_cache'));
        add_action('switch_theme', array(&$this, 'flush_widget_cache'));
    }

    // Front view
    public function widget($args, $instance) {
        global $wpdb, $assetsUrl, $filetype_icons;
        $cache = wp_cache_get($this->alt_option_name, 'widget');

        if (!is_array($cache))
            $cache = array();

        if (!isset($args['widget_id']))
            $args['widget_id'] = null;

        if (isset($cache[$args['widget_id']])) {
            echo $cache[$args['widget_id']];
            return;
        }

        ob_start();
        extract($args, EXTR_SKIP);

        echo $args['before_widget'];
        echo $args['before_title'];
        echo apply_filters('widget_title', $instance['title']);

        echo $args['after_title'];

        // Lien ancre
        $params = explode('=',$instance["ancre"]);
        if(!empty($params)){
            $code_ancre = substr($params[1], 0,8);
            echo '<a name="'.$code_ancre.'">&nbsp;</a>';
        }

        echo "<p>" . $instance["description"] . "</p>";
        echo $args['after_widget'];
        $data = json_decode($instance['data'], true);
        ?>

        <?php if (!empty($data)): ?>
            <div class="ex-attachments">

                <ul class="ex-attachments-<?php echo $icons; ?>icons">
                    <?php foreach ($data as $key => $element): ?>
                        <li>
                            <a target="_blank" href="<?php echo $element['link'] ?>">
                                <?php
                                if ($icons != 'no') {
                                    $path = parse_url($element['link'], PHP_URL_PATH);
                                    $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
                                    if (!array_key_exists($ext, $filetype_icons))
                                        $ext = 'file';  // if no specific filetype icon, use a generic image
                                    echo '<img src="' . $assetsUrl . '/images/' . $filetype_icons[$ext] . '.png" />';
                                }
                                echo '<div>' . $element['name'] . '</div>';
                                ?>
                            </a>
                            <?php if (!empty($element['description'])): ?>
                                <p><?php echo $element['description']; ?></p>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ul>

            </div>
        <?php endif; ?>

        <?php
        echo $after_widget;

        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set($this->alt_option_name, $cache, 'widget');
    }

    function update($new_instance, $old_instance){
        $instance = $old_instance;

        foreach ($new_instance as $key => $new) {
            $instance[$key] = $new;
        } $instance['title'] = strip_tags($new_instance['title']);


        $tempData = $new_instance['data'];
        $tempArray = array();

        foreach ($tempData as $value) {
            if (!empty($value)) {
                $tempArray[] = json_decode($value, true);
            }
        }

        $instance['data'] = json_encode($tempArray);
        $this->flush_widget_cache();

        $alloptions = wp_cache_get('alloptions', 'options');
        if (isset($alloptions[$this->alt_option_name]))
            delete_option($this->alt_option_name);

        return $instance;
    }

    function flush_widget_cache() {
        wp_cache_delete($this->alt_option_name, 'widget');
    }

    // Form
    public function form($instance){
        $title = isset($instance['title']) ? $instance['title'] : '';
        $description = isset($instance['description']) ? $instance['description'] : '';
        $docs = isset($instance['docs']) ? $instance['docs'] : '';
        $data = json_decode($instance['data'], true);

        preg_match('/.*?-([0-9]+)$/i', $this->id, $matches);
        ?>
        <p>
            <label for="<?php echo $this->get_field_name('title'); ?>">Titre :</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_name('description'); ?>"><?php _e('Description :'); ?></label> <br>
            <textarea class="htmleditor_widgeted"  name="<?php echo $this->get_field_name('description'); ?>" id="<?php echo $this->get_field_name('description'); ?>"><?php echo $description; ?></textarea>
        </p>

        <div>
            Document : <a class="button-secondary ex-attachment-add-fieldset" id="ex-attachment-add-fieldset" href="#">Ajouter un document</a>
        </div>

        <ul class="ex-attachments sortable list">
            <li class="default">
                <span>
                    <a class="up" href="#"></a>
                    <a class="down" href="#"></a>
                </span>
                <div class="widget-container-inline">
                        <a target="_blank" class="a-link widget-inline"></a>
                        <a href="#" class="remove remove_attachement_widget widget-inline"></a>
                    <input name="<?php echo esc_attr($this->get_field_name('data')); ?>[]" type="hidden" class="link" value="" />
                </div>
            </li>
            <?php if (!empty($data)): ?>
                <?php foreach ($data as $key => $value): ?>
                    <li>
                        <span>
                            <a class="up" href="#"></a>
                            <a class="down" href="#"></a>
                        </span>
                        <div class="widget-container-inline">
                            <a target="_blank" class="a-link widget-inline"></a>
                            <a href="#" class="remove remove_attachement_widget widget-inline"></a>
                            <input name="<?php echo esc_attr($this->get_field_name('data')); ?>[]" type="hidden" class="link" value='<?php echo json_encode($value); ?>' />
                        </div>
                    </li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>

      <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8,'defaut'); ?>
            <p>
                <label for="<?php echo $this->get_field_name( 'ancre' ); ?>"><?php _e( 'Ancre :' ); ?></label> Préciser le titre entre les "" de title=""<br>
                <input class="widefat" id="<?php echo $this->get_field_id( 'ancre' ); ?>" name="<?php echo $this->get_field_name( 'ancre' ); ?>" type="text" value="<?php echo  htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>

        <?php
    }

}

//register_widget('Dh_Widget_Perso_Ours');
//add_action('widgets_init', function() {register_widget('Dh_Widget_Perso_Ours');});