<?php
//------------------------------------------------------------------------------
//    Widget Publicite
//------------------------------------------------------------------------------

class Dh_Widget_Perso_Events extends WP_Widget{

    public function __construct(){
        parent::__construct('dh_events', 'Evénement', array('description' => 'Widget événement'));
        $this->alt_option_name = 'dh_events_attachements';

        add_action( 'save_post', array(&$this, 'flush_widget_cache' ) );
        add_action( 'deleted_post', array(&$this, 'flush_widget_cache' ) );
        add_action( 'switch_theme', array(&$this, 'flush_widget_cache' ) );

        add_action( 'admin_enqueue_scripts', array( $this, 'register_widget_styles' ) );
    }

    // Enqueue
    function register_widget_styles(){
        wp_enqueue_script('jquery-ui-datepicker');
        wp_enqueue_style ( 'jquery-ui-lightness', "https://code.jquery.com/ui/1.12.0/themes/black-tie/jquery-ui.css");
    }

    // Front view
    function widget( $args, $instance ){
        global $wpdb, $assetsUrl, $filetype_icons;
        $cache = wp_cache_get( $this->alt_option_name, 'widget' );

        if ( !is_array( $cache ) )
            $cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = null;

        if ( isset( $cache[$args['widget_id']])){
            echo $cache[$args['widget_id']];
            return;
        }

        ob_start();
        extract( $args, EXTR_SKIP );

        $title = apply_filters( 'widget_title', empty( $instance['title'] ) ? __( 'Attachments', 'ex_attachments_widget' ) : $instance['title'], $instance, $this->id_base);


        echo $before_widget;
        echo "<div ";
        // Lien ancre
        $params = explode('=', $instance["ancre"]);
        if (!empty($params)) {
            $code_ancre = substr($params[1], 0, 8);
            echo "id='" . $code_ancre . "' ";
        }
        echo "class='wrapper-widget border-active widget-event'>";
        echo $before_title;
            echo $title; // Can set this with a widget option, or omit altogether
        echo $after_title;

        echo "<div class='text-widget'>";
            echo "<date>".$instance['date_events']."</date><br>";
            if(!empty($instance['nom_lieu'])) echo "Nom du lieu : ".$instance['nom_lieu']."<br>";

            $titre_lien = (!empty($instance["titre_lien"])) ? $instance["titre_lien"] : "Lien";
            echo "<a href='".$instance["link"]."'>".$titre_lien."</a>";

            // Google map
            if (isset($instance['pos_geo_lat']) && isset($instance['pos_geo_lon'])){
                $gmap_key = get_option("dh_key_api_google_map"); ?>

                <div id="map" style="height:350px;width:100%"></div>

                <script type="text/javascript">
                    var map;

                    function initMap(){
                        map = new google.maps.Map(document.getElementById('map'), {
                            center: {lat: <?php echo $instance['pos_geo_lat'];?>, lng: <?php echo $instance['pos_geo_lon'];?>},
                            zoom: 8,
                            scrollwheel: false,
                            navigationControl: false,
                            mapTypeControl: false,
                            scaleControl: false,
                            draggable: false,
                            mapTypeId: google.maps.MapTypeId.ROADMAP
                        });
                    }
                </script>
                <script async defer src="https://maps.googleapis.com/maps/api/js?key=<?php echo $gmap_key;?>&callback=initMap"></script>

                <?php
            }

            echo "<p>".$instance["description"]."</p>";
            echo "Programmation : ".$instance['programmation']."<br>";

        echo "</div>";

        $data = json_decode($instance['data'], true);
    ?>

    <?php if (!empty($data)): ?>
    <div class="ex-attachments">
        <ul class="ex-attachments-<?php echo $icons; ?>icons">
            <?php foreach($data as $key => $element): ?>
            <li>
                <a target="_blank" href="<?php echo $element['link']?>">
                    <?php
                        if ($icons != 'no') {
                            $path = parse_url( $element['link'], PHP_URL_PATH );
                            $ext = strtolower( pathinfo( $path, PATHINFO_EXTENSION ) );
                            if (!array_key_exists($ext, $filetype_icons))
                                $ext = 'file';  // if no specific filetype icon, use a generic image
                            echo '<img src="'.$assetsUrl.'/images/'.$filetype_icons[$ext].'.png" />';
                        }
                        echo '<div>'.$element['name'].'</div>';
                    ?>
                </a>
                <?php if (!empty($element['description'])): ?>
                    <p><?php echo $element['description']; ?></p>
                <?php endif;?>
            </li>
            <?php endforeach;?>
        </ul>

    </div>
    <?php endif; ?>

    <?php
        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set( $this->alt_option_name, $cache, 'widget');
        echo "</div>";
        echo $after_widget;
    }

    // MAJ BDD
    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;

        foreach($new_instance as $key => $new){
            $instance[$key] = $new;
        }
        $instance['title'] = strip_tags($new_instance['title']);

        $tempData = $new_instance['data'];
        $tempArray = array();

        foreach($tempData as $value) {
            if ( !empty($value) ) {
                $tempArray[] = json_decode($value, true);
            }
        }

        $instance['data'] = json_encode($tempArray);
        $this->flush_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset( $alloptions[$this->alt_option_name]))
            delete_option( $this->alt_option_name );

        return $instance;
    }

    function flush_widget_cache(){
        wp_cache_delete( $this->alt_option_name, 'widget' );
    }

    // Form
    public function form($instance){
        $title = isset($instance['title']) ? $instance['title'] : '';
        $date_events = isset($instance['date_events']) ? $instance['date_events'] : '';
        $nom_lieu = isset($instance['nom_lieu']) ? $instance['nom_lieu'] : '';
        $pos_geo_lat = isset($instance['pos_geo_lat']) ? $instance['pos_geo_lat'] : '';
        $pos_geo_lon = isset($instance['pos_geo_lon']) ? $instance['pos_geo_lon'] : '';
        $description = isset($instance['description']) ? $instance['description'] : '';
        $programmation = isset($instance['programmation']) ? $instance['programmation'] : '';
        $titre_lien = isset($instance['titre_lien']) ? $instance['titre_lien'] : '';
        $lien = isset($instance['lien']) ? $instance['lien'] : '';
        $docs = isset($instance['docs']) ? $instance['docs'] : '';
        $data = json_decode($instance['data'], true);

        preg_match('/.*?-([0-9]+)$/i', $this->id, $matches);
    ?>
        <script>
            jQuery(document).ready(function(){
                jQuery('.date_events_picker').datepicker({
                    dateFormat : 'dd-mm-yy'
                });
            });
        </script>

        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo  htmlspecialchars($title); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'date_events' ); ?>">Date :</label>
            <input class="widefat date_events_picker" id="<?php echo $this->get_field_id( 'date_events' ); ?>" name="<?php echo $this->get_field_name( 'date_events' ); ?>" type="text" value="<?php echo  $date_events; ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'nom_lieu' ); ?>">Nom du lieu :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'nom_lieu' ); ?>" name="<?php echo $this->get_field_name( 'nom_lieu' ); ?>" value="<?php echo  htmlspecialchars($nom_lieu); ?>"/>
        </p>

        <?php
            $gmap_key = get_option("dh_key_api_google_map");
            if(!isset($gmap_key) || $gmap_key == ""){
                echo "Il faut configurer une clé API google map depuis le menu \"E-mag\"";
            }
        ?>

        <p>
            <label for="<?php echo $this->get_field_name( 'pos_geo_lat' ); ?>">Latitude :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'pos_geo_lat' ); ?>" name="<?php echo $this->get_field_name( 'pos_geo_lat' ); ?>" value="<?php echo  htmlspecialchars($pos_geo_lat); ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'pos_geo_lon' ); ?>">Longitude :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'pos_geo_lon' ); ?>" name="<?php echo $this->get_field_name( 'pos_geo_lon' ); ?>" value="<?php echo  htmlspecialchars($pos_geo_lon); ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'description' ); ?>">Description :</label>
            <textarea  class="htmleditor_widgeted"  id="<?php echo $this->get_field_id( 'description' ); ?>" name="<?php echo $this->get_field_name( 'description' ); ?>"><?php echo  $description; ?></textarea>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'programmation' ); ?>">Programmation :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'programmation' ); ?>" name="<?php echo $this->get_field_name( 'programmation' ); ?>" value="<?php echo  htmlspecialchars($programmation); ?>"/>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'titre_lien' ); ?>">Intitulé du lien sortant :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'titre_lien' ); ?>" name="<?php echo $this->get_field_name( 'titre_lien' ); ?>" value="<?php echo  htmlspecialchars($titre_lien); ?>"/>
        </p>
        <p>
            <label for="<?php echo $this->get_field_name( 'lien' ); ?>">Lien :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'lien' ); ?>" name="<?php echo $this->get_field_name( 'lien' ); ?>" value="<?php echo  htmlspecialchars($lien); ?>"/>
        </p>

        <div>
        Document : <a class="button-secondary ex-attachment-add-fieldset" id="ex-attachment-add-fieldset" href="#">Ajouter un document </a>
    </div>

    <ul class="ex-attachments sortable list">
        <li class="default">
            <span>
                <a class="up" href="#"></a>
                <a class="down" href="#"></a>
            </span>
            <div class="widget-container-inline">
                <a target="_blank" class="a-link widget-inline" ></a>
                <a href="#" class="remove remove_attachement_widget widget-inline"></a>
                <input name="<?php echo esc_attr( $this->get_field_name( 'data' ) ); ?>[]" type="hidden" class="link" value="" />
            </div>
        </li>
        <?php if (!empty($data)): ?>
            <?php foreach($data as $key => $value): ?>
                <li>
                    <span>
                        <a class="up" href="#"></a>
                        <a class="down" href="#"></a>
                    </span>
                    <div class="widget-container-inline">
                        <a target="_blank" class="a-link widget-inline" ></a>
                        <a href="#" class="remove remove_attachement_widget widget-inline"></a>
                        <input name="<?php echo esc_attr( $this->get_field_name( 'data' ) ); ?>[]" type="hidden" class="link" value='<?php echo json_encode($value); ?>' />
                    </div>
                </li>
            <?php endforeach;?>
        <?php endif; ?>
    </ul>

        <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8,'defaut'); ?>
            <p>
                <label for="<?php echo $this->get_field_name( 'ancre' ); ?>"><?php _e( 'Ancre :' ); ?></label> Préciser le titre entre les "" de title=""<br>
                <input class="widefat" id="<?php echo $this->get_field_id( 'ancre' ); ?>" name="<?php echo $this->get_field_name( 'ancre' ); ?>" type="text" value="<?php echo  htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>
        <?php
    }
}

register_widget('Dh_Widget_Perso_Events');
add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_Events');});