<?php
//------------------------------------------------------------------------------
//    Widget Galerie       
//------------------------------------------------------------------------------   
    
class Dh_Widget_Perso_Galerie extends WP_Widget{
    
    public function __construct(){
        parent::__construct('dh_galerie', 'Galerie_old', array('description' => 'Widget Galerie'));
        $this->alt_option_name = 'dh_galerie_attachements';

        add_action( 'save_post', array(&$this, 'flush_widget_cache' ) );
        add_action( 'deleted_post', array(&$this, 'flush_widget_cache' ) );
        add_action( 'switch_theme', array(&$this, 'flush_widget_cache' ) );
        add_action('admin_enqueue_scripts', array($this, 'enqueue_upload_media'));
    }
    
    // ADD JS / CSS
    public function enqueue_upload_media(){
        if(!is_admin())  return;
        
        wp_enqueue_media();
        wp_enqueue_script('upload_media_widget', get_template_directory_uri().'/widgets/js/upload-media.js', array('jquery'));
        wp_enqueue_script('widget_slider_wallop', get_template_directory_uri().'/widgets/js/Wallop.min.js', array('jquery'));
        wp_enqueue_style('widget_slider_wallop_css', get_template_directory_uri().'/widgets/css/wallop.css', array('jquery'));
    }
    
    // Front view
    public function widget($args, $instance){
        global $wpdb, $assetsUrl, $filetype_icons;
        $cache = wp_cache_get( $this->alt_option_name, 'widget' );

        if ( !is_array( $cache ))
            $cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = null;

        if ( isset( $cache[$args['widget_id']])){
            echo $cache[$args['widget_id']];
            return;
        }

        ob_start();
        extract( $args, EXTR_SKIP );
        $data = json_decode($instance['data'], true);
        
        echo $args['before_widget'];
        echo "<div class='wrapper-widget border-active'>";
        
        // Lien ancre
        $params = explode('=',$instance["ancre"]);
        if(!empty($params)){
            $code_ancre = substr($params[1], 0,8);
            echo '<a name="'.$code_ancre.'">&nbsp;</a>';
        }

        // Gallerie Image
        if (!empty($data)){ ?>
            <div class="widget-galerie">
                <?php foreach($data as $key => $element): ?>
                    <a class="fancybox-button" rel="gallery-<?php echo $args['widget_id'];?>" href="<?php echo $element['link'];?>">
                        <img src="<?php echo $element['link'];?>" alt="<?php echo $element['name']; ?>" title="<?php echo $element['name']; ?>"/>
                    </a>
                <?php endforeach;?>
            </div>
        <?php } ?>

        <?php
            // Titre
            echo $args['before_title'];
                echo apply_filters('widget_title', $instance['title']);
            echo $args['after_title'];
            
            // Content
            if(!empty($instance["description"])){
                echo "<div class='text-widget'>";
                    echo "<p>".$instance["description"]."</p>";
                echo "</div>";
            }
            
            // Sous-titre
            echo "<h5>".$instance['sous_titre']."</h5><br>";
            
            // Auteur
            if(!empty($instance["auteur"])){
                echo "<p class='auteur-quote'>".$instance['auteur']."</p>";
            }
        
            // $alt = get_post_meta($instance["img_pub_id"], '_wp_attachment_image_alt', true);
            // $info_img = wp_get_attachment_metadata($instance["img_pub_id"]);

        
            echo "</div>";
        echo $after_widget;
        
        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set( $this->alt_option_name, $cache, 'widget');
    }
    
    function update($new_instance, $old_instance){
        $instance = $old_instance;
        
        foreach($new_instance as $key => $new){
            $instance[$key] = $new;
        }
        $instance['title'] = strip_tags($new_instance['title']);
        

        $tempData = $new_instance['data'];
        $tempArray = array();

        foreach($tempData as $value) {
            if ( !empty($value) ) {
                $tempArray[] = json_decode($value, true);
            }
        }

        $instance['data'] = json_encode($tempArray);
        $this->flush_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset( $alloptions[$this->alt_option_name]))
            delete_option( $this->alt_option_name );

        return $instance;
    }

    function flush_widget_cache() {
        wp_cache_delete( $this->alt_option_name, 'widget' );
    }
    
    // Form
    public function form($instance){
        $title = isset($instance['title']) ? $instance['title'] : '';
        $auteur = isset($instance['auteur']) ? $instance['auteur'] : '';
        $description = isset($instance['description']) ? $instance['description'] : '';
        $sous_titre = isset($instance['sous_titre']) ? $instance['sous_titre'] : '';
        $img_sommaire = isset($instance['img_sommaire']) ? $instance['img_sommaire'] : '';
        $img_sommaire_id = isset($instance['img_sommaire_id']) ? $img_sommaire_id : '';
        $docs = isset($instance['docs']) ? $instance['docs'] : '';
        $data = json_decode($instance['data'], true);

        preg_match('/.*?-([0-9]+)$/i', $this->id, $matches);
    ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>">Titre :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo  htmlspecialchars($title); ?>" />
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_name( 'auteur' ); ?>">Auteur :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'auteur' ); ?>" name="<?php echo $this->get_field_name( 'auteur' ); ?>" type="text" value="<?php echo  htmlspecialchars($auteur); ?>" />
        </p>
        
        <div>
            <label>Documents :</label> <a class="button-secondary ex-attachment-add-fieldset" id="ex-attachment-add-fieldset" href="#">Ajouter des images</a>
        </div>
        
        <ul class="ex-attachments sortable list">
            <li class="default">
                <span>
                    <a class="up" href="#"></a>
                    <a class="down" href="#"></a>
                </span>
                <div>
                    <a target="_blank" class="a-link"></a> <a href="#" class="remove">(x)</a>
                    <p class="desc-text"></p>
                    <input name="<?php echo esc_attr( $this->get_field_name( 'data' ) ); ?>[]" type="hidden" class="link" value="" />
                </div>
            </li>
            <?php if (!empty($data)): ?>
                <?php foreach($data as $key => $value): ?>
                    <li>
                        <span>
                            <a class="up" href="#"></a>
                            <a class="down" href="#"></a>
                        </span>
                        <div>
                            <a target="_blank" class="a-link" href="<?php echo $value['link']; ?>"><?php echo $value['name']; ?></a> <a href="#" class="remove">(x)</a>
                            <p class="desc-text"><?php echo $value['description']; ?></p>
                            <input name="<?php echo esc_attr( $this->get_field_name( 'data' ) ); ?>[]" type="hidden" class="link" value='<?php echo json_encode($value); ?>' />
                        </div>
                    </li>
                <?php endforeach;?>
            <?php endif; ?>
        </ul>
        
        
        <p>
            <label for="<?php echo $this->get_field_name( 'description' ); ?>"><?php _e( 'Description :' ); ?></label> <br>
            <textarea  class="htmleditor_widgeted" name="<?php echo $this->get_field_name( 'description' ); ?>" id="<?php echo $this->get_field_name( 'description' ); ?>"><?php echo $description;?></textarea>
        </p>
        
        <p>
            <label for="<?php echo $this->get_field_name( 'sous_titre' ); ?>"><?php _e( 'Sous-titre :' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'sous_titre' ); ?>" name="<?php echo $this->get_field_name( 'sous_titre' ); ?>" type="text" value="<?php echo  htmlspecialchars($sous_titre); ?>" />
        </p>
       
        <p class="widget-upload-media">
            <label for="<?php echo $this->get_field_name( 'img_sommaire' ); ?>">Image pour le sommaire :</label><br>
            <div style="text-align:center;" class="dh_thumb_widget">
                <input name="<?php echo $this->get_field_name( 'img_sommaire_id' ); ?>" id="<?php echo $this->get_field_id( 'img_sommaire_id' ); ?>" type="hidden" class="setter-ID-img-upload" size="36" value="<?php echo $img_sommaire_id; ?>" />
                <input name="<?php echo $this->get_field_name( 'img_sommaire' ); ?>" id="<?php echo $this->get_field_id( 'img_sommaire' ); ?>" class="widefat image-url" type="hidden" size="36" value="<?php echo esc_url( $img_sommaire ); ?>" />
                <input class="upload-image-btn button button-primary" type="button" value="Upload Image" />
                <img src="<?php echo esc_url( $img_sommaire ); ?>" class="image-preview<?php echo $img_sommaire == '' ? ' hidden' : ''; ?>">
                <input class="remove-image-btn button button-error<?php echo $img_sommaire == '' ? ' hidden' : ''; ?>" type="button" value="Remove Image" />
            </div>
        </p>
        
        
        <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8); ?>
            <p>
                <label for="<?php echo $this->get_field_name( 'ancre' ); ?>"><?php _e( 'Ancre :' ); ?></label> Ajouter ico=video ou ico=image ico=pdf avant "]" pour changer l'icone du lien rapide<br>
                <input class="widefat" id="<?php echo $this->get_field_id( 'ancre' ); ?>" name="<?php echo $this->get_field_name( 'ancre' ); ?>" type="text" value="<?php echo  htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>
        <?php
    }
}

//register_widget('Dh_Widget_Perso_Galerie');
//add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_Galerie');});