<?php

//------------------------------------------------------------------------------
//      LOGIN FORM - page maintenance
//------------------------------------------------------------------------------
function dh_login_form_sc() {

    if (is_user_logged_in())
        return '';

    return wp_login_form(array('echo' => false));
}

add_shortcode('DH_LOGIN_FORM', 'dh_login_form_sc');

//------------------------------------------------------------------------------
//      Filtre content pour ajouter les liens ancre
//------------------------------------------------------------------------------

function dh_add_ancre_auto($params) {

    $class_ico = "ico_link";
    if ($params["ico"] == "defaut") {
        $class_ico = "ico_link_defaut";
    }
    if ($params["ico"] == "chiffres_cles") {
        $class_ico = "ico_link_chiffres_cles";
    }
    if ($params["ico"] == "citation") {
        $class_ico = "ico_link_citation";
    }
    if ($params["ico"] == "embed") {
        $class_ico = "ico_link_embed";
    }
    if ($params["ico"] == "galerie") {
        $class_ico = "ico_link_galerie";
    }

    $content = '<p class="special_link">'
            . '<a href="#' . $params['link'] . '" title="' . $params['title'] . ' (ancre)">'
            . '<i class="' . $class_ico . '"></i>'
            . '<span class="aside_texte">' . $params['title'] . '</span>'
            . '</a>'
            . '</p>';
    return($content);
}

add_shortcode("ANCRE", "dh_add_ancre_auto");

//------------------------------------------------------------------------------
//      SOCIAL SHARE
//------------------------------------------------------------------------------
function dh_social_share($params) {
    if (is_array($params))
        extract($params);
    ?>

    <link href="//netdna.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">

        <?php
        $share_url = get_site_url() . $_SERVER['REQUEST_URI'];
        $share_title = (wp_title('', false) != "") ? wp_title('', false) : get_option('blogname');
        $share_title = str_replace(' ', '%20', $share_title);
        $fb_app_id = get_option("dh_fb_app_id_emag");
        $dh_nl_is_active = get_option("dh_is_nl_active");
        $dh_commentaire_is_active = get_option("dh_is_cmt_active");
        $content = "J’ai trouvé cet article intéressant sur " . get_option('blogname') . "%0A%0A" . $share_title . "%0A%0A" . $share_url;
        $content = str_replace(' ', '%20', $content);
        ?>

    <nav role="social" class="pull-right">
        <?php if ($dh_nl_is_active == 1 ) { ?>
        <ul>
            <li class="newsletter">
                <a href="#subscribe_newsletter" class="popup-opener" title="Newsletter (pop-up)"> </a>
            </li>
        </ul>
        <?php } ?>

        <?php if (is_home() || is_front_page()) { ?>
        <?php
        // Download PDF
        $current_numero = getCurrentNumero();
        $info_pdf = get_field("pdf_du_numero", $current_numero->id_acf);
        if (is_array($info_pdf)) {
            ?>
                <ul>
                    <li class="download_pdf">
                        <a href="<?php echo $info_pdf["url"]; ?>" target="_blank" title="Téléchargez le PDF (pdf) (nouvelle fenêtre)">&nbsp;</a>
                    </li>
                </ul>
        <?php } ?><?php } ?>



        <?php if (is_single() && $dh_commentaire_is_active == 1 ) { ?>
            <ul>
                <li class="commentaires">
                    <a href="#comments" class="popup-opener" title="Commentaires (pop-up)"></a>
                    <!--<span class="count"></span>-->
                </li>
            </ul>
    <?php } ?>

    <?php if (is_single()) { ?>
            <ul>
                <li class="ico-share-print">
                    <a href="javascript:window.print();" data-original-title="Print" title="Imprimer (nouvelle fenêtre)">&nbsp;</a>
                </li>
            </ul>
    <?php } ?>

    <?php if (!is_page("archives") && get_option("dh_social_is_active") == 1) { ?>
            <ul>
                <li class="share-ico">
                    <ul class="submenusocial">
                        <li class="ico-share-facebook">
                            <a href="http://www.facebook.com/dialog/feed?app_id=<?php echo $fb_app_id; ?>&link=<?php echo $share_url; ?>" data-original-title="Facebook" target="_blank">&nbsp;</a>
                        </li>
                        <li class="ico-share-twitter">
                            <a href="https://twitter.com/share?url=<?php echo $share_url; ?>" data-original-title="Twitter" target="_blank">&nbsp;</a>
                        </li>
                        <li class="ico-share-scoopit">
                            <a href="http://www.scoop.it/bookmarklet?url=<?php echo $share_url; ?>" data-original-title="Scoop it !" target="_blank">&nbsp;</a>
                        </li>
                        <li class="ico-share-google">
                            <a href="https://plus.google.com/share?url=<?php echo $share_url; ?>" data-original-title="Google+" target="_blank">&nbsp;</a>
                        </li>
                        <li class="ico-share-linkedin">
                            <a href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo $share_url; ?>&amp;title=<?php echo $share_title; ?>" data-original-title="LinkedIn" target="_blank">&nbsp;</a>
                        </li>
                        <li class="ico-share-mail">
                            <a href="mailto:?subject=<?php echo $share_title; ?>&body=<?php echo $content; ?>" data-original-title="Mail">&nbsp;</a>
                        </li>
                    </ul>
                </li>
            </ul>
    <?php } ?>
        <ul class="navigation-post">
            <li class="navigation-post-previous"><a href="<?php echo $prev; ?>">&nbsp;</a></li>
            <li class="navigation-post-next"><a href="<?php echo $next; ?>/">&nbsp;</a></li>
        </ul>
    </nav>

    <div style="display:none;">
        <div id="subscribe_newsletter" class="popup-container">
            <i class="ico-share-newsletter"></i>
            <h4><?php echo _e("Soyez informé de la mise en ligne de votre prochain E-Mag", 'html5blank'); ?></h4>
            <hr>
    <?php
    $widgetNL = new WYSIJA_NL_Widget(true);
    echo $widgetNL->widget(array('form' => 1, 'form_type' => 'php'));
    ?>
        </div>
    </div>

    <div style="display:none;">
        <div id="comments" class="popup-container">
    <!--        <i class="ico-share-commentaires"></i>
            <h4><?php echo _e("Laissez nous un commentaire", 'html5blank'); ?></h4>
            <hr>-->
    <?php comments_template(); ?>
        </div>
    </div>

    <?php
}

add_shortcode('DH_SOCIAL_SHARE', 'dh_social_share');

//------------------------------------------------------------------------------
//      ARCHIVES NUMEROS
//------------------------------------------------------------------------------

function dh_archived_numero() {

    $numeros = get_terms(array(
        "taxonomy" => "numero",
        'orderby' => "term_id",
        'order' => 'DESC',
            // 'hide_empty' => false,
    ));

    if (is_array($numeros)) {
        ?>

        <div class="numero-wrapper">
            <ul class="numero-liste">
                <?php
                $i = 0;
                foreach ($numeros as $k => $numero) {

                    $date_pub = get_field("date_de_publication", "numero_" . $numero->term_id);
                    if (substr($date_pub, 0, 6) > date('Ym'))
                        continue;
                    //$i++; if( $i%2 == 0){  echo '<div class="row">'; }

                    if (isset($_SESSION["dh_num_mag"]) && $_SESSION["dh_num_mag"] == $numero->term_id) {

                        $html_current = '<li>';
                        $html_current.='<a href="' . get_bloginfo('url') . '/?id_num=' . $numero->term_id . '">';
                        $html_current.='<div>';
                        $html_current.='<span class="numero-current"></span>';

                        $url_thumb = get_field("image_de_couverture", $numero->taxonomy . "_" . $numero->term_id);
                        if (!empty($url_thumb)) {
                            $html_current.='<img src="' . $url_thumb['sizes']['thumbnail'] . '" width="' . $url_thumb['sizes']['thumbnail-width'] . '" height="' . $url_thumb['sizes']['thumbnail-height'] . '">';
                        }

                        $html_current.='<div class="numero-content">';

                        $sous_titre = get_field("surtitre_de_laccroche", $numero->taxonomy . "_" . $numero->term_id);
                        if ($sous_titre)
                            $html_current.="<h2>" . $sous_titre . "</h2>";

                        $html_current.='<span>' . $numero->name . '</span>';
                        $numero = get_field("numerotation", $numero->taxonomy . "_" . $numero->term_id);
                        $html_current.="<i>" . $numero . "</i>";

                        $html_current.="</div>";
                    }else {
                        $html_other_numero.= '<li>';
                        $html_other_numero.='<a href="' . get_bloginfo('url') . '/?id_num=' . $numero->term_id . '">';
                        $html_other_numero.='<div>';

                        $url_thumb = get_field("image_de_couverture", $numero->taxonomy . "_" . $numero->term_id);
                        if (!empty($url_thumb)) {
                            $html_other_numero.='<img src="' . $url_thumb['sizes']['thumbnail'] . '" width="' . $url_thumb['sizes']['thumbnail-width'] . '" height="' . $url_thumb['sizes']['thumbnail-height'] . '">';
                        }

                        $html_other_numero.='<div class="numero-content">';

                        $sous_titre = get_field("surtitre_de_laccroche", $numero->taxonomy . "_" . $numero->term_id);
                        if ($sous_titre)
                            $html_other_numero.="<h2>" . $sous_titre . "</h2>";

                        $html_other_numero.='<span>' . $numero->name . '</span>';
                        $numero = get_field("numerotation", $numero->taxonomy . "_" . $numero->term_id);
                        $html_other_numero.="<i>" . $numero . "</i>";

                        $html_other_numero.="</div>";
                    }
                    ?>
            <?php //if( $i%2 == 0){ echo '</div>';}  ?>
                <?php }
                ?>
                <?php
                echo $html_current . $html_other_numero;

                if (get_field('activer_archives_old')) {
                    $image = get_field('img_archives_old');
                    ?>
                    <li>
                        <a target="_blank" href="<?php the_field('lien_archives_old'); ?>">
                            <div>
                                <img src="<?php echo $image['sizes']['thumbnail']; ?>" width="150" height="150">
                                <div class="numero-content">
                                    <h2><?php the_field('content_archives_old'); ?></h2>
                                    <span><?php the_field('title_archives_old'); ?></span>
                                    <span class="number external"></span>
                                </div>
                            </div>
                        </a>
                    </li>
            <?php
        }
        ?>
            </ul></div>
    <?php
    }
}

add_shortcode('DH_ARCHIVES', 'dh_archived_numero');
?>