<?php
/**
 * Template Name: Toutes les vidéos
 * */
?>

<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$num_colors = get_option('numero_colors');
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$dark = "rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", 0.8);";
$light = "rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", 0.5);";
?>

<main role="main" class="toutes-les-videos-wrap">
    <!-- section -->
    <section>
        <h1 class="allembeds-title"><?php the_title(); ?></h1>

        <?php if (have_posts()): while (have_posts()) : the_post(); ?>

                <!-- article -->
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                    <?php the_content(); ?>

                    <?php comments_template('', true); // Remove if you don't want comments ?>

                    <br class="clear">

                    <?php
                    if (is_user_logged_in()) {
                        ?>
                        <div class="edit-post-edito">
                            <i class="glyphicon glyphicon-pencil"></i>
                            <?php edit_post_link(); ?>
                        </div>
                    <?php } ?>

                </article>
                <!-- /article -->
            <?php endwhile; ?>

        <?php else: ?>

            <!-- article -->
            <article>
                <h2><?php _e('Sorry, nothing to display.', 'html5blank'); ?></h2>
            </article>
            <!-- /article -->
        <?php endif; ?>

    </section>
    <!-- /section -->
</main>

<?php //get_sidebar(); ?>
<?php get_footer(); ?>