<?php get_header(); ?>
<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');
$active_color = $num_colors[$current_numero->term_id];
?>

<style>
    div.bg-repeat{
        background: url("<?php echo get_template_directory_uri(); ?>/img/bg_whitetrame.png") center fixed;
        width:100%;
        height:100%;
        position:fixed;
        display:block;
        left:0;
        top:0;
        z-index: -1;
    }
</style>
<main role="main" class="container-chat">
    <section class="article-content">
        <h1 style="background-color:<?php echo $active_color; ?>"><?php echo the_title(); ?></h1>
        <article>
            <div class="post-content-ours">
                <?php
                wp_reset_query();
                the_content();
                ?>

                <?php
                $postID = get_post();
                $links = get_field("amorce", $postID->ID);
                if (!empty($links)) {
                    ?>
                    <div class="amorce-cont">
                        <?php
                        foreach ($links as $link) {
                            ?>
                            <div class="post-link-out">
                                <a href="<?php echo $link['url_amorce']; ?>" target="_blank">
                                    <span class="icone-en-savoir-plus"></span>
                                    <span class="txt_amorce">
                                        <?php
                                        if ($link['titre_amorce']) {
                                            echo $link['titre_amorce'];
                                        } else {
                                            ?>En savoir plus<?php
                                        }
                                        ?>
                                    </span>
                                </a>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <?php
                }
                ?>

                <?php
                // Get Arbo
                $tree_menu = dh_get_tree_menu_nav();
                $id_item = get_the_ID(false);

                // Set link
                if (!empty($tree_menu)) {
                    $key = dh_find_key_array_by_value($tree_menu, $id_item);
                    $max = count($tree_menu);

                    $prev = $key - 1;
                    if ($prev < 0) {
                        $prev = $max - 1;
                    }

                    $next = $key + 1;
                    if ($next > ($max - 1)) {
                        $next = 0;
                    }

                    $link_prev = $tree_menu[$prev];
                    $link_current = $tree_menu[$key];
                    $link_next = $tree_menu[$next];
                }
                ?>

                <div class="contextual_nav" style="margin: 25px 0 0;">
                    <div class="previous">
                        <?php
                        if (!empty($link_prev['name'])) {
                            ?><a href="<?php echo $link_prev['url']; ?>" id="prev" title="<?php echo $link_prev['name']; ?>" alt="<?php echo $link_prev['name']; ?>"><span class='inner'><span class='text'><?php echo $link_prev['name']; ?></span><span class='icon'></span></a>
                        <?php } ?>
                    </div>
                    <div class="next">
                        <?php
                        if (!empty($link_next['name'])) {
                            ?><a href="<?php echo $link_next['url']; ?>" id="next" title="<?php echo $link_next['name']; ?>" alt="<?php echo $link_next['name']; ?>"><span class='inner'><span class='text'><?php echo $link_next['name']; ?></span><span class='icon'></span></a>
                        <?php } ?>
                    </div>
                </div>

                <?php
                $cat_colors = get_option('category_colors');
                $articles_en_relation = get_field("articles_en_relation");
                if ($articles_en_relation) {
                    ?>
                    <div class="related-articles">
                        <h4>À lire aussi</h4>
                        <div class="inner">
                            <?php
                            foreach ($articles_en_relation as $article_en_relation) {
                                $thumb = get_the_post_thumbnail($article_en_relation, 'thumbnail');
                                $link = get_permalink($article_en_relation);
                                $category = get_the_category($article_en_relation);
                                $id_cat = (int) $category[0]->cat_ID;
                                $lib_cat = (!empty($category[0]->name)) ? $category[0]->name : "";
                                $cat_colors_css = ($id_cat != 0) ? "color:" . $cat_colors[$id_cat] . ";" : "";
                                ?>
                                <div class="related-article">
                                    <a href="<?php echo $link; ?>">
                                        <?php if ($thumb) { ?>
                                            <figure class="related-image">
                                                <?php echo $thumb; ?>
                                            </figure>
                                        <?php } ?>
                                        <div class="related-text">
                                            <p class="parent" style="<?php echo $cat_colors_css; ?>"><?php echo $lib_cat; ?></p>
                                            <h5><?php echo dh_filtre_texte_bold($article_en_relation->post_title); ?></h5>
                                        </div>
                                    </a>
                                </div>
                            <?php } ?>
                        </div></div>
                    <?php } ?>
            </div>

        </article>
    </section>
</main>
<?php get_footer();
?>