/**
 * Copyright REZO ZERO 2016
 *
 *
 *
 * @file NewsList.js
 * @copyright REZO ZERO 2016
 * @author Ambroise Maupate
 */
var NewsList = function ($viewport) {
    var _this = this;

    _this.$viewport = $viewport;
    _this.$articles = _this.$viewport.find('.article');
    _this.$cont = _this.$viewport.find('.news-columned-container').eq(0);
    _this.$videos = _this.$viewport.find('.webtv-video a');
    _this.$cover = _this.$viewport.find('.cover');
    _this.$socialLinks = _this.$viewport.find('.page_navigation').eq(0);

    _this.init();
};

NewsList.prototype.init = function() {
    var _this = this;

    if (_this.$cont.outerHeight() < _this.$viewport.outerHeight()) {
        _this.$cont.css({
            "min-height": _this.$viewport.outerHeight(),
        });
    }

    var onResize = $.proxy(_this.onResize, _this);

    $(window).off('resize', onResize);
    $(window).on('resize', onResize);

    _this.resizeImages();
    _this.bindVideos();
    _this.resizeCover();
    _this.setBorderOffset();

    $(window).trigger('resize');
};

NewsList.prototype.setBorderOffset = function() {
    var _this = this;

    var $tagContainer = _this.$viewport.find('.tag-container');
    var $return = $tagContainer.find('.return');
    var $line = $tagContainer.find('.line');

    if ($tagContainer.length && $return.length && $line.length) {
        $line.css('margin-left', $return.outerWidth());
    }
};

NewsList.prototype.onResize = function(event) {
    var _this = this;

    if (_this.$socialLinks.length) {
        _this.$socialLinks[0].removeAttribute('style');
        var top = _this.$viewport.scrollTop() + _this.$socialLinks.offset().top;

        _this.$socialLinks.css({
            'position': 'fixed',
            'left': _this.$socialLinks.offset().left,
            'top': top,
            'right': 'auto',
        });
    }
};

NewsList.prototype.resizeImages = function() {
    var _this = this;

    var $images = _this.$articles.find('img');
    $images.each(function(index, el) {
        var $el = $(el);
        var $figure = $el.parents('figure').eq(0);
        var src = $el.attr('src');

        $figure.css({
            'background-image': 'url(' + src + ')'
        });

        $el.remove();
    });
};

NewsList.prototype.resizeCover = function() {
    var _this = this;

    if (!_this.$viewport.hasClass('news-article')) {
        var $firstArticle = _this.$articles.find('a').eq(0);
        var bottom = ($firstArticle.offset().top - _this.$viewport.offset().top) + $firstArticle.outerHeight();
        _this.$cover.css({
            height: bottom
        });
    }
};

NewsList.prototype.bindVideos = function() {
    var _this = this;

    if (_this.$videos.length) {
        _this.$videos.off('click');
        _this.$videos.on('click', $.proxy(_this.onVideoClicked, _this));
    }
};

NewsList.prototype.onVideoClicked = function(event) {
    var _this = this;
    event.preventDefault();
    var $video = $(event.currentTarget);

    Ultramedia.current_issue.unbindKeyNavigation();

    var width = $video.attr('data-iframe-width');
    var height = $video.attr('data-iframe-height');
    var src = $video.attr('data-iframe-src');
    var title = $video.attr('data-iframe-title');
    var excerpt = $video.attr('data-iframe-excerpt');

    if (width && height && src) {
        var dom = [
            '<div class="embed-overlay">',
                '<div class="embed-overlay-bg">',
                '</div>',
                '<div class="embed-overlay-inner">',
                    '<iframe width="'+width+'" height="'+height+'" src="'+src+'" frameborder="0" allowfullscreen></iframe>',
                    '<div class="embed-overlay-inner-text">',
                        '<h2 class="embed-overlay-title">',
                            title,
                        '</h2>',
                        '<p class="embed-overlay-excerpt">',
                            excerpt,
                        '</p>',
                    '</div>',
                '</div>',
                '<div class="embed-overlay-close">',
                '</div>',
            '</div>',
        ];

        $('body').append(dom.join(''));
        _this.$currentOverlay = $('.embed-overlay').eq(0);
        var $iframeInner = _this.$currentOverlay.find('.embed-overlay-inner').eq(0);
        $iframeInner.css({
            'margin-left': $iframeInner.outerWidth()/-2,
            'margin-top': $iframeInner.outerHeight()/-2
        });


        _this.$currentOverlay.animate({
                opacity:1,
            },
            500, function() {
            $(window).one('keyup', $.proxy(_this.overlayKeyup, _this));
            _this.$currentOverlay.find('.embed-overlay-close').one('click', $.proxy(_this.closeOverlay, _this));
            _this.$currentOverlay.find('.embed-overlay-bg').one('click', $.proxy(_this.closeOverlay, _this));
        });
    }
};

NewsList.prototype.overlayKeyup = function(event) {
    var _this = this;

    if (event.keyCode === 27) {
        _this.closeOverlay();
    }
};

NewsList.prototype.closeOverlay = function(event, callback) {
    var _this = this;

    if (_this.$currentOverlay) {
        _this.$currentOverlay.animate({
            opacity:0,
            },
            500, function() {
            _this.$currentOverlay.remove();
            _this.$currentOverlay = null;
            Ultramedia.current_issue.bindKeyNavigation();

            if (callback) {
                callback();
            }
        });
    }

    return false;
};

