<?php
//------------------------------------------------------------------------------
//    Widget Chiffres clés
//------------------------------------------------------------------------------

class Dh_Widget_Perso_ChiffresCles extends WP_Widget{

    public function __construct(){
        parent::__construct('dh_chiffres_cles', 'Chiffres Clés', array('description' => 'Widget Chiffres Clés'));
    }

    // Front view
    public function widget($args, $instance){

        echo $args['before_widget'];
            echo "<div class='wrapper-widget border-active widget-chiffre-cle'>";
                echo $args['before_title'];
                echo apply_filters('widget_title', $instance['title']);
                    echo $args['after_title'];

                    // Lien ancre
                    $params = explode('=',$instance["ancre"]);
                    if(!empty($params)){
                        $code_ancre = substr($params[1], 0,8);
                        echo '<a name="'.$code_ancre.'">&nbsp;</a>';
                    }

                    echo "<div class='text-widget'>";
                        echo "<p>".dh_filtre_texte_bold($instance["description"])."</p>";
                    echo "</div>";
                        echo "<p class='auteur-quote'>".$instance["auteur"]."</p>";
            echo "</div>"; // wrapper
        echo $args['after_widget'];
    }

    // Form
    public function form($instance){
        $title = isset($instance['title']) ? $instance['title'] : '';
        $description = isset($instance['description']) ? $instance['description'] : '';
        $auteur = isset($instance['auteur']) ? $instance['auteur'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_name( 'title' ); ?>">Titre :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo  htmlspecialchars($title); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'description' ); ?>"><?php _e( 'Description :' ); ?></label> <br>
            <textarea class="htmleditor_widgeted" name="<?php echo $this->get_field_name( 'description' ); ?>" id="<?php echo $this->get_field_name( 'description' ); ?>"><?php echo $description;?></textarea>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name( 'auteur' ); ?>">Auteur :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'auteur' ); ?>" name="<?php echo $this->get_field_name( 'auteur' ); ?>" type="text" value="<?php echo  htmlspecialchars($auteur); ?>" />
        </p>

        <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8,'chiffres_cles'); ?>
            <p>
                <label for="<?php echo $this->get_field_name('ancre'); ?>"><?php _e('Ancre :'); ?></label> Préciser le titre entre les "" de title=""<br>
                <input class="widefat" id="<?php echo $this->get_field_id('ancre'); ?>" name="<?php echo $this->get_field_name('ancre'); ?>" type="text" value="<?php echo htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>

        <?php
    }
}

register_widget('Dh_Widget_Perso_ChiffresCles');
add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_ChiffresCles');});