<?php
/*
Plugin Name: Cache Manifest for Wordpress
Version: 1.0
Description: Use cache manifest in wordpress
*/

// function add_cache_manifest_head( $output ){
// 	$manifest_file = get_home_path() .'/cache.manifest';

// 	if ( file_exists( $manifest_file ) ){
// 			$ipad = strpos($_SERVER['HTTP_USER_AGENT'], 'iPad');
// 			$iphone = strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone');
// 			$ipod = strpos($_SERVER['HTTP_USER_AGENT'], 'iPod');

// 		if ( $ipad || $iphone || $ipod )
// 			return $output . ' manifest="'. get_home_path() .'/cache.manifest"';

// 	}

// 	return $output;
// }

// add_filter( 'language_attributes', 'add_cache_manifest_head' );

function _add_manifest_file(){

	$hashes = "";
	$network = array("\n\nNETWORK:\n*\n");
	$cache = array("\n\nCACHE:");
	$pathhome = get_home_path();
	$path = get_stylesheet_directory()."/";
	$pathmobile = $pathhome."/wp-content/themes/emag-mobile_new/";
	
	$dir = new RecursiveDirectoryIterator( $path );
	foreach(new RecursiveIteratorIterator($dir) as $file) {
		if ($file->IsFile() && $file != "./manifest.php" && substr($file->getFilename(), 0, 1) != ".") {
			if(!preg_match('/.php$/', $file)) {
				if (isAllowedExtension($file))
					array_push($cache,"\n" . str_replace($pathhome, "", $file));
			}

			$hashes .= md5_file($file);
		}
	}
	
	// Cache image
	$attachments = get_children( array(
		'post_parent' => get_the_ID(),
		'post_status' => 'inherit',
		'post_type' => 'attachment',
		'numberposts' => 50,
		'post_mime_type' => 'image') 
	);
	foreach ( $attachments as $attachment_id => $attachment ) {
		array_push($cache,"\n" . wp_get_attachment_url( $attachment_id ) );
	}

 	//URLs
 	$site_url = "\n". get_bloginfo("url");
	$pages = array('post_type' => 'page', 'posts_per_page' => -1 );
	$posts = array('post_type' => 'post', 'posts_per_page' => -1 );
	$categories = get_categories(array(
    'orderby' => 'name',
    'order'   => 'ASC'
) );

	$urls = "\n";
 	$loop = new WP_Query($pages);
 	if( $loop->have_posts() ): 
 		while( $loop->have_posts() ):
 			$loop->the_post();
 			global $post; 
    		$urls .= get_permalink($post->ID)."\n";
   		endwhile;
   	endif;
   	wp_reset_query();

   	$loop = new WP_Query($posts);
 	if( $loop->have_posts() ): 
 		while( $loop->have_posts() ):
 			$loop->the_post();
 			global $post; 
    		$urls .= get_permalink($post->ID)."\n";
   		endwhile;
   	endif;
   	wp_reset_query();

   	foreach ($categories as $cat) {
	   $urls .= get_category_link($cat->cat_ID)."\n";
	}

	//$fh = fopen( get_stylesheet_directory().'/cache.manifest', 'w' );
	$fh = fopen( get_home_path().'/cache.manifest', 'w' );
	fwrite($fh,'CACHE MANIFEST');
 
	foreach($cache as $file){ fwrite($fh,$file); }
	fwrite($fh,$site_url);
	fwrite($fh,$urls);
	fwrite($fh,"\n# Contenu Fallback");
	fwrite($fh,"\nFALLBACK:");
	fwrite($fh,"\n/ offline.html");
	foreach($network as $file){ fwrite($fh,$file);}
	fwrite($fh,"\nhSpecific Entry");
	fwrite($fh, "\n\n# Hash:" . md5($hashes));  
	fclose($fh);

	$manifest_file = get_home_path() .'/offline.html';

	if ( !file_exists($manifest_file) ) {
			$fh = fopen( get_home_path().'/offline.html', 'w' );
			fwrite($fh, "<!DOCTYPE html>\n");
			fwrite($fh, "<html manifest=\"cache.manifest\">\n");
			fwrite($fh, "<head><meta charset=\"utf-8\" /><title>cache</title></head>\n");
			fwrite($fh, "<div class='content-center' style='max-width: 200px;margin: 100px auto;'>\n");
			fwrite($fh, "<h1 style='color: #333;font-size: 25px; text-align: center;'>Contenu disponible en ligne uniquement</h1>\n");
			fwrite($fh, "</div>\n");
			fwrite($fh, "</html>\n");
			fclose($fh);
	}

}

function isAllowedExtension($file) {
	$allowedExtensions = array("php", "gif", "png", "jpg", "js", "css");
	//$ignore = array("error_log","html", ".dev.", "screenshot", ".txt", "psd", "psd", "manifest", "_.", "!");
	return in_array(end(explode(".", $file)), $allowedExtensions);
}

function remove_manifest_file(){
	$files = array( get_stylesheet_directory() .'/manifest.html', get_stylesheet_directory().'/cache.manifest' );
	foreach( $files as $file ) {
		if( file_exists( $file ) )
		unlink( $file );
	}
}

register_activation_hook( __FILE__, '_add_manifest_file' );

//register_deactivation_hook( __FILE__, 'remove_manifest_file' );

?>