/*
 * ============================================================================
 * KiosqueTheme entry point
 * ============================================================================
 */

var Kiosque = {};

Kiosque.$window = null;
Kiosque.$body = null;

Kiosque.windowSize = {
    width: 1920,
    height: 1280
};

Kiosque.firstResize = true;
Kiosque.smLimit = 767;
Kiosque.$loading = null;

Kiosque.$nav = null;
Kiosque.nav = null;

Kiosque.$footer = null;
Kiosque.footer = null;

Kiosque.$search = null;
Kiosque.search = null;

Kiosque.isMobile = false;
Kiosque.isIE = false;

Kiosque.page = null;
Kiosque.formerPage = null;

Kiosque.nodeTypesClasses = {
    'page' : 'KiosquePage',
    'basicblock' : 'BasicBlock',
    'issuefeed' : 'IssueFeedBlock',
    'mixedsocialfeed' : 'MixedSocialFeedBlock'
};

Kiosque.$ajaxContainer = null;
Kiosque.ajaxEnabled = false;
Kiosque.gmapLoaded = false;

/**
 * On document ready
 */
Kiosque.onDocumentReady = function(e) {
    var _this = _this;

    // Store temp configuration
    for( var index in temp ){
        Kiosque[index] = temp[index];
    }

    Kiosque.init();
};


/**
 * Init
 */
Kiosque.init = function(){
    var _this = this;

    // Set default TweenLite ease
    TweenLite.defaultEase = Expo.easeOut;

    // Selectors
    _this.$window = $(window);
    _this.$body = $('body');

    _this.$ajaxContainer = $('#ajax-container');
    _this.$loading = $('#loading');

    // Set first window size
    var viewport = getViewportSize();

    _this.windowSize = {
        width : viewport.width,
        height : viewport.height
    };

    // isMobile test
    _this.isMobile = (isMobile.any === false) ? false : true;
    if(_this.isMobile) addClass(_this.$body[0],'is-mobile');

    // IE Test
    if(navigator.userAgent.indexOf('MSIE') >= 0 ||
        navigator.userAgent.indexOf('Trident') >= 0){
        _this.isIE = true;
        addClass(_this.$body[0],'ie');
    }

    // Disable ajax if history is not available
    if(!Modernizr.history) Kiosque.ajaxEnabled = false;

    // History
    _this.history = new KiosqueHistory({
        'homeHasClass': false
    });
    var dataHome = _this.$body[0].getAttribute('data-is-home'),
        isHome = (dataHome == '1') ? true : false;
    _this.history.boot(_this.$body[0].getAttribute('data-node-type'), _this.$body[0].id, 'static', isHome);

    // Nav
    _this.$nav = $('#nav');
    if(_this.$nav.length) _this.nav = new KiosqueNav();

    // Footer
    _this.$footer = $('#footer');
    if(_this.$footer.length) _this.footer = new KiosqueFooter();

    // Search
    _this.$search = $('#search-cont');
    if(_this.$search.length) _this.search = new KiosqueSearch();

    // Events
    _this.$window.on('resize', debounce($.proxy(_this.resize, _this), 50, false));
    _this.$window.on('orientationchange', debounce($.proxy(_this.resize, _this), 50, false));
    _this.$window.trigger('resize');

    gaTrackErrors();
};


/**
 * Resize
 */
Kiosque.resize = function(){
    var _this = this;

    // console.log('-> Resize');

    // Check is sizes has changed
    var viewport = getViewportSize();

    if(viewport.width !== _this.windowSize.width ||
        viewport.height !== _this.windowSize.height ||
        _this.firstResize){

        _this.windowSize = getViewportSize();

        // console.log('ww : '+_this.windowSize.width);
        // console.log('wh : '+_this.windowSize.height);

        if(_this.firstResize) _this.firstResize = false;
    }
};

/**
 * Dispatch Google Maps initialization
 * over every page blocks.
 *
 * This method must be called as a Google Map callback
 * after external JS lib has been loaded:
 *
 *     Kiosque.gmapLoaded = true;
 *     var script = document.createElement('script');
 *     script.type = 'text/javascript';
 *     script.src = '//maps.googleapis.com/maps/api/js?key=' +
 *         Kiosque.googleClientId +
 *         '&callback=Kiosque.initMaps';
 *     document.body.appendChild(script);
 */
Kiosque.initMaps = function () {
    var _this = this;

    _this.gmapLoaded = true;

    for(var blockIndex = 0; blockIndex < _this.page.blockLength; blockIndex++) {
        var block = _this.page.blocks[blockIndex];
        block.initMaps();
    }
};


/*
 * ============================================================================
 * Plug into jQuery standard events
 * ============================================================================
 */
$(document).ready(Kiosque.onDocumentReady);
