<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('en', array (
  'messages' => 
  array (
    'welcome.user.email.%site%' => 'A user account has been created for you on %site%.',
    'your.user.account' => 'Your user account',
    'username' => 'Username',
    'email' => 'Email',
    'password' => 'Password',
    'for.questions.email' => 'Any questions? Email us at:',
    'contact.form' => 'Contact form',
    'new.contact.form.%site%' => 'New contact request for %site%',
    'form.successfully.sent' => 'Your form has been successfully sent',
    'form.has.errors' => 'Your form is not valid, please fill correctly mandatory fields.',
    '%field%.is.mandatory' => 'Field %field% is mandatory',
    'email.not.valid' => 'Your email is not valid',
    'date' => 'Date',
    'ip.address' => 'IP address',
    'submittedAt' => 'Submitted on',
    'form.submit' => 'Submit',
    'answer.form' => 'Answer form.',
    'customForm.%name%.send' => 'The custom form "%name%" sent.',
    'new.answer.form.%site%' => 'New answer for "%site%" form.',
    'file.not.accepted' => 'Attached file could not be accepted.',
    'customForm.answer.sent' => 'Your answer has been successfully sent.',
    'none' => 'None',
    'reset.password.request' => 'Reset password request',
    'you.asked.for.a.password.reset.on.%site%' => 'You asked for a password reset on “%site%”',
    'you.need.to.choose.a.new.password.using.following.link' => 'You need to create a new password for your account by using the following link.',
    'as.a.reminder.here.are.your.credentials' => 'As a reminder, here are your public credentials.',
    'if.you.didnt.request.this.password.reset.ignore.this.email' => 'If you didn’t ask for this email, just ignore it and your password won’t be changed.',
    'reset_your_password' => 'Reset your password',
    'you.need.to.fill.this.required.field' => 'You need to fill this required field.',
    '*.required.fields' => '* Required fields',
    'website.is.under.maintenance' => 'Website is under maintenance',
    'website.is.under.maintenance.we.will.be.back.soon' => 'Website is currently under maintenance, it will be back soon!',
    'Node name' => 'Node name',
    'See tree' => 'See tree',
    '_username' => 'Username',
    '_password' => 'Password',
    'password.verify' => 'Verify password',
    'delete' => 'Delete',
    'status' => 'Status',
    'welcome.title' => 'Roadiz’s Installation',
    'welcome.subtitle' => 'Welcome to Roadiz CMS!',
    'welcome.message' => '<p>Here is just a bit of configuration before letting you play. So start the engine!</p>',
    'requirements.title' => 'Requirements',
    'requirements.message' => '<p>To use Roadiz, your server needs some requirements, especially with PHP. If you have access to your configuration file (php.ini), you could modify some of them.</p>',
    'requirements.spec' => 'Specification',
    'requirements.requirement' => 'Requirement',
    'requirements.actual_value' => 'Actual value',
    'database.title' => 'Database',
    'database.message' => '<p>Roadiz need a database to store all your content. You could select your favorite database driver and configure it.</p>',
    'database.cannot_connect' => 'Cannot connect to database',
    'database.build' => 'Build database',
    'database_done.title' => 'Database installed',
    'database_done.message' => '<p>Your database has been successfully installed. We are going to import base contents and parameters for your website.</p>',
    'database_fail.title' => 'Database could not be installed',
    'database_fail.message' => '<p>Your database could not be installed due to following errors. Verify your database credentials or if database has been installed yet.</p>',
    'import.title' => 'Import default data',
    'import.message' => '<p>Importing default data for settings, roles and groups</p>',
    'import.step_name' => 'Step',
    'user.title' => 'Create user',
    'user.message' => '<p>Create an user to access to the back-office.</p>',
    'user.create' => 'Create user',
    'user.name' => 'Username',
    'user.email' => 'User email',
    'user.create_another' => 'Create another user',
    'user_summary.title' => 'User created',
    'themes.title' => 'Information',
    'themes.message' => '<p>Enter basic informations about your site</p>',
    'themes.save_informations' => 'Save informations',
    'themes.frontend.description' => 'You can install some default theme(s) and content to your site',
    'import_node_type.title' => 'Import node type',
    'import_node_type.message' => 'Node type',
    'import_node_type.node_type' => 'Import node type',
    'import_node_type.node' => 'Node type',
    'import_tags' => 'Tags',
    'success.title' => 'Success',
    'success.message' => '<p>Roadiz has been successfully installed</p>',
    'success.quit_install' => 'Exit installation',
    'goto.requirements' => 'Requirements',
    'goto.welcome' => 'Back to home',
    'goto.database' => 'Database',
    'goto.import' => 'Import',
    'goto.user' => 'User',
    'goto.theme' => 'Theme',
    'goto.informations' => 'Informations',
    'skip.user.goto.theme' => 'Skip',
    'skip.user.goto.done' => 'User summary',
    'skip.database.goto.import' => 'Skip',
    'choose.language' => 'Choose language',
    'choose.a.language' => 'Choose your main language',
    'skip.database.goto.theme' => 'Skip',
    'theme.summary.title' => 'Theme setup summary',
    'check.version' => 'Version',
    'theme.name' => 'Name',
    'theme.version' => 'Version',
    'cms.version' => 'CMS version',
    'theme.supportedLocale' => 'Supported locale(s)',
    'cms.locale' => 'CMS locale',
    'name' => 'Name',
    'filename' => 'File name',
    'nodetypes' => 'Node-types',
    'nodes' => 'Nodes',
    'install.theme' => 'Perform theme install',
    'import.theme.content.title' => 'Import theme content',
    'step.name' => 'Step',
    'goto.done' => 'Done',
    'import_roles' => 'Roles',
    'import_groups' => 'Roles groups',
    'import_settings' => 'Settings',
    'theme.selector' => 'Available themes',
    'check.locale' => 'Locale',
    'check.import.files' => 'Files to import',
    'password.must_match' => 'Passwords must match',
    'site_name' => 'Website name',
    'email_sender' => 'Main website email address',
    'email_sender_name' => 'Main website sender name',
    'meta_description' => 'SEO Description',
    'timezone' => 'TImezone',
    'install_theme' => 'Install a theme?',
    'driver' => 'Driver',
    'host' => 'Host',
    'port' => 'Port',
    'unix_socket' => 'UNIX socket',
    'path' => 'Path',
    'user' => 'User',
    'dbname' => 'Database name',
    'error.locale.message' => 'Theme locale does not exist on your system.',
    'error.modal.title' => 'Please fix the following issues before installing theme.',
    'error.version.message' => 'This theme needs a newer version of Roadiz.',
    'warning.theme.continue' => 'You can ignore theses messages and continue anyway.',
    'now_you_can_delete_install_file_and_use_roadiz' => 'Now Roadiz installation is completed you can remove the install.php script from Roadiz folder and access to your fresh website without it.',
    'node.%name%.updated' => 'Node "%name%" has been updated.',
    'node.%nodeId%.not_exists' => 'Node %nodeId% does not exists.',
    'node.%name%.status.%field%.updated' => 'Node %name% "%field%" status has been updated.',
    'node.has_no.field.%field%' => 'Node has no field named "%field%".',
    'node.id.not_specified' => 'A node id hasn’t been specified.',
    'document.%name%.updated' => 'Document "%name%" has been updated.',
    'document.%name%.deleted' => 'Document "%name%" has been deleted.',
    'document.%name%.cannot_delete' => 'Document "%name%" can\'t be deleted.',
    'document.%name%.uploaded' => 'Document "%name%" has been uploaded.',
    'document.cannot_persist' => 'Document can\'t be saved to database.',
    'description' => 'Description',
    'copyright' => 'Copyright',
    'private' => 'Private',
    'choose.documents.to_upload' => 'Choose documents to upload to your server.',
    'cache.deleted' => 'Cache has been purged.',
    'group.%name%.created' => 'Group %name% has been created.',
    'group.%name%.deleted' => 'Group %name% has been deleted.',
    'group.%name%.updated' => 'Group %name% has been updated.',
    'role.%role%.linked_group.%group%' => 'Role %role% has been added to %group% group.',
    'role.%role%.removed_from_group.%group%' => 'Role %role% has been removed from %group% group.',
    'user.%user%.linked.group.%group%' => 'User %user% has been linked to %group% group.',
    'user.%user%.removed_from_group.%group%' => 'User %user% has been removed from %group% group.',
    'group.name' => 'Group name',
    'choose.role' => 'Choose a role.',
    'choose.user' => 'Choose an user.',
    'group.name.already.exists' => 'Group name already exists.',
    'theme.%name%.created' => 'Theme (%name%) has been created.',
    'theme.%name%.updated' => 'Theme (%name%) has been updated.',
    'theme.%name%.deleted' => 'Theme (%name%) has been deleted.',
    'themeClass' => 'Theme’s class',
    'available' => 'Available',
    'hostname' => 'Host name',
    'backendTheme' => 'Backend theme',
    'theme.%name%.no_creation.already_exists' => 'Theme (%name%) can\'t be added, it already exists.',
    'user.%name%.updated' => 'User %name% has been updated.',
    'user.%user%.role.%role%.linked' => 'User %user% has been granted to role "%role%".',
    'user.%name%.role_removed' => 'User %name% has been removed a role.',
    'user.%user%.group.%group%.linked' => 'User %user% has joined %group% group.',
    'user.%user%.group.%group%.removed' => 'User %user% has been removed from %group% group.',
    'user.%name%.created' => 'User %name% has been created.',
    'user.%name%.deleted' => 'User %name% has been deleted.',
    'user.facebook_name.%name%._does_not_exist' => 'Facebook user (%name%) does not exist',
    'passwordVerify' => 'Verify your password',
    'firstName' => 'First name',
    'lastName' => 'Last name',
    'phone' => 'Phone',
    'company' => 'Company',
    'job' => 'Job',
    'birthday' => 'Birthday',
    'facebookName' => 'Facebook user ID',
    'role.%name%.created' => 'Role "%name%" has been created.',
    'role.%name%.deleted' => 'Role "%name%" has been deleted.',
    'role.%name%.updated' => 'Role "%name%" has been updated.',
    'role.name.must_comply_with_standard' => 'Role’s name must start with "ROLE_" and contain only uppercase letters and underscores.',
    'role.name.already.exists' => 'Role name already exists.',
    'role.required.cannot_be_updated' => 'Role is required by system and can\'t be updated.',
    'role.is.required' => 'Role is required',
    'nodeType.imported.created' => 'Node type has been imported and successfully saved to database.',
    'nodeType.imported.updated' => 'Node type has been imported and successfully updated database.',
    'file.format.not_valid' => 'File format is not valid.',
    'file.not_uploaded' => 'File could not be uploaded.',
    'nodeType.file' => 'Node type file',
    'tag.%name%.updated' => 'Tag %name% has been updated.',
    'tag.%name%.created' => 'Tag %name% has been created.',
    'tag.%name%.deleted' => 'Tag %name% has been deleted.',
    'child.tag.%name%.created' => 'Child tag %name% has been created.',
    'locked' => 'Locked',
    'visible' => 'Visible',
    'invisible' => 'Invisible',
    'parent_tagId' => 'Parent tag’s id',
    'tagName' => 'Unique tag identifier',
    'node.seo.updated' => 'Node SEO data has been updated.',
    'node.seo.not.updated' => 'Node SEO data could not been updated.',
    'url_alias.%alias%.updated' => 'Url alias "%alias%" has been updated.',
    'url_alias.%alias%.no_update.already_exists' => 'Url alias "%alias%" can\'t be updated, it already exists.',
    'url_alias.%alias%.deleted' => 'Url alias "%alias%" has been deleted.',
    'url_alias.%alias%.created.%translation%' => 'Url alias "%alias%" has been created for "%translation%" translation.',
    'url_alias.%alias%.no_creation.already_exists' => 'Url alias "%alias%" could not be created, it already exists',
    'url_alias.no_translation.%translation%' => 'Cannot create an url alias for %translation% translation, it does not exists.',
    'urlAlias' => 'Url alias',
    'translation' => 'Translation',
    'metaTitle' => 'Meta-title',
    'metaKeywords' => 'Meta-keywords',
    'metaDescription' => 'Meta-description',
    'nodeTypeField.%name%.updated' => 'Node-type field %name% has been updated.',
    'nodeTypeField.%name%.created' => 'Node-type field %name% has been created.',
    'nodeTypeField.%name%.deleted' => 'Node-type field %name% has been deleted.',
    'label' => 'Label',
    'type' => 'Type',
    'indexed' => 'Indexed',
    'defaultValues' => 'Default values',
    'enter_values_comma_separated' => 'Enter each values separated with commas.',
    'node.%name%.translated' => 'Node %name% has been translated.',
    'node_source.%node_source%.updated.%translation%' => 'Node source %node_source% has been updated for %translation% translation.',
    'node.%node%.linked.tag.%tag%' => 'Node %node% has been tagged "%tag%".',
    'tag.%name%.removed' => 'Tag %name% has been removed.',
    'node.%name%.created' => 'Node %name% has been created.',
    'child_node.%name%.created' => 'Child node %name% has been created.',
    'node.%name%.deleted' => 'Node %name% has been deleted.',
    'nodeName' => 'Node name',
    'nodeType' => 'Node-type',
    'priority' => 'Priority',
    'node.isHome' => 'Mark this node as Home',
    'choose.tag' => 'Choose a tag',
    'nodeType.%name%.updated' => 'Node-type %name% has been updated.',
    'nodeType.%name%.created' => 'Node-type %name% has been created.',
    'nodeType.%name%.deleted' => 'Node-type %name% has been deleted.',
    'nodeType.displayName' => 'Display name',
    'nodeType.newsletterType' => 'Newsletter node-type',
    'nodeType.hidingNodes' => 'Node-type hides its nodes',
    'role.imported' => 'Role has been imported.',
    'role.file' => 'Role file',
    'setting.%name%.updated' => 'Setting %name% has been updated.',
    'setting.%name%.created' => 'Setting %name% has been created.',
    'setting.%name%.deleted' => 'Setting %name% has been deleted.',
    'setting.%name%.no_update.already_exists' => 'Setting %name% can\'t be updated, it already exists.',
    'setting.%name%.no_creation.already_exists' => 'Setting %name% can\'t be created, it already exists.',
    'value' => 'Value',
    'setting.group' => 'Settings group',
    'database.schema.updated' => 'Database schema has been updated.',
    'database.schema.cannot_updated' => 'Database schema could not be updated.',
    'group.imported.updated' => 'Group has been imported and successfully saved to database.',
    'group.file' => 'Group file',
    'font.%name%.created' => 'Font %name% has been created.',
    'font.%name%.deleted' => 'Font %name% has been deleted.',
    'font.%name%.updated' => 'Font %name% has been updated.',
    'font.name' => 'Font name',
    'font.variant' => 'Font style variant',
    'font.hash' => 'Font CSS identifier',
    'font.eotFile' => 'EOT font file',
    'font.woffFile' => 'WOFF font file',
    'font.woff2File' => 'WOFF2 font file',
    'font.otfFile' => 'OTF font file',
    'font.svgFile' => 'SVG font file',
    'setting.imported' => 'Setting has been successfully imported.',
    'settingFile' => 'Setting file',
    'translation.%name%.made_default' => 'Translation %name% has been set as the default language.',
    'translation.%name%.updated' => 'Translation %name% has been updated.',
    'translation.%name%.created' => 'Translation %name% has been created.',
    'translation.%name%.deleted' => 'Translation %name% has been deleted.',
    'translation.%name%.cannot_delete_default_translation' => 'Translation "%name%" can\'t be deleted, it is the default translation.',
    'locale' => 'Locale',
    'add.tag' => 'Add tag',
    'add.child.tag' => 'Add child tag',
    'tags' => 'Tags',
    'id' => 'Id',
    'actions' => 'Actions',
    'notranslation_available.tag' => 'No available translation has been found for tag.',
    'edit.node.%name%.seo' => '%name%',
    'edit.node.seo' => 'Edit SEO data',
    'save' => 'Save',
    'add.urlAlias' => 'Add url-alias',
    'unlink.tag.%name%' => 'Unlink tag "%name%"',
    'are_you_sure.unlink.tag' => 'Are you sure to unlink tag?',
    'cancel' => 'Cancel',
    'edit.nodeType.%name%' => '%name%',
    'edit.tag.%name%' => '%name%',
    'edit.tag' => 'Edit tag',
    'add.tag.%name%.child' => 'Add child to "%name%" tag',
    'delete.tag.%name%' => 'Delete tag "%name%"',
    'delete.tag' => 'Delete tag',
    'edit.user.%name%.groups' => '%name%’s groups',
    'group' => 'Group',
    'unlink' => 'Unlink',
    'add.group' => 'Add group',
    'add.user' => 'Add user',
    'back_to.users' => 'Back to users',
    'edit.group.%name%' => '%name%',
    'Welcome' => 'Welcome',
    'edit.user.%name%' => '%name%',
    'import.setting' => 'Import settings',
    'import' => 'Import',
    'hello.%name%' => 'Hello, %name%',
    'back_to.tags' => 'Back to tags',
    'edit' => 'Edit',
    'edit.setting.%name%' => 'Edit setting %name%',
    'back_to.settings' => 'Back to settings',
    'are_you_sure.delete.tag' => 'Are you sure to delete this tag.',
    'search' => 'Search',
    'goto.page' => 'Go to page',
    'prev' => 'Prev.',
    'next' => 'Next',
    'delete.user.%name%' => 'Delete user %name%.',
    'are_you_sure.delete.user' => 'Are you sure you want to delete this user ?',
    'edit.group.%name%.roles' => 'Edit roles from group %name%',
    'role' => 'Role',
    'unlink.role' => 'Unlink role',
    'add.role' => 'Add role',
    'delete.user' => 'Delete user',
    'translations' => 'Translations',
    'add.translation' => 'Add translations',
    'translation.locale' => 'Translation locale',
    'not_available' => 'Not available',
    'set.default' => 'Set default',
    'edit.nodeSource.%name%' => '%name%',
    'back_to.documents' => 'Back to documents',
    'delete.document' => 'Delete document',
    'edit.nodeTypeFields.for.nodeType.%name%' => '%name% fields',
    'back_to.nodeTypes' => 'Back to node-types',
    'add.nodeTypeField' => 'Add node-type field',
    'remove.user.%name%.from.group.%group%' => 'Remove %name% form group %group%',
    'are_you_sure.remove.user.from.group' => 'Are you sure you want to remove user from group ?',
    'edi.user.%name%.roles' => '%name%\'s roles',
    'specific.roles' => 'Specific roles',
    'inherited.roles' => 'Inherited roles',
    'add.specific.role' => 'Add specific role',
    'import.role' => 'Import role',
    'edit.node.%name%.tags' => '%name%',
    'back_to.groups' => 'Back to groups',
    'delete.group' => 'Delete group',
    'user.edit' => 'Informations',
    'user.roles' => 'Roles',
    'user.groups' => 'Groups',
    'user.history' => 'History',
    'delete.document.%name%' => 'Delete document %name%',
    'are_you_sure.delete.document' => 'Are you sure you want to delete this document ?',
    'group.edit' => 'Edit group',
    'group.roles' => 'Group roles',
    'group.users' => 'Group users',
    'remove.user.%name%.role.%role%' => 'Remove role %role% from user %name%',
    'are_you_sure.remove.user.role' => 'Are you sur you want to remove this user\'s role ?',
    'add.theme' => 'Add theme',
    'back_to.themes' => 'Back to themes',
    'unlink.user.%name%' => 'Unlink user %name%',
    'add.node' => 'Add node',
    'In' => 'In',
    'back_to.nodes' => 'Back to nodes',
    'nodeTree' => 'Node tree',
    'dashboard' => 'Dashboard',
    'history' => 'History',
    'comments' => 'Comments',
    'themes' => 'Themes',
    'theme' => 'Theme',
    'theme.classname' => 'Theme class name',
    'theme.host' => 'Theme host',
    'all.hostnames' => 'All host names',
    'theme.disabled' => 'Theme disabled',
    'theme.backend' => 'Theme Backend',
    'roles' => 'Roles',
    'export.all.roles' => 'Export all roles',
    'export' => 'Export',
    'role.required' => 'Role is required',
    'welcome' => 'Welcome',
    'back_to.roles' => 'Back to roles',
    'delete.role' => 'Delete role',
    'add' => 'Add',
    'tag.%name%.tree' => 'Tag %name% tree',
    'edit.role.%name%' => '%name%',
    'settings' => 'Settings',
    'add.setting' => 'Add setting',
    'Delete' => 'Delete',
    'create.node' => 'Create node',
    'node.type' => 'Node-type',
    'node.status' => 'Node status',
    'last.modification' => 'Last modification',
    'node.not.published' => 'Node not published',
    'see.nodetree' => 'See node tree',
    'import.group' => 'Import group',
    'purge.cache' => 'Purge cache',
    'are_you_sure.purge.cache' => 'Are you sure you want to purge cache ?',
    'clear' => 'Clear',
    'fonts' => 'Fonts',
    'add.font' => 'Add font',
    'font.files' => 'Font files',
    'font.cssfamily' => 'Font css family',
    'download' => 'Download',
    'unlink.role.%name%' => 'Unlink role %name%',
    'are_you_sure.remove.role.from.group' => 'Are you sure you want to remove this role from this group ?',
    'users' => 'Users',
    'user.username' => 'User name',
    'edit.theme' => 'Edit theme',
    'edit.tag.%name%.settings' => '%name%',
    'delete.font.%name%' => 'Delete font %name%',
    'are_you_sure.delete.font' => 'Are you sure you want to delete this font ?',
    'search.node' => 'Search node',
    'edit.nodeTypeField.%name%' => '%name%',
    'delete.caches' => 'Delete caches',
    'logout' => 'Log out',
    'dev_mode.activated' => 'Dev mode On',
    'help' => 'Help',
    'datetime' => 'Datetime',
    'level' => 'Level',
    'message' => 'Message',
    'back_to.nodeTypeFields' => 'Back to node-type fields',
    'delete.nodeTypeField' => 'Delete node-type field',
    'edit.node.%name%' => '%name%',
    'edit.node' => 'Edit node',
    'add.node.%name%.child' => 'Add node %name% child',
    'add.child.node' => 'Add child node',
    'delete.node.%name%' => 'Delete node %name%',
    'delete.node' => 'Delete node',
    'see.page' => 'See page',
    'preview.page' => 'Preview page',
    'duplicate' => 'Duplicate',
    'add.child' => 'Add child',
    'statuses' => 'Statuses',
    'visibility' => 'Visibility',
    'published' => 'Published',
    'hiding-children' => 'Hiding children',
    'lock-status' => 'Lock status',
    'sterile-status' => 'Forbid children',
    'archive-status' => 'Archive status',
    'edit.document.%name%' => '%name%',
    'delete.nodeTypeField.%name%' => 'Delete node-type field %name%',
    'arz_you_sure.delete.nodeTypeField' => 'Are you sure you want to delete this node-type field ?',
    'delete.theme.%name%' => 'Delete theme %name%',
    'are_you_sure.delete.theme' => 'Are you sure you want to delete this theme ?',
    'edit.group.%name%.users' => '%name% users',
    'unlink.user' => 'Unlink user',
    'delete.group.%name%' => 'Delete group %name%',
    'are_you_sure.delete.group' => 'Are you sure you want to delete this group ?',
    'see.website' => 'See website',
    'minify.tree.panel' => 'Minify tree panel',
    'interactions' => 'Interactions',
    'manage.surveys' => 'Manage surveys',
    'manage.newsletters' => 'Manage newsletters',
    'manage.subscribers' => 'Manage subscribers',
    'manage.comments' => 'Manage comments',
    'manage.tags' => 'Manage tags',
    'manage.documents' => 'Manage documents',
    'construction' => 'Construction',
    'manage.nodes' => 'Manage nodes',
    'manage.nodeTypes' => 'Manage node-types',
    'manage.translations' => 'Manage translations',
    'manage.themes' => 'Manage themes',
    'manage.fonts' => 'Manage fonts',
    'user.system' => 'User system',
    'manage.users' => 'Manage users',
    'manage.roles' => 'Manage roles',
    'manage.groups' => 'Manage groups',
    'site.settings' => 'Site settings',
    'Translate' => 'Translate',
    'are_you_sure.delete.node.and.data' => 'Are you sure you want to delete node and data ?',
    'node.content' => 'Node content',
    'node.parameters' => 'Node parameters',
    'seo' => 'SEO',
    'tree' => 'Tree',
    'back_to.fonts' => 'Back to fonts',
    'import.nodeType' => 'Import node-type',
    'back_office' => 'Backstage',
    'login' => 'Log in',
    'view.site' => 'View website',
    'forgot.password' => 'Forgot password ?',
    'nodeTypes' => 'Node-types',
    'add.nodeType' => 'Add node-type',
    'nodeType.entityName' => 'Node-type entity name',
    'fields' => 'Fields',
    'manage.nodeTypeFields' => 'Manage node-type fields',
    'delete.nodeType' => 'Delete node-type',
    'edit.translation.%name%' => '%name%',
    'back_to.translations' => 'Back to translations',
    'delete.translation' => 'Delete translation',
    'edit.node.%name%.tree' => '%name%',
    'tag.color' => 'Color',
    'tag.tree' => 'Tag tree',
    'tag.content' => 'Tag content',
    'tag.settings' => 'Tag settings',
    'tag.nodes' => 'Tag nodes',
    'tagged.nodes' => 'Tagged nodes',
    'groups' => 'Groups',
    'export.all.groups' => 'Export all groups',
    'group.required' => 'Group required',
    'delete.nodeType.%name%' => 'Delete node-type %name%',
    'are_you_sure.delete.nodeType.and.nodes.newsletters' => 'Are you sure you want to delete node-type ans nodes newsletters ?',
    'upload.document' => 'Upload',
    'upload' => 'Upload',
    'edit.font.%name%' => '%name%',
    'edit.font' => 'Edit font',
    'edit.document' => 'Edit document',
    'unlink.document' => 'Unlink document',
    'delete.role.%name%' => 'Delete role %name%',
    'are_you_sure.delete.role' => 'Are you sure you want to delete this role ?',
    'wait_for.authentification' => 'Wait for authentification',
    'documents' => 'Documents',
    'document.thumbnail' => 'Thumbnail',
    'document.filename' => 'Filename',
    'document.createdAt' => 'Created at',
    'documents.toggle-explorer' => 'Explorer',
    'documents.toggle-uploader' => 'Uploader',
    'documents.toggle-embedder' => 'Embedder',
    'delete.translation.%name%' => 'Delete translation %name%',
    'are_you_sure.delete.translation.and.node.data' => 'Are you sure you want to delete this translation and node data ?',
    'delete.setting.%name%' => 'Delete settings %name%',
    'are_you_sure.delete.setting' => 'Are you sure you want to delete settings ?',
    'translate' => 'Translate',
    'translate.node' => 'Translate node',
    'title' => 'Title',
    'page' => 'Page',
    'choose.value' => '-- Choose a value --',
    '{0} no.item|{1} 1.item|]1,Inf] %count%.items' => '{0} No item|{1} <span>1</span> item|]1,Inf] <span>%count%</span> items',
    '1.item' => '1 item',
    '%count%.items' => '%count% items',
    '{0} no.role|{1} 1.role|]1,Inf] %count%.roles' => '{0} No role|{1} 1 role|]1,Inf] %count% roles',
    '1.role' => '1 role',
    '%count%.roles' => '%count% roles',
    '{0} no.group|{1} 1.group|]1,Inf] %count%.groups' => '{0} No group|{1} 1 group|]1,Inf] %count% groups',
    '1.group' => '1 group',
    '%count%.groups' => '%count% groups',
    '{0} no.user|{1} 1.user|]1,Inf] %count%.users' => '{0} No user|{1} 1 user|]1,Inf] %count% users',
    '1.user' => '1 user',
    '%count%.users' => '%count% users',
    '{0} no.tag|{1} 1.tag|]1,Inf] %count%.tags' => '{0} No tag|{1} 1 tag|]1,Inf] %count% tags',
    '1.tag' => '1 tag',
    '%count%.tags' => '%count% tags',
    '{0} no.document|{1} 1.document|]1,Inf] %count%.documents' => '{0} No document|{1} 1 document|]1,Inf] %count% documents',
    '1.document' => '1 document',
    '%count%.documents' => '%count% documents',
    '{0} no.node|{1} 1.node|]1,Inf] %count%.nodes' => '{0} No node|{1} 1 node|]1,Inf] %count% nodes',
    '1.node' => '1 node',
    '%count%.nodes' => '%count% nodes',
    '{0} no.nodeTypeField|{1} 1.nodeTypeField|]1,Inf] %count%.nodeTypeFields' => '{0} No field|{1} 1 field|]1,Inf] %count% fields',
    '1.nodeTypeField' => '1 field',
    '%count%.nodeTypeFields' => '%count% fields',
    'string.type' => 'Single-line text',
    'date-time.type' => 'Date and time',
    'date.type' => 'Date',
    'text.type' => 'Basic text',
    'markdown.type' => 'Markdown text',
    'json.type' => 'JSON code',
    'css.type' => 'CSS code',
    'boolean.type' => 'Boolean (true or false)',
    'integer.type' => 'Integer number',
    'decimal.type' => 'Decimal number',
    'email.type' => 'Email',
    'single-choice.type' => 'Single choice',
    'multiple-choice.type' => 'Multiple choice',
    'documents.type' => 'Documents',
    'children-nodes.type' => 'Children nodes',
    'add.a.%nodeType%' => 'Add a %nodeType%',
    'bad.request' => 'Bad request',
    'document.platform' => 'Media platform',
    'document.embedId' => 'Platform media identifier',
    '%field%.is.reserved.word' => '“%field%” name is a reserved word, please choose another one.',
    'settingGroup' => 'Setting groups',
    '%group%.settings' => '“%group%” settings',
    'settingGroup.%name%.updated' => 'Setting group %name% has been updated.',
    'settingGroup.%name%.created' => 'Setting group %name% has been created.',
    'settingGroup.%name%.deleted' => 'Setting group %name% has been deleted.',
    'settingGroup.%name%.no_update.already_exists' => 'Setting group %name% can\'t be updated, it already exists.',
    'settingGroup.%name%.no_creation.already_exists' => 'Setting group %name% can\'t be created, it already exists.',
    'settingGroup.in.menu' => 'In menu',
    'see.settings' => 'See settings',
    'add.settingGroup' => 'Add setting group',
    'edit.settingGroup.%name%' => '%name%',
    'save.settingGroup' => 'Save setting group',
    'are_you_sure.delete.settingGroup' => 'Are you sure you want to delete this setting group ?',
    'delete.settingGroup.%name%' => 'Delete setting group “%name%”',
    'delete.settingGroup' => 'Delete setting group',
    'back_to.settingGroups' => 'Back to setting groups',
    'all.settings' => 'All settings',
    'setting.groups' => 'Setting groups',
    'settingGroups' => 'Setting groups',
    'display_debug_panel' => 'Display debug panel',
    'soundcloud_client_id' => 'Soundcloud client ID',
    'google_client_id' => 'Google API - browser key',
    'google_server_id' => 'Google API - server key',
    'twitter_client_id' => 'Twitter client ID',
    'facebook_client_id' => 'Facebook client ID',
    'seo_description' => 'SEO meta-description',
    'site_copyright' => 'Website author name',
    'maintenance_mode' => 'Maintenance mode',
    'universal_analytics_id' => 'Universal Analytics ID',
    'facebook_url' => 'Facebook URL',
    'instagram_url' => 'Instagram URL',
    'twitter_url' => 'Twitter URL',
    'twitter_account' => 'Twitter account name',
    'recaptcha_public_key' => 'Recaptcha site key (public)',
    'recaptcha_private_key' => 'Recaptcha private key (secret)',
    'you_must_show_youre_not_robot' => 'You must validate the Recaptcha to verify you’re not a robot.',
    'recaptcha_is_invalid.try_again' => 'Recaptcha is invalid, please try again.',
    'document.%name%.usage' => 'Document "%name%" usage',
    'usage.fieldName' => 'Usage field name',
    'nodeType.name' => 'Node-type',
    'document.usage' => 'Usage',
    'document.edit' => 'Edit document',
    'document.preview' => 'Preview',
    'all.nodes' => 'All nodes',
    'draft.nodes' => 'Draft nodes',
    'pending.nodes' => 'Pending nodes',
    'archived.nodes' => 'Archived nodes',
    'deleted.nodes' => 'Deleted nodes',
    'node.draft' => 'Draft',
    'node.pending.validation' => 'Pending validation',
    'node.archived' => 'Archived',
    'node.deleted' => 'Deleted',
    'draft' => 'Draft',
    'pending' => 'Pending',
    'archived' => 'Archived',
    'deleted' => 'Deleted',
    'undelete' => 'Undelete',
    'are_you_sure.undelete.node.and.data' => 'Are you sure you want to undelete node and its data?',
    'undelete.node.%name%' => 'Undelete node %name%',
    'parameters' => 'Parameters',
    'embed.document' => 'Embed',
    'embed' => 'Embed',
    'tagTree' => 'Tag tree',
    'node.%node%.linked.tags' => 'Node %node% has been linked with new tags.',
    'list.tags.to_link' => 'List tags to link with current node',
    'use.new_or_existing.tags_with_hierarchy' => 'You can use existing or new tags. You can directly create tags inside an existing one using "/".',
    'add.stack.type' => 'Add a stack type',
    'stack.types' => 'Stack types',
    'remove' => 'Remove',
    'stack_node.%name%.has_new_type.%type%' => 'Stack node “%name%” is linked to “%type%” type.',
    'field.%name%.updated' => 'Field “%name%” has been updated.',
    'field.%nodeTypeFieldId%.not_exists' => 'Field #%nodeTypeFieldId% does not exist.',
    'created.at' => 'Created at',
    'updated.at' => 'Updated at',
    'position' => 'Position',
    'empty.node.trash' => 'Empty node trash',
    'node.trash.emptied' => 'Node trash has been emptied.',
    'empty.trash' => 'Empty trash',
    'are_you_sure.empty.node.and.data.trash' => 'Are you sure to empty trash from deleted nodes and their data?',
    'random.document' => 'Random',
    'document.format.unknown' => 'Document format is unknown.',
    'no.embed.document.found' => 'No document to embed has been found.',
    'embed.document.already_exists' => 'Document to embed already exists.',
    'document.metas' => 'Metas',
    'delete.document.translation.%name%' => 'Delete document “%name%” translation',
    'are_you_sure.delete.document.translation' => 'Are you sure to delete this document translation?',
    'document.translation.%name%.updated' => 'Document “%name%” translation has been updated.',
    'document.translation.%name%.deleted' => 'Document “%name%” translation has been deleted',
    'document.translation.%name%.cannot_delete' => 'Document “%name%” translation cannot be deleted.',
    'folderTree' => 'Document folders',
    'add.folder' => 'Add folder',
    'add.child.folder' => 'Add sub-folder',
    'edit.folder' => 'Edit folder',
    'delete.folder' => 'Delete folder',
    'back_to.folders' => 'Back to folders',
    'delete.folder.%name%' => 'Delete folder %name%',
    'are_you_sure.delete.folder' => 'Are you sure you want to delete this folder?',
    'edit.folder.%name%' => '%name%',
    'folders' => 'Folders',
    'default.translation' => 'Default translation',
    'nodeTypeField.minLength' => 'Min length',
    'nodeTypeField.maxLength' => 'Max length',
    'export.all.nodes' => 'Export all nodes',
    'drop.files.here.to.upload.or.click.to.open.your.explorer' => 'Drop files here to upload or click to open your explorer',
    'your.browser.does.not.support.dragndrop.file.uploads' => 'Your browser does not support drag’n’drop file uploads',
    'please.use.the.fallback.form.below.to.upload.your.files.like.in.the.olden.days' => 'Please use the fallback form below to upload your files like in the olden days',
    'file.is.too.big.({{filesize}}mib).max.filesize.{{maxFilesize}}.mib' => 'File is too big ({{filesize}}MiB), max filesize {{maxFilesize}} MiB',
    'you.cant.upload.files.of.this.type' => 'You can’t upload files of this type',
    'server.responded.with.{{statuscode}}.code' => 'Server responded with {{statuscode}} code',
    'cancel.upload' => 'Cancel upload',
    'are.you.sure.you.want.to.cancel.this.upload' => 'Are you sure you want to cancel this upload',
    'remove.file' => 'Remove file',
    'you.can.not.upload.any.more.files' => 'You can not upload any more files',
    'headline.2' => 'Headline 2',
    'headline.3' => 'Headline 3',
    'headline.4' => 'Headline 4',
    'headline.5' => 'Headline 5',
    'headline.6' => 'Headline 6',
    'fullscreen' => 'Fullscreen',
    'bold' => 'Bold',
    'italic' => 'Italic',
    'strikethrough' => 'Strikethrough',
    'blockquote' => 'Blockquote',
    'link' => 'Link',
    'image' => 'Image',
    'unordered.list' => 'Unordered list',
    'ordered.list' => 'Ordered list',
    'back' => 'Back',
    'separator' => 'Separator',
    'non_breaking.space' => 'Non-breaking space',
    'forbidden.page' => 'Forbidden page, please connect again.',
    'see_all' => 'See all…',
    'search.documents' => 'Search documents',
    'search.nodes' => 'Search nodes',
    'nodes.toggle-explorer' => 'Explorer',
    'folder.name' => 'Folder name',
    'nodeType.color' => 'Color',
    'nodeType.numberFields' => 'Number of fields',
    'back_to.top' => 'Back to top',
    'no.customFormField' => 'No custom form\'s field',
    'add.customForm' => 'Add custom form',
    'customForm' => 'Custom form',
    'customForm.displayName' => 'Display name',
    '%count%.customFormFields' => '%count% custom form\'s fields',
    'manage.customFormFields' => 'Manage fields',
    'customForm.answers' => 'Answers',
    'customForm.show' => 'Show form',
    'are_you_sure.delete.customFormAnswer' => 'Are you sure you want to delete delete this answer',
    'delete.customFormAnswer.%name%' => 'Answer %name% deleted',
    'back_to.customFormAnswers' => 'Back to answers',
    'customFormAnswer' => 'Answers',
    'back_to.customForms' => 'Back to custom forms',
    'submitted.date' => 'Submitted date',
    'customFormAnswer.answers' => 'Answer attribute',
    'customFormFieldAttribute' => 'Answer attribute',
    'delete.customFormField' => 'Delete field',
    'add.customFormField' => 'Add field',
    'back_to.customFormFields' => 'Back to fields',
    'delete.customFormField.%name%' => 'Field %name% deleted',
    'are_you_sure.delete.customFormField' => 'Are you sure you want to delete to delete this field',
    'edit.customFormField.%name%' => '%name%',
    'edit.customFormFields.for.customForm.%name%' => '%name% fields',
    'delete.customForm' => 'Delete custom form',
    'delete.customForm.%name%' => 'Custom form %name% deleted',
    'are_you_sure.delete.customForm' => 'Are you sure you want to delete this custom form ?',
    'edit.customForm.%name%' => '%name%',
    '{0} no.customFormField|{1} 1.customFormField|]1,Inf] %count%.customFormFields' => '{0} No field|{1} 1 field|]1,Inf] %count% fields',
    'create.a.node' => 'Create a node',
    'add.a.node' => 'Add a node',
    'add.a.tag' => 'Add a tag',
    'add.a.urlAlias' => 'Add an url-alias',
    'add.a.child.node' => 'Add a child node',
    'add.a.child.tag' => 'Add a child tag',
    'add.a.nodeType' => 'Add a node type',
    'add.a.nodeTypeField' => 'Add a node-type field',
    'add.a.translation' => 'Add a translation',
    'add.a.theme' => 'Add a theme',
    'add.a.font' => 'Add a font',
    'add.a.user' => 'Add an user',
    'add.a.specific.role' => 'Add a specific role',
    'add.a.group' => 'Add a group',
    'add.a.role' => 'Add a role',
    'add.a.setting' => 'Add a setting',
    'add.a.settingGroup' => 'Add a setting group',
    'delete.font' => 'Delete font',
    'add.a.customForm' => 'Add a custom form',
    'customForm.color' => 'Couleur',
    'manage.customForms' => 'Manage custom forms',
    'customForm.open' => 'Open',
    'customForm.closeDate' => 'Close date',
    'add.a.customFormField' => 'Add a custom form field',
    'edit.customFormFields' => 'Add a field',
    'add.a.folder' => 'Add a folder',
    'node.hidden' => 'Hidden',
    'required' => 'Required',
    'delete.documents' => 'Delete documents',
    'are_you_sure.delete.these.documents' => 'Are you sure you want to delete these documents ?',
    'bulk.delete.documents' => 'Delete selected documents',
    'main_color' => 'Main back-office color',
    'colour.type' => 'Color',
    'nodes.type' => 'Nodes references',
    'embed.preview' => 'External media preview',
    'customFormAnswer.%id%.deleted' => 'Answer "%id%" deleted.',
    'customFormField.%name%.updated' => 'Field "%name%" updated.',
    'customFormField.%name%.created' => 'Field "%name%" created.',
    'customFormField.%name%.deleted' => 'Field "%name%" deleted.',
    'duplicated.node.%name%' => 'Node “%name%” has been duplicated',
    'impossible.duplicate.node.%name%' => 'Impossible to duplicate node “%name%”',
    'list.folders.to_link' => 'List folders (existant or not)',
    'bulk.fold.documents' => 'Link selected documents',
    'documents.linked_to.folders' => 'Documents have been linked to folders.',
    'no_documents.linked_to.folders' => 'No documents have linked.',
    'wrong.request' => 'Wrong request',
    'delete.nodes' => 'Delete selected nodes',
    'are_you_sure.delete.these.nodes' => 'Are you sure you want to delete these nodes ?',
    'delete.all' => 'Delete all',
    'bulk.delete.nodes' => 'Delete selected nodes',
    'link.tags' => 'Tag selected',
    'unlink.tags' => 'Untag selected',
    'list.tags.to_link.or_unlink' => 'List tags to link or unlink…',
    'nodes.bulk.deleted' => 'Selected nodes have been deleted',
    'nodes.bulk.not_tagged' => 'Impossible to tag selected nodes',
    'nodes.bulk.tagged' => 'Selected nodes have been tagged',
    'nodes.bulk.not_untagged' => 'Impossible to untag selected nodes',
    'nodes.bulk.untagged' => 'Selected nodes have been untagged',
    'bulk.actions' => 'Bulk actions',
    'reset.marker' => 'Reset marker',
    'geotag.type_an_address.then_type_enter' => 'Type an address then type “Enter”…',
    'geographic.coordinates.type' => 'Single geographic coordinates',
    'multiple.geographic.coordinates.type' => 'Multiple geographic coordinates',
    'link.folders' => 'Link to folder(s)',
    'unlink.folders' => 'Unlink from folder(s)',
    'bulk.download.documents' => 'Download selected documents',
    'download.documents' => 'Download documents',
    'are_you_sure.download.these.documents' => 'Are you sure you want to download these documents ?',
    'purge.generated_images.cache' => 'Purge images cache',
    'are_you_sure.purge.generated_images.cache' => 'Are you sure you want to purge images cache?',
    'delete.generated_images.cache' => 'Purge images cache',
    'more.documents' => 'More documents',
    'more.nodes' => 'More nodes',
    'more.custom_forms' => 'More custom-forms',
    'search.custom_forms' => 'Search custom-forms',
    'custom-forms.toggle-explorer' => 'Explorer',
    'edit.account' => 'Edit your account',
    'NodeType' => 'Node type',
    'select.nodetype' => 'Filter',
    'ignore' => 'Indifferent',
    'true' => 'Yes',
    'false' => 'No',
    'node.name' => 'Node name',
    'node.id.parent' => 'Node parent id',
    'node.datetime.operator' => 'Operator',
    'node.datetime.value' => 'Creation date',
    'node.limit.result' => 'Results limit',
    'node.tags' => 'Tags',
    'node.tag.exclusive' => 'Exclusive tags selection',
    'nodetypefield' => 'Node type fields',
    'search.a.node' => 'Search a node',
    'export.all.nodesSource' => 'Export all nodes sources',
    'role.cannot.update.status' => 'Insufficient rights to apply this status',
    'node.%name%.%field%.updated' => 'Node %name% "%field%" status has been updated.',
    'added.node.%name%' => 'Node “%name%” has been added.',
    'custom-forms.type' => 'Custom form',
    'Bad credentials.' => 'Bad credentials',
    'User account has expired.' => 'User account has expired.',
    'User account is locked.' => 'User account is locked.',
    'User credentials have expired.' => 'User credentials have expired.',
    'User account is disabled.' => 'User account is disabled.',
    'change.nodes.status' => 'Change selected nodes status',
    'change.nodes.status.all' => 'Change all selected nodes status',
    'are_you_sure.change-status.these.nodes' => 'Are you sure you want to change every selected nodes status?',
    'nodes.status' => 'Selection status',
    'nodes.bulk.status.changed' => 'Node selection status has been changed.',
    'staticTheme' => 'Static theme',
    'staticTheme.does_not.allow.node_url_routes' => 'A static theme means that it won’t listen dynamic nodes URLs, only static routes.',
    'theme.is_static' => 'Static',
    'password.must.match' => 'Passwords must match',
    'passwords.must.match' => 'Passwords must match',
    'no.nodeType.available.create_one_first' => 'No node-type have been found. Please create one before adding a node.',
    'node.%name%.no_creation.already_exists' => 'Node “%name%” can\'t be created, one with same name already exists.',
    'node.dynamicNodeName' => 'Dynamic node name',
    'nodeType.status' => 'Status',
    'nodeType.not_visible' => 'Invisible node-type',
    'newsletter.nodeType' => 'Newsletters reserved type',
    'nodeType.hiding_nodes' => 'This type hides its node-tree',
    'newsletter.%name%.created' => 'Newsletter “%name%” created.',
    'newsletter.%newsletter%.updated.%translation%' => 'Newsletter “%newsletter%” has been updated for %translation% translation',
    'duplicated.newsletter.%name%' => 'Newsletter “%name%” has been duplicated.',
    'impossible.duplicate.newsletter.%name%' => 'Impossible to duplicate newsletter “%name%”',
    'see.newsletter' => 'See newsletter',
    'add.a.newsletter' => 'Add a newsletter',
    'edit.newsletter.%name%' => 'Edit newsletter “%name%”',
    'newsletter' => 'Newsletter',
    'newsletter.type' => 'Newsletter type',
    'back_to.newsletter' => 'Back to newsletter',
    'create.a.newsletter' => 'Create a newsletter',
    'export.html' => 'Export HTML',
    'export.html.inline' => 'Export HTML (inline CSS)',
    'start.test.user.right' => 'Take user privileges',
    'stop.test.user.right' => 'Go back to your user',
    'overwrite.document' => 'Overwrite document file',
    'document.file.%name%.updated' => 'File “%name%” has been updated',
    'are_you_sure.delete.nodeSource' => 'Are you sure you want to delete this node source?',
    'node_source.%node_source%.%translation%.cant.deleted' => '“%node_source%” %translation% translation can not be deleted',
    'node_source.%node_source%.deleted.%translation%' => '“%node_source%” %translation% translation has been deleted',
    'delete.nodesource' => 'Delete node source',
    'latest.node-sources.updates' => 'Latest updated node sources',
    'customForm.%name%.updated' => 'Custom form “%name%” has been updated',
    'customForm.%name%.created' => 'Custom form “%name%” has been created',
    'customForm.%name%.deleted' => 'Custom form “%name%” has been deleted.',
    'customForm.%name%.cannot_rename_already_exists' => 'Custom form “%name%” can not be renamed, another one already exists',
    'customForm.%name%.already_exists' => 'Custom form “%name%” already exists',
    'select.all' => 'Select all',
    'deselect.all' => 'Deselect all',
    'edit.user.%name%.roles' => '%name% roles',
    'history.for.%name%' => '%name% history',
    'admin_image' => 'Back-office main picture or brand',
    'chroot.limited.one' => 'You can only choose one root node',
    'chroot' => 'Root node',
    'node.noCreation.alreadyExists' => 'Node can not be created, a node already exists with its name',
    'maps_style' => 'Default Google Maps styles',
    'user.status' => 'Status',
    'user.enabled' => 'Enabled account',
    'user.disabled' => 'Disabled account',
    'user.locked' => 'Locked account',
    'user.expired' => 'Expired account',
    'user.expiresAt' => 'Account will expire at:',
    'user.force.expired' => 'Force account expiration',
    'user.credentialsExpiresAt' => 'Account credentials will expire at:',
    'user.force.credentialsExpired' => 'Force account credential expiration',
    'edit.user.%name%.security' => '“%name%” security',
    'user.%name%.security.updated' => '“%name%” security settings have been updated.',
    'user.account.has-expired' => 'User account has expired',
    'user.crendentials.has-expired' => 'User account credentials have expired',
    'user.last-login' => 'Last login date',
    'user.password-requested-at' => 'Last password request date',
    'never.requested' => 'Never',
    'year' => 'Year',
    'month' => 'Month',
    'day' => 'Day',
    'hour' => 'Hour',
    'minute' => 'Min.',
    'user.security' => 'Security',
    'your.account.email' => 'Your email account',
    '%email%.email.does.not.exist.in.user.account.database' => '“%email%” email does not exist in users database.',
    'to.get.new.password.enter.your.account.email' => 'In order to request a new password, just enter the email linked to your account.',
    'request.new.password' => 'Request a new password',
    'back_to.login' => 'Back to login',
    'a.personal.password.reset.link.has.been.sent.to.your.account.email' => 'A personal password reset link has been sent to you by email, do not wait too long this link will automatically expire.',
    'confirmation.token.is.invalid' => 'Confirmation token is invalid.',
    'confirmation.token.has.expired' => 'Confirmation token has expired.',
    'choose.a.new.password' => 'Choose a new password',
    'save.new.password' => 'Save new password',
    'your.new.password.has.been.saved' => 'Your new password has been saved.',
    'go_back_to.login.page.to.connect' => 'Go back to login page to connect.',
    'a.confirmation.email.has.already.be.sent' => 'A confirmation email already has been sent to you, check your emails or your spam folder.',
    'email.invalid' => 'Email is invalid or does not exist.',
    'resultCache' => 'Result cache',
    'hydratationCache' => 'Hydratation cache',
    'queryCache' => 'Query cache',
    'metadataCache' => 'Metadata cache',
    'no.cache.available' => 'No available cache found.',
    'homeNode.limited.one' => 'You only can choose one home node.',
    'homeNode' => 'Home node',
    'theme.root.limited.one' => 'You can only choose one root node',
    'themeRoot' => 'Root node',
    'about.cms' => 'About Roadiz',
    'news.version.release' => 'A new Roadiz version is available for update.',
    'lastest.version.installed' => 'Roadiz is up-to-date.',
    'current.version' => 'Current version',
    'last.version' => 'Lastest version',
    'changelog' => 'Changelog',
    'download.folder.content' => 'Download folder content',
    'not.valid.facebook.name' => 'This is not a valid Facebook user ID, find your ID using http://lookup-id.com/ website.',
    'routePrefix' => 'Static routes prefix',
    'current.document.is.private.you.cannot.preview.it' => 'Current document is private, you can’t preview it.',
    'document.public_url' => 'Public URL',
    'document.filepath' => 'Absolute file path',
    'download.document' => 'Download document',
    'static_domain_name' => 'Static domain name',
    'item-per-page.display.count' => 'Display:',
    'move.node.to.first.position' => 'Move to first position',
    'move.node.to.last.position' => 'Move to last position',
    'node.hide' => 'Hide',
    'node.show' => 'Show',
    'node.publish' => 'Publish',
    'node.unpublish' => 'Unpublish',
    'node.duplicate' => 'Duplicate',
    'string.should.only.contain.latin.characters' => 'String should only contain simple latin characters',
    'string.should.not.be.a.sql.reserved.word' => 'String should not be a SQL reserved word',
    'This value should not be blank.' => 'This value should not be blank',
    'This value is not valid.' => 'This value is not valid.',
    'font_variant.regular' => 'Regular',
    'font_variant.italic' => 'Italic',
    'font_variant.bold' => 'Bold',
    'font_variant.bold.italic' => 'Bold italic',
    'font_variant.light' => 'Light',
    'font_variant.light.italic' => 'Light italic',
    'update.roadiz' => 'Update Roadiz',
    'update.please_wait' => 'Update in progress; please wait',
    'update.done.back_to_home' => 'Back to backoffice home',
    'update_roadiz.download_archive' => 'Roadiz is downloading lastest archive file…',
    'update_roadiz.unarchive' => 'Roadiz is unpacking latest archive file…',
    'update_roadiz.move_new_files' => 'Roadiz is moving around files to update your favorite CMS…',
    'update_roadiz.clear_cache' => 'Roadiz is clearing its cache…',
    'update_roadiz.update_schema' => 'Roadiz is updating your database schema…',
    'update_roadiz.update_complete' => 'Roadiz update is now complete!',
    'automatic.upgrade' => 'Automatic upgrade',
    'always.make.a.database.backup.before.upgrade' => 'You should always make a database backup before using the automatic upgrade tool.',
    'cannot_update_roadiz.using_git' => 'Roadiz can’t update itself, you are using a Git based setup. Update manually…',
    'cannot_update_roadiz.using_symlink' => 'Roadiz can’t update itself, you are using symbolic links. Update manually…',
    'cannot_update_roadiz.no_release_available' => 'Roadiz can’t update itself, no available release was found…',
    'cannot_update_roadiz.no_archive_to_download' => 'Roadiz can’t update itself, there is no available archive file to download…',
    'cannot_update_roadiz.temp_archive_does_not_exist' => 'Roadiz can’t update itself, it can’t find the downloaded archive file…',
    'cannot_update_roadiz.cant_open_archive' => 'Roadiz can’t update itself, archive file can’t be extracted…',
    'cannot_update_roadiz.cant_create_temp_dir' => 'Roadiz can’t update itself, it’s impossible to create a temporary directory…',
    'cannot_update_roadiz.destination_folder_does_not_exist' => 'Roadiz can’t update itself, your destination folder does not exist…',
    'cannot_update_roadiz.destination_folder_is_not_writable' => 'Roadiz can’t update itself, your destination folder is not writable…',
    'nodeName.alreadyExists' => 'This node name is already used',
    'nodeName.alreadyExists.as.urlAlias' => 'This node name is already used as an Url alias',
    'new.version.available' => 'A new version is available',
    'node.childrenOrder' => 'Children nodes are ordered by',
    'node.childrenOrderDirection' => 'Children nodes order direction',
    'createdAt' => 'Creation date',
    'updatedAt' => 'Update date',
    'ascendant' => 'Ascendant',
    'descendant' => 'Descendant',
    'email.alreadyExists' => 'Email address is already used',
    'username.alreadyExists' => 'Username is already used',
    'tagName.alreadyExists' => 'This tag name is already used',
    'nodeTypeField.name.alreadyExists' => 'Node-type field name already exists',
    'nodeType.name.alreadyExists' => 'Node-type name already exists',
    'color.should.be.formatted.in.hexadecimal' => 'Color should be formatted using hexadecimal notation',
    'customFormField.name.alreadyExists' => 'Custom-form field name already exists',
    'customForm.name.alreadyExists' => 'Custom form name already exists',
    'ip' => 'IP',
    'font.variant.alreadyExists' => 'Font variant already exists',
    'file.is_not_a.valid.font.file' => 'This file is not a valid font file',
    'folder.%name%.updated' => 'Folder “%name%” has been updated.',
    'folder.alreadyExists' => 'Folder already exists.',
    'folder.%name%.deleted' => 'Folder “%name%” has been deleted.',
    'no.folder.found' => 'No folder found',
    'folder.does_not_exist' => 'Folder does not exist',
    'pinterest_url' => 'Pinterest URL',
    'use_cdn' => 'Use a CDN for resources',
    'force_locale' => 'Force locale in URL',
    'nodeSourcesUrlsCache' => 'Node-sources URL cache',
    'translation.locale.alreadyExists' => 'This translation locale is already used',
    'translation.override_locale.alreadyExists' => 'This translation override locale is already used',
    'overrideLocale' => 'Override locale',
    'keep_me_logged_in' => 'Keep me logged in',
    'setting.theme' => 'Themes settings',
    'unused_documents' => 'Unused documents',
    'node.offspring.published' => 'Node offspring has been published.',
    'are_you_sure.publish.node.offspring' => 'Are you sure you want to publish this node offspring?',
    'publish.node.%name%.offspring' => 'Publish node “%name%” offspring',
    'publish_node_offspring' => 'Publish offspring',
    'publish-all' => 'Publish offspring',
    'groupName' => 'Group name',
    'embedId.does_not_exist' => 'Embed media ID does not exist.',
    'YoutubeEmbedFinder needs a Google server key.' => 'YoutubeEmbedFinder needs a Google server key.',
    'edit.user_details.%name%' => '%name%',
    'user.edit_details' => 'Details',
    'new.version.release' => 'A new version is released!',
    'no_valid_class_found' => 'No valid class found!',
    'duplicated.custom.form.%name%' => 'Custom form “%name%” has been duplicated.',
    'impossible.duplicate.custom.form.%name%' => 'Impossible to duplicate custom form “%name%”',
    'customForm.duplicate' => 'Duplicate',
    'transtype' => 'Transtype',
    'transtype.node' => 'Transtype node',
    'transtype_will_copy_data_from_fields_existing_in_both_types_not_others' => 'Transtype processing will try to copy similar contents from former type to the new one. Remaining data will be lost.',
    'transtype.a.node' => 'Transtype a node',
    '%node%.transtyped_to.%type%' => '“%node%” has been transtyped to %type%.',
    'add_all' => 'Add all',
    'add.multiple.tags' => 'Add multiple tags',
    'write.every.tags.names.comma.separated' => 'Write every tags names you want to create comma separated.',
    'tags.names' => 'Tags names',
    'add.tags' => 'Add tags',
    'download.raw.document' => 'Download raw document',
    'document.raw_document' => 'Raw document',
    'export_format.rzn' => 'RZN file format',
    'export_format.excel.%language%' => 'Excel file format (%language%)',
    'delete.tags' => 'Delete tags',
    'are_you_sure.delete.these.tags' => 'Are you sure you want to delete these tags?',
    'bulk.delete.tags' => 'Delete selected tags',
    'tags.bulk.deleted' => 'Selected tags have been deleted',
    'tag.childrenOrder' => 'Children tags are ordered by',
    'tag.childrenOrderDirection' => 'Children tags order direction',
    'node.%name%.status_changed_to.%status%' => '« %name% » node status has been changed to: %status%.',
    'node.%name%.visibility_changed_to.%visible%' => '« %name% » node visibility has been changed to: %visible%.',
    'cookie_choice.consent_message' => 'We use cookies to make your experience of our website better. Continuing on our website, you give us your consent to set these cookies.',
    'cookie_choice.close_message' => 'That’s OK',
    'cookie_choice.find_out_more_message' => 'Find out more',
    'no_javascript_message' => 'JavaScript is disabled on your browser or it does not support this technology. Please enable or update your browser to get a better browsing experience.',
    'browser_update.message' => 'Your browser is out of date. It has some security failures et could not show properly some features of this website.',
    'browser_update.link' => 'See how to update your browser',
    'error404.title' => 'Error 404',
    'error404.message' => 'Requested page cannot be found.',
    'language' => 'Language',
    'back.to.site' => 'Back to site',
    'back.to.homepage' => 'Back to homepage',
    'reset_filters' => 'Reset',
    'filters' => 'Filters',
    'emag' => 'Emag',
    'pdf' => 'Press releases',
    'video' => 'Video',
    'diaporama' => 'Slideshow',
    'your_search' => 'Your search',
    'more_issues' => 'More issues',
    'no_issues' => 'No issues',
    'issue.click.title' => 'Issue Click',
    'back_to_top' => 'Top',
    'ext_link' => 'External links',
    'search.results' => '{1}<span class="search-results-number">1</span><span class="search-results-title-text">Search result</span> |]1,Inf]<span class="search-results-number">%count%</span><span class="search-results-title-text">Search results</span>',
    'no.search.results' => 'No results',
    'create.a.issue' => 'Create an issue',
    'create.issue' => 'Create issue',
    'issues' => 'Issues',
    'edit.issue' => 'Edit',
    'back_to.issues' => 'Back to issues',
  ),
));


return $catalogue;
