

<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');

// Active color
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$couleur = "background-color:rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ") !important";

$bg_wall = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
?>

<main role="main">
    <section>
        <style>
            body{
                background: none;
            }
            nav[role="social"]{
                display: none;
            }
            .news-container .article-title {
                color:<?php echo $active_color; ?>;
            }
            .article-filters ul li a {
                background-color:<?php echo $active_color; ?>;
            }
            .news-container .article-filters ul li.active a {
                color:<?php echo $active_color; ?>;
            }
            .news-container .article-body .cover {
                background-color:<?php echo $active_color; ?>;
            }
            .news-container .article-body .cover {
                background-image: url(<?php echo $bg_wall[0]; ?>);
            }
            .news-container .article-body .cover:after {
                background-color:<?php echo $active_color; ?>;
            }
        </style>

        <div class="viewport news-container">
            <div class="news-columned-container">
                <article class="article-body">
                    <figure class="cover"></figure>
                    <header class="article-header">
                        <h1 class="container-title"><?php the_title(); ?></h1>
                        <aside class="article-nav">
                            <div class="article-filters">
                                <ul>
                                    <li class="webtv-filter-item">
                                        <a href="?tagged=">Toutes les actualités</a>
                                    </li>
                                    <?php
                                    // Récupérer la taxonomie dans une variable
                                    $taxonomy = 'etiquette_actu';
                                    // Variable avec le get_terms
                                    $tax_terms = get_terms($taxonomy, array('hide_empty' => false));
                                    // La boucle d'affichage
                                    foreach ($tax_terms as $tax_term) {
                                        ?>
                                        <li class="webtv-filter-item">
                                            <a href="?tagged=<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></a>
                                        </li>
                                        <?php
                                    }
                                    ?>
                                </ul>
                            </div>
                        </aside>
                    </header>
                    <ul class="article-list first-page"><!-- First page correspond a page 1 -->
                        <?php
                        wp_reset_postdata();
                        wp_reset_query();
                        $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                        $filtre = $_GET['tagged'];
                        if (empty($filtre)) {
                            $args = array(
                                'post_type' => array('wall_actu'),
                                'post_status' => array('publish'),
                                'order' => 'DESC',
                                'orderby' => 'date',
                                'posts_per_page' => 3,
                                'paged' => $paged
                            );
                        } else {
                            $args = array(
                                'post_type' => array('wall_actu'),
                                'post_status' => array('publish'),
                                'order' => 'DESC',
                                'orderby' => 'date',
                                'posts_per_page' => 3,
                                'paged' => $paged,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'etiquette_actu', // taxonomy name
                                        'field' => 'slug', // term_id, slug or name
                                        'terms' => $filtre, // term id, term slug or term name
                                    )
                                )
                            );
                        }
// WP_Query arguments
// The Query
                        $query_actu = new WP_Query($args);

// The Loop
                        if ($query_actu->have_posts()) {
                            $n = 1;
                            while ($query_actu->have_posts()) {
                                $query_actu->the_post();

                                $post_ID = get_post($id);
                                $title = $post_ID->post_title;
                                $link = $post_ID->guid;

                                // Récupérer la taxonomie dans une variable
                                $taxonomy = 'etiquette_actu';
                                // Variable avec le get_terms
//                                $term_actu = get_terms($post_ID, $taxonomy, array('hide_empty' => false));
                                ?>
                                <li class="article article-<?php echo $n; ?>">
                                    <a href="<?php echo $link; ?>">
                                        <?php
                                        if (has_post_thumbnail()) { // Vérifies qu'une miniature est associée à l'article.
                                            $title_img = get_post(get_post_thumbnail_id())->post_title;
                                            $bg_cat = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
                                            ?><figure style="background-image:url(<?php echo $bg_cat[0]; ?>);"></figure><?php
                                        }
                                        ?>
                                        <div class="article-text">
                                            <?php if (get_field('sous_titre_actu')) { ?>
                                                <h4 class="over-title"><span class="over-title-wrap"><?php the_field('sous_titre_actu', $post_ID); ?></span></h4>
                                            <?php } ?>
                                            <h3 class="article-title"><?php echo $title; ?></h3>
                                            <div class="article-excerpt"><?php echo the_field('chapo_actu'); ?></div>
                                        </div>
                                    </a>
                                </li>

                                <?php
                                $n++;
                            }
                            if ($query_actu->max_num_pages > 1) { // check if the max number of pages is greater than 1  ?>
                              <nav class="prev-next-posts">
                                <div class="prev-posts-link">
                                  <?php echo get_next_posts_link( 'Older Entries', $query_actu->max_num_pages ); // display older posts link ?>
                                </div>
                                <div class="next-posts-link">
                                  <?php echo get_previous_posts_link( 'Newer Entries' ); // display newer posts link ?>
                                </div>
                              </nav>
                            <?php }
                        } else {
                            echo "Erreur";
                        }

// Restore original Post Data
                        wp_reset_postdata();
                        wp_reset_query();
                        ?>

                    </ul>
                </article>
            </div>
        </div>
    </section>
</main>
<?php get_footer(); ?>