<?php 
function dh_plugin_settings_page_documentation(){ ?>
  
<style>
.dh_documentation section article{
    background-color:#FFF;
    border: 1px solid #eee;
    margin:0 40px;
    padding:10px;
}
.dh_documentation section article img{
    vertical-align: middle;
    float:left;
    margin-right: 20px;
}

#menu ul{
 margin:50px;
 padding:0;
 list-style-type:none;
 text-align:center;
 position:relative;
 }
#menu li {
 float:left;
 margin:auto;
 padding:0;
 background-color:#23282D;
 }
#menu li a {
 display:block;
 width:200px;
 color:white;
 text-decoration:none;
 padding:5px;
 }
#menu li a:hover {
 color:#00b9eb;
 }
 
 #menu ul li ul {
 display:none;
 }
 #menu ul li:hover ul {
 display:block;
 margin:-1px 0;
 }
#menu li:hover ul li {
 float:none;
 }
 #menu li ul {
 position:absolute;
 }
 #menu {
 height:50px;
 }
 ul.liste{
     margin:10px;
 }
 
 .to_top{
     position:fixed;
     width:150px;
     height:40px;
     background:#FFF;
     text-align:center;
     right:50px;
     bottom:100px;
 }
 a.translation_62{
     text-decoration:none;
 }
</style>

<!--[if !IE]> <-->
<style type="text/CSS">
#menu li ul {
 position:absolute;
 }
</style>
<!--><![endif]-->
<!--[if IE 8]>
<style type="text/CSS">
#menu li ul {
 position:absolute;
 }
</style>
<![endif]--> 

<a name="top">&nbsp;</a>
<nav id="menu">
    <ul>
        <li><a href="#">Configuration</a>
            <ul>
                <li><a href="#config_private">Privatiser l'Emag</a></li>
                <li><a href="#config_role">Gestion des rôles</a></li>
                <li><a href="#config_api">Clés API</a></li>
                <li><a href="#config_lang">Multilingue</a></li>
            </ul>
        </li>
        <li><a href="#content">Gestion des contenus</a>
            <ul>
                <li><a href="#content_num">Les numéros</a></li>
                <li><a href="#content_cat">Les catégories</a></li>
                <li><a href="#content_articles">Les articles</a></li>
                <li><a href="#content_cmt">Les commentaires</a></li>
                <li><a href="#content_page">Les pages</a></li>
            </ul>
        </li>
        
        <li><a href="#modules">Les modules</a>
            <ul>
                <li><a href="#mod_newsletter" title="Newsletter (nouvelle fenêtre)" alt="Newsletter (nouvelle fenêtre)">Newsletter</a></li>
                <li><a href="#mod_allvids" title="Toutes les vidéos (nouvelle fenêtre)" alt="Toutes les vidéos (nouvelle fenêtre)">Toutes les vidéos</a></li>
            </ul>
        </li>
        
    </ul>
</nav>

<div class="dh_documentation container">
    <section id="config">
        <a name="config_private"></a>
        <article id="config_private">
            <h1>Privatiser l'E-mag</h1>
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/config_private.png">
                
                <h2>Lien : <a href="<?php echo admin_url("options-general.php?page=wp-maintenance/wp-maintenance.php"); ?>">Menu > Réglages > WP-maintenance</a></h2>
                
                <p> Pour privatiser l'E-mag, vous pouvez Activer le mode maintenance pour rendre l'E-mag consultable par les membres connectés uniquement.</p>
                <p> L'accès à l'E-mag peut être autorisé depuis l'onglet réglages pour des adresses IP spécifques ou par rôle d'utilisateur (voir gestion des rôles).</p> 
                
                <h2>Personnalisation </h2>
                <p>Il est possible de personnaliser la page d'identification grâce aux onglets : </p>
                
                <ul class="liste">
                    <li><b>Général</b> : Textes, contenus et modules (newsletter, google analytics, réseaux sociaux).</li>
                    <li><b>Couleurs et Fonts</b> : Pattern, taille, couleurs et police.</li>
                    <li><b>Images</b> : Logo, image de fond, style et slider.</li>
                    <li><b>Compte à Rebours</b> : Permet de programmé un timer et d'ouvrir publiquement l'E-mag à la date de fin. </li>
                </ul>
                
                <br><br>
            
            <div style="clear:both"></div>
        </article>
        
        <a name="config_role"></a>
        <article id="config_role">
            <h1>Gestion des rôles</h1>
            
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/config_role.png">
                <h2>Lien : <a href="<?php echo admin_url("users.php?page=capsman"); ?>">Utilisateurs > Capabilities</a></h2>
                
                <p>
                    La gestion des rôles permet de configurer des templates d'accès aux utilisateurs. <br>
                </p>
                
                <h2>Les rôles </h2>
                <p>Les rôles par défaut sont les suivant : </p>
                
                <ul class="liste">
                    <li><b>Administrateur</b> : Administration général du site.</li>
                    <li><b>Editeur</b> : Peux administrer les contenus (pages, articles et commentaires).</li>
                    <li><b>Auteur</b> : Peux modifier / supprimer les articles publiés. </li>
                    <li><b>Contributeur</b> : Peux modifier ses articles uniquement.</li>
                    <li><b>Abonné</b> : Accèder à l'E-mag privatif. </li>
                </ul>
                <br><br>
            
            <div style="clear:both"></div>
        </article>
        
        <a name="config_api"></a>
        <article id="config_api">
            <h1>Clés API</h1>
            
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/config_api.png">
                
                <p>Accessible directement depuis le menu E-mag, il est possible de configurer les clés suivantes :</p>
                <ul>
                    <li><b>Clé API Google map</b> : Pour afficher la carte google map sur le site.</li>
                    <li><b>Clé API Youtube</b> : Pour les requêtes distantes Youtube.</li>
                    <li><b>Channel ID Youtube</b> : L'identifiant de la chaîne Youtube à capturer.</li>
                    <li><b>Logo de la ville</b> : URL complète du logo de la ville. (il faut préalablement l'uploader via les
                        <a href="<?php echo admin_url("upload.php");?>"> Médias > Ajouter </a> )</li>
                </ul>
                <br><br>
            <div style="clear:both"></div>
        </article>
        
        <a name="config_lang"></a>
        <article id="config_lang">
            <h1>Multilingue</h1>
            
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/config_lang.png">
                <h2>Lien : <a href="<?php echo admin_url('admin.php?page=mlang');?>">Réglages > Languages</a></h2>
                <p>Sélectionner la langue à ajouter dans la liste déroulante, les informations et images se chargeront automatiquement, puis cliquez sur Ajouter en bas de page.</p>
                
                <h2>Traduire un article</h2>
                <p>Une fois les langues configurées, vous pouvez éditer un article, et sur la droite, sélectionner la langue pour traduire le contenu.</p>
                
                <p>Depuis la liste des articles, les icônes indiquent quel article n'as pas été traduit. </p>
                <ul>
                    <li>
                        <a class="pll_icon_tick translation_62" href="#">&nbsp;</a>
                        Indique le contenu d'origine.
                    </li>
                    <li>
                        <a class="pll_icon_edit translation_62" href="#">&nbsp;</a>
                        Indique le contenu traduit.
                    </li>
                    <li>
                        <a class="pll_icon_add translation_62" href="#">&nbsp;</a>
                        Indique qu'il n'y a pas de traduction.
                    </li>
                </ul>
            <div style="clear:both"></div>
        </article>
    </section>
    
    <section id="content">
        
        <a name="content_num"></a>
        <article>
            <h1>Les numéros</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/categorie_add.png" />
            <h2>Lien : <a href="<?php echo admin_url("edit-tags.php?taxonomy=numero"); ?>">Articles > Numéro</a></h2>
            <p>Les numéros sont personnalisables </p>
            <ul>
                <li>- Une catégorie peut contenir une ou plusieurs sous-catégories.</li>
                <li>- Une catégorie affiche un ou plusieurs articles.</li>
                <li>- Les catégories peuvent avoir une couleur dédiée.</li>
            </ul>
            <h2>Ajouter / modifier une catégorie </h2>   
            <ul>
                <li><b>Nom</b> : Le nom de la catégorie visible sur le site</li>
                <li><b>Identifiant</b> : un identifiant unique (généré automatiquement à partir du nom)</li>
                <li><b>Parent</b> : Permet de créer une sous-catégorie</li>
                <li><b>Description</b> : Champ texte libre pour décrire la catégorie</li>
            </ul>
            
            <h2>Personnaliser une catégorie</h2>
                <p>Une fois la catégorie créée, vous pouvez lui attribuer une couleur.
                Cette couleur est utilisée pour la selection du menu, des titres, des couleurs de fonds, etc...<p>
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/categorie_color.png" />
            <div style="clear:both"></div>
            <h2>Action groupées</h2    
                <p>
                    Vous pouvez effectuer des actions groupées sur un ensemble de catégories. Attention cependant, l'action est irréversible.
                </p>
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/categorie_action_groupe.png" />
                <div style="clear:both"></div>
        </article>
        
        <a name="content_cat"></a>
        <article id="">
            <h1>Les catégories</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/categorie_add.png" />
            <h2>Lien : <a href="<?php echo admin_url("edit-tags.php?taxonomy=category"); ?>">Articles > Catégories</a></h2>
            <p>Le système de catégorie permet de regrouper plusieurs articles.</p>
            <ul>
                <li>- Une catégorie peut contenir une ou plusieurs sous-catégories.</li>
                <li>- Une catégorie affiche un ou plusieurs articles.</li>
                <li>- Les catégories peuvent avoir une couleur dédiée.</li>
            </ul>
            <h2>Ajouter / modifier une catégorie </h2>   
            <ul>
                <li><b>Nom</b> : Le nom de la catégorie visible sur le site</li>
                <li><b>Identifiant</b> : un identifiant unique (généré automatiquement à partir du nom)</li>
                <li><b>Parent</b> : Permet de créer une sous-catégorie</li>
                <li><b>Description</b> : Champ texte libre pour décrire la catégorie</li>
            </ul>
            
            <h2>Personnaliser une catégorie</h2>
                <p>Une fois la catégorie créée, vous pouvez lui attribuer une couleur.
                Cette couleur est utilisée pour la selection du menu, des titres, des couleurs de fonds, etc...<p>
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/categorie_color.png" />
            <div style="clear:both"></div>
            <h2>Action groupées</h2    
                <p>
                    Vous pouvez effectuer des actions groupées sur un ensemble de catégories. Attention cependant, l'action est irréversible.
                </p>
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/categorie_action_groupe.png" />
                <div style="clear:both"></div>
        </article>
        
        
        <a name="content_articles"></a>
        <article>
            <h1>Les articles</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_article.png" />
            <h2>Lien : <a href="<?php echo admin_url("post-new.php"); ?>">Articles > Ajouter</a></h2>
                <p>Un article doit être publié dans une catégorie pour être visible, et peut contenir tout type de média (texte, image, vidéo, des widgets, etc..)</p>
                <ul>
                    <li>L'éditeur wysiwig permet de mettre en forme du texte, des images, vidéos, etc...</li>
                    <li>Un article peut contenir plusieurs widgets (des encarts).</li>
                    <li>Un article peut avoir plusieur mise en page différente (.</li>
                    <li>Un article peut être publié dans plusieurs catégories.</li>
                    <li>Un article peut avoir des commentaires.</li>
                </ul>
                
            <h2>Publication</h2>     
            <p>Vous pouvez sélectionner autant de catégorie dans laqulle publier votre article.</p>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_art_cat.png" />    
            <div style="clear:both"></div> 
        
            <div style="float:left; width:50%">
                <h2>Les étiquettes</h2>     
                <p>Les étiquettes sont des tags permettant de mettre plusieurs articles en relation par thématique,<br> vous pouvez en ajouter autant que souhaité, séparés par des virgules.</p>
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_art_tags.png" />    
            </div>
            <div style="float:left; width:50%">
                <h2>Image à la Une</h2>
                <p>L'image à la une est l'image mise en avant pour chaque article. <br>Souvent utilisée pour les fonds d'écran ou petite vignette en résultat de recherche.
                <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_art_img_une.png" />    
            </div>
            <div style="clear:both"></div>     

            <h2>Widgets</h2>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_widgets.png" />    
            <p>Les widgets sont des petits encarts visible sur la droite de l'article.<br>
                Pour les ajouter, il vous suffit de sélectionner l'encart sur la gauche et de le déposer sur la droite. <br>
            Chaque encart a sa spécificité, des champs supplémentaires, des vidéos, un plan google map, etc... Pensez donc a bien configurer les clés API.</p>
            
            <p>Voici les différentes spécificités des widgets</p>
            
            <ul>
                <li><b>Objet Embed</b> : La vidéo ajoutée dans ce widget sera visible sur l'article et aussi consultable dans la page "Toutes les vidéos".</li>
                <li><b>Evénement</b> : Cet objet requiert une clé API google map valide, si les coordonnées GPS ont étés saisies. </li>
                <li></li>
            </uL>
                
            <div style="clear:both"></div>
        </article>
        
        <a name="content_cmt"></a>
        <article>
            <h1>Les commentaires</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_cmt.png" />
            <h2>Lien : <a href="<?php echo admin_url("edit-comments.php"); ?>">Commentaires</a></h2>
            
            <p>Si vous avez autorisé les commentaires depuis le menu <a href="<?php echo admin_url('options-discussion.php');?>">Réglages > Discussion</a>, les internautes 
            pourront alors commenter chaque article.</p>
            <p>Toutefois, afin d’éviter de se faire polluer par les indésirables, pensez à supprimer les spams de la catégorie «Indésirables» de temps en temps.</p>
            <p>Les commentaires peuvent être modifiés ou supprimés. Les 3 états ou status des commentaires sont :  </p>
            
            <ul>
                <li><b>Approuvé</b> : Le commentaire est publié.</li>
                <li><b>En attente</b> : Le commentaire est invisible et consultable uniquement par l'auteur du commentaire.</li>
                <li><b>Indésirable</b>: Le commentaire est supprimé.</li>
            </ul>
            <div style="clear:both;"></div>
        </article>
        
        <a name="content_page"></a>
        <article>
            <h1>Les pages</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/content_page.png" />
            <h2>Lien : <a href="<?php echo admin_url("edit.php?post_type=page"); ?>">Pages</a></h2>
            
            <p>La Page est destinée à présenter un contenu statique, à l’exemple de la page « Mentions légales » ou du formulaire de contact.</p>
            <ul>
                <li>Une page contient du texte, des images, etc...</li>
                <li>On peut lui attribuer un modèle de page (uné présentation différente).</li>
            </ul>
            
            <div style="clear:both;"></div>
        </article>
    </section>
    
    <section>
        <a name="mod_newsletter"></a>
        <article>
            <h1>Newsletter</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/mod_newsletter.png">
            <h2>Lien : <a href="<?php echo admin_url("admin.php?page=wysija_config");?>">MailPoet > Réglages</a></h2>
            <p>Vérifier que les réglages comme le nom de l'émetteur, les contenus et méthodes d'envoi sont bien paramétrés.</p>
            <p>Pour envoyer une newsletter, il faut dans un premier temps <a href="<?php echo admin_url("admin.php?page=wysija_subscribers");?>">créer une liste </a>. 
            Vous pouvez ajouter ou supprimer librement des adresses e-mails, mais aussi créer des listes spécifique à certain ultilisateurs, comme les contributeurs uniquement par exemple.</p>
            
            <p><b>Etape 1</b> : Il faut <a href="<?php echo admin_url('admin.php?page=wysija_campaigns&action=add');?>">créer la newsletter</a> classique, saisir le sujet et sélectionner la liste de diffusion.</p>
            <p><b>Etape 2</b> : Rédaction du contenu grâce au block de mise en forme et l'éditeur wysiwyg. En bas de page, vous pouvez saisir votre e-mail et vous envoyer un aperçu </p>
            <p><b>Dernière étape</b> : La confirmation avant l'envoi, il est conseillé de planifier l'envoi pendant la nuit si il y a beaucoup d'e-mail dans la liste de diffusion.</p>
            <div style="clear:both;"></div>
        </article>
        
        <a name="mod_allvids"></a>
        <article>
            <h1>Toutes les vidéos</h1>
            <img src="<?php echo get_template_directory_uri(); ?>/documentation/img/mod_allvids.png">
            <h2>Lien : <a href="<?php echo admin_url("admin.php?page=videogallerys_huge_it_videogallery");?>">Video Gallery</a></h2>
            <p>Pour utiliser la page vidéo, il faut <a href="<?php echo admin_url('post-new.php?post_type=page');?>">créer une page</a>, et coller dans la partie contenu le shortcode suivant : <b>[huge_it_videogallery id="1"]</b></p>
            <p>Les vidéos ajoutées depuis le widget "objet embed", seront automatiquement insérés dans cette catégorie.</p>
            
            <h2>La webTV</h2>
            <p>Pour afficher la webTV, il faut configurer une <a href="https://developers.google.com/youtube/v3/getting-started" target="_blank">Clé API Youtube valide</a>, ainsi que le Channel ID Youtube depuis le menu E-mag.</p>
                
            <p>Pour obtenir le Channel ID Youtube, il faut se positionner sur la page d'accueil d'une chaîne, et copier son URL.<br>
                https://www.youtube.com/channel/<span style="color:red">UCinRP-BvNUmtu6inwENIWXw</span><br>
                Dans cet exemple, la clé est : UCinRP-BvNUmtu6inwENIWXw </p>
                <p>il faut <a href="<?php echo admin_url('post-new.php?post_type=page');?>">créer une page</a>, et utiliser le shortcode suivant <b>[DH_PAGE_WEB_TV]</b></p>
            <div style="clear:both;"></div>
        </article>
    </section>
    <div class="to_top"><a href="#top">Retour en haut</a></div>
</div>
<?php } ?>