jQuery(document).ready(function ($){
    
    function dump(arr,level) {
        var dumped_text = "";
        if(!level) level = 0;

        //The padding given at the beginning of the line.
        var level_padding = "";
        for(var j=0;j<level+1;j++) level_padding += "    ";

        if(typeof(arr) == 'object') { //Array/Hashes/Objects 
                for(var item in arr) {
                        var value = arr[item];

                        if(typeof(value) == 'object') { //If it is an array,
                                dumped_text += level_padding + "'" + item + "' ...\n";
                                dumped_text += dump(value,level+1);
                        } else {
                                dumped_text += level_padding + "'" + item + "' => \"" + value + "\"\n";
                        }
                }
        } else { //Stings/Chars/Numbers etc.
                dumped_text = "===>"+arr+"<===("+typeof(arr)+")";
        }
        return console.log(dumped_text);
    }
    
    
    $('body').delegate('.upload-image-btn', 'click', function (e) {
        e.preventDefault();

        var $image = $(this).siblings('.image-preview');
        var $input = $(this).siblings('.image-url');
        var $remove_btn = $(this).siblings('.remove-image-btn');
        
        
        var uploader = wp.media({
            title: 'Choisir une image',
            button: {
                text: 'Sélectionner'
            },
            multiple: false
        })
            .on('select', function () {
                var attachment = uploader.state().get('selection').first().toJSON();
                
            var assoc = {
                "val"  : "New",
                "number" : 8,
                "theting" : attachment
            }; dump(assoc);
                
                // Add id
                $(".setter-ID-img-upload").val(attachment.id);
                
                $image.attr('src', attachment.url).removeClass('hidden');
                $remove_btn.removeClass('hidden');
                $input.val(attachment.url);
            }).open();
    });

    $('body').delegate('.remove-image-btn', 'click', function (e) {
        var $image = $(this).siblings('.image-preview');
        var $input = $(this).siblings('.image-url');

        $image.addClass('hidden');
        $(this).addClass('hidden');
        $input.val('');
        $(".setter-ID-img-upload").val(''); // reset id
    });
});