<?php

//------------------------------------------------------------------------------
//    Widget Publicite
//------------------------------------------------------------------------------

class Dh_Widget_Perso_Publicite extends WP_Widget {

    public function __construct() {
        parent::__construct('dh_publicite', 'Publicité', array('description' => 'Widget Publicité'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_upload_media'));
    }

    // ADD JS / CSS
    public function enqueue_upload_media() {
        if (!is_admin())
            return;

        wp_enqueue_media();
        wp_enqueue_script('upload_media_widget', get_template_directory_uri() . '/widgets/js/upload-media.js', array('jquery'));
    }

    // Front view
    public function widget($args, $instance) {
        echo $args['before_widget'];

        echo "<div ";
        // Lien ancre
        $params = explode('=', $instance["ancre"]);
        if (!empty($params)) {
            $code_ancre = substr($params[1], 0, 8);
            echo "id='" . $code_ancre . "' ";
        }
        echo "class='wrapper-widget border-active'>";

        echo $args['before_title'];
        echo apply_filters('widget_title', $instance['title']);
        echo $args['after_title'];

        $alt = get_post_meta($instance["img_pub_id"], '_wp_attachment_image_alt', true);
        //$info_img = wp_get_attachment_metadata($instance["img_pub_id"]);

        echo "<img src='" . $instance['img_pub'] . "' alt='" . $alt . "'>";
        echo "<br><a href='" . $instance["link_out"] . "'>" . $instance["link_out"] . "</a>";
        echo "<br>" . $instance["mention"];

//        echo "<br>ID = " . $instance["img_pub_id"];
        echo "</div>";
        echo $args['after_widget'];
    }

    // Form
    public function form($instance) {
        $title = isset($instance['title']) ? $instance['title'] : '';
        $img_pub = isset($instance['img_pub']) ? $instance['img_pub'] : '';
        $img_pub_id = isset($instance['img_pub_id']) ? $instance['img_pub_id'] : '';
        $link_out = isset($instance['link_out']) ? $instance['link_out'] : '';
        $mention = isset($instance['mention']) ? $instance['mention'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_name('title'); ?>"><?php _e('Title:'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>

        <p class="widget-upload-media">
            <label for="<?php echo $this->get_field_name('img_pub'); ?>"><?php _e('Image :'); ?></label>
        <div style="text-align:center;" class="dh_thumb_widget">
            <input name="<?php echo $this->get_field_name('img_pub_id'); ?>" id="<?php echo $this->get_field_id('img_pub_id'); ?>" type="hidden" class="setter-ID-img-upload" size="36" value="<?php echo $img_pub_id; ?>" />
            <input name="<?php echo $this->get_field_name('img_pub'); ?>" id="<?php echo $this->get_field_id('img_pub'); ?>" class="widefat image-url" type="hidden" size="36" value="<?php echo esc_url($img_pub); ?>" />
            <input class="upload-image-btn button button-primary" type="button" value="Upload Image" />
            <img src="<?php echo esc_url($img_pub); ?>" class="image-preview<?php echo $img_pub == '' ? ' hidden' : ''; ?>">
            <input class="remove-image-btn button button-error<?php echo $img_pub == '' ? ' hidden' : ''; ?>" type="button" value="Remove Image" />
        </div>
        </p>

        <p>
            <label for="<?php echo $this->get_field_name('link_out'); ?>"><?php _e('Lien sortant :'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('link_out'); ?>" name="<?php echo $this->get_field_name('link_out'); ?>" type="text" value="<?php echo $link_out; ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_name('mention'); ?>"><?php _e('Mention :'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('mention'); ?>" name="<?php echo $this->get_field_name('mention'); ?>" type="text" value="<?php echo $mention; ?>" />
        </p>

        <hr>
        <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8,'defaut'); ?>
        <p>
            <label for="<?php echo $this->get_field_name('ancre'); ?>"><?php _e('Ancre :'); ?></label> Préciser le titre entre les "" de title=""<br>
            <input class="widefat" id="<?php echo $this->get_field_id('ancre'); ?>" name="<?php echo $this->get_field_name('ancre'); ?>" type="text" value="<?php echo htmlspecialchars($ancre); ?>" />
            Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
        </p>
        <br><br>

        <?php
    }

}

register_widget('Dh_Widget_Perso_Publicite');
add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_Publicite');});