     <?php
/**
 * Template Name: Galerie actualités
 * */
?>

<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');

// Active color
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$couleur = "background-color:rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ") !important";

$bg_wall = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
?>

<main role="main">
    <section>
        <style>
       .custom-pagination {
            text-align: center;
            margin: 20px auto 50px;
            z-index: 2;
            position: relative;

        }
        .page-numbers{
            display: inline-block;
                margin: 0;
                font-size: 17px;
                line-height: 21px;
                text-decoration:none!important;
                color:#ccc!important;
                padding: 0 4px;
                    margin: 0 2px;
        }
        .page-numbers:hover{
                color:#000!important;
        }
        .current{
            display: inline-block;
                margin: 0;
                font-size: 17px;
                line-height: 21px;
                text-decoration:underline!important;
                color:#000!important;
        }
        .page-num{
            color:#000!important;
        }
            .custom-pagination .icon {
                display: inline-block;
                text-indent: -9999px;
                width: 40px;
                height: 60px;
                cursor: pointer;
                line-height: 1;
                background-image: url('http://digitalheroes.agence-ultramedia.com/wp-content/themes/emag_new/img/set_icons.png');
                background-repeat: no-repeat;
                background-size: 690px 480px;
                image-rendering: optimizeSpeed;
                image-rendering: pixellated;
                image-rendering: -o-crisp-edges;
                image-rendering: -webkit-optimize-contrast;
                image-rendering: optimize-contrast;
                -ms-interpolation-mode: nearest-neighbor;
            }

            .icon-next{
                background-position: -70px -360px;
                display: inline-block;
                    vertical-align: middle;
                    margin: 0 3.5px;
            }

            .icon-prev{
                background-position: -10px -360px;
                display: inline-block;
                vertical-align: middle;
                margin: 0 3.5px;
            }

            .icon-next:hover{
                background-position: -70px -420px;
            }

            .icon-prev:hover{
                background-position: -10px -420px;
            }

            body{
                background: none;
            }
            nav[role="social"]{
                display: none;
            }
            .news-container .article-title {
                color:<?php echo $active_color; ?>;
            }
            .article-filters ul li a {
                background-color:<?php echo $active_color; ?>;
            }
            .news-container .article-filters ul li.active a {
                color:<?php echo $active_color; ?>;
            }
            .news-container .article-body .cover {
                background-color:<?php echo $active_color; ?>;
            }
            .news-container .article-body .cover {
                background-image: url(<?php echo $bg_wall[0]; ?>);
            }
            .news-container .article-body .cover:after {
                background-color:<?php echo $active_color; ?>;
            }
        </style>
        <div class="viewport news-container">
            <div class="news-columned-container">
                <article class="article-body">
                    <figure class="cover"></figure>
                    <header class="article-header">
                        <h1 class="container-title"><?php the_title(); ?></h1>
                        <aside class="article-nav">
                            <div class="article-filters">
                                <ul>
                                    <?php
                                        $url_de_base = get_permalink(482);
                                    ?>
                                    <li class="webtv-filter-item">
                                        <a href="<?php print($url_de_base); ?>">Toutes les actualités</a>
                                    </li>
                                    <?php
                                    // Récupérer la taxonomie dans une variable
                                    $taxonomy = 'etiquette_actu';
                                    // Variable avec le get_terms
                                    $tax_terms = get_terms($taxonomy, array('hide_empty' => false));
                                    // La boucle d'affichage
                                    foreach ($tax_terms as $tax_term) {
                                        ?>
                                        <li class="webtv-filter-item">
                                            <a href="<?php echo add_query_arg('tagged', $tax_term->slug, $url_de_base); ?>"><?php echo $tax_term->name; ?></a>

                                        </li>
                                        <?php
                                    }
                                    ?>
                                </ul>
                            </div>
                        </aside>
                    </header>
                    <ul class="article-list first-page"><!-- First page correspond a page 1 -->
                        <?php
                        wp_reset_postdata();
                        wp_reset_query();
                        $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
                        $filtre = $_GET['tagged'];
                        if (empty($filtre)) {
                            $args = array(
                                'post_type' => array('wall_actu'),
                                'post_status' => array('publish'),
                                'order' => 'DESC',
                                'orderby' => 'date',
                                'posts_per_page' => 1,
                                'paged' => $paged
                            );
                        } else {
                            $args = array(
                                'post_type' => array('wall_actu'),
                                'post_status' => array('publish'),
                                'order' => 'DESC',
                                'orderby' => 'date',
                                'posts_per_page' => 1,
                                'paged' => $paged,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'etiquette_actu', // taxonomy name
                                        'field' => 'slug', // term_id, slug or name
                                        'terms' => $filtre, // term id, term slug or term name
                                    )
                                )
                            );
                        }
// WP_Query arguments
// The Query
                        $query_actu = new WP_Query($args);

// The Loop
                        if ($query_actu->have_posts()) {
                            $n = 1;
                            while ($query_actu->have_posts()) {
                                $query_actu->the_post();

                                $post_ID = get_post($id);
                                $title = $post_ID->post_title;
                                $link = $post_ID->guid;

                                // Récupérer la taxonomie dans une variable
                                $taxonomy = 'etiquette_actu';
                                // Variable avec le get_terms
//                                $term_actu = get_terms($post_ID, $taxonomy, array('hide_empty' => false));
                                ?>
                                <li class="article article-<?php echo $n; ?>">
                                    <a href="<?php echo $link; ?>">
                                        <?php
                                        if (has_post_thumbnail()) { // Vérifies qu'une miniature est associée à l'article.
                                            $title_img = get_post(get_post_thumbnail_id())->post_title;
                                            $bg_cat = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
                                            ?><figure style="background-image:url(<?php echo $bg_cat[0]; ?>);"></figure><?php
                                        }
                                        ?>
                                        <div class="article-text">
                                            <?php if (get_field('sous_titre_actu')) { ?>
                                                <h4 class="over-title"><span class="over-title-wrap"><?php the_field('sous_titre_actu', $post_ID); ?></span></h4>
                                            <?php } ?>
                                            <h3 class="article-title"><?php echo $title; ?></h3>
                                            <div class="article-excerpt"><?php echo the_field('chapo_actu'); ?></div>
                                        </div>
                                    </a>
                                </li>

                                <?php
                                $n++;
                            } ?>
                        <?php } else {
                            echo "Erreur";
                        }

// Restore original Post Data

                        ?>

                    </ul>
                    <!-- pagination here -->
                       <?php

                           custom_pagination($query_actu->max_num_pages,'',$paged);
                           wp_reset_postdata();
                           wp_reset_query();
                       ?>
                </article>
            </div>
        </div>
    </section>
</main>
<?php get_footer(); ?>