<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$sticky_posts = get_option('sticky_posts');
$num_colors = get_option('numero_colors');
$active_color = $num_colors[$current_numero->term_id];
$url_logo_by_numero = get_field('petit_logo_presentation', $current_numero->id_acf); // Logo Actualité + Principal (en haut à gauche)
$presentation_numero = get_field("presentation_numero_home", $current_numero->id_acf);
$sticky_by_numero = getStickyPostByNumero($current_numero->term_id);
$rbg_active_color = dh_hex2rgb($active_color);
$light = "background-color:rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", 0.67);";
$num_mag = get_field('numerotation', $current_numero->id_acf);
$bg = get_field("image_de_couverture", $current_numero->id_acf);
$postID = get_post();
?>

<body>

    <?php
    $colors_category = get_option("category_colors");
    $active_color = $colors_category[the_category_ID(false)];

    // Position sidebar
    $position_sidebar = get_field("position_sidebar");
    if ($position_sidebar == "Désactivé") {
        $css_sidebar = "aside.sidebar{display:none;}";
        $css_sidebar.="article.post-content{left:0 !important; width:100%;}";
    }

    // Active color
    $rbg_active_color = dh_hex2rgb($active_color);
    $light = "background-color:rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", .1) !important";
    $dark = "color:rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", .9) !important";
//    get(get_field("sidebar_mobile", $postID->ID));
    if (!get_field("sidebar_mobile", $postID->ID)){ $sidebar_active = ".sidebar, #btn-sidebar{display:none !important;}";}
    ?>

    <style>
        <?php echo $sidebar_active; ?>
        .category_color, .bg-color-active{
            background-color:<?php echo $active_color; ?> !important;
        }
        .border-active{
            border-color: <?php echo $active_color; ?> !important;
        }
        .font-color-category, .title-widget, h3{
            color:<?php echo $active_color; ?> !important;
        }
        .light{
<?php echo $light; ?>
        }
<?php echo $css_sidebar; ?>
    </style>


    <main id="main" role="main">
        <!-- section -->
        <section class="article-content">
<?php get_sidebar(); ?>
<?php //if (have_posts()): while (have_posts()) : the_post();  ?>

            <!-- article -->
            <article class="post-content" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <div class="post-wrapper">
                    <?php
                    // Sous-titre
                    $sub_title = get_field("sous-titre");
                    if (isset($sub_title))
                        echo '<h2 itemprop="name" class="font-color-category sub-title">' . $sub_title . "</h2>";
                    ?>

                    <h1 class="post-title"><?php the_title(); ?></h1>

                    <?php
                    //Thumbnail
                    $title = get_post(get_post_thumbnail_id())->post_title;
                    ?><div class="img_thumbnail"><?php echo get_the_post_thumbnail($article_du_topic, "full");
                    echo '<span class="legende_img_une">' . $title . '</span>';
                    ?></div><?php
                    // Chapo
                    $chapo = get_field("chapo_de_larticle");
                    if (isset($chapo)) {
                        echo "<div class='post-chapo'><p>" . $chapo . "</p></div>";
                    }
                    ?>

                    <?php
                    wp_reset_query();
                    do_shortcode(the_content());
                    ?>

                    <br><br>
                    <!--                 post details
                                    <span class="date"><?php the_time('F j, Y'); ?> <?php the_time('g:i a'); ?></span>
                                    <span class="author"><?php _e('Published by', 'html5blank'); ?> <?php the_author_posts_link(); ?></span>
                                    <span class="comments"><?php if (comments_open(get_the_ID())) comments_popup_link(__('Leave your thoughts', 'html5blank'), __('1 Comment', 'html5blank'), __('% Comments', 'html5blank')); ?></span>
                                     /post details -->

                    <?php
                    // Get Arbo
                    $branches_menu = dh_get_tree_menu_nav();
                    $id_item = get_the_ID(false);

                    $tree_menu;
                    foreach ($branches_menu as $branche_menu) {
                        $post_format = get_post_format($branche_menu['ID']);

                        if ($post_format == 'aside') {
                            $articles_du_topic = get_field("articles_a_attacher", $branche_menu["ID"]);
                            if (!empty($articles_du_topic)) {
                                foreach ($articles_du_topic as $article_du_topic) {
                                    $tree_menu[] = array("url" => get_permalink($article_du_topic->ID), "ID" => $article_du_topic->ID, "obj" => "post", "name" => $article_du_topic->post_title);
                                }
                                continue;
                            }
                        } else {
                            $tree_menu[] = array("url" => $branche_menu['url'], "ID" => $branche_menu['ID'], "obj" => $branche_menu['obj'], "name" => $branche_menu['name']);
                        }
                    }

                    // Set link
                    if (!empty($tree_menu)) {
                        $key = dh_find_key_array_by_value($tree_menu, $id_item);
                        $max = count($tree_menu);

                        $prev = $key - 1;
                        if ($prev < 0) {
                            $prev = $max - 1;
                        }

                        $next = $key + 1;
                        if ($next > ($max - 1)) {
                            $next = 0;
                        }

                        $link_prev = $tree_menu[$prev];
                        $link_current = $tree_menu[$key];
                        $link_next = $tree_menu[$next];
                    }
                    ?>

                    <div class="contextual_nav">
                        <div class="previous">
                            <?php
                            if (!empty($link_prev['name']))
                                echo "<a href='" . $link_prev['url'] . "'id='prev'><span class='inner'><span class='text'>" . $link_prev['name'] . "</span><span class='icon'></span></a>";
                            ?>
                        </div>
                        <div class="next">
                            <?php
                            if (!empty($link_next['name']))
                                echo "<a href='" . $link_next['url'] . "' id='next'><span class='inner'><span class='text'>" . $link_next['name'] . "</span><span class='icon'></span></a>";
                            ?>
                        </div>
                    </div>

                    <?php
                    $cat_colors = get_option('category_colors');
                    $articles_en_relation = get_field("articles_en_relation");
                    if ($articles_en_relation) {
                        ?>
                        <div class="related-articles">
                            <h4>À lire aussi</h4>
                            <div class="inner">
                                <?php
                                foreach ($articles_en_relation as $article_en_relation) {
                                    $thumb = get_the_post_thumbnail($article_en_relation, 'thumbnail');
                                    $link = get_permalink($article_en_relation);
                                    $category = get_the_category($article_en_relation);
                                    $id_cat = (int) $category[0]->cat_ID;
                                    $lib_cat = (!empty($category[0]->name)) ? $category[0]->name : "";
                                    $cat_colors_css = ($id_cat != 0) ? "color:" . $cat_colors[$id_cat] . ";" : "";
                                    ?>
                                    <div class="related-article">
                                        <a href="<?php echo $link; ?>">
                                            <?php if ($thumb) { ?>
                                                <figure class="related-image">
            <?php echo $thumb; ?>
                                                </figure>
        <?php } ?>
                                            <div class="related-text">
                                                <p class="parent" style="<?php echo $cat_colors_css; ?>"><?php echo $lib_cat; ?></p>
                                                <h5><?php echo dh_filtre_texte_bold($article_en_relation->post_title); ?></h5>
                                            </div>
                                        </a>
                                    </div>
                        <?php } ?>
                            </div></div>
                        <?php
                    }

                    /*
                      $original_query = $wp_query;
                      $wp_query = null;
                      $args=array('posts_per_page'=> 6, 'tag' => $brand_name);
                      $wp_query = new WP_Query( $args );
                      if ( have_posts() ) :
                      while (have_posts()) : the_post();
                      echo '<li>';
                      the_title();
                      echo '</li>';
                      endwhile;
                      endif;
                      $wp_query = null;
                      $wp_query = $original_query;
                      wp_reset_postdata();
                     */
                    ?>

<!--                    <p><?php //_e( 'Categorised in: ', 'html5blank' ); the_category(', '); // Separated by commas         ?></p>

                    <br /><br />-->


<?php
if (is_user_logged_in()) {
    ?>
                        <div class="edit-post-edito">
                            <i class="glyphicon glyphicon-pencil"></i>
                        <?php edit_post_link(); ?>
                        </div>
<?php } ?>

<?php //comments_template();     ?>
                </div>
            </article>
            <!-- /article -->

<?php //endwhile;    ?>

            <?php //else:     ?>

            <div style="clear:both"></div>

    <?php //endif;     ?>
        </section>
        <!-- /section -->
    </main>
<?php get_footer(); ?>