<!DOCTYPE html>

<html  lang="fr" xml:lang="fr" class="full no-js" manifest="<?php echo site_url(); ?>/cache.manifest">
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <title><?php wp_title(''); ?><?php
            if (wp_title('', false)) {
                echo ' :';
            }
            ?> <?php bloginfo('name'); ?></title>

        <link href="<?php bloginfo('url'); ?>/favicon.ico" rel="shortcut icon">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/touch.png" rel="apple-touch-icon-precomposed">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="<?php bloginfo('description'); ?>">

        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap.css">
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/bootstrap-theme.css">
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/portfolio.css">
        <link rel="stylesheet" type="text/css" href="<?php echo get_template_directory_uri(); ?>/css/site.css">
        <link rel="stylesheet" href="//code.jquery.com/mobile/1.3.2/jquery.mobile-1.3.2.min.css" />
        <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/mobile/mobile.css" type="text/css" />

        <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
        <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery-migrate/1.2.1/jquery-migrate.min.js"></script>
        <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/modernizr/2.7.1/modernizr.min.js"></script>

        <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/main_mobile.js"></script>
<?php wp_head(); ?>
        <script>
            // conditionizr.com
            // configure environment tests
            conditionizr.config({
                assets: '<?php echo get_template_directory_uri(); ?>',
                tests: {}
            });</script>

            <style>
                .ico_link_defaut{

                }

                .ico_link_chiffres_cles{
                    background-position: -300px -120px!important;
                }
                .ico_link_chiffres_cles:hover{
                    background-position: -300px -180px!important;
                }

                .ico_link_citation{
                    background-position: 0 -120px!important;
                }
                .ico_link_citation:hover{
                    background-position: 0 -180px!important;
                }


                .ico_link_embed{
                    background-position: -420px -120px!important;
                }
                .ico_link_embed:hover{
                    background-position: -420px -180px!important;
                }

                .ico_link_galerie{
                    background-position: -300px -360px!important;
                }
                .ico_link_galerie:hover{
                    background-position: -300px -420px!important;
                }
            </style>
            <?php echo GenererFichiersCSS(); ?>
    </head>
    <body <?php body_class(); ?>>

        <?php
        $current_numero = getCurrentNumero();
        $num_colors = get_option('numero_colors');
        $active_color = $num_colors[$current_numero->term_id];
        $bg = get_field("image_de_couverture", $current_numero->id_acf);
        $url_logo_by_numero = get_field('petit_logo_presentation', $current_numero->id_acf);
        $fonts = get_field("police", $current_numero->id_acf);
        //FONT TITLE
        if ($fonts) {
            wp_enqueue_style("dh_options_typography", "http://fonts.googleapis.com/css?family=$fonts", false, null, 'all');
            $fonts_css = "body, td, div, a, form, input, textarea, p{font-family:" . $fonts . " !important;}";
        }
        $fonts_title = get_field("police_titre", $current_numero->id_acf);
        if ($fonts_title) {
            wp_enqueue_style("dh_options_typography_title", "http://fonts.googleapis.com/css?family=$fonts_title", false, null, 'all');
            $fonts_css_title = ".home h2 p, .single h1.post-title, .page h2.color-current-numero, h1.category_color, h1.color-current-numero-bg, .encadre-titre h2, .h4.color-current-numero{font-family:" . $fonts_title . " !important;}";
        }

        // Get Arbo
        $tree_menu = dh_get_tree_menu_nav();

        // Get id current
        if (is_single()) {
            $id_item = get_the_ID(false);
        } else {
            $id_item = the_category_ID(false);
        }
        if (is_page()) {
            $id_item = $post->ID;
        }
        if (is_front_page()) {
            $id_item = 0;
        }

        // Set link
        if (!empty($tree_menu)) {
            $key = dh_find_key_array_by_value($tree_menu, $id_item);
            $max = count($tree_menu);

            $prev = $key - 1;
            if ($prev < 0) {
                $prev = $max - 1;
            }

            $next = $key + 1;
            if ($next > ($max - 1)) {
                $next = 0;
            }

            $link_prev = $tree_menu[$prev]['url'];
            $link_current = $tree_menu[$key]['url'];
            $link_next = $tree_menu[$next]['url'];
        }
        ?>

        <style scoped>
            body{
                background: url(<?php echo dh_get_best_url_img($bg); ?>) no-repeat center fixed;
                -webkit-background-size: cover !important;
                background-size: cover !important;
                background-position: 0 50px !important;
            }
<?php echo $fonts_css; ?>
<?php echo $fonts_css_title; ?>
            nav.navbar{
                background-color:<?php echo $active_color; ?>;
            }
            span.count{
                background-color:<?php echo $active_color; ?>;
            }

            .color-current-numero{
                color: <?php echo $active_color; ?> !important;
            }
            .color-current-numero-bg{
                background-color: <?php echo $active_color; ?> !important;
            }
        </style>
        <header style="border-color:<?php echo $active_color; ?>">
            <!-- LOGO VILLE -->
            <h2>
                <a href="<?php echo get_bloginfo("url"); ?>">
                    <img alt="Logo" width="300" height="120" src="<?php echo $url_logo_by_numero["sizes"]["medium"]; ?>" />
                </a>
            </h2>
            <div id="btn-back">
                <span class="btn-inner">
                    <span class="btn-text">Retour</span>
                    <a href="<?php echo get_bloginfo("url"); ?>/" class="icon icon-back">&nbsp;</a>
                </span>
            </div>
            <div id="btn-sidebar">
                <span class="btn-inner">
                    <span class="btn-text">Sidebar</span>
                    <span class="icon icon-sidebar">&nbsp;</span>
                </span>
            </div>
        </header>