<?php
/**
 * Template Name: Credit
 * */
?>

<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');
$active_color = $num_colors[$current_numero->term_id];
?>

<style>
    div.bg-repeat{
        background: url("<?php echo get_template_directory_uri(); ?>/img/bg_whitetrame.png") center fixed;
        width:100%;
        height:100%;
        position:fixed;
        display:block;
        left:0;
        top:0;
        z-index: -1;
    }

    .archive div.bg-repeat{
        background: url("http://integration1.agence-ultramedia.com/wp-content/themes/emag_new/img/bg_widget.png") center fixed;
        background-size: 6px 6px!important;    
        width:100%;
        height:100%;
        position:fixed;
        display:block;
        left:0;
        top:0;
        z-index: -1;
    }

</style>
<main role="main" class="container-chat">
    <section class="article-content">
        <h1 style="background-color:<?php echo $active_color; ?>"><?php echo the_title(); ?></h1>
        <article>
            <?php
            $link_logo_secondaire = get_option("dh_blog_img_secondaire");
            $legende_logo_secondaire = get_option('dh_blog_img_secondaire_legende'); // Logo Actualité + Principal (en haut à gauche)
            // Logo de la ville
            if (!empty($link_logo_secondaire)) {
                echo "<img id='logo' src='" . $link_logo_secondaire . "' alt='" . $legende_logo_secondaire . "' title='" . $legende_logo_secondaire . "'>";
            }
            ?>
            <div class="numerotation">
                <h2 style="color:<?php echo $active_color; ?>;">N°<?php echo $numerotation; ?> - <?php echo $current_numero->name; ?></h2>
            </div>

            <div class="post-content-ours">
                <?php
                wp_reset_query();
                the_content();
                ?>
            </div>

        </article>
    </section>
</main>
<?php get_footer(); ?>