<?php
/**
 * Template Name: WebTV
 * */
?>

<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');

// Active color
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$couleur = "background-color:rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ") !important";

$bg_wall = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
?>
<style>
    body{
        background: none;
    }
    nav[role="social"]{
        display: none;
    }
    .article-filters ul li a {
        background-color:<?php echo $active_color; ?>;
    }
    .article-filters ul li.active a {
        color: <?php echo $active_color; ?>;
    }
    .article-title {
        color:<?php echo $active_color; ?>;
    }
    .article-body .cover {
        background-color:<?php echo $active_color; ?>;
    }
    .article-body .cover {
        background-image: url(<?php echo $bg_wall[0]; ?>);
    }
    .article-body .cover:after {
        background-color:<?php echo $active_color; ?>;
    }
    /*    .article-body .cover{
            display:none;
        }*/

    <?php
    if (isset($_GET['p'])) {
        ?>
        .article-body .cover {
            height: 331px;
        }
        <?php
    }

    if (isset($_GET['playlist'])) {
        ?>
        .article-filters ul <?php echo "li#" . $_GET['playlist']; ?> a {
            opacity: 1;
            background-color: #ffffff;
            color: <?php echo $active_color; ?>;
        }
        <?php
    } else {
        ?>
        .article-filters ul li#All a {
            opacity: 1;
            background-color: #ffffff;
            color: <?php echo $active_color; ?>;
        }
        <?php
    }
    ?>





</style>
<main role="main">
    <section>
        <div class="viewport webtv-container">
            <?php
            $channelId = get_option("dh_channel_id_youtube");
//            $channelId = 'UCinRP-BvNUmtu6inwENIWXw';
            $maxResults = 13;
//            $API_key = get_option("dh_key_api_youtube");
            $API_key = 'AIzaSyCq0QCaQQsaScVfMF4MwFdLt2p1fUrgdvc';
            //Liste des playlists
            $playlist_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/playlists?order=date&part=snippet&channelId=' . $channelId . '&key=' . $API_key . ''));
            ?>

            <div class="news-columned-container">
                <article class="article-body">
                    <figure class="cover"></figure>
                    <header class="article-header">
                        <h1 class="container-title has-tag"><?php the_title(); ?></h1>
                        <aside class="article-nav">
                            <div class="article-filters">
                                <ul>
                                    <li class="webtv-filter-item" id="All">
                                        <a class="item_playlist" href="?playlist=All">Toutes les vidéos</a>
                                    </li>
                                    <?php
                                    foreach ($playlist_list->items as $item) {
                                        ?>
                                        <li class="webtv-filter-item" id="<?php echo $item->id; ?>">
                                            <?php echo('<a class="item_playlist" data-id="' . $item->id . '" href="?playlist=' . $item->id . '">' . $item->snippet->title . '</a>'); ?>
                                        </li>
                                        <?php
                                    }
                                    ?>
                                </ul>
                            </div>
                        </aside>
                    </header>
                    <ul class="article-list first-page">
                        <?php
                        if (isset($_GET['playlist']) && $_GET['playlist'] != 'All') {
                            //Liste des vidéos par playlists
                            if (isset($_GET['p'])) {
                                $playlist_videos_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/playlistItems?order=date&part=id,snippet,contentDetails,status&maxResults=' . $maxResults . '&playlistId=' . $_GET['playlist'] . '&key=' . $API_key . '&pageToken=' . $_GET['p'] . ''));
                                $i = 4;
                            } else {
                                $playlist_videos_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/playlistItems?order=date&part=id,snippet,contentDetails,status&maxResults=' . $maxResults . '&playlistId=' . $_GET['playlist'] . '&key=' . $API_key . ''));
                                $i = 1;
                            }

//                            get($playlist_videos_list);
                            $tokenPrevPage = $playlist_videos_list->prevPageToken;
                            $tokenNextPage = $playlist_videos_list->nextPageToken;
                            $paramPlaylist = $_GET['playlist'];
                            $nbItems = $playlist_videos_list->pageInfo->totalResults;

                            foreach ($playlist_videos_list->items as $videoitem) {
                                
                                $video_info = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/videos?part=snippet&id=' . $videoitem->contentDetails->videoId . '&key=' . $API_key . ''));
                                ?>
                                <li class="article webtv-video article-<?php echo $i; ?>" data-id="<?php print($videoitem->contentDetails->videoId); ?>">
                                    <a class="popup-opener-video" href="http://integration1.agence-ultramedia.com/wp-content/themes/emag_new/templates/ajax_videos.php" data-id="<?php print($videoitem->contentDetails->videoId); ?>" >
                                        <figure style="background-image: url(<?php print($video_info->items[0]->snippet->thumbnails->medium->url); ?>);"><i class="icon-play"></i></figure>
                                        <div class="article-text">
                                            <h3 class="article-title"><?php print($video_info->items[0]->snippet->title); ?></h3>
                                            <div class="article-excerpt"><?php print($video_info->items[0]->snippet->description); ?></div>
                                        </div>
                                    </a>
                                </li>
                                <?php
                                $i++;
                            }
                        } else {
                            //Liste de toutes les vidéos
                            if (isset($_GET['p'])) {
                                $video_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/search?order=date&part=snippet&channelId=' . $channelId . '&maxResults=' . $maxResults . '&key=' . $API_key . '&pageToken=' . $_GET['p'] . ''));
                                $i = 4;
                            } else {
                                $video_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/search?order=date&part=snippet&channelId=' . $channelId . '&maxResults=' . $maxResults . '&key=' . $API_key . ''));
                                $i = 1;
                            }
                            $tokenPrevPage = $video_list->prevPageToken;
                            $tokenNextPage = $video_list->nextPageToken;
                            $nbItems = $video_list->pageInfo->totalResults;

                            foreach ($video_list->items as $item) {
                                if (isset($item->id->videoId)) {
                                    ?>
                                    <li class="article webtv-video article-<?php echo $i; ?>" data-id="<?php print($item->contentDetails->videoId); ?>">
                                        <a href="http://integration1.agence-ultramedia.com/wp-content/themes/emag_new/templates/ajax_videos.php" data-id="<?php print($item->id->videoId); ?>" >
                                            <figure style="background-image: url(<?php print($item->snippet->thumbnails->medium->url); ?>);"><i class="icon-play"></i></figure>
                                            <div class="article-text">
                                                <h3 class="article-title"><?php print($item->snippet->title); ?></h3>
                                                <div class="article-excerpt"><?php print($item->snippet->description); ?></div>
                                            </div>
                                        </a>
                                    </li>
                                    <?php
                                }
                                $i++;
                            }
                        }
                        ?>
                    </ul>

                    <nav class="pagination">
                        <span class="item-count"><?php echo $nbItems; ?> vidéos</span>
                        <?php
                        if ($tokenPrevPage != "") {
                            ?>

                            <a class="previous" title="Page précédente" href="?p=<?php
                            echo $tokenPrevPage;
                            if ($paramPlaylist != "") {
                                echo "&playlist=" . $paramPlaylist;
                            }
                            ?>">
                                <i class="icon icon-previous"></i>
                                <span class="text">Page précédente</span>
                            </a>
                            <?php
                        }
                        ?>
                        <?php
                        if ($tokenNextPage != "") {
                            ?>
                            <a class="next" title="Page suivante" href="?p=<?php
                            echo $tokenNextPage;
                            if ($paramPlaylist != "") {
                                echo "&playlist=" . $paramPlaylist;
                            }
                            ?>">
                                <i class="icon icon-next"></i>
                                <span class="text">Page suivante</span>
                            </a>
                            <?php
                        }
                        ?>
                    </nav>

                </article>
            </div>

            <div style="clear:both"></div>
            <div style="display:none;">
                <div id="popupvideo" class="popup-container popup-container-webtv">

                </div>
            </div>
        </div>
    </section>
</main>
<?php get_footer(); ?>