<?php
/**
 * Template Name: WebTV
 * */
?>

<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');

// Position sidebar
$position_sidebar = get_field("position_sidebar");
if ($position_sidebar == "Droite") {
    $css_sidebar = "aside.sidebar{right:0!important;left:inherit;}";
    $css_sidebar.="article.post-content{left:0 !important;right:inherit; width:60%;}";
    $css_sidebar.="aside.sidebar .container-widget .border-active{border-left:0; border-right:solid 6px;}";
}
if ($position_sidebar == "Désactivé") {
    $css_sidebar = "aside.sidebar{display:none;}";
    $css_sidebar.="article.post-content{left:0 !important; width:100%;}";
}

// Active color
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$couleur = "background-color:rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ") !important";

$bg_wall = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
?>
<style>
    body header div .btn-inner .icon.icon-sidebar, body.page header div .btn-inner .icon.icon-sidebar, body.single header div .btn-inner .icon.icon-sidebar {
        width: 60px;
        height: 60px;
        left: 0px;
        top: 0px;
        background-position: -423px 0px;
    }
    nav[role="social"]{
        display: none;
    }
    .article-filters{
        margin-top:10px;
    }
    .article-filters ul li{
        border-left:0!important;
        width:80%;
        margin-left:10%;
    }
    .article-filters ul li a{
        background-color:rgba(255,255,255,.35)!important;
        color:#fff!important;
        border-top:0!important;
        text-transform: none!important;
    }
    .article-title {
        color:<?php echo $active_color; ?>;
        font-size: 18px;
        line-height: 22px;
        font-weight: 700;
        margin: 0;
        text-align: left;
    }
    .article-body .cover {
        background-color:<?php echo $active_color; ?>;
    }
    .article-body .cover {
        background-image: url(<?php echo $bg_wall[0]; ?>);
    }
    .article-body .cover:after {
        background-color:<?php echo $active_color; ?>;
    }

    body main section aside.sidebar ul, body.page main section aside.sidebar ul{
        text-align:left!important;
    }

    body main section aside.sidebar ul li a, body.page main section aside.sidebar ul li a, body.single main section aside.sidebar ul li a{
        padding: 8px 15px!important;
    }

    body.page main section .article-header{
        margin-bottom: 0px;
        padding-bottom: 0px;
    }
    body.page main section .article-header h1:before{
        display:none;
    }

    body.page main section .article-header h1{
        margin-left:0;
    }

    body.page main {
        margin-top: 0px !important;
    }

    .webtv-container .article .article-text, .news-container .article .article-text {
        display: block;
        margin: 0;
        padding: 1em;
        text-decoration: none;
        box-sizing: border-box;
    }

    .webtv .article-header .container-title:after, .post_container .article-header .container-title:after {
        content: '';
        display: block;
        width: 20px;
        margin: 11px auto;
        background-color: rgba(92,92,92,.72);
        height: 1px;
    }
    .fancybox-wrap{
        width:90%!important;
        left:5%!important;
    }

    .wrap-webtv {
        padding: 0 2em 1em;
    }

    .popup-container-webtv h2.title_popin {
        font-weight: lighter;
        margin: 1em 0;
        font-size: 22px;
        line-height: 1.2em;
        color: #efefef;
        text-align: center;
        border-top: 1px rgba(255, 255, 255, 0.15) solid;
        padding-top: 10px;
    }

    .popup-container-webtv p.content_popin {
        margin: 1em 0;
        font-size: 15px;
        line-height: 1.3em;
        color: #ccc;
        text-align: center;
    }

    .popup-container-webtv .fancybox-inner {
        background-color: #111;
    }

    body main section aside.sidebar, body.page main section aside.sidebar{
        background-color: #313132;
    }
    .sidebarWebTv .article-filters h4 {
        font-weight: 700;
        font-size: 17px;
        padding: 0 1em .5em;
        margin: 15px 0;
        letter-spacing: .005em;
        border-bottom: rgba(255,255,255,.35) solid 1px;
        color: white;
        text-align: left;
    }
    
    body.webtv main{
        margin-bottom:0px;
    }
        
    <?php
    if (isset($_GET['playlist'])) {
        ?>
        .article-filters ul <?php echo "li#" . $_GET['playlist']; ?> a{
            background-color: #fff!important;
            color: black!important;
        }
        <?php
    } else {
        ?>
        .article-filters ul li#All a{
            background-color: #fff!important;
            color: black!important;
        }
        <?php
    }
    ?>

</style>
<main role="main">
    <section>
        <!-- sidebar -->
        <aside id="sidebar" class="sidebar sidebarWebTv close" role="complementary">
            <div class="article-filters">
                <h4>Playlists</h4>
                <?php
                $channelId = get_option("dh_channel_id_youtube");
                //            $channelId = 'UCinRP-BvNUmtu6inwENIWXw';
                $maxResults = 13;
                //            $API_key = get_option("dh_key_api_youtube");
                $API_key = 'AIzaSyCq0QCaQQsaScVfMF4MwFdLt2p1fUrgdvc';
                //Liste des playlists
                $playlist_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/playlists?order=date&part=snippet&channelId=' . $channelId . '&key=' . $API_key . ''));
                ?>
                <ul>
                    <li class="webtv-filter-item" id="All">
                        <a class="item_playlist" href="?playlist=All">Toutes les vidéos</a>
                    </li>
                    <?php
                    foreach ($playlist_list->items as $item) {
                        ?>
                        <li class="webtv-filter-item" id="<?php echo $item->id; ?>">
                            <?php echo('<a class="item_playlist" data-id="' . $item->id . '" href="?playlist=' . $item->id . '">' . $item->snippet->title . '</a>'); ?>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </div>
        </aside>
        <!-- /sidebar -->
        <main id="main" role="main">
            <div class="viewport webtv-container">


                <div class="news-columned-container">
                    <article class="article-body">
                        <figure class="cover"></figure>
                        <div class="article-header">
                            <h1 class="container-title has-tag"><?php the_title(); ?></h1>
                        </div>
                        <article class="" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <div class="post-wrapper">
                                <ul class="article-list first-page">
                                    <?php
                                    if (isset($_GET['playlist']) && $_GET['playlist'] != 'All') {
                                        //Liste des vidéos par playlists
                                        if (isset($_GET['p'])) {
                                            $playlist_videos_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/playlistItems?order=date&part=id,snippet,contentDetails,status&maxResults=' . $maxResults . '&playlistId=' . $_GET['playlist'] . '&key=' . $API_key . '&pageToken=' . $_GET['p'] . ''));
                                            $i = 4;
                                        } else {
                                            $playlist_videos_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/playlistItems?order=date&part=id,snippet,contentDetails,status&maxResults=' . $maxResults . '&playlistId=' . $_GET['playlist'] . '&key=' . $API_key . ''));
                                            $i = 1;
                                        }

//                            get($playlist_videos_list);
                                        $tokenPrevPage = $playlist_videos_list->prevPageToken;
                                        $tokenNextPage = $playlist_videos_list->nextPageToken;
                                        $paramPlaylist = $_GET['playlist'];
                                        $nbItems = $playlist_videos_list->pageInfo->totalResults;
                                        foreach ($playlist_videos_list->items as $videoitem) {

                                            $video_info = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/videos?part=snippet&id=' . $videoitem->contentDetails->videoId . '&key=' . $API_key . ''));
                                            ?>
                                            <li class="article webtv-video" data-id="<?php print($videoitem->contentDetails->videoId); ?>">
                                                <a class="popup-opener-video" href="http://integration1.agence-ultramedia.com/wp-content/themes/emag-mobile_new/templates/ajax_videos.php" data-id="<?php print($videoitem->contentDetails->videoId); ?>" >
                                                    <figure style="background: url(<?php print($video_info->items[0]->snippet->thumbnails->medium->url); ?>) no-repeat center center; background-size:cover;;"><i class="icon-play"></i></figure>
                                                    <div class="article-text">
                                                        <h3 class="article-title"><?php print($video_info->items[0]->snippet->title); ?></h3>
                                                        <!-- <div class="article-excerpt"><?php print($video_info->items[0]->snippet->description); ?></div> -->
                                                    </div>
                                                    <div style="clear:both"></div>
                                                </a>
                                                <div style="clear:both"></div>
                                            </li>
                                            <?php
                                            $i++;
                                        }
                                    } else {
                                        //Liste de toutes les vidéos
                                        if (isset($_GET['p'])) {
                                            $video_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/search?order=date&part=snippet&channelId=' . $channelId . '&maxResults=' . $maxResults . '&key=' . $API_key . '&pageToken=' . $_GET['p'] . ''));
                                            $i = 4;
                                        } else {
                                            $video_list = json_decode(file_get_contents('https://www.googleapis.com/youtube/v3/search?order=date&part=snippet&channelId=' . $channelId . '&maxResults=' . $maxResults . '&key=' . $API_key . ''));
                                            $i = 1;
                                        }
//                            get($video_list);
                                        $tokenPrevPage = $video_list->prevPageToken;
                                        $tokenNextPage = $video_list->nextPageToken;
                                        $nbItems = $video_list->pageInfo->totalResults;
                                        foreach ($video_list->items as $item) {
                                            if (isset($item->id->videoId)) {
                                                ?>
                                                <li class="article webtv-video" data-id="<?php print($item->contentDetails->videoId); ?>">
                                                    <a class="popup-opener-video" href="http://integration1.agence-ultramedia.com/wp-content/themes/emag-mobile_new/templates/ajax_videos.php" data-id="<?php print($item->id->videoId); ?>" >
                                                        <figure style="background: url(<?php print($item->snippet->thumbnails->medium->url); ?>) no-repeat center center; background-size:cover;"><i class="icon-play"></i></figure>
                                                        <div class="article-text">
                                                            <h3 class="article-title"><?php print($item->snippet->title); ?></h3>
                                                            <!-- <div class="article-excerpt"><?php print($item->snippet->description); ?></div> -->
                                                        </div>
                                                        <div style="clear:both"></div>
                                                    </a>
                                                    <div style="clear:both"></div>

                                                </li>
                                                <?php
                                            }
                                            $i++;
                                        }
                                    }
                                    ?>
                                    <div style="clear:both"></div>
                                </ul>

                                <nav class="pagination">
                                    <span class="item-count"><?php echo $nbItems; ?> vidéos</span>
                                    <?php
                                    if ($tokenPrevPage != "") {
                                        ?>

                                        <a class="previous" title="Page précédente" href="?p=<?php
                                        echo $tokenPrevPage;
                                        if ($paramPlaylist != "") {
                                            echo "&playlist=" . $paramPlaylist;
                                        }
                                        ?>">
                                            <i class="icon icon-previous"></i>
                                            <span class="text">Page précédente</span>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                    <?php
                                    if ($tokenNextPage != "") {
                                        ?>
                                        <a class="next" title="Page suivante" href="?p=<?php
                                        echo $tokenNextPage;
                                        if ($paramPlaylist != "") {
                                            echo "&playlist=" . $paramPlaylist;
                                        }
                                        ?>">
                                            <i class="icon icon-next"></i>
                                            <span class="text">Page suivante</span>
                                        </a>
                                        <?php
                                    }
                                    ?>
                                </nav>
                                <div style="clear:both"></div>
                            </div>
                            <div style="clear:both"></div>
                        </article>
                        <div style="clear:both"></div>
                    </article>
                    <div style="clear:both"></div>
                </div>

                <div style="clear:both"></div>
                <div style="display:none;">
                    <div id="popupvideo" class="popup-container popup-container-webtv">

                    </div>
                </div>
                <div style="clear:both"></div>
            </div>
            <div style="clear:both"></div>
    </section>
    <div style="clear:both"></div>
</main>
</main>
<?php get_footer(); ?>