<?php
/*
 *  Author: Digital Heroes | @toddmotto
 *  URL: html5blank.com | @html5blank
 *  Custom functions, support, custom post types and more.
 */
function custom_pagination($numpages = '', $pagerange = '', $paged='') {

  if (empty($pagerange)) {
    $pagerange = 2;
  }

  /**
   * This first part of our function is a fallback
   * for custom pagination inside a regular loop that
   * uses the global $paged and global $wp_query variables.
   *
   * It's good because we can now override default pagination
   * in our theme, and use this function in default quries
   * and custom queries.
   */
  global $paged;
  if (empty($paged)) {
    $paged = 1;
  }
  if ($numpages == '') {
    global $wp_query;
    $numpages = $wp_query->max_num_pages;
    if(!$numpages) {
        $numpages = 1;
    }
  }

  /**
   * We construct the pagination arguments to enter into our paginate_links
   * function.
   */
  $pagination_args = array(
    'base'            => preg_replace('/\?.*/', '/', get_pagenum_link(1)) . '%_%',
    'format'          => 'page/%#%',
    'total'           => $numpages,
    'current'         => max(1, get_query_var('paged')),
    'show_all'        => false,
    'prev_next'       => false
  );

  $paginate_links = paginate_links($pagination_args);
  $previous_link = get_previous_posts_link( '<i class="icon icon-prev"></i>' );
  $next_link = get_next_posts_link( '<i class="icon icon-next"></i>', $numpages);

  if ($paginate_links) {
    echo "<nav class='custom-pagination'>";
      // echo "<span class='page-numbers page-num'>Pages " . $paged . " of " . $numpages . "</span> ";
      echo "<span class='page-numbers page-num'>Pages </span> ";
      echo $paginate_links . $previous_link . $next_link;

    echo "</nav>";
  }

}

function dh_find_key_array_by_value($array, $key) {
    foreach($array as $index => $val) {
        if($val['ID'] == $key) return $index;
    }
    return FALSE;
}

//------------------------------------------------------------------------------
//    CUSTOM THEME PERSO
//------------------------------------------------------------------------------
function get($str){
    print('<pre>');
        print_r($str);
    exit;
}

function dh_session_start(){
   if ( !session_id() && !headers_sent()){
      session_start();
   }
} add_action( 'init', 'dh_session_start' );

// Génération code
function dh_get_code($nb_car = 8, $ico, $chaine = 'azertyuiopqsdfghjklmwxcvbn123456789') {
    $nb_lettres = strlen($chaine) - 1;
    $generation = '';
    for ($i = 0; $i < $nb_car; $i++) {
        $pos = mt_rand(0, $nb_lettres);
        $car = $chaine[$pos];
        $generation .= $car;
    }
    return '[ANCRE link=' . $generation . ' ico=' . $ico . ' title="" ]';
}

// Rend le plus grand format d'une image
function dh_get_best_url_img($obj_img){

    if(!empty($obj_img)){

        if($obj_img["sizes"]["large-width"] > $obj_img["width"]){
            $url = $obj_img["sizes"]["large"];
        }else{
            $url = $obj_img["url"];
        }
        return($url);
    }
}

// Transform Hexa to RGB
function dh_hex2rgb($hex) {
   $hex = str_replace("#", "", $hex);

   if(strlen($hex) == 3) {
      $r = hexdec(substr($hex,0,1).substr($hex,0,1));
      $g = hexdec(substr($hex,1,1).substr($hex,1,1));
      $b = hexdec(substr($hex,2,1).substr($hex,2,1));
   } else {
      $r = hexdec(substr($hex,0,2));
      $g = hexdec(substr($hex,2,2));
      $b = hexdec(substr($hex,4,2));
   }
   $rgb = array($r, $g, $b);
   return $rgb; // returns an array with the rgb values
}

function gm_get_theme_menu_name( $theme_location ){
    if( ! $theme_location ) return false;

    $theme_locations = get_nav_menu_locations();
    if( ! isset( $theme_locations[$theme_location] ) ) return false;

    $menu_obj = get_term( $theme_locations[$theme_location], 'nav_menu' );
    if( ! $menu_obj ) $menu_obj = false;
    if( ! isset( $menu_obj->name ) ) return false;

    return $menu_obj;
}

//------------------------------------------------------------------------------
//    CUSTOM RSS
//------------------------------------------------------------------------------
remove_all_actions( 'do_feed_rss2' );
add_action( 'do_feed_rss2', 'acme_product_feed_rss2', 10, 1 );

function acme_product_feed_rss2( $for_comments ){
    $rss_template = get_template_directory() . '/numero/rss.php';
    load_template( $rss_template );
}
//------------------------------------------------------------------------------
//    Function filtre editorial
//------------------------------------------------------------------------------
function dh_filtre_texte_bold($str){
    return(preg_replace('#\*\*(.+)\*\*#', '<b>$1</b>', $str));
}

//------------------------------------------------------------------------------
//    REDIRECTION USER -> FRONT // ADMIN -> BACK
//------------------------------------------------------------------------------
add_filter("login_redirect", "dh_user_login_redirect", 10, 3);
function dh_user_login_redirect($redirect_to, $request, $user){

    if(is_array($user->roles))
        if(in_array('administrator', $user->roles)) return site_url('/wp-admin/');

    return home_url();
}

//------------------------------------------------------------------------------
//   CUSTOM POST TYPE
//------------------------------------------------------------------------------
// Rename post format
add_theme_support( 'post-formats', array('aside','chat','gallery','image', 'link'));
function rename_post_formats( $safe_text ) {

    switch($safe_text){
        case "En passant" : $libelle = "Topic";         break;
        case 'link'       : $libelle = "Condensé";      break;
        case "Discussion" : $libelle = "Ours";          break;
        case "Galerie"    : $libelle = "Publicité";     break;
        default :           $libelle = $safe_text;      break;
    }return $libelle;
} add_filter( 'esc_html', 'rename_post_formats' );

// Loading template
function dh_special_post_format($template) {
    if (is_single() && has_post_format()) {
        $post_format_template = locate_template('single-' . get_post_format() . '.php');
        if ($post_format_template){
            $template = $post_format_template;
        }
    } return $template;
} add_filter('template_include', 'dh_special_post_format');

// Sticky sur home
function getStickyPostByNumero($id_numero){
    $sticky_posts = get_option( 'sticky_posts' );
    $articles_en_avant = get_posts(array(
        'post_type' => 'post',
        'numberposts' => -1,
        'post__in' => $sticky_posts,
        'tax_query' => array(
            array(
                'taxonomy' => 'numero',
                'field' => 'term_id',
                'terms' => $id_numero,
                'include_children' => false
            )
        )
    )); return($articles_en_avant);
}

//------------------------------------------------------------------------------
//    Admin bar menu
//------------------------------------------------------------------------------
// Add Toolbar Menus
function dh_numero_adminbar(){
    global $wp_admin_bar,$wpdb;

    $url_param = (strpos($_SERVER['REQUEST_URI'], '?') !=0) ? $_SERVER['REQUEST_URI'] : $_SERVER['REQUEST_URI'].'?';
    $current_numero = getCurrentNumero();

    $args = array(
            'id'     => 'all_numeros',
            'title'  => 'Numéros',
            'href'   => $url_param.'&id_num=all',
    ); $wp_admin_bar->add_menu( $args );

    $numeros = get_terms( 'numero', 'orderby=term_id' );
    if(is_array($numeros)){
        $wp_admin_bar->add_menu( $args = array(
                'id'    => 0,
                'title' => "Tous",
                'parent'=> "all_numeros",
                'href'  => $url_param."&id_num=all"
        ));
        foreach($numeros as $numero){

            $args = array(
                'id'    => $numero->slug,
                'title' => $numero->name,
                'parent'=> "all_numeros",
                'href'  => $url_param."&id_num=".$numero->term_id
            );
            $wp_admin_bar->add_menu( $args );
        }
    }
} add_action( 'wp_before_admin_bar_render', 'dh_numero_adminbar', 999 );

//------------------------------------------------------------------------------
//    Shortcode
//------------------------------------------------------------------------------
include('shortcode.php');
include("documentation/index.php");
include('numero/numero.php');

function dh_page_web_tv($params){
    if(is_array($params))
        extract($params);
    ?>

    <div class="container">
        <?php
            $key_auth_youtube = get_option("dh_key_api_youtube");
            $channel_ID = get_option("dh_channel_id_youtube");
            //wp_enqueue_script( 'dh_tagsort_js', get_template_directory_uri() . '/js/filterable.js', array('jquery') );
            wp_enqueue_script( 'dh_tagsort_js', get_template_directory_uri() . '/js/filterable.pack.js', array('jquery') );
        ?>

<script>
    jQuery( window ).load(function(){

        function slugify(text){
            return text.toString().toLowerCase()
              .replace(/\s+/g, '-')           // Replace spaces with -
              .replace(/[^\w\-]+/g, '')       // Remove all non-word chars
              .replace(/\-\-+/g, '-')         // Replace multiple - with single -
              .replace(/^-+/, '')             // Trim - from start of text
              .replace(/-+$/, '');            // Trim - from end of text
        }

        localStorage.clear();
        var html_vid = localStorage.getItem('dh_cache_playlist');

        if(html_vid != null){
            var videos = JSON.parse(localStorage.getItem('dh_cache_videos'));
            var playlist = JSON.parse(localStorage.getItem('dh_cache_playlist'));

            jQuery.each(playlist, function(i,playlist_html){
                jQuery("#portfolio-filter").append(playlist_html);
            });

            jQuery.each(videos, function(i,videos_html){
                jQuery("#portfolio-list").append(videos_html);
            });

            jQuery('#portfolio-list').filterable();
            console.log("FROM CACHE !");
        }else{
                jQuery.getJSON( "https://www.googleapis.com/youtube/v3/playlists?maxResults=50&part=snippet&channelId=<?php echo $channel_ID;?>&key=<?php echo $key_auth_youtube;?>", function( data ) {

                dh_playlist = new Array();

                jQuery.each( data.items, function( i,playlist ){
                    var dh_playlist_html = '<li><a href="#'+slugify(playlist.snippet.localized.title)+'" title="">'+playlist.snippet.localized.title+'</a></li>';
                    jQuery("#portfolio-filter").append(dh_playlist_html);
                    dh_playlist.push(dh_playlist_html);

                    var dh_cache_playlist = JSON.stringify(dh_playlist);
                    localStorage.setItem("dh_cache_playlist",dh_cache_playlist);

                    jQuery.getJSON( 'https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&playlistId='+playlist.id+'&key=<?php echo $key_auth_youtube;?>', function( videos ) {

                        var dh_vids = new Array();
                        jQuery.each( videos.items, function( i,video ){

                            var html = '<li style="display: block;" class="'+slugify(playlist.snippet.localized.title)+'"><div class="vid"><iframe width="320" height="280" src="//www.youtube.com/embed/'+video.snippet.resourceId.videoId+'" frameborder="0" allowfullscreen=""></iframe></div></li>';
                            jQuery("#portfolio-list").append(html);
                            dh_vids.push(html);
                            var dh_cache_videos = JSON.stringify(dh_vids);
                            localStorage.setItem("dh_cache_videos",dh_cache_videos);
                        });
                    });
                });
                jQuery("#portfolio-list").append('<li style="overflow: hidden; clear: both; height: 0px; position: relative; float: none; display: block;"></li>');
                jQuery('#portfolio-list').filterable();
            });
        }
    });
</script>

    <div class="boundingBox" id="content">
        <ul id="portfolio-filter"></ul>
        <ul id="portfolio-list"></ul>
    </div>

 <?php
} add_shortcode( 'DH_PAGE_WEB_TV', 'dh_page_web_tv' );


//------------------------------------------------------------------------------
//    JS / css widget admin
//------------------------------------------------------------------------------
function dh_include_scripts_admin(){
    if( (int) strpos($_SERVER['REQUEST_URI'], 'post.php?') !=0
            || (int) strpos($_SERVER['REQUEST_URI'], 'post-new.php') !=0
            || (int) strpos($_SERVER['REQUEST_URI'],'widgets.php') !=0  ){
        wp_enqueue_script( 'dh_widgets_text_editor_js', get_template_directory_uri() . '/widgets/js/jquery.markitup.js', array('jquery'));
        wp_enqueue_script( 'dh_widgets_js', get_template_directory_uri() . '/widgets/js/widgets.js', array('jquery') );
        wp_enqueue_style( 'dh_widgets_css', get_template_directory_uri() . '/widgets/css/widgets.css');
    }

    if((int) strpos( $_SERVER["REQUEST_URI"], 'taxonomy=category')
            || $_GET["taxonomy"] == "numero"){
        wp_enqueue_script( 'dh_widgets_hide_js', get_template_directory_uri() . '/js/widget.js', array('jquery'));
    }

} add_action( 'admin_enqueue_scripts', 'dh_include_scripts_admin' );

//------------------------------------------------------------------------------
//    WIDGETS
//------------------------------------------------------------------------------
include('widgets/amorce.php');
include('widgets/publicite.php');
include('widgets/encart.php');
include('widgets/embed.php');
include('widgets/evenement.php');
include('widgets/chiffres_cles.php');
include('widgets/galerie.php');
include('widgets/citation.php');
include('widgets/ours.php');

// Ajoute le lien de déconnexion dans le top menu
add_filter('wp_nav_menu_items', 'dh_emag_logout_menu_top', 10, 2);
function dh_emag_logout_menu_top($items, $args){

    // Hook menu top
    if($args->theme_location == "header-menu"){

        // Info mag
        $current_numero = getCurrentNumero();
        $name_mag = get_option('dh_name_site_magazine');
        $num_mag = get_field('numerotation', $current_numero->id_acf);
            $menu_info_mag = "<li><a tabindex='0' href='". get_bloginfo("url") ."/' alt='".$name_mag." - ".$num_mag." : ".$current_numero->name." (nouvelle fenêtre)' title='".$name_mag." - ".$num_mag." : ".$current_numero->name." (nouvelle fenêtre)'>".$name_mag." - ".$num_mag." : ".$current_numero->name."</a></li>";

        // Download PDF
        $info_pdf = get_field("pdf_du_numero", $current_numero->id_acf);
        if(is_array($info_pdf)){
            $menu_url_pdf = "<li><a href='".$info_pdf["url"]."' target='_blank' alt='".$info_pdf["title"]." (pdf)(nouvelle fenêtre)' title='".$info_pdf["title"]." (pdf)(nouvelle fenêtre)'>".$info_pdf["title"]."</a></li>";
        }

        // Aide
        $menu_aide = "<li><a href='#help-content' alt='Aide (pop-up)' title='Aide (pop-up)' class='popup-opener-aide trigger-help' >Aide</a></li>";

        // Logout
        ob_start();
        wp_loginout('index.php');
        $loginout = ob_get_contents();
        ob_end_clean();
            $menu_logout = '<li>'.  $loginout .'</li>';

        // Ret
        $items = $menu_info_mag.$items.$menu_url_pdf.$menu_aide.$menu_logout;
    }

    // Menu de lang
    if($args->theme_location == "langmenu"){
        $url_rss = '<a href="'.get_feed_link('atom').'" target="_blank">'
                    . '<img src="'.get_template_directory_uri().'/img/ico-rss.png" alt="RSS" title="RSS" class="ico-rss">'
                . '</a>';

        $items = $url_rss.$items;
    }

    // Sous-menu de navigation
    if($args->theme_location == "submenu"){
        $links = wp_get_nav_menu_items($args->menu->term_id);
        $colors_category = get_option("category_colors");

        if(is_array($links)){

            $current_numero = getCurrentNumero();
            $num_colors = get_option('numero_colors');
            $active_color = $num_colors[$current_numero->term_id];

            $css = "<style>";
            foreach($links as $link){

                if($link->object == 'category'){
                    $css.=".menu-item-".$link->db_id." {";
                        $css.="border-left: 4px solid ".$colors_category[$link->object_id]." !important;";
                    $css.="}";
					$css.=".menu-item-".$link->db_id." a h5 {";
                        $css.="color: ".$colors_category[$link->object_id]." !important;";
                    $css.="}";
                }else{
                    $css.=".menu-item-".$link->db_id." {";
                        $css.="border-left: 4px solid ".$active_color." !important;";
                    $css.="}";
					$css.=".menu-item-".$link->db_id." a h5 {";
                        $css.="color: ".$active_color." !important;";
                    $css.="}";
                }
            }
            $css.="</style>";

            $items = $css.$items;
        }
    } return $items;
}


//------------------------------------------------------------------------------
//    THEME CONFIG
//------------------------------------------------------------------------------
// create custom plugin settings menu
add_action('admin_menu', 'dh_add_admin_menu');

function dh_add_admin_menu(){
    add_menu_page('E-mag', 'E-mag', 'administrator', __FILE__, 'dh_plugin_settings_page' , "dashicons-admin-site" );
    add_menu_page('Documentation', 'Documentation', 'administrator', __FILE__."/documentation/index.php",'dh_plugin_settings_page_documentation', "dashicons-admin-site");
    add_action( 'admin_init', 'register_dh_plugin_settings' );
}

// Config emag
function register_dh_plugin_settings(){
    // API
    register_setting( 'dh-plugin-settings-group', 'dh_key_api_google_map' );
    register_setting('dh-plugin-settings-group','dh_key_api_youtube');
    register_setting('dh-plugin-settings-group','dh_channel_id_youtube');

    // JS
    register_setting('dh-plugin-settings-group','dh_js_code_piwik');

    // Commentaire
    register_setting('dh-plugin-settings-group','dh_is_cmt_active');

    // Social
    register_setting('dh-plugin-settings-group','dh_fb_app_id_emag');
    register_setting('dh-plugin-settings-group','dh_social_is_active');

    // Vidéo
    register_setting('dh-plugin-settings-group','dh_video_nb_per_page');

    // Theme option (img, nom, etc..)
    register_setting('dh-plugin-settings-group','dh_blog_img_ville');
    register_setting('dh-plugin-settings-group','dh_blog_img_ville_legende');
    register_setting('dh-plugin-settings-group','dh_name_site_magazine');
}

function dh_plugin_settings_page(){
?>
<div class="wrap">
<h1>Configuration E-mag</h1>


<form method="post" action="options.php">
    <?php settings_fields( 'dh-plugin-settings-group' ); ?>
    <?php do_settings_sections( 'dh-plugin-settings-group' ); ?>
    <table class="form-table">
        <tr valign="top">
            <th scope="row">Clé API google map</th>
            <td><input type="text" name="dh_key_api_google_map" value="<?php echo esc_attr( get_option('dh_key_api_google_map') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Clé API Youtube</th>
            <td><input type="text" name="dh_key_api_youtube" value="<?php echo esc_attr( get_option('dh_key_api_youtube') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Channel ID Youtube</th>
            <td><input type="text" name="dh_channel_id_youtube" value="<?php echo esc_attr( get_option('dh_channel_id_youtube') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Code piwik</th>
            <td><textarea name="dh_js_code_piwik" ><?php echo esc_attr( get_option('dh_js_code_piwik') ); ?></textarea></td>
        </tr>

        <tr valign="top">
            <th scope="row">Activer les commentaires</th>
            <td>
                <?php  $dh_commentaire_is_active = get_option("dh_is_cmt_active"); ?>
                <input type="checkbox" name="dh_is_cmt_active" value="1" <?php checked( 1 == $dh_commentaire_is_active ); ?>>
            </td>
        </tr>

        <tr valign="top">
            <th scope="row">Nb de vidéo par page</th>
            <td><input type="text" name="dh_video_nb_per_page" value="<?php echo esc_attr( get_option('dh_video_nb_per_page') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Activer le partage ?</th>
            <td>
                <?php  $dh_social_is_active = get_option("dh_social_is_active"); ?>
                <input type="checkbox" name="dh_social_is_active" value="1" <?php checked( 1 == $dh_social_is_active ); ?>>
            </td>
        </tr>
        <tr valign="top">
            <th scope="row">Facebook APP id</th>
            <td><input type="text" name="dh_fb_app_id_emag" value="<?php echo esc_attr( get_option('dh_fb_app_id_emag') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Logo de la ville (URL)</th>
            <td><input type="text" name="dh_blog_img_ville" value="<?php echo esc_attr( get_option('dh_blog_img_ville') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Légende pour logo</th>
            <td><input type="text" name="dh_blog_img_ville_legende" value="<?php echo esc_attr( get_option('dh_blog_img_ville_legende') ); ?>" /></td>
        </tr>
        <tr valign="top">
            <th scope="row">Nom de Magazine</th>
            <td><input type="text" name="dh_name_site_magazine" value="<?php echo esc_attr( get_option('dh_name_site_magazine') ); ?>" /></td>
        </tr>
    </table>
    <?php submit_button(); ?>
</form>
</div>
<?php }

/*------------------------------------*\
	Theme Support
\*------------------------------------*/

if (!isset($content_width)){
    $content_width = 900;
}

if (function_exists('add_theme_support')){
    // Add Menu Support
    //add_theme_support('menus');

    // Add Thumbnail Theme Support
    add_theme_support('post-thumbnails');
    add_image_size('large', 700, '', true); // Large Thumbnail
    add_image_size('medium', 250, '', true); // Medium Thumbnail
    add_image_size('small', 120, '', true); // Small Thumbnail
    add_image_size('custom-size', 700, 200, true); // Custom Thumbnail Size call using the_post_thumbnail('custom-size');

    // Add Support for Custom Backgrounds - Uncomment below if you're going to use
    add_theme_support('custom-background', array(
	'default-color' => 'FFF',
	//'default-image' => get_template_directory_uri() . '/img/bg.jpg'
    ));


//------------------------------------------------------------------------------
//    END OF
//------------------------------------------------------------------------------
/*
    // Add Support for Custom Header - Uncomment below if you're going to use
    add_theme_support('custom-header', array(
	'default-image'			=> get_template_directory_uri() . '/img/headers/default.jpg',
	'header-text'			=> false,
	'default-text-color'		=> '000',
	'width'				=> 1000,
	'height'			=> 198,
	'random-default'		=> false,
	'wp-head-callback'		=> $wphead_cb,
	'admin-head-callback'		=> $adminhead_cb,
	'admin-preview-callback'	=> $adminpreview_cb
    ));
*/
    // Enables post and comment RSS feed links to head
    add_theme_support('automatic-feed-links');

    // Localisation Support
    load_theme_textdomain('html5blank', get_template_directory() . '/languages');
}

/*------------------------------------*\
	Functions
\*------------------------------------*/



// Load HTML5 Blank scripts (header.php)
function html5blank_header_scripts()
{
    if ($GLOBALS['pagenow'] != 'wp-login.php' && !is_admin()) {

    	wp_register_script('conditionizr', get_template_directory_uri() . '/js/lib/conditionizr-4.3.0.min.js', array(), '4.3.0'); // Conditionizr
        wp_enqueue_script('conditionizr');

        wp_register_script('modernizr', get_template_directory_uri() . '/js/lib/modernizr-2.7.1.min.js', array(), '2.7.1'); // Modernizr
        wp_enqueue_script('modernizr');

        wp_register_script('html5blankscripts', get_template_directory_uri() . '/js/scripts.js', array('jquery'), '1.0.0'); // Custom scripts
        wp_enqueue_script('html5blankscripts');

        wp_enqueue_script( 'dh_hammer_js', get_template_directory_uri() . '/js/hammer.min.js', array('jquery') );
        wp_enqueue_script( 'dh_hammer_js_2', get_template_directory_uri() . '/js/jquery.hammer.js', array('jquery') );
    }
}

// Load HTML5 Blank conditional scripts
function html5blank_conditional_scripts()
{
    if (is_page('pagenamehere')) {
        wp_register_script('scriptname', get_template_directory_uri() . '/js/scriptname.js', array('jquery'), '1.0.0'); // Conditional script(s)
        wp_enqueue_script('scriptname'); // Enqueue it!
    }
}

// Load HTML5 Blank styles
function html5blank_styles() {
    wp_register_style('normalize', get_template_directory_uri() . '/normalize.css', array(), '1.0', 'all');
    wp_enqueue_style('normalize');
    wp_register_style('html5blank', get_template_directory_uri() . '/style.css', array(), '1.0', 'all');
    wp_enqueue_style('html5blank');

    // Pop-up
    //wp_enqueue_style('dh_popup_css', get_template_directory_uri() . '/css/magnific-popup.css');
    //wp_enqueue_script('dh_popup_js', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js');

    wp_register_style('dh_fancy_css', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.css');
    wp_register_script('dh_fancy_js', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.js', array('jquery'), '1.0.0');
    wp_register_script('dh_swiper_js', get_template_directory_uri() . '/js/swiper.jquery.min.js', array('jquery'), '1.0.0');
    wp_register_style('dh_swiper_css', get_template_directory_uri() . '/css/swiper.min.css');
    wp_register_style('dh_webtv_actu_css', get_template_directory_uri() . '/css/webtv_articles.css');
    wp_register_style('dh_new_css', get_template_directory_uri() . '/css/new.css');
    wp_register_style('dh_global_sass', get_template_directory_uri() . '/css/global.css', array(), '1.0', 'all');
    wp_register_style('dh_global_sass_mobile', get_template_directory_uri() . '/css/mobile/mobile.css', array(), '1.0', 'all');
    wp_register_style('dh_global_sass_print', get_template_directory_uri() . '/css/print.css', array(), '1.0', 'all');

    wp_enqueue_style('dh_global_sass');
    wp_enqueue_style('dh_global_sass_mobile');
    wp_enqueue_style('dh_global_sass_print');
    wp_enqueue_style('dh_fancy_css');
    wp_enqueue_script('dh_fancy_js');
    wp_enqueue_script('dh_swiper_js');
    wp_enqueue_style('dh_swiper_css');
    wp_enqueue_style('dh_webtv_actu_css');
    wp_enqueue_style('dh_new_css');
}

// Register menu
function register_html5_menu(){
    register_nav_menus(array(
        'header-menu' => __( 'Menu principal', 'emag' ), // Main Navigation
        'langmenu'=> __( 'Menu de traduction', 'emag' ),
        'submenu'=> __( 'Sous-menu', 'emag' )
    ));
}


// Remove the <div> surrounding the dynamic navigation to cleanup markup
function my_wp_nav_menu_args($args = '') {
    $args['container'] = false;
    return $args;
}

// Remove Injected classes, ID's and Page ID's from Navigation <li> items
function my_css_attributes_filter($var) {
    return is_array($var) ? array() : '';
}

// Remove invalid rel attribute values in the categorylist
function remove_category_rel_from_category_list($thelist){
    return str_replace('rel="category tag"', 'rel="tag"', $thelist);
}

// Add page slug to body class, love this - Credit: Starkers Wordpress Theme
function add_slug_to_body_class($classes) {
    global $post;
    if (is_home()) {
        $key = array_search('blog', $classes);
        if ($key > -1) {
            unset($classes[$key]);
        }
    } elseif (is_page()) {
        $classes[] = sanitize_html_class($post->post_name);
    } elseif (is_singular()) {
        $classes[] = sanitize_html_class($post->post_name);
    }
    return $classes;
}

// If Dynamic Sidebar Exists
if (function_exists('register_sidebar')){ // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => "Widgets",
        'description' => "Déposser ici les widgets pour l'article",
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="container-widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4 class="title-widget">',
        'after_title' => '</h4>'
    ));
}

// Remove wp_head() injected Recent Comment styles
function my_remove_recent_comments_style()
{
    global $wp_widget_factory;
    remove_action('wp_head', array(
        $wp_widget_factory->widgets['WP_Widget_Recent_Comments'],
        'recent_comments_style'
    ));
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 20;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 40;
}

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('View Article', 'html5blank') . '</a>';
}

// Remove Admin bar
function remove_admin_bar()
{
    return false;
}

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}

// Custom Gravatar in Settings > Discussion
function html5blankgravatar ($avatar_defaults)
{
    $myavatar = get_template_directory_uri() . '/img/gravatar.jpg';
    $avatar_defaults[$myavatar] = "Custom Gravatar";
    return $avatar_defaults;
}

// Threaded Comments
function enable_threaded_comments()
{
    if (!is_admin()) {
        if (is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) {
            wp_enqueue_script('comment-reply');
        }
    }
}

add_filter( 'comment_form_defaults', 'juiz_manage_default_fields');

// $default contient tous les messages du formulaire de commentaire
// il contient également "comment_field", le textarea du message

if ( !function_exists('juiz_manage_default_fields')) {
   function juiz_manage_default_fields( $default ) {

      // get($default);

      $commenter = wp_get_current_commenter();

      unset($default["fields"]["url"]);

      $default['title_reply'] = '
        <i class="ico-share-commentaires"></i>
        <h4>Laissez nous un commentaire</h4>
        <hr>
      ';
      $default['comment_field'] = '
        <p class="comment-form-comment">
            <textarea id="comment" name="comment" class="wysija-input" cols="45" rows="8" maxlength="65525" aria-required="true" placeholder="Commentaire" required="required"></textarea>
        </p>
     ';

      return $default;
   }
}

// Custom Comments Callback
function html5blankcomments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}

?>
    <!-- heads up: starting < for the html tag (li or div) in the next line: -->
    <<?php echo $tag ?> <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
	<div class="comment-author vcard">
	<?php if ($args['avatar_size'] != 0) echo get_avatar( $comment, $args['180'] ); ?>
	<?php printf(__('<cite class="fn">%s</cite> <span class="says">says:</span>'), get_comment_author_link()) ?>
	</div>
<?php if ($comment->comment_approved == '0') : ?>
	<em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.') ?></em>
	<br />
<?php endif; ?>

	<div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
		<?php
			printf( __('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'),'  ','' );
		?>
	</div>

	<?php comment_text() ?>

	<div class="reply">
	<?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
	</div>
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
<?php }

/*------------------------------------*\
	Actions + Filters + ShortCodes
\*------------------------------------*/

// Add Actions
add_action('init', 'html5blank_header_scripts'); // Add Custom Scripts to wp_head
add_action('wp_print_scripts', 'html5blank_conditional_scripts'); // Add Conditional Page Scripts
add_action('get_header', 'enable_threaded_comments'); // Enable Threaded Comments
add_action('wp_enqueue_scripts', 'html5blank_styles'); // Add Theme Stylesheet
add_action('init', 'register_html5_menu'); // Add HTML5 Blank Menu

add_action('widgets_init', 'my_remove_recent_comments_style'); // Remove inline Recent Comment Styles from wp_head()
add_action('init', 'html5wp_pagination'); // Add our HTML5 Pagination

// Remove Actions
remove_action('wp_head', 'feed_links_extra', 3); // Display the links to the extra feeds such as category feeds
remove_action('wp_head', 'feed_links', 2); // Display the links to the general feeds: Post and Comment Feed
remove_action('wp_head', 'rsd_link'); // Display the link to the Really Simple Discovery service endpoint, EditURI link
remove_action('wp_head', 'wlwmanifest_link'); // Display the link to the Windows Live Writer manifest file.
remove_action('wp_head', 'index_rel_link'); // Index link
remove_action('wp_head', 'parent_post_rel_link', 10, 0); // Prev link
remove_action('wp_head', 'start_post_rel_link', 10, 0); // Start link
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0); // Display relational links for the posts adjacent to the current post.
remove_action('wp_head', 'wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
remove_action('wp_head', 'rel_canonical');
remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

// Add Filters
add_filter('avatar_defaults', 'html5blankgravatar'); // Custom Gravatar in Settings > Discussion
add_filter('body_class', 'add_slug_to_body_class'); // Add slug to body class (Starkers build)
add_filter('widget_text', 'do_shortcode'); // Allow shortcodes in Dynamic Sidebar
add_filter('widget_text', 'shortcode_unautop'); // Remove <p> tags in Dynamic Sidebars (better!)
add_filter('wp_nav_menu_args', 'my_wp_nav_menu_args'); // Remove surrounding <div> from WP Navigation
// add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> injected classes (Commented out by default)
// add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> injected ID (Commented out by default)
// add_filter('page_css_class', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> Page ID's (Commented out by default)
add_filter('the_category', 'remove_category_rel_from_category_list'); // Remove invalid rel attribute
add_filter('the_excerpt', 'shortcode_unautop'); // Remove auto <p> tags in Excerpt (Manual Excerpts only)
add_filter('the_content', 'do_shortcode'); // Allows Shortcodes to be executed in Excerpt (Manual Excerpts only)
add_filter('the_excerpt', 'do_shortcode'); // Allows Shortcodes to be executed in Excerpt (Manual Excerpts only)
add_filter('excerpt_more', 'html5_blank_view_article'); // Add 'View Article' button instead of [...] for Excerpts
add_filter('show_admin_bar', 'remove_admin_bar'); // Remove Admin bar
add_filter('style_loader_tag', 'html5_style_remove'); // Remove 'text/css' from enqueued stylesheet
add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to thumbnails
add_filter('image_send_to_editor', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to post images

// Remove Filters
remove_filter('the_excerpt', 'wpautop'); // Remove <p> tags from Excerpt altogether

?>