<?php
//------------------------------------------------------------------------------
//    Widget Publicite       
//------------------------------------------------------------------------------   
    
class Dh_Widget_Perso_Amorce2 extends WP_Widget{
    
    public function __construct(){
        parent::__construct('dh_amorce2', 'Amorce2', array('description' => 'Widget Amorce2'));
    }
     
    // Front view
    public function widget($args, $instance){
        echo $args['before_widget'];
        
            echo "<div class='wrapper-widget border-active'>";
                echo $args['before_title'];
                    echo apply_filters('widget_title', $instance['title']);
                echo $args['after_title'];
                
                // Lien ancre
                $params = explode('=',$instance["ancre"]);
                if(!empty($params)){
                    $code_ancre = substr($params[1], 0,8);
                    echo '<a name="'.$code_ancre.'">&nbsp;</a>';
                }
                
                echo "<div class='text-widget'>";
                    echo "<p>".$instance["description"]."</p>";
                echo "</div>";
                    echo "<p class='auteur-quote'><a href='".$instance["link"]."' target='_blank'>Lien</a></p>";
            echo "</div>";
        echo $args['after_widget'];
    }
       
    // Form
    public function form($instance){
        $title = isset($instance['title']) ? $instance['title'] : '';
        $description = isset($instance['description']) ? $instance['description'] : '';
        $link = isset($instance['link']) ? $instance['link'] : '';?>
        
        <p><label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:' ); ?></label>
        <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo htmlspecialchars( $title ); ?>" /></p>
        
        <p>
            <label for="<?php echo $this->get_field_name( 'description' ); ?>"><?php _e( 'Description :' ); ?></label> <br>
            <textarea class="htmleditor_widgeted" name="<?php echo $this->get_field_name( 'description' ); ?>" id="<?php echo $this->get_field_name( 'description' ); ?>" ><?php echo $description;?></textarea>
        </p>
             
        <p>
            <label for="<?php echo $this->get_field_name( 'link' ); ?>">Lien :</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'link' ); ?>" name="<?php echo $this->get_field_name( 'link' ); ?>" type="text" value="<?php echo  htmlspecialchars($link); ?>" />
        </p>
        
        <hr>
            <?php $ancre = ($instance["ancre"]) ? $instance["ancre"] : dh_get_code(8); ?>
            <p>
                <label for="<?php echo $this->get_field_name( 'ancre' ); ?>"><?php _e( 'Ancre :' ); ?></label> Ajouter ico=video ou ico=image ico=pdf avant "]" pour changer l'icone du lien rapide<br>
                <input class="widefat" id="<?php echo $this->get_field_id( 'ancre' ); ?>" name="<?php echo $this->get_field_name( 'ancre' ); ?>" type="text" value="<?php echo  htmlspecialchars($ancre); ?>" />
                Copiez le code ci-dessus pour l'intégrer dans le contenu de l'article.
            </p>
            <br><br>
        <?php
    }
}
register_widget('Dh_Widget_Perso_Amorce2');
add_action('widgets_init', function(){register_widget('Dh_Widget_Perso_Amorce2');});