<?php get_header(); ?>

<?php
$current_numero = getCurrentNumero();
$url_logo_by_numero = get_field('petit_logo', $current_numero->id_acf);
$numerotation = get_field("numerotation", $current_numero->id_acf);
$num_colors = get_option('numero_colors');

$post_ID = get_post($id);

$title_actu = $post_ID->post_title;
$content_actu = $post_ID->post_content;

$terms_actu = get_the_terms($post_ID, 'etiquette_actu', array('hide_empty' => false));

// Active color
$active_color = $num_colors[$current_numero->term_id];
$rbg_active_color = dh_hex2rgb($active_color);
$couleur = "background-color:rgb(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ") !important";

$bg_wall = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
?>

<main role="main">
    <section>
        <!-- sidebar -->
        <aside id="sidebar" class="sidebar sidebarActu close" role="complementary">
            <div class="article-filters">
                <h4>Filtres</h4>
                <ul>
                    <li class="webtv-filter-item">
                        <a href="?tagged=">Toutes les actualités</a>
                    </li>
                    <?php
                    // Récupérer la taxonomie dans une variable
                    $taxonomy = 'etiquette_actu';
                    // Variable avec le get_terms
                    $tax_terms = get_terms($taxonomy, array('hide_empty' => false));
                    // La boucle d'affichage
                    foreach ($tax_terms as $tax_term) {
                        ?>
                        <li class="webtv-filter-item">
                            <a href="?tagged=<?php echo $tax_term->slug; ?>"><?php echo $tax_term->name; ?></a>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </div>
        </aside>
        <!-- /sidebar -->
        <main id="main" role="main">
            <div class="viewport news-article news-article-single">
                <style>
                    body header div .btn-inner .icon.icon-sidebar, body.page header div .btn-inner .icon.icon-sidebar, body.single header div .btn-inner .icon.icon-sidebar {
                        width: 60px;
                        height: 60px;
                        left: 0px;
                        top: 0px;
                        background-position: -423px 0px;
                    }
                    .article-title {
                        color:<?php echo $active_color; ?>;
                    }
                    .article-content > blockquote {
                        background-color:<?php echo $active_color; ?>;
                    }
                    .article-excerpt {
                        border-left-color:<?php echo $active_color; ?>;
                    }
                    .article-filters ul li a {
                        background-color:<?php echo $active_color; ?>;
                    }
                    .article-body .cover {
                        background-color:<?php echo $active_color; ?>;
                    }

                    .news-article-single .tag-container {
                        width: 90%;
                        margin: auto;
                        margin-top: 20px;
                        padding: 10px 0;
                        border-bottom: 1px solid rgba(92,92,92,.24);
                    }
                    .news-article-single .tag-container h3 {
                        text-align: center;
                        font-size: 20px;
                        line-height: 25px;
                        font-weight: 700;
                        margin: 0;
                        color: #191919;
                    }
                    .news-article-single .article-header {
                        position: relative;
                        margin: 0 0 25px;
                        text-align: center;
                    }
                    .news-article .article-header .article-date {
                        padding: 0px;
                        border-bottom: none;
                    }
                    .news-article-single .article-header .article-date {
                        display: block;
                    }
                    .news-article-single .article-header .article-date .inner {
                        color: black;
                        padding: 15px 0 10px;
                        border-bottom: 1px solid black;
                        font-size: 17px;
                        line-height: 21px;
                        font-weight: 700;
                        letter-spacing: .005em;
                        display: inline-block;
                    }
                    .news-article .article-header .over-title {
                        background-color: transparent;
                        padding: 0;
                    }
                    .news-article-single .article-header .over-title {
                        display: block;
                        margin: 12px 0;
                    }
                    .news-article-single .article-header .over-title .inner {
                        background-color: #393939;
                        height: 27px;
                        box-sizing: border-box;
                        padding: 8px 15px 6px;
                        color: white;
                        text-transform: uppercase;
                        display: inline-block;
                        font-size: 12px;
                        line-height: 13px;
                    }
                    .news-article-single .article-header .article-title {
                        font-size: 31px;
                        line-height: 34px;
                        margin: 14px auto;
                        max-width: 655px;
                        font-weight: 700;
                    }
                    .news-article-single .img-container {
                        margin: 0 0em;
                        position: relative;
                        z-index: 3;
                    }
                    .sidebarActu .article-filters h4 {
                        font-weight: 700;
                        font-size: 17px;
                        padding: 0 1em .5em;
                        margin: 15px 0;
                        letter-spacing: .005em;
                        border-bottom: rgba(255,255,255,.35) solid 1px;
                        color: white;
                    }
                    body main section aside.sidebar, body.page main section aside.sidebar{
                        background-color: <?php echo $active_color; ?> !important;
                    }
                    .news-container .article-title {
                        color:<?php echo $active_color; ?>;
                    }
                    .article-filters{
                        margin-top:10px;
                    }
                    .article-filters ul li{
                        border-left:0!important;
                        width:80%;
                        margin-left:10%;
                    }
                    .article-filters ul li a{
                        background-color:rgba(255,255,255,.35)!important;
                        color:#fff!important;
                        border-top:0!important;
                        text-transform: none!important;
                    }
                    .article-filters ul li.active a{
                        color: #313131!important;
                        background-color:rgba(255,255,255,1)!important;
                    }
                    .news-container .article-body .cover {
                        background-color:<?php echo $active_color; ?>;
                    }
                    .news-container .article-body .cover {
                        background-image: url(<?php echo $bg_wall[0]; ?>);
                    }
                    .news-container .article-body .cover:after {
                        background-color:<?php echo $active_color; ?>;
                    }

                    body main section aside.sidebar ul, body.page main section aside.sidebar ul{
                        text-align:left!important;
                    }

                    body main section aside.sidebar ul li a, body.page main section aside.sidebar ul li a, body.single main section aside.sidebar ul li a{
                        padding: 8px 15px!important;
                    }
                </style>
                <div class="news-columned-container">
                    <article class="article-body">
                        <figure class="cover"></figure>
                        <div class="tag-container">
                            <?php $post_id_parent = get_field('wall_dactualites', false, false); ?>
                            <h3><?php echo get_the_title($post_id_parent); ?></h3>
                            <span class="line"></span>
                        </div>
                        <div class="article-header">
                            <?php
                            if (get_field('date_actu')) {
                                $date = get_field('date_actu', false, false);
                                $date = new DateTime($date);
                                ?>
                                <time class="article-date" datetime="<?php echo $date->format('j/m/y'); ?>"><span class="inner">Le <?php echo $date->format('j/m/y'); ?></span></time>
                            <?php } ?>
                            <?php if (get_field('sous_titre_actu')) { ?>
                                <h2 class="over-title"><span class="inner"><?php the_field('sous_titre_actu', $post_ID); ?></span></h2>
                            <?php } ?>
                            <?php if (!empty($content_actu)) { ?>
                                <h1 class="article-title"><?php echo $title_actu; ?></h1>
                            <?php } ?>
                            <?php if (get_field('auteur_actu')) { ?>
                                <p class="author">par <span class="author_name"><?php the_field('auteur_actu', $post_ID); ?></span></p>
                            <?php } ?>


                        </div>
                        <?php
                        if (has_post_thumbnail()) { // Vérifies qu'une miniature est associée à l'article.
                            $title_img = get_post(get_post_thumbnail_id())->post_title;
                            $bg_cat = wp_get_attachment_image_src(get_post_thumbnail_id($post_ID), 'full');
                            ?>
                            <div class="img-container">
                                <figure>
                                    <img alt="<?php echo $title_img; ?>" width="<?php echo $bg_cat[1]; ?>" src="<?php echo $bg_cat[0]; ?>">
                                </figure>
                            </div>
                            <?php
                        }
                        ?>
                        <div class="article-container">
                            <?php if (get_field('chapo_actu')) { ?>
                                <div class="article-excerpt"><?php the_field('chapo_actu', $post_ID); ?></div>
                            <?php } ?>
                            <?php if (!empty($content_actu)) { ?>
                                <div class="article-content"><?php echo $content_actu; ?></div>
                            <?php } ?>
                        </div>

                        <?php
                        $articles_en_relation_actu = get_field("articles_en_relation_actu", false, false);

                        if ($articles_en_relation_actu) {
                            ?>
                            <div class = "article-same-topic article-references">
                                <h4>Sur le même sujet</h4>
                                <ul>
                                    <?php
                                    foreach ($articles_en_relation_actu as $post) {
                                        setup_postdata( $post );

                                        $thumb = get_the_post_thumbnail($post, 'thumbnail');
                                        $bg_relat = wp_get_attachment_image_src(get_post_thumbnail_id($post), 'thumbnail');
                                        $link = get_permalink($post);
                                        $category = get_the_category($post);
                                        $id_cat = (int) $category[0]->cat_ID;
                                        $lib_cat = (!empty($category[0]->name)) ? $category[0]->name : "";
                                        $cat_colors_css = ($id_cat != 0) ? "color:" . $cat_colors[$id_cat] . ";" : "";
                                    $sous_titre_actu = get_field("sous_titre_actu");
                                        ?>
                                        <li class = "article">
                                            <a href = "<?php echo $link; ?>">
                                                <?php if ($bg_relat) { ?>
                                                    <figure style="background-image:url(<?php echo $bg_relat[0]; ?>);"></figure>
                                                <?php } ?>
                                                <div class = "article-text">
                                                   <?php if($sous_titre_actu != ''){ ?>
                                                                                                       <h4 class = "over-title"><span class = "over-title-wrap"><?php print($sous_titre_actu); ?></span></h4>
                                                                                                  <?php } ?>
                                                    <h3 class = "article-title"><?php the_title(); ?></h3>
                                                </div>
                                            </a>
                                        </li>
                                        <?php
                                        wp_reset_postdata();
                                    }
                                    ?>
                                </ul>
                            </div>
                            <?php
                        }
                        ?>
                    </article>
                </div>
            </div>
        </main>
    </section>
</main>
<?php get_footer();
?>