<?php get_header(); ?>

<?php
// Load option
$colors_category = get_option("category_colors");
$active_color = $colors_category[the_category_ID(false)];
$sous_titre = get_field("sous-titre");

// Position sidebar
$position_sidebar = get_field("position_sidebar");
if ($position_sidebar == "Désactivé") {
    $css_sidebar = "aside.sidebar{display:none !important;}";
    $css_sidebar.="body header div#btn-archives, body.single header div#btn-sidebar {display: none !important;}";
}
?>
?>

<style>
    .font-color-category, .title-widget{
        color:<?php echo $active_color; ?> !important;
    }
    <?php echo $css_sidebar; ?>
</style>
<section class="container-format-image">
    <aside id="sidebar" class="sidebar format-image close" role="complementary">
        <div class="wrapper-format-image">
            <div class="chapo-format-image">
                <?php
                $chapo = get_field("chapo_de_larticle");
                echo $chapo;
                ?>
            </div>
            <div class="content-format-image">
                &nbsp;
            </div>
        </div>
    </aside>  

    <main id="main" role="main">
        <section class="article-content">
            <article>
                <?php if (!empty($sous_titre)) { ?>
                    <h2 class="font-color-category title-categorie sub-title"><?php echo $sous_titre; ?></h2>
                <?php } ?>
                <h1  class="post-title"><?php echo the_title(); ?></h1>

                <?php if (!empty(get_field("shortcode_diaporama"))) { 
                        echo do_shortcode(get_field("shortcode_diaporama"));
                    }
                    ?>

                    <div style="padding: 1em 1em 2em; font-size: 13px; line-height: 17px;">
<?php wp_reset_query();
echo the_content(); ?>
                    </div>

                    <?php
                    $images = get_field("galerie");

                    if (have_rows('galerie')): while (have_rows('galerie')) : the_row();
                            $legende = get_sub_field('titre');
                            $url_image = get_sub_field('image');
                            echo '<img src="' . dh_get_best_url_img($url_image) . '" alt="' . htmlspecialchars($legende) . '" title="' . htmlspecialchars($legende) . '" rel="' . htmlspecialchars($legende) . '" class="tooltip-legend"> <br />';
                        endwhile;
                    endif;
                    ?>

                    <?php
                    // Get Arbo
                    $tree_menu = dh_get_tree_menu_nav();
                    $id_item = get_the_ID(false);

                    // Set link
                    if (!empty($tree_menu)) {
                        $key = dh_find_key_array_by_value($tree_menu, $id_item);
                        $max = count($tree_menu);

                        $prev = $key - 1;
                        if ($prev < 0) {
                            $prev = $max - 1;
                        }

                        $next = $key + 1;
                        if ($next > ($max - 1)) {
                            $next = 0;
                        }

                        $link_prev = $tree_menu[$prev];
                        $link_current = $tree_menu[$key];
                        $link_next = $tree_menu[$next];
                    }
                    ?>

                    <div class="contextual_nav" style="margin: 25px 0 0;">
                        <div class="previous">
                            <?php
                            if (!empty($link_prev['name']))
                                echo "<a href='" . $link_prev['url'] . "'id='prev'><span class='inner'><span class='text'>" . $link_prev['name'] . "</span><span class='icon'></span></a>";
                            ?>
                        </div>
                        <div class="next">
                            <?php
                            if (!empty($link_next['name']))
                                echo "<a href='" . $link_next['url'] . "' id='next'><span class='inner'><span class='text'>" . $link_next['name'] . "</span><span class='icon'></span></a>";
                            ?>
                        </div>
                    </div>
            </article>
        </section>
    </main>
</section>

<?php get_footer(); ?>