// ----------------------------------------------------------------------------
// markItUp!
// ----------------------------------------------------------------------------
// Copyright (C) 2011 Jay Salvat
// http://markitup.jaysalvat.com/
// ----------------------------------------------------------------------------
// Html tags
// http://en.wikipedia.org/wiki/html
// ----------------------------------------------------------------------------
// Basic set. Feel free to add more tags
// ----------------------------------------------------------------------------
var mySettings = {
	onShiftEnter:  	{keepDefault:false, replaceWith:'<br />\n'},
	onCtrlEnter:  	{keepDefault:false, openWith:'\n<p>', closeWith:'</p>'},
	onTab:    		{keepDefault:false, replaceWith:'    '},
	markupSet:  [
                {name:'H1', key:'h', openWith:'<h1>', closeWith:'</h1>'},
                {name:'H2', key:'j', openWith:'<h2>', closeWith:'</h2>'},
                {name:'H3', key:'k', openWith:'<h3>', closeWith:'</h3>'},
                {name:'H4', key:'l', openWith:'<h4>', closeWith:'</h4>'},
                {name:'H5', key:'m', openWith:'<h5>', closeWith:'</h5>'},
                {name:'H6', key:'n', openWith:'<h6>', closeWith:'</h6>'},
                {separator:'---------------' },
		{name:'Bold', key:'B', openWith:'(!(<strong>|!|<b>)!)', closeWith:'(!(</strong>|!|</b>)!)' },
		{name:'Italic', key:'I', openWith:'(!(<em>|!|<i>)!)', closeWith:'(!(</em>|!|</i>)!)'  },
                // {name:'Barré', key:'S', openWith:'<del>', closeWith:'</del>' },
                {separator:'---------------' },
                {name:'Liste à Puce', openWith:'    <li>', closeWith:'</li>', multiline:true, openBlockWith:'<ul>\n', closeBlockWith:'\n</ul>'},
		{name:'Liste numérique', openWith:'    <li>', closeWith:'</li>', multiline:true, openBlockWith:'<ol>\n', closeBlockWith:'\n</ol>'},
		{separator:'---------------' },
		{name:'Image', key:'P', replaceWith:'<img src="[![Source:!:http://]!]" alt="[![Alternative text]!]" />' },
		{name:'Link', key:'L', openWith:'<a href="[![Link:!:http://]!]"(!( title="[![Title]!]")!)>', closeWith:'</a>', placeHolder:'Your text to link...' },
		{separator:'---------------' },
                {name:'Citation', key:'c', openWith:'<blockquote>', closeWith:'</blockquote>'},
                {name:'Code', key:'n', openWith:'<code>', closeWith:'</code>'},
                {separator:'---------------' },
		//{name:'Clean', className:'clean', replaceWith:function(markitup) { return markitup.selection.replace(/<(.*?)>/g, "") } },		
		{name:'Preview', className:'preview',  call:'preview', previewInWindow: 'width=800, height=600, resizable=yes, scrollbars=yes' }
                   //previewParser: function(content) { return dhPreviewParser(content);}, }
	]
}


jQuery(function(){
 
	// Add markItUp! to your textarea in one line
        //jQuery('textarea').markItUp( { mySettings }, { OptionalExtraSettings } );
	jQuery('.htmleditor_widgeted').markItUp(mySettings);
        
        /*
	jQuery('.add').click(function(){
            jQuery('.htmleditor').markItUp('insert',
                    { 	openWith:'<opening tag>',
                            closeWith:'<\/closing tag>',
                            placeHolder:"New content"
                    }
            );
            return false;
	}); */
	
        /*
	// And you can add/remove markItUp! whenever you want
	// $(textarea).markItUpRemove();
	jQuery('.toggle').click(function() {
		if (jQuery(".htmleditor.markItUpEditor").length === 1) {
 			jQuery(".htmleditor").markItUp('remove');
			jQuery("span", this).text("get markItUp! back");
		} else {
			jQuery('.htmleditor').markItUp(mySettings);
			jQuery("span", this).text("remove markItUp!");
		}
 		return false;
	});*/
});