<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml"
      xmlns:fb="https://www.facebook.com/2008/fbml"
      xml:lang="fr"
      lang="fr"
      dir="ltr"
      manifest="<?php echo site_url(); ?>/cache.manifest" ><!--<![endif]-->
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, maximum-scale=1, minimum-scale=1" />
        <title>Mobile Emag</title>
        <meta name="description" co1ntent="" />
        <meta name="keywords" content="" />
        <link href="<?php bloginfo('url'); ?>/favicon.ico" rel="shortcut icon">

            <meta name="apple-mobile-web-app-status-bar-style" content="black" />
            <meta name="apple-mobile-web-app-capable" content="yes" />
            <meta name="apple-mobile-web-app-title" content="" />
            <link rel="stylesheet" href="//code.jquery.com/mobile/1.3.2/jquery.mobile-1.3.2.min.css" />
            <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/mobile/mobile.css" type="text/css" />

            <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery/1.11.0/jquery.min.js"></script>
            <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/jquery-migrate/1.2.1/jquery-migrate.min.js"></script>        
            <script type="text/javascript" src="//cdnjs.cloudflare.com/ajax/libs/modernizr/2.7.1/modernizr.min.js"></script>

            <script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/js/main_mobile.js"></script>
            <?php wp_head(); ?>
            <?php echo GenererFichiersCSS(); ?>
    </head>

    <?php
    $current_numero = getCurrentNumero();
    $sticky_posts = get_option('sticky_posts');
    $num_colors = get_option('numero_colors');
    $active_color = $num_colors[$current_numero->term_id];
    $cat_colors = get_option('category_colors');
    $url_logo_by_numero = get_field('petit_logo_presentation', $current_numero->id_acf); // Logo Actualité + Principal (en haut à gauche)
    $presentation_numero = get_field("presentation_numero_home", $current_numero->id_acf);
    $sticky_by_numero = getStickyPostByNumero($current_numero->term_id);
    $rbg_active_color = dh_hex2rgb($active_color);
    $light = "background-color:rgba(" . $rbg_active_color[0] . ", " . $rbg_active_color[1] . ", " . $rbg_active_color[2] . ", 0.67);";

    $rbg_cat_color = dh_hex2rgb($cat_colors);
    $color_current = "rgb(" . $rbg_cat_color[0] . ", " . $rbg_cat_color[1] . ", " . $rbg_cat_color[2] . ")";

    $num_mag = get_field('numerotation', $current_numero->id_acf);
    $bg = get_field("image_de_couverture", $current_numero->id_acf);
    $post_reference = get_field("reference_a_larticle_de_couverture", $current_numero->id_acf);
    $post_reference_link = get_permalink($post_reference->ID);
    ?>

    <style>
        .menu-item{
            background-image: none;
            background: #f7f7f7;
            border-left-style: solid;
            border-left-width: 4px;
            border-left-color: <?php echo $active_color; ?>;
        }
        .menu-item a{
            display: block;
            text-transform: uppercase;
            font-size: 15px;
            font-weight: 400;
            padding: 8px 25px;
            text-decoration: none;
            border-bottom: 1px solid #ddd;
        }
        .menu-item a h5{
            font-weight: 700;
            display: block;
            margin: .6em 0;
        }

        .menu-item.menu_mob_princ a{
            display: block;
            text-transform: uppercase;
            font-size: 11px;
            font-weight: 400;
            padding: 8px 25px;
            text-decoration: none;
            border-bottom: 1px solid #ddd;
        }
        .menu-item.menu_mob_princ a h5{
            font-weight: 400;
            display: block;
            margin: .6em 0;
        }
    </style>

    <body class="home_mob">
        <section>

            <!-- MENU GAUCHE -->
            <div id="menu-wrap" class="menu-wrap close">
                <div id="header_panel" style="background-color:<?php echo $active_color; ?>;">
                    <strong><?php echo get_bloginfo("name"); ?></strong><br/>
                    <span class="issue-prefix">N°</span><?php echo $num_mag; ?> : <?php echo $current_numero->name; ?>
                </div>

                <div id="search_form">
                    <input type="search" name="s" id="main_search" value="" placeholder="Rechercher…">
                </div>

                <!-- MENU GAUCHE - Rubriques -->
                <ul>
                    <!-- DIVIDER = ETIQUETTEs -->
                    <li style='background-color:<?php echo $active_color; ?>' class="li-divider">Rubriques</li>
                    <?php
                    $numMag = get_field("numerotation", $current_numero->id_acf);
                    $menu = wp_get_nav_menu_items('Sous-menu-' . $numMag);
                    $cat_Couleur = $active_color;
                    foreach ($menu as $item) {
                        if ($item->object == "category") {
                            $cat_Couleur = $cat_colors[$item->object_id];
                        } else if ($item->object == 'post') {
                            $cat_Item = get_the_category($item->object_id);
                            $cat_Couleur = $cat_colors[$cat_Item[0]->term_id];
                        }
                        ?>
                        <li class="menu-item" style="border-left-color: <?php echo $cat_Couleur; ?>;">
                            <a href="http://digitalheroes.agence-ultramedia.com/fr/archives/">
                                <h5 style="color: <?php echo $cat_Couleur; ?>;"><?php echo $item->title; ?></h5>
                            </a>
                        </li>
                        <?php
                    }

                    $menu_princ = wp_get_nav_menu_items('Menu principal', array('theme_location' => 'header-menu'));
//                    get($menu_princ);
                    ?>

                    <li style="background-color: <?php echo $active_color; ?>;" class="li-divider">À propos</li>
                    <?php
                    foreach ($menu_princ as $item_princ) {
                        if ($item_princ->title == "Archives") {
                            continue;
                        }
                        ?>
                        <li class="menu-item menu_mob_princ" style="border-left-color: <?php echo $active_color; ?>;">
                            <a href="<?php echo $item_princ->url; ?>">
                                <h5><?php echo $item_princ->title; ?></h5>
                            </a>
                        </li>
                        <?php
                    }
                    $info_pdf = get_field("pdf_du_numero", $current_numero->id_acf);
                    ?>
                    <li class="menu-item menu_mob_princ" style="border-left-color: <?php echo $active_color; ?>;">
                        <a href='<?php echo $info_pdf["url"]; ?>' target='_blank' alt='Téléchargez le PDF (pdf)(nouvelle fenêtre)' title='Téléchargez le PDF (pdf)(nouvelle fenêtre)'>
                            <h5>Téléchargez le PDF</h5>
                        </a>
                    </li>
                    <li class="menu-item menu_mob_princ" style="border-left-color: <?php echo $active_color; ?>;">
                        <a href='#help-content' alt='Aide (pop-up)' title='Aide (pop-up)' class='popup-opener-aide trigger-help'>
                            <h5>Aide</h5>
                        </a>
                    </li>
                </ul>
            </div>

            <!-- MENU GAUCHE  - MENU DROITE -->
            <?php
            $numeros = get_terms(array(
                "taxonomy" => "numero",
                'orderby' => "term_id",
                'order' => 'DESC',
                    // 'hide_empty' => false,
            ));
// TO DO -> class active sur mois en cours
            ?>
            <div id="archives-wrap" class="archives-wrap close">
                <ul class="archives">
                    <h4 style='background-color:<?php echo $active_color; ?>'>Archives</h4>

                    <?php
                    if (is_array($numeros)) {
                        $i = 0;
                        foreach ($numeros as $k => $numero) {
                            ?>
                            <li>
                                <a href="<?php echo get_bloginfo('url') . '/?id_num=' . $numero->term_id; ?>" title="<?php echo $numero->name; ?>">
                                    <p><?php echo $numero->name; ?></p>
                                </a>
                            </li>
                            <?php
                        }
                    }

                    if (get_field('activer_archives_old')) {
                        ?>
                        <li>
                            <a href="<?php the_field('lien_archives_old'); ?>" title="<?php the_field('title_archives_old'); ?>">
                                <p><?php the_field('title_archives_old'); ?></p>
                            </a>
                        </li>
                        <?php
                    }
                    ?>
                </ul>
            </div>


            <!-- PAGE -->
            <div id="main" role="main">
                <header style="border-color:<?php echo $active_color; ?>;">  

                    <!-- LOGO VILLE -->
                    <h2>
                        <a href="<?php echo get_bloginfo("url"); ?>">
                            <img alt="Logo" width="300" height="120" src="<?php echo $url_logo_by_numero["sizes"]["medium"]; ?>" />
                        </a>
                    </h2>

                    <!-- BTN_GAUCHE -->
                    <div id="btn-menu">
                        <span class="btn-inner">
                            <span class="btn-text">Menu</span>
                            <span class="icon icon-menu">&nbsp;</span>
                        </span>
                    </div>

                    <!-- BTN_DROITE -->
                    <div id="btn-archives">
                        <span class="btn-inner">
                            <span class="btn-text">Archives</span>
                            <span class="icon icon-archives">&nbsp;</span>
                        </span>
                    </div>
                </header>


                <!-- INDEX -->
                <ul class="wall">
                    <!-- IMG DU NUMERO -->
                    <figure class="cover with-wall">
                        <a data-transition="slide" href="<?php echo $post_reference_link; ?>">
                            <img alt="Article en avant" width="1440" height="960" src="<?php echo $bg["sizes"]["medium_large"]; ?>" />
                        </a>
                    </figure>

                    <?php
                    /*
                     *  TO DO : DARKER LIGTHER COLOR CAT
                     *  front_article = pas d'image
                     *  article_preview = article normal
                     *  big_article = article portrait
                     * 
                     */
                    ?>

                    <?php
//-----------------------------------------------------------------------------
//                      BLOC ARTICLE NUMERO DE REFERENCE
//-----------------------------------------------------------------------------
                    ?>

                    <li class="li-divider first-child" style="background-color:<?php echo $active_color; ?>">
                        <h4 class="li-heading">À la Une</h4>
                    </li>

                    <li class="article_preview front_article height-1">
                        <a data-transition="slide" href="<?php echo $post_reference_link; ?>">
                            <h6 class="overtitle"><?php echo get_field("surtitre_de_laccroche", $current_numero->id_acf); ?></h6>
                            <h4 class="entry-title"><?php echo get_field("accroche_du_numero", $current_numero->id_acf); ?></h4>
                            <p class="excerpt"></p>
                        </a>
                    </li>

                    <?php
                    $sticky_by_numero = getStickyPostByNumero($current_numero->term_id);
                    
                    foreach ($sticky_by_numero as $recent) {
                        
                        $imageData = get_the_post_thumbnail($recent->ID, "thumbnail");
                        if ($recent->post_type == 'post') {
                            $category = get_the_category($recent->ID);
                        } else if ($recent->post_type == 'wall_actu') {
                            $category = get_the_terms($recent->ID, 'etiquette_actu', array('hide_empty' => false));
                        }
                        
                        ?>
                        <li class="article_preview ">
                            <a data-transition="slide" href="<?php echo get_permalink($recent->guid); ?>">
                                <?php echo $imageData; ?>
                                <h6 class="overtitle"><?php echo $category[0]->name; ?></h6>
                                <h4 class="entry-title"><?php echo $recent->post_title; ?></h4>
                                <p class="excerpt"><?php echo $recent->post_excerpt; ?></p>
                            </a>
                        </li>
                        <?php
                    }
//-----------------------------------------------------------------------------
//                      Boucle article
//-----------------------------------------------------------------------------
                    ?>                    
                    <?php
                    $tree_menu = dh_get_tree_menu_nav();

//                    get($tree_menu);
                    foreach ($tree_menu as $link) {
                        $img = "";
                        if ($link["obj"] == "blank")
                            continue;
                        ?>
                        <?php if ($link["obj"] == "category") { // Categorie d'article               ?>

                            <?php
                            $item = get_category($link["ID"]);

                            // Var
                            $title_cat = $item->cat_name;
                            $content = get_field("sous_titre_categorie", "category_" . $link["ID"]);
                            $img_cat = get_field("image_de_fond", "category_" . $link["ID"]);
                            $img = $img_cat['url'];
                            // Color 
                            $cat_colors_css = dh_hex2rgb($cat_colors[$link["ID"]]);
                            $light_color_cat = "rgba(" . $cat_colors_css[0] . ", " . $cat_colors_css[1] . ", " . $cat_colors_css[2] . ", 1);";
                            ?>

                            <li class="li-divider" style="background-color:<?php echo $light_color_cat; ?>">
                                <h4 class="li-heading">
                                    <a href="<?php echo $link[url]; ?>"><?php echo $title_cat; ?></a>
                                </h4>
                            </li>
                        <?php } else { // Article + format                ?>

                            <?php
                            $item = get_post($link["ID"]);
                            $post_format = get_post_format($link["ID"]);

                            // Affichage par format d'article 
                            if ($post_format == "aside") {   // Format topic
                                $articles_du_topic = get_field("articles_a_attacher", $link["ID"]);
                                if (!empty($articles_du_topic)) {
                                    foreach ($articles_du_topic as $article_du_topic) {

                                        $link_article = get_permalink($article_du_topic->ID);
                                        $sous_titre = get_field("sous-titre", $article_du_topic->ID);
                                        $titre = $article_du_topic->post_title;

                                        $tailleThumbnail;
                                        if (get_field("mise_en_avant_sur_mobile", $article_du_topic->ID)) {
                                            $thumb = wp_get_attachment_image_src(get_post_thumbnail_id($article_du_topic->ID), 'full');
                                            $thumbnail = '<div id="post" style="background-image: url(' . $thumb['0'] . '); background-position: center;background-size:cover;background-position:top center;background-repeat: no-repeat; height:150px;width:100%;"></div>';
                                        } else {
                                            $thumbnail = get_the_post_thumbnail($article_du_topic, "thumbnail");
                                        }
                                        ?>

                                        <li class="article_preview li-border <?php
                                        if (get_field("mise_en_avant_sur_mobile", $article_du_topic->ID)) {
                                            echo"big_article";
                                        }
                                        ?>" style="border-color:<?php echo $light_color_cat; ?>;">
                                            <a href="<?php echo $link_article; ?>" alt="" title="">
                                                <?php echo $thumbnail; ?>
                                                <h6 class="overtitle" style="color:<?php echo $light_color_cat; ?>"><?php echo $sous_titre; ?></h6>
                                                <h4 class="entry-title"><?php echo $titre; ?></h4>
                                                <p class="excerpt"></p>
                                            </a>
                                        </li>

                                        <?php
                                    }
                                    continue;
                                }
                            }

                            // VAR
                            $title = $item->post_title;
                            $content = get_field("sous-titre", $item->ID);

                            $tailleThumbnail;
                            if (get_field("mise_en_avant_sur_mobile", $item->ID)) {
                                $thumb = wp_get_attachment_image_src(get_post_thumbnail_id($item->ID), 'full');
                                $thumbnail = '<div id="post" style="background-image: url(' . $thumb['0'] . '); background-position: center;background-size:cover;background-position:top center;background-repeat: no-repeat; height:150px;width:100%;"></div>';
                            } else {
                                $thumbnail = get_the_post_thumbnail($item, "thumbnail");
                            }
                            // Affichage format page
                            if ($link["obj"] == "page") {
                                if($link['ID'] == 17 || $link['ID'] == 482){
                                    continue;
                                }
                                ?>
                                <li class="article_preview <?php
                                if (get_field("mise_en_avant_sur_mobile", $item->ID)) {
                                    echo"big_article";
                                }
                                ?>">
                                    <a data-transition="slide" href="<?php echo $link['url']; ?>">
                                        <?php echo $thumbnail; ?>
                                        <h6 class="overtitle"><?php echo $title; ?></h6>
                                        <h4 class="entry-title"><?php echo $content; ?></h4>
                                        <p class="excerpt"></p>
                                    </a>
                                </li>
                                <?php
                                continue;
                            }
                            ?>

                            <li class="article_preview li-border <?php
                            if (get_field("mise_en_avant_sur_mobile", $item->ID)) {
                                echo "big_article";
                            }
                            ?>" style="border-color:<?php echo $light_color_cat; ?>;">
                                <a data-transition="slide" href="<?php echo $link['url']; ?>">
                                    <?php echo $thumbnail; ?>
                                    <h6 class="overtitle" style="color:<?php echo $light_color_cat; ?>"><?php echo $content; ?></h6>
                                    <h4 class="entry-title"><?php echo $title; ?></h4>
                                    <p class="excerpt"></p>
                                </a>
                            </li>
                        <?php } ?>
                    <?php } ?>
                </ul>
            </div>
        </section>
        <?php get_footer(); ?>