<?php
/**
 * Copyright REZO ZERO 2015
 *
 *
 *
 * @file AdminIssuesController.php
 * @copyright REZO ZERO 2015
 * @author Ambroise Maupate
 */
namespace Themes\KiosqueTheme\Controllers\Admin;

use RZ\Roadiz\CMS\Forms\Constraints\UniqueNodeName;
use RZ\Roadiz\Core\Entities\Node;
use RZ\Roadiz\Core\Events\FilterNodeEvent;
use RZ\Roadiz\Core\Events\NodeEvents;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints\NotBlank;
use Themes\Rozier\Controllers\Nodes\NodesController;

class AdminIssuesController extends NodesController
{
    public function listAction(
        Request $request,
        $_locale = ""
    ) {
        $this->validateAccessForRole('ROLE_ACCESS_NODES');

        if (empty($_locale)) {
            $translation = $this->getService('em')
                ->getRepository('RZ\Roadiz\Core\Entities\Translation')
                ->findDefault();
        } else {
            $translation = $this->getService('em')
                ->getRepository('RZ\Roadiz\Core\Entities\Translation')
                ->findOneByLocale($_locale);
        }

        $listManager = $this->createEntityListManager(
            "GeneratedNodeSources\NSIssue",
            [
                "translation" => $translation,
                "node.status" => ['<=', Node::PUBLISHED],
            ],
            [
                "sticky" => "DESC",
                "issuedate" => "DESC",
            ]
        );
        $listManager->handle();

        $this->assignation['filters'] = $listManager->getAssignation();
        $this->assignation['issues'] = $listManager->getEntities();

        return $this->render('admin/issues/issues.html.twig', $this->assignation, null, 'KiosqueTheme');
    }

    public function addIssueAction(
        Request $request,
        $_locale = ""
    ) {
        $this->validateAccessForRole('ROLE_ACCESS_NODES');

        $parent = $this->getService('nodeApi')
            ->getOneBy([
                'nodeName' => 'parutions',
            ]);

        $type = $this->getService('em')
            ->getRepository('RZ\Roadiz\Core\Entities\NodeType')
            ->findOneByName('Issue');

        if (empty($_locale)) {
            $translation = $this->getService('em')
                ->getRepository('RZ\Roadiz\Core\Entities\Translation')
                ->findDefault();
        } else {
            $translation = $this->getService('em')
                ->getRepository('RZ\Roadiz\Core\Entities\Translation')
                ->findOneByLocale($_locale);
        }

        $form = $this->createFormBuilder()
            ->add('nodeName', 'text', [
                'constraints' => [
                    new NotBlank(),
                    new UniqueNodeName([
                        'entityManager' => $this->getService('em'),
                    ]),
                ],
            ])
            ->getForm();
        $form->handleRequest($request);

        if ($form->isValid()) {
            try {
                $node = $this->createNode($form->getData(), $type, $translation);
                $this->getService('em')->refresh($node);

                $node->setParent($parent);
                $node->getNodeSources()->first()->setIssuedate(new \DateTime());
                $this->getService('em')->flush();
                /*
                 * Dispatch event
                 */
                $event = new FilterNodeEvent($node);
                $this->getService('dispatcher')->dispatch(NodeEvents::NODE_CREATED, $event);

                $msg = $this->getTranslator()->trans(
                    'node.%name%.created',
                    ['%name%' => $node->getNodeName()]
                );
                $this->publishConfirmMessage($request, $msg);

                return $this->redirect($this->generateUrl('nodesEditSourcePage', [
                    'nodeId' => $node->getId(),
                    'translationId' => $translation->getId(),
                ]));

            } catch (EntityAlreadyExistsException $e) {
                $this->publishErrorMessage($request, $e->getMessage());
            }

            return $this->redirect($this->generateUrl('adminIssuesPage', ['_locale' => $translation->getLocale()]));
        }

        $this->assignation['form'] = $form->createView();

        return $this->render('admin/issues/add-issue.html.twig', $this->assignation, null, 'KiosqueTheme');
    }
}
