# Kiosque theme

Copyright (c) 2015 *REZO ZERO* pour *Ultramedia*

## Install

- Create a virtual host folder structure for your kiosque website.
- Create an *Nginx* virtual host using one of the samples provided in `samples/` folder.
- Create the matching *php5-fpm* pool with your vhost user.

### Files and theme

- Clone Roadiz on `develop` branch in your `htdocs/` folder: `git clone -b develop https://github.com/roadiz/roadiz.git ./`
- Copy a configuration file `cp conf/config.default.yml conf/config.yml`
- Copy the sample install entry point `cp samples/install.php.sample install.php`
- Ajust the *install.php* IP array permission to match your own IP
- Add virtual host *SSH public key* to [Gitlab deploy keys section](https://gitlab.rezo-zero.com/ultramedia/KiosqueTheme/deploy_keys) in order to authorize cloning from your server. 
- Make sure you cloned `KiosqueTheme` into *Roadiz* themes’ folder before launching *install process*. `git clone git@gitlab.rezo-zero.com:ultramedia/KiosqueTheme.git`.
- Install PHP dependencies with `composer install --no-dev -o`. You should always install dependencies **after** cloning *KiosqueTheme* as it needs some specific dependencies too. So you will have to run *composer* only once.
- Launch *Install process* in your browser and make sure to choose *Kiosque Theme* and to enable its installation.
- Remove *install.php* file

## Node-types

- **KiosqueHeader**: contains all informations for Kiosque header and general layout.
- **KiosqueFooter**: contains all informations for Kiosque footer this should be the parent of every annexe pages. Footer favigation will be created from its children nodes.
- **Page**: simple page for annex informations such as legal things
- **MixedSocialFeed**: gather every social accounts to display a MixedFeed using rezozero open-source lib https://github.com/rezozero/mixedfeed.
- **SocialAccount**: contain informations for adding a single social feed into the mixed feed.

## Fonts

KiosqueTheme can customize the two main fonts for titlings. Just upload your fonts to Roadiz back-office with following *CSS font-family*:

- `primary-font`: for header titles and section titles
- `secondary-font`: for filters and issue titles

## Do not forget to enter your Universal Analytics ID

In Settings > API

## Update your Kiosque data

After pulling *KiosqueTheme*, you should need to upgrade your node-types definitions.

```shell
bin/roadiz themes:install --no-debug --data /Themes/KiosqueTheme/KiosqueThemeApp
bin/roadiz core:sources -r
bin/roadiz orm:schema-tool:update --force --dump-sql
bin/roadiz cache -a --env=prod #or dev
```

## Configure Kiosque header 

![Kiosque header fields](static/img/kiosque-header-fields.png)

## Configure Issue-feed 

![Issue feed fields](static/img/issuefeed-fields.png)


