<?php
/*
 * Copyright REZO ZERO 2015
 *
 * MixedSocialFeed
 *
 * @file MixedSocialFeedController.php
 * @copyright REZO ZERO 2015
 * @author Thomas Aufresne
 */

namespace Themes\KiosqueTheme\Controllers\Blocks;

use RZ\MixedFeed\FacebookPageFeed;
use RZ\MixedFeed\InstagramFeed;
use RZ\MixedFeed\MixedFeed;
use RZ\MixedFeed\TwitterFeed;
use RZ\Roadiz\Core\Bags\SettingsBag;
use RZ\Roadiz\Core\Entities\Node;
use RZ\Roadiz\Core\Entities\NodesSources;
use Symfony\Component\HttpFoundation\Request;
use Themes\KiosqueTheme\KiosqueThemeApp;

/**
 * SocialFeedController class
 */
class MixedSocialFeedController extends KiosqueThemeApp
{
    const ITEMS = 20;

    public static $feedProviders;

    public function buildMixedFeed()
    {

        $accounts = $this->getService('nodeSourceApi')
            ->getBy([
                'node.nodeType' => $this->themeContainer['typeSocialAccount'],
                'node.parent' => $this->node,
                'node.visible' => true,
            ], ['node.position' => 'ASC']);

        if (null !== $accounts &&
            count($accounts) > 0) {
            $accountStack = [];

            foreach ($accounts as $account) {
                if (null !== $feed = $this->getFeedProvider($account)) {
                    $accountStack[] = $feed;
                }
            }
            return new MixedFeed($accountStack);
        }

        return null;
    }

    protected function getFeedProvider(NodesSources $account)
    {
        if ($account->getAccountId() == "") {
            return null;
        }

        switch ($account->getPlatform()) {
            case 'twitter':
                return new \RZ\MixedFeed\TwitterFeed(
                    $account->getAccountId(),
                    SettingsBag::get('twitter_consumer_key'),
                    SettingsBag::get('twitter_consumer_secret'),
                    SettingsBag::get('twitter_access_token'),
                    SettingsBag::get('twitter_access_token_secret'),
                    $this->getService('em')->getConfiguration()->getMetadataCacheImpl()
                );
                break;

            case 'facebook':
                return new \RZ\MixedFeed\FacebookPageFeed(
                    $account->getAccountId(),
                    SettingsBag::get('facebook_app_token'),
                    $this->getService('em')->getConfiguration()->getMetadataCacheImpl(),
                    ['full_picture']
                );
                break;

            case 'pinterest':
                return new \RZ\MixedFeed\PinterestBoardFeed(
                    $account->getAccountId(),
                    SettingsBag::get('pinterest_access_token'),
                    $this->getService('em')->getConfiguration()->getMetadataCacheImpl()
                );
                break;

            case 'instagram':
                return new \RZ\MixedFeed\InstagramFeed(
                    $account->getAccountId(),
                    SettingsBag::get('instagram_access_token'),
                    $this->getService('em')->getConfiguration()->getMetadataCacheImpl()
                );
                break;

            default:
                return null;
                break;
        }
    }

    public function ajaxAction(Request $request, $accountId, $_locale = 'fr')
    {
        $this->prepareNodeSourceAssignation(null, null);

        $translation = $this->bindLocaleFromRoute($request, $_locale);

        $source = $this->getService('nodeSourceApi')->getOneBy([
                'id' => $accountId,
                'node.nodeType' => $this->themeContainer['typeSocialFeed']
            ]);

        if (null === $source) {
            return $this->throw404();
        }

        $this->prepareNodeSourceAssignation($source, $source->getTranslation());

        $mixedFeed = $this->buildMixedFeed();

        $itemsCount = ($this->nodeSource->getItemsCount() > 0) ? $this->nodeSource->getItemsCount() : static::ITEMS;

        if (null !== $mixedFeed) {
            $socialItems = $mixedFeed->getItems($itemsCount);
            $this->assignation['socialItems'] = $socialItems;
        }

        return $this->render('render-blocks/mixedsocialfeed.html.twig', $this->assignation);
    }
}
