/**
 * Mixed Social Block
 */
var MixedSocialFeedBlock = function(id, type){

    AbstractBlock.call(this, id, type);
};

$.extend(MixedSocialFeedBlock.prototype, AbstractBlock.prototype);

/**
 * Init
 * @return {[type]} [description]
 */
MixedSocialFeedBlock.prototype.init = function(id, type){
    var _this = this;

    AbstractBlock.prototype.init.call(this, id, type);

    // console.log('-> MixedSocialFeedBlock init : '+id);

    _this.masonryActive = false;
    _this.$feedsCont = _this.$cont.find('.socials-container');
    _this.loadSocialFeeds(_this.$cont[0].getAttribute('data-ajax-url'));
};

/**
 * Load social feeds
 * @return {[type]} [description]
 */
MixedSocialFeedBlock.prototype.loadSocialFeeds = function(url){
    var _this = this;

    $.ajax({
        url: url,
        type: 'get',
        success: function(data) {
            // Append content
            _this.$feedsCont[0].innerHTML = data;
            _this.initMasonry();

        }
    });
};

MixedSocialFeedBlock.prototype.initMasonry = function() {
    var _this = this;

    _this.$socialCont = _this.$cont.find('.socials-container');
    var $blockWidth = $(_this.$cont.find('.social-block')[0]);

    _this.$itemLink = _this.$cont.find('.item-link');
    _this.$itemLink.on('click', $.proxy(_this.itemLinkClick, _this));

    if (_this.$socialCont.length &&
        Kiosque.windowSize.width > Kiosque.smLimit) {

        var loaded = 0;
        var $socialImages = _this.$socialCont.find('img');
        var socialImagesLength = $socialImages.length;

        $socialImages.one('load', function() {
            loaded++;
            if (loaded == socialImagesLength) {
                _this.$socialCont.masonry('layout');
                _this.masonryActive = true;
            }
        });

        _this.$socialCont.masonry({
            itemSelector: '.social-block',
            columnWidth: '.social-block',
        });
        _this.masonryActive = true;
    }
};

MixedSocialFeedBlock.prototype.updateMasonry = function() {
    var _this = this;

    if (typeof _this.$socialCont !== "undefined" && _this.$socialCont.length) {
        _this.$socialCont.masonry('layout');
        _this.masonryActive = true;
    }
};


/**
 * Item link click
 * @return {[type]} [description]
 */
MixedSocialFeedBlock.prototype.itemLinkClick = function(e){
    var _this = this;

    // Send analytics event
    if (typeof ga !== 'undefined'){

        ga('send', {
            hitType: 'event',
            eventCategory: 'Social link',
            eventAction: e.currentTarget.href,
            eventLabel: e.currentTarget.getAttribute('data-type')
        });
    }
};


/**
 * Resize
 */
MixedSocialFeedBlock.prototype.resize = function(){
    var _this = this;

    if (typeof _this.$socialCont !== "undefined" &&
        _this.$socialCont.length &&
        Kiosque.windowSize.width > Kiosque.smLimit) {

        if (_this.masonryActive === false) {
            _this.$socialCont.masonry({
                itemSelector: '.social-block',
                columnWidth: '.social-block',
            });
        }

        _this.$socialCont.masonry('layout');
        _this.masonryActive = true;

    } else if (typeof _this.$socialCont !== "undefined" &&
        _this.$socialCont.length &&
        _this.masonryActive === true &&
        Kiosque.windowSize.width <= Kiosque.smLimit) {

        _this.$socialCont.masonry('destroy');
        _this.masonryActive = false;
    }
};
