/**
 * Issue detail
 */
var IssueDetail = function($cont){
    var _this = this;

    _this.$cont = $cont;

    _this.init();
    _this.initEvents();
};

/**
 * Init
 * @return {[type]} [description]
 */
IssueDetail.prototype.init = function(){
    var _this = this;

    // console.log('-> IssueDetail init : '+id);

    _this.$image = _this.$cont.find('.issue-detail-image-cont');
    _this.$imageImg = _this.$image.find('img');
    _this.$navItem = _this.$cont.find('.issue-detail-nav-item');

    _this.$close = _this.$cont.find('.issue-detail-close');

    _this.imageCurrent = 0;
    _this.imageLoadLength = 0;
    _this.imageLength = _this.$image.length;

    _this.$cont[0].style.display = 'block';
    TweenLite.to(_this.$cont, 1, {opacity:1});

    _this.$cont.waitForImages({
        finished: $.proxy(_this.resize, _this),
        waitForAll: true
    });
};

/**
 * Destroy
 * @return {[type]} [description]
 */
IssueDetail.prototype.destroy = function(){
    var _this = this;

    _this.destroyEvents();
};

/**
 * Init events
 * @return {[type]} [description]
 */
IssueDetail.prototype.initEvents = function(){
    var _this = this;

    if(_this.$image.length > 1){
         _this.$navItem.on('click', $.proxy(_this.navItemClick, _this));
        _this.$image.on('click', $.proxy(_this.imageClick, _this));
    }
    _this.$close.on('click', $.proxy(_this.close, _this));
    Kiosque.$window.on('keyup', $.proxy(_this.onKeyUp, _this));

    Kiosque.$window.on('resize', debounce($.proxy(_this.resize, _this), 50, false));
};

/**
 * Destroy events
 * @return {[type]} [description]
 */
IssueDetail.prototype.destroyEvents = function(){
    var _this = this;

    if(_this.$image.length > 1){
         _this.$navItem.off('click', $.proxy(_this.navItemClick, _this));
        _this.$image.off('click', $.proxy(_this.imageClick, _this));
    }
    _this.$close.off('click', $.proxy(_this.close, _this));
    Kiosque.$window.off('keyup', $.proxy(_this.onKeyUp, _this));

};

/**
 * Nav image click
 * @return {[type]} [description]
 */
IssueDetail.prototype.navItemClick = function(e){
    var _this = this;

    var dir = (e.currentTarget.className.indexOf('prev') >= 0) ? 'left' : 'right';
    _this.switchImage(dir);

    e.preventDefault();
};

/**
 * Image click
 * @return {[type]} [description]
 */
IssueDetail.prototype.imageClick = function(e){
    var _this = this;

    _this.switchImage('right');

    e.preventDefault();
};

/**
 * On key up
 * @return {[type]} [description]
 */
IssueDetail.prototype.onKeyUp = function(e){
    var _this = this;

    if(e.keyCode == 27) _this.close();
    else if(e.keyCode == 37) _this.switchImage('left');
    else if(e.keyCode == 39) _this.switchImage('right');
};


/**
 * Switch image
 * @return {[type]} [description]
 */
IssueDetail.prototype.switchImage = function(dir){
    var _this = this;

    if(!_this.switchActive){

        _this.switchActive = true;

        var indexToGo,
            indexPrev = _this.imageCurrent;

        if(dir == 'left'){
            if(_this.imageCurrent > 0) indexToGo = _this.imageCurrent-1;
            else indexToGo = _this.imageLength-1;
        }
        else if(dir == 'right'){
            if(_this.imageCurrent < _this.imageLength-1) indexToGo = _this.imageCurrent+1;
            else indexToGo = 0;
        }

        // console.log('prev : '+_this.imageCurrent);
        // console.log('togo : '+indexToGo);

        addClass(_this.$image[indexToGo],'active');
        _this.$image[indexPrev].style.zIndex = '12';
        _this.$image[indexToGo].style.zIndex = '13';

        // Animate
        var toGoImageXFrom = (dir == 'right') ? Math.round(0.3 * Kiosque.windowSize.width) : -Math.round(0.3 * Kiosque.windowSize.width);

        TweenLite.to(_this.$image[indexPrev], 1.2, {opacity:0, x:-toGoImageXFrom});
        TweenLite.fromTo(_this.$image[indexToGo], 1.2, {opacity:0, x:toGoImageXFrom}, {opacity:1, x:0});

        // Update vars
        setTimeout(function(){

            _this.switchActive = false;
            removeClass(_this.$image[indexPrev],'active');
            _this.$image[indexPrev].style.zIndex = '';
            _this.$image[indexToGo].style.zIndex = '';
            _this.imageCurrent = indexToGo;
        }, 800);
    }
};


/**
 * Close
 * @return {[type]} [description]
 */
IssueDetail.prototype.close = function(){
    var _this = this;

    TweenLite.to(_this.$cont, 1, {opacity:0, onComplete:function(){
        _this.$cont[0].innerHTML = '';
        _this.$cont[0].style.display = 'none';
    }});

    _this.destroy();
};

/**
 * Resize
 * @return {[type]} [description]
 */
IssueDetail.prototype.resize = function(e){
    var _this = this;

    if(!isMediaMinSM()){

        for(var indexImage = 0; indexImage < _this.imageLength; indexImage++) {

            var imgHeight = $(_this.$imageImg[indexImage]).actual('outerHeight'),
                imgTop = Math.round( (0.5 * Kiosque.windowSize.height) - (0.5 * imgHeight) );

            _this.$image[indexImage].style.top = imgTop + 'px';
        }
    }
};
