<?php

use Symfony\Component\Routing\Exception\MethodNotAllowedException;
use Symfony\Component\Routing\Exception\ResourceNotFoundException;
use Symfony\Component\Routing\RequestContext;

/**
 * StaticUrlMatcher.
 *
 * This class has been auto-generated
 * by the Symfony Routing Component.
 */
class StaticUrlMatcher extends Symfony\Component\Routing\Matcher\UrlMatcher
{
    /**
     * Constructor.
     */
    public function __construct(RequestContext $context)
    {
        $this->context = $context;
    }

    public function match($pathinfo)
    {
        $allow = array();
        $pathinfo = rawurldecode($pathinfo);
        $context = $this->context;
        $request = $this->request;

        // rozierRemoveTrailingSlash
        if (preg_match('#^/(?P<url>.*/)$#s', $pathinfo, $matches)) {
            if (!in_array($this->context->getMethod(), array('GET', 'HEAD'))) {
                $allow = array_merge($allow, array('GET', 'HEAD'));
                goto not_rozierRemoveTrailingSlash;
            }

            return $this->mergeDefaults(array_replace($matches, array('_route' => 'rozierRemoveTrailingSlash')), array (  '_controller' => 'Themes\\Rozier\\RozierApp::removeTrailingSlashAction',));
        }
        not_rozierRemoveTrailingSlash:

        // adminHomePage
        if ($pathinfo === '/rz-admin') {
            return array (  '_controller' => 'Themes\\Rozier\\Controllers\\DashboardController::indexAction',  '_route' => 'adminHomePage',);
        }

        if (0 === strpos($pathinfo, '/login')) {
            // loginPage
            if ($pathinfo === '/login') {
                return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginController::indexAction',  '_route' => 'loginPage',);
            }

            if (0 === strpos($pathinfo, '/login/re')) {
                if (0 === strpos($pathinfo, '/login/request')) {
                    // loginRequestPage
                    if ($pathinfo === '/login/request') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginRequestController::indexAction',  '_route' => 'loginRequestPage',);
                    }

                    // loginRequestConfirmPage
                    if ($pathinfo === '/login/request/confirm') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginRequestController::confirmAction',  '_route' => 'loginRequestConfirmPage',);
                    }

                }

                if (0 === strpos($pathinfo, '/login/reset')) {
                    // loginResetConfirmPage
                    if ($pathinfo === '/login/reset/confirm') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginResetController::confirmAction',  '_route' => 'loginResetConfirmPage',);
                    }

                    // loginResetPage
                    if (preg_match('#^/login/reset/(?P<token>[^/]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'loginResetPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginResetController::resetAction',));
                    }

                }

            }

            // loginImagePage
            if ($pathinfo === '/login/image') {
                return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginController::imageAction',  '_route' => 'loginImagePage',);
            }

        }

        // logoutPage
        if ($pathinfo === '/rz-admin/logout') {
            return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginController::logoutAction',  '_route' => 'logoutPage',);
        }

        // loginFailedPage
        if ($pathinfo === '/login_failed') {
            return array (  '_controller' => 'Themes\\Rozier\\Controllers\\LoginController::indexAction',  '_route' => 'loginFailedPage',);
        }

        if (0 === strpos($pathinfo, '/rz-admin')) {
            // loginCheckPage
            if ($pathinfo === '/rz-admin/login_check') {
                return array('_route' => 'loginCheckPage');
            }

            // ajaxSessionMessages
            if ($pathinfo === '/rz-admin/session/messages') {
                return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxSessionMessages::getMessagesAction',  '_route' => 'ajaxSessionMessages',);
            }

            if (0 === strpos($pathinfo, '/rz-admin/cache/delete-')) {
                // deleteDoctrineCache
                if ($pathinfo === '/rz-admin/cache/delete-doctrine-cache') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\CacheController::deleteDoctrineCache',  '_route' => 'deleteDoctrineCache',);
                }

                // deleteAssetsCache
                if ($pathinfo === '/rz-admin/cache/delete-assets-cache') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\CacheController::deleteAssetsCache',  '_route' => 'deleteAssetsCache',);
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/nodes')) {
                // nodesHomePage
                if ($pathinfo === '/rz-admin/nodes') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::indexAction',  '_route' => 'nodesHomePage',);
                }

                // nodesHomeDraftPage
                if ($pathinfo === '/rz-admin/nodes/drafts') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::indexAction',  'filter' => 'draft',  '_route' => 'nodesHomeDraftPage',);
                }

                // nodesHomePendingPage
                if ($pathinfo === '/rz-admin/nodes/pending') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::indexAction',  'filter' => 'pending',  '_route' => 'nodesHomePendingPage',);
                }

                // nodesHomeArchivedPage
                if ($pathinfo === '/rz-admin/nodes/archived') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::indexAction',  'filter' => 'archived',  '_route' => 'nodesHomeArchivedPage',);
                }

                // nodesHomeDeletedPage
                if ($pathinfo === '/rz-admin/nodes/deleted') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::indexAction',  'filter' => 'deleted',  '_route' => 'nodesHomeDeletedPage',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/nodes/edit')) {
                    // nodesEditPage
                    if (preg_match('#^/rz\\-admin/nodes/edit/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::editAction',));
                    }

                    // nodesTranstypePage
                    if (preg_match('#^/rz\\-admin/nodes/edit/(?P<nodeId>[0-9]+)/transtype$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesTranstypePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\TranstypeController::transtypeAction',));
                    }

                    // nodesEditSourcePage
                    if (preg_match('#^/rz\\-admin/nodes/edit/(?P<nodeId>[0-9]+)/source/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesEditSourcePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesSourcesController::editSourceAction',));
                    }

                }

                // nodesDeleteSourcePage
                if (0 === strpos($pathinfo, '/rz-admin/nodes/source/delete') && preg_match('#^/rz\\-admin/nodes/source/delete/(?P<nodeSourceId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesDeleteSourcePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesSourcesController::removeAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/nodes/edit')) {
                    // nodesEditTagsPage
                    if (preg_match('#^/rz\\-admin/nodes/edit/(?P<nodeId>[0-9]+)/tags$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesEditTagsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesTagsController::editTagsAction',));
                    }

                    // nodesRemoveTagsPage
                    if (preg_match('#^/rz\\-admin/nodes/edit/(?P<nodeId>[0-9]+)/tags/(?P<tagId>[0-9]+)/remove$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesRemoveTagsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesTagsController::removeTagAction',));
                    }

                    // nodesEditSEOPage
                    if (preg_match('#^/rz\\-admin/nodes/edit/(?P<nodeId>[0-9]+)/seo/(?P<translationId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesEditSEOPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\UrlAliasesController::editAliasesAction',));
                    }

                }

                // nodesTreePage
                if (0 === strpos($pathinfo, '/rz-admin/nodes/tree') && preg_match('#^/rz\\-admin/nodes/tree/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesTreePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesTreesController::treeAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/nodes/bulk-')) {
                    // nodesBulkDeletePage
                    if ($pathinfo === '/rz-admin/nodes/bulk-delete') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesTreesController::bulkDeleteAction',  '_route' => 'nodesBulkDeletePage',);
                    }

                    // nodesBulkStatusPage
                    if ($pathinfo === '/rz-admin/nodes/bulk-status') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesTreesController::bulkStatusAction',  '_route' => 'nodesBulkStatusPage',);
                    }

                }

                if (0 === strpos($pathinfo, '/rz-admin/nodes/add')) {
                    // nodesAddPage
                    if (preg_match('#^/rz\\-admin/nodes/add/(?P<nodeTypeId>[0-9]+)/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesAddPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::addAction',));
                    }

                    // nodesAddChildPage
                    if (0 === strpos($pathinfo, '/rz-admin/nodes/add-child') && preg_match('#^/rz\\-admin/nodes/add\\-child(?:/(?P<nodeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesAddChildPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::addChildAction',  'nodeId' => NULL,));
                    }

                }

                // nodesDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/nodes/delete') && preg_match('#^/rz\\-admin/nodes/delete/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::deleteAction',));
                }

                // nodesUndeletePage
                if (0 === strpos($pathinfo, '/rz-admin/nodes/undelete') && preg_match('#^/rz\\-admin/nodes/undelete/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesUndeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::undeleteAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/nodes/export')) {
                    // nodesExportPage
                    if (preg_match('#^/rz\\-admin/nodes/export/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesUtilsController::exportAction',));
                    }

                    // nodesExportAllPage
                    if ($pathinfo === '/rz-admin/nodes/export') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesUtilsController::exportAllAction',  '_route' => 'nodesExportAllPage',);
                    }

                    // nodesExportAllXlsxPage
                    if (0 === strpos($pathinfo, '/rz-admin/nodes/export/xlsx') && preg_match('#^/rz\\-admin/nodes/export/xlsx/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesExportAllXlsxPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\ExportController::exportAllXlsxAction',));
                    }

                }

                // nodesDuplicatePage
                if (0 === strpos($pathinfo, '/rz-admin/nodes/duplicate') && preg_match('#^/rz\\-admin/nodes/duplicate/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesDuplicatePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesUtilsController::duplicateAction',));
                }

                // nodesEmptyTrashPage
                if ($pathinfo === '/rz-admin/nodes/empty-trash') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::emptyTrashAction',  '_route' => 'nodesEmptyTrashPage',);
                }

                // nodesGenerateAndAddNodeAction
                if ($pathinfo === '/rz-admin/nodes/create') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::generateAndAddNodeAction',  '_route' => 'nodesGenerateAndAddNodeAction',);
                }

                // nodesPublishAllAction
                if (0 === strpos($pathinfo, '/rz-admin/nodes/publish-all') && preg_match('#^/rz\\-admin/nodes/publish\\-all/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesPublishAllAction')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Nodes\\NodesController::publishAllAction',));
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/ajax')) {
                if (0 === strpos($pathinfo, '/rz-admin/ajax/node')) {
                    // nodeAjaxTags
                    if (0 === strpos($pathinfo, '/rz-admin/ajax/node/tags') && preg_match('#^/rz\\-admin/ajax/node/tags/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeAjaxTags')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodesController::getTagsAction',));
                    }

                    // nodeAjaxEdit
                    if (0 === strpos($pathinfo, '/rz-admin/ajax/node/edit') && preg_match('#^/rz\\-admin/ajax/node/edit/(?P<nodeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeAjaxEdit')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodesController::editAction',));
                    }

                    if (0 === strpos($pathinfo, '/rz-admin/ajax/nodes')) {
                        // searchNodesSourcesAjax
                        if ($pathinfo === '/rz-admin/ajax/nodes-sources/search') {
                            return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxSearchNodesSourcesController::searchAction',  '_route' => 'searchNodesSourcesAjax',);
                        }

                        // nodesStatusesAjax
                        if ($pathinfo === '/rz-admin/ajax/nodes/statuses') {
                            return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodesController::statusesAction',  '_route' => 'nodesStatusesAjax',);
                        }

                        // nodesTreeAjax
                        if (0 === strpos($pathinfo, '/rz-admin/ajax/nodes/tree') && preg_match('#^/rz\\-admin/ajax/nodes/tree(?:/(?P<translationId>[0-9]+))?$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesTreeAjax')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodeTreeController::getTreeAction',  'translationId' => NULL,));
                        }

                        // nodesQuickAddAjax
                        if ($pathinfo === '/rz-admin/ajax/nodes/add') {
                            return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodesController::quickAddAction',  '_route' => 'nodesQuickAddAjax',);
                        }

                        // nodesAjaxExplorerPage
                        if ($pathinfo === '/rz-admin/ajax/nodes/explore') {
                            return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodesExplorerController::indexAction',  '_route' => 'nodesAjaxExplorerPage',);
                        }

                    }

                    // nodeTypesFieldAjaxEdit
                    if (0 === strpos($pathinfo, '/rz-admin/ajax/node-types/fields/edit') && preg_match('#^/rz\\-admin/ajax/node\\-types/fields/edit/(?P<nodeTypeFieldId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypesFieldAjaxEdit')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxNodeTypeFieldsController::editAction',));
                    }

                }

                // documentsAjaxExplorerPage
                if ($pathinfo === '/rz-admin/ajax/documents/explore') {
                    return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxDocumentsExplorerController::indexAction',  '_route' => 'documentsAjaxExplorerPage',);
                }

                // foldersAjaxExplorerPage
                if ($pathinfo === '/rz-admin/ajax/folders/explore') {
                    return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxFoldersExplorerController::indexAction',  '_route' => 'foldersAjaxExplorerPage',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/ajax/tag')) {
                    // tagAjaxEdit
                    if (0 === strpos($pathinfo, '/rz-admin/ajax/tag/edit') && preg_match('#^/rz\\-admin/ajax/tag/edit/(?P<tagId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagAjaxEdit')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxTagsController::editAction',));
                    }

                    // tagAjaxSearch
                    if ($pathinfo === '/rz-admin/ajax/tag/search') {
                        return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxTagsController::searchAction',  '_route' => 'tagAjaxSearch',);
                    }

                }

                if (0 === strpos($pathinfo, '/rz-admin/ajax/folder')) {
                    // foldersAjaxEdit
                    if (0 === strpos($pathinfo, '/rz-admin/ajax/folder/edit') && preg_match('#^/rz\\-admin/ajax/folder/edit/(?P<folderId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'foldersAjaxEdit')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxFoldersController::editAction',));
                    }

                    // foldersAjaxSearch
                    if ($pathinfo === '/rz-admin/ajax/folder/search') {
                        return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxFoldersController::searchAction',  '_route' => 'foldersAjaxSearch',);
                    }

                }

                // customFormFieldAjaxEdit
                if (0 === strpos($pathinfo, '/rz-admin/ajax/custom-forms/fields/edit') && preg_match('#^/rz\\-admin/ajax/custom\\-forms/fields/edit/(?P<customFormFieldId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormFieldAjaxEdit')), array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxCustomFormFieldsController::editAction',));
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/node-types')) {
                // nodeTypesHomePage
                if ($pathinfo === '/rz-admin/node-types') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypes\\NodeTypesController::indexAction',  '_route' => 'nodeTypesHomePage',);
                }

                // nodeTypesEditPage
                if (0 === strpos($pathinfo, '/rz-admin/node-types/edit') && preg_match('#^/rz\\-admin/node\\-types/edit/(?P<nodeTypeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypesEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypes\\NodeTypesController::editAction',));
                }

                // nodeTypesAddPage
                if ($pathinfo === '/rz-admin/node-types/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypes\\NodeTypesController::addAction',  '_route' => 'nodeTypesAddPage',);
                }

                // nodeTypesImportPage
                if ($pathinfo === '/rz-admin/node-types/import') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypes\\NodeTypesUtilsController::importJsonFileAction',  '_route' => 'nodeTypesImportPage',);
                }

                // nodeTypesDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/node-types/delete') && preg_match('#^/rz\\-admin/node\\-types/delete/(?P<nodeTypeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypesDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypes\\NodeTypesController::deleteAction',));
                }

                // nodesTypesExportPage
                if (0 === strpos($pathinfo, '/rz-admin/node-types/export') && preg_match('#^/rz\\-admin/node\\-types/export/(?P<nodeTypeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodesTypesExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypes\\NodeTypesUtilsController::exportJsonFileAction',));
                }

                // nodeTypesSchemaUpdate
                if (0 === strpos($pathinfo, '/rz-admin/node-types/update-schema') && preg_match('#^/rz\\-admin/node\\-types/update\\-schema/(?P<_token>[A-z0-9\\- \\$]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypesSchemaUpdate')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SchemaController::updateNodeTypesSchemaAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/node-types/fields')) {
                    // nodeTypeFieldsListPage
                    if (preg_match('#^/rz\\-admin/node\\-types/fields/(?P<nodeTypeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypeFieldsListPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypeFieldsController::listAction',));
                    }

                    // nodeTypeFieldsEditPage
                    if (0 === strpos($pathinfo, '/rz-admin/node-types/fields/edit') && preg_match('#^/rz\\-admin/node\\-types/fields/edit/(?P<nodeTypeFieldId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypeFieldsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypeFieldsController::editAction',));
                    }

                    // nodeTypeFieldsAddPage
                    if (0 === strpos($pathinfo, '/rz-admin/node-types/fields/add') && preg_match('#^/rz\\-admin/node\\-types/fields/add/(?P<nodeTypeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypeFieldsAddPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypeFieldsController::addAction',));
                    }

                    // nodeTypeFieldsDeletePage
                    if (0 === strpos($pathinfo, '/rz-admin/node-types/fields/delete') && preg_match('#^/rz\\-admin/node\\-types/fields/delete/(?P<nodeTypeFieldId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypeFieldsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NodeTypeFieldsController::deleteAction',));
                    }

                    // nodeTypesFieldSchemaUpdate
                    if (0 === strpos($pathinfo, '/rz-admin/node-types/fields/update-schema') && preg_match('#^/rz\\-admin/node\\-types/fields/update\\-schema/(?P<nodeTypeId>[0-9]+)/(?P<_token>[A-z0-9\\- \\$]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'nodeTypesFieldSchemaUpdate')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SchemaController::updateNodeTypeFieldsSchemaAction',));
                    }

                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/setting')) {
                if (0 === strpos($pathinfo, '/rz-admin/settings')) {
                    // settingsHomePage
                    if ($pathinfo === '/rz-admin/settings') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsController::indexAction',  '_route' => 'settingsHomePage',);
                    }

                    // settingsEditPage
                    if (0 === strpos($pathinfo, '/rz-admin/settings/edit') && preg_match('#^/rz\\-admin/settings/edit/(?P<settingId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'settingsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsController::editAction',));
                    }

                    // settingsAddPage
                    if ($pathinfo === '/rz-admin/settings/add') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsController::addAction',  '_route' => 'settingsAddPage',);
                    }

                    // settingsDeletePage
                    if (0 === strpos($pathinfo, '/rz-admin/settings/delete') && preg_match('#^/rz\\-admin/settings/delete/(?P<settingId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'settingsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsController::deleteAction',));
                    }

                    // settingsExportAllPage
                    if ($pathinfo === '/rz-admin/settings/export') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsUtilsController::exportAllAction',  '_route' => 'settingsExportAllPage',);
                    }

                    // settingsImportPage
                    if ($pathinfo === '/rz-admin/settings/import') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsUtilsController::importJsonFileAction',  '_route' => 'settingsImportPage',);
                    }

                }

                if (0 === strpos($pathinfo, '/rz-admin/setting-groups')) {
                    // settingGroupsHomePage
                    if ($pathinfo === '/rz-admin/setting-groups') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingGroupsController::indexAction',  '_route' => 'settingGroupsHomePage',);
                    }

                    // settingGroupsSettingsPage
                    if (0 === strpos($pathinfo, '/rz-admin/setting-groups/settings') && preg_match('#^/rz\\-admin/setting\\-groups/settings/(?P<settingGroupId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'settingGroupsSettingsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingsController::byGroupAction',));
                    }

                    // settingGroupsEditPage
                    if (0 === strpos($pathinfo, '/rz-admin/setting-groups/edit') && preg_match('#^/rz\\-admin/setting\\-groups/edit/(?P<settingGroupId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'settingGroupsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingGroupsController::editAction',));
                    }

                    // settingGroupsAddPage
                    if ($pathinfo === '/rz-admin/setting-groups/add') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingGroupsController::addAction',  '_route' => 'settingGroupsAddPage',);
                    }

                    // settingGroupsDeletePage
                    if (0 === strpos($pathinfo, '/rz-admin/setting-groups/delete') && preg_match('#^/rz\\-admin/setting\\-groups/delete/(?P<settingGroupId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'settingGroupsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SettingGroupsController::deleteAction',));
                    }

                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/tags')) {
                // tagsHomePage
                if ($pathinfo === '/rz-admin/tags') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::indexAction',  '_route' => 'tagsHomePage',);
                }

                // tagsEditNodesPage
                if (0 === strpos($pathinfo, '/rz-admin/tags/edit') && preg_match('#^/rz\\-admin/tags/edit/(?P<tagId>[0-9]+)/nodes$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsEditNodesPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::editNodesAction',));
                }

                // tagsTreePage
                if (0 === strpos($pathinfo, '/rz-admin/tags/tree') && preg_match('#^/rz\\-admin/tags/tree/(?P<tagId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsTreePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::treeAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/tags/edit')) {
                    // tagsEditPage
                    if (preg_match('#^/rz\\-admin/tags/edit/(?P<tagId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::editTranslatedAction',));
                    }

                    // tagsSettingsPage
                    if (preg_match('#^/rz\\-admin/tags/edit/(?P<tagId>[0-9]+)/settings$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsSettingsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::editSettingsAction',));
                    }

                    // tagsEditTranslatedPage
                    if (preg_match('#^/rz\\-admin/tags/edit/(?P<tagId>[0-9]+)/translation/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsEditTranslatedPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::editTranslatedAction',));
                    }

                }

                if (0 === strpos($pathinfo, '/rz-admin/tags/add')) {
                    // tagsAddPage
                    if ($pathinfo === '/rz-admin/tags/add') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::addAction',  '_route' => 'tagsAddPage',);
                    }

                    if (0 === strpos($pathinfo, '/rz-admin/tags/add-')) {
                        // tagsAddChildPage
                        if (0 === strpos($pathinfo, '/rz-admin/tags/add-child') && preg_match('#^/rz\\-admin/tags/add\\-child/(?P<tagId>[0-9]+)$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsAddChildPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::addChildAction',));
                        }

                        // tagsAddMultipleChildPage
                        if (0 === strpos($pathinfo, '/rz-admin/tags/add-multiple-child') && preg_match('#^/rz\\-admin/tags/add\\-multiple\\-child/(?P<parentTagId>[0-9]+)$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsAddMultipleChildPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagMultiCreationController::addChildAction',));
                        }

                    }

                }

                // tagsDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/tags/delete') && preg_match('#^/rz\\-admin/tags/delete/(?P<tagId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::deleteAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/tags/export')) {
                    // tagsExportPage
                    if (preg_match('#^/rz\\-admin/tags/export/(?P<tagId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'tagsExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsUtilsController::exportAction',));
                    }

                    // tagsExportAllPage
                    if ($pathinfo === '/rz-admin/tags/export') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsUtilsController::exportAction',  '_route' => 'tagsExportAllPage',);
                    }

                }

                // tagsBulkDeletePage
                if ($pathinfo === '/rz-admin/tags/bulk-delete') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Tags\\TagsController::bulkDeleteAction',  '_route' => 'tagsBulkDeletePage',);
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/users')) {
                // usersHomePage
                if ($pathinfo === '/rz-admin/users') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersController::indexAction',  '_route' => 'usersHomePage',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/users/edit')) {
                    // usersEditPage
                    if (preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersController::editAction',));
                    }

                    // usersEditDetailsPage
                    if (preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)/details$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersEditDetailsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersController::editDetailsAction',));
                    }

                    // usersEditRolesPage
                    if (preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)/roles$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersEditRolesPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersRolesController::editRolesAction',));
                    }

                    // usersRemoveRolesPage
                    if (preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)/roles/(?P<roleId>[0-9]+)/remove$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersRemoveRolesPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersRolesController::removeRoleAction',));
                    }

                    // usersEditGroupsPage
                    if (preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)/groups$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersEditGroupsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersGroupsController::editGroupsAction',));
                    }

                    // usersRemoveGroupsPage
                    if (preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)/groups/(?P<groupId>[0-9]+)/remove$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersRemoveGroupsPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersGroupsController::removeGroupAction',));
                    }

                }

                // usersAddPage
                if ($pathinfo === '/rz-admin/users/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersController::addAction',  '_route' => 'usersAddPage',);
                }

                // usersDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/users/delete') && preg_match('#^/rz\\-admin/users/delete/(?P<userId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersController::deleteAction',));
                }

                // usersSecurityPage
                if (0 === strpos($pathinfo, '/rz-admin/users/edit') && preg_match('#^/rz\\-admin/users/edit/(?P<userId>[0-9]+)/security$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'usersSecurityPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\Users\\UsersSecurityController::securityAction',));
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/fo')) {
                if (0 === strpos($pathinfo, '/rz-admin/fonts')) {
                    // fontsHomePage
                    if ($pathinfo === '/rz-admin/fonts') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\FontsController::indexAction',  '_route' => 'fontsHomePage',);
                    }

                    // fontsEditPage
                    if (0 === strpos($pathinfo, '/rz-admin/fonts/edit') && preg_match('#^/rz\\-admin/fonts/edit/(?P<fontId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'fontsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FontsController::editAction',));
                    }

                    // fontsDownloadPage
                    if (0 === strpos($pathinfo, '/rz-admin/fonts/download') && preg_match('#^/rz\\-admin/fonts/download/(?P<fontId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'fontsDownloadPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FontsController::downloadAction',));
                    }

                    // fontsAddPage
                    if ($pathinfo === '/rz-admin/fonts/add') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\FontsController::addAction',  '_route' => 'fontsAddPage',);
                    }

                    // fontsDeletePage
                    if (0 === strpos($pathinfo, '/rz-admin/fonts/delete') && preg_match('#^/rz\\-admin/fonts/delete/(?P<fontId>[^/]++)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'fontsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FontsController::deleteAction',));
                    }

                }

                if (0 === strpos($pathinfo, '/rz-admin/folders')) {
                    // foldersHomePage
                    if ($pathinfo === '/rz-admin/folders') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\FoldersController::indexAction',  '_route' => 'foldersHomePage',);
                    }

                    // foldersEditPage
                    if (0 === strpos($pathinfo, '/rz-admin/folders/edit') && preg_match('#^/rz\\-admin/folders/edit/(?P<folderId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'foldersEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FoldersController::editAction',));
                    }

                    if (0 === strpos($pathinfo, '/rz-admin/folders/d')) {
                        // foldersDownloadPage
                        if (0 === strpos($pathinfo, '/rz-admin/folders/download') && preg_match('#^/rz\\-admin/folders/download/(?P<folderId>[0-9]+)$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'foldersDownloadPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FoldersController::downloadAction',));
                        }

                        // foldersDeletePage
                        if (0 === strpos($pathinfo, '/rz-admin/folders/delete') && preg_match('#^/rz\\-admin/folders/delete/(?P<folderId>[0-9]+)$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'foldersDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FoldersController::deleteAction',));
                        }

                    }

                    // foldersAddPage
                    if (0 === strpos($pathinfo, '/rz-admin/folders/add') && preg_match('#^/rz\\-admin/folders/add(?:/(?P<parentFolderId>[0-9]+))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'foldersAddPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FoldersController::addAction',  'parentFolderId' => NULL,));
                    }

                    // foldersExportPage
                    if (0 === strpos($pathinfo, '/rz-admin/folders/export') && preg_match('#^/rz\\-admin/folders/export/(?P<folderId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'foldersExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\FoldersController::exportAction',));
                    }

                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/translations')) {
                // translationsHomePage
                if ($pathinfo === '/rz-admin/translations') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\TranslationsController::indexAction',  '_route' => 'translationsHomePage',);
                }

                // translationsEditPage
                if (0 === strpos($pathinfo, '/rz-admin/translations/edit') && preg_match('#^/rz\\-admin/translations/edit/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'translationsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\TranslationsController::editAction',));
                }

                // translationsSetDefaultPage
                if (0 === strpos($pathinfo, '/rz-admin/translations/set-default') && preg_match('#^/rz\\-admin/translations/set\\-default/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'translationsSetDefaultPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\TranslationsController::setDefaultAction',));
                }

                // translationsAddPage
                if ($pathinfo === '/rz-admin/translations/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\TranslationsController::addAction',  '_route' => 'translationsAddPage',);
                }

                // translationsDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/translations/delete') && preg_match('#^/rz\\-admin/translations/delete/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'translationsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\TranslationsController::deleteAction',));
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/documents')) {
                // documentsHomePage
                if (preg_match('#^/rz\\-admin/documents(?:/(?P<folderId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsHomePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::indexAction',  'folderId' => NULL,));
                }

                // documentsEditPage
                if (0 === strpos($pathinfo, '/rz-admin/documents/edit') && preg_match('#^/rz\\-admin/documents/edit/(?P<documentId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::editAction',));
                }

                // documentsMetaPage
                if (0 === strpos($pathinfo, '/rz-admin/documents/meta') && preg_match('#^/rz\\-admin/documents/meta/(?P<documentId>[0-9]+)(?:/(?P<translationId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsMetaPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentTranslationsController::editAction',  'translationId' => NULL,));
                }

                // documentsPreviewPage
                if (0 === strpos($pathinfo, '/rz-admin/documents/preview') && preg_match('#^/rz\\-admin/documents/preview/(?P<documentId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsPreviewPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::previewAction',));
                }

                // documentsDownloadPage
                if (0 === strpos($pathinfo, '/rz-admin/documents/download') && preg_match('#^/rz\\-admin/documents/download/(?P<documentId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsDownloadPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::downloadAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/documents/u')) {
                    // documentsUsagePage
                    if (0 === strpos($pathinfo, '/rz-admin/documents/usage') && preg_match('#^/rz\\-admin/documents/usage/(?P<documentId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsUsagePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::usageAction',));
                    }

                    // documentsUploadPage
                    if (0 === strpos($pathinfo, '/rz-admin/documents/upload') && preg_match('#^/rz\\-admin/documents/upload(?:/(?P<folderId>[0-9]+))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsUploadPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::uploadAction',  'folderId' => NULL,));
                    }

                }

                // documentsRandomPage
                if (0 === strpos($pathinfo, '/rz-admin/documents/random') && preg_match('#^/rz\\-admin/documents/random(?:/(?P<folderId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsRandomPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::randomAction',  'folderId' => NULL,));
                }

                // documentsEmbedPage
                if (0 === strpos($pathinfo, '/rz-admin/documents/embed') && preg_match('#^/rz\\-admin/documents/embed(?:/(?P<folderId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsEmbedPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::embedAction',  'folderId' => NULL,));
                }

                // documentsDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/documents/delete') && preg_match('#^/rz\\-admin/documents/delete/(?P<documentId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'documentsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::deleteAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/documents/bulk-d')) {
                    // documentsBulkDeletePage
                    if ($pathinfo === '/rz-admin/documents/bulk-delete') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::bulkDeleteAction',  '_route' => 'documentsBulkDeletePage',);
                    }

                    // documentsBulkDownloadPage
                    if ($pathinfo === '/rz-admin/documents/bulk-download') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::bulkDownloadAction',  '_route' => 'documentsBulkDownloadPage',);
                    }

                }

                // documentsUnusedPage
                if ($pathinfo === '/rz-admin/documents/orphans') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\DocumentsController::unusedAction',  '_route' => 'documentsUnusedPage',);
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/themes')) {
                // themesHomePage
                if ($pathinfo === '/rz-admin/themes') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::indexAction',  '_route' => 'themesHomePage',);
                }

                // themesEditPage
                if (0 === strpos($pathinfo, '/rz-admin/themes/edit') && preg_match('#^/rz\\-admin/themes/edit/(?P<themeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::editAction',));
                }

                // themesAddPage
                if ($pathinfo === '/rz-admin/themes/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::addAction',  '_route' => 'themesAddPage',);
                }

                // themesDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/themes/delete') && preg_match('#^/rz\\-admin/themes/delete/(?P<themeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::deleteAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/themes/s')) {
                    // themesSummaryPage
                    if ($pathinfo === '/rz-admin/themes/summary') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::summaryAction',  '_route' => 'themesSummaryPage',);
                    }

                    // themesSettingPage
                    if ($pathinfo === '/rz-admin/themes/setting') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::settingAction',  '_route' => 'themesSettingPage',);
                    }

                }

                // themesImportPage
                if (0 === strpos($pathinfo, '/rz-admin/themes/import') && preg_match('#^/rz\\-admin/themes/import/(?P<id>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::importAction',));
                }

                // themesClearCacheSchema
                if ($pathinfo === '/rz-admin/themes/clear-cache') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::clearDoctrineCacheAction',  '_route' => 'themesClearCacheSchema',);
                }

                // themesUpdateSchema
                if ($pathinfo === '/rz-admin/themes/update') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesController::updateSchemaAction',  '_route' => 'themesUpdateSchema',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/themes/import')) {
                    // themesImportSettings
                    if (0 === strpos($pathinfo, '/rz-admin/themes/import/settings') && preg_match('#^/rz\\-admin/themes/import/settings(?:/(?P<themeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportSettings')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesImportController::importSettingsAction',  'themeId' => NULL,));
                    }

                    // themesImportGroups
                    if (0 === strpos($pathinfo, '/rz-admin/themes/import/groups') && preg_match('#^/rz\\-admin/themes/import/groups(?:/(?P<themeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportGroups')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesImportController::importGroupsAction',  'themeId' => NULL,));
                    }

                    // themesImportRoles
                    if (0 === strpos($pathinfo, '/rz-admin/themes/import/roles') && preg_match('#^/rz\\-admin/themes/import/roles(?:/(?P<themeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportRoles')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesImportController::importRolesAction',  'themeId' => NULL,));
                    }

                    if (0 === strpos($pathinfo, '/rz-admin/themes/import/node')) {
                        // themesImportNodes
                        if (0 === strpos($pathinfo, '/rz-admin/themes/import/nodes') && preg_match('#^/rz\\-admin/themes/import/nodes(?:/(?P<themeId>[^/]++))?$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportNodes')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesImportController::importNodesAction',  'themeId' => NULL,));
                        }

                        // themesImportNodeTypes
                        if (0 === strpos($pathinfo, '/rz-admin/themes/import/nodetypes') && preg_match('#^/rz\\-admin/themes/import/nodetypes/(?P<themeId>[0-9]+)$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportNodeTypes')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesImportController::importNodeTypesAction',));
                        }

                    }

                    // themesImportTags
                    if (0 === strpos($pathinfo, '/rz-admin/themes/import/tags') && preg_match('#^/rz\\-admin/themes/import/tags/(?P<themeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'themesImportTags')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\ThemesImportController::importTagsAction',));
                    }

                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/roles')) {
                // rolesHomePage
                if ($pathinfo === '/rz-admin/roles') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesController::indexAction',  '_route' => 'rolesHomePage',);
                }

                // rolesEditPage
                if (0 === strpos($pathinfo, '/rz-admin/roles/edit') && preg_match('#^/rz\\-admin/roles/edit/(?P<roleId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'rolesEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesController::editAction',));
                }

                // rolesAddPage
                if ($pathinfo === '/rz-admin/roles/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesController::addAction',  '_route' => 'rolesAddPage',);
                }

                // rolesDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/roles/delete') && preg_match('#^/rz\\-admin/roles/delete/(?P<roleId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'rolesDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesController::deleteAction',));
                }

                if (0 === strpos($pathinfo, '/rz-admin/roles/export')) {
                    // rolesExportAllPage
                    if ($pathinfo === '/rz-admin/roles/export') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesUtilsController::exportAllAction',  '_route' => 'rolesExportAllPage',);
                    }

                    // rolesExportPage
                    if (preg_match('#^/rz\\-admin/roles/export/(?P<roleId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'rolesExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesUtilsController::exportAction',));
                    }

                }

                // rolesImportPage
                if ($pathinfo === '/rz-admin/roles/import') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\RolesUtilsController::importJsonFileAction',  '_route' => 'rolesImportPage',);
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/groups')) {
                // groupsHomePage
                if ($pathinfo === '/rz-admin/groups') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::indexAction',  '_route' => 'groupsHomePage',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/groups/edit')) {
                    // groupsEditPage
                    if (preg_match('#^/rz\\-admin/groups/edit/(?P<groupId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::editAction',));
                    }

                    // groupsEditRolesPage
                    if (preg_match('#^/rz\\-admin/groups/edit/(?P<groupId>[0-9]+)/roles$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsEditRolesPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::editRolesAction',));
                    }

                    // groupsRemoveRolesPage
                    if (preg_match('#^/rz\\-admin/groups/edit/(?P<groupId>[0-9]+)/roles/(?P<roleId>[0-9]+)/remove$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsRemoveRolesPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::removeRolesAction',));
                    }

                }

                // groupsAddPage
                if ($pathinfo === '/rz-admin/groups/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::addAction',  '_route' => 'groupsAddPage',);
                }

                // groupsDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/groups/delete') && preg_match('#^/rz\\-admin/groups/delete/(?P<groupId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::deleteAction',));
                }

                // groupsImportPage
                if ($pathinfo === '/rz-admin/groups/import') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsUtilsController::importJsonFileAction',  '_route' => 'groupsImportPage',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/groups/e')) {
                    if (0 === strpos($pathinfo, '/rz-admin/groups/edit')) {
                        // groupsEditUsersPage
                        if (preg_match('#^/rz\\-admin/groups/edit/(?P<groupId>[0-9]+)/users$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsEditUsersPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::editUsersAction',));
                        }

                        // groupsRemoveUsersPage
                        if (preg_match('#^/rz\\-admin/groups/edit/(?P<groupId>[0-9]+)/users/(?P<userId>[0-9]+)/remove$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsRemoveUsersPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsController::removeUsersAction',));
                        }

                    }

                    if (0 === strpos($pathinfo, '/rz-admin/groups/export')) {
                        // groupsExportAllPage
                        if ($pathinfo === '/rz-admin/groups/export') {
                            return array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsUtilsController::exportAllAction',  '_route' => 'groupsExportAllPage',);
                        }

                        // groupsExportPage
                        if (preg_match('#^/rz\\-admin/groups/export/(?P<groupId>[0-9]+)$#s', $pathinfo, $matches)) {
                            return $this->mergeDefaults(array_replace($matches, array('_route' => 'groupsExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\GroupsUtilsController::exportAction',));
                        }

                    }

                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/history')) {
                // historyHomePage
                if ($pathinfo === '/rz-admin/history') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\HistoryController::indexAction',  '_route' => 'historyHomePage',);
                }

                // historyUserPage
                if (0 === strpos($pathinfo, '/rz-admin/history/user') && preg_match('#^/rz\\-admin/history/user/(?P<userId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'historyUserPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\HistoryController::userAction',));
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/custom-forms')) {
                // customFormsHomePage
                if ($pathinfo === '/rz-admin/custom-forms') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormsController::indexAction',  '_route' => 'customFormsHomePage',);
                }

                // customFormsEditPage
                if (0 === strpos($pathinfo, '/rz-admin/custom-forms/edit') && preg_match('#^/rz\\-admin/custom\\-forms/edit/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormsController::editAction',));
                }

                // customFormsAddPage
                if ($pathinfo === '/rz-admin/custom-forms/add') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormsController::addAction',  '_route' => 'customFormsAddPage',);
                }

                // customFormsDeletePage
                if (0 === strpos($pathinfo, '/rz-admin/custom-forms/delete') && preg_match('#^/rz\\-admin/custom\\-forms/delete/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormsController::deleteAction',));
                }

                // customFormsExportPage
                if (0 === strpos($pathinfo, '/rz-admin/custom-forms/export') && preg_match('#^/rz\\-admin/custom\\-forms/export/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormsExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormsUtilsController::exportAction',));
                }

                // customFormsDuplicatePage
                if (0 === strpos($pathinfo, '/rz-admin/custom-forms/duplicate') && preg_match('#^/rz\\-admin/custom\\-forms/duplicate/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormsDuplicatePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormsUtilsController::duplicateAction',));
                }

            }

            // customFormsAjaxExplorerPage
            if ($pathinfo === '/rz-admin/ajax/custom-forms/explore') {
                return array (  '_controller' => 'Themes\\Rozier\\AjaxControllers\\AjaxCustomFormsExplorerController::indexAction',  '_route' => 'customFormsAjaxExplorerPage',);
            }

            if (0 === strpos($pathinfo, '/rz-admin/custom-form')) {
                if (0 === strpos($pathinfo, '/rz-admin/custom-form-answers')) {
                    // customFormAnswersHomePage
                    if (preg_match('#^/rz\\-admin/custom\\-form\\-answers/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormAnswersHomePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormAnswersController::listAction',));
                    }

                    // customFormAnswersDeletePage
                    if (0 === strpos($pathinfo, '/rz-admin/custom-form-answers/delete') && preg_match('#^/rz\\-admin/custom\\-form\\-answers/delete/(?P<customFormAnswerId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormAnswersDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormAnswersController::deleteAction',));
                    }

                    // customFormFieldAttributesHomePage
                    if (0 === strpos($pathinfo, '/rz-admin/custom-form-answers/fields') && preg_match('#^/rz\\-admin/custom\\-form\\-answers/fields/(?P<customFormAnswerId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormFieldAttributesHomePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormFieldAttributesController::listAction',));
                    }

                }

                if (0 === strpos($pathinfo, '/rz-admin/custom-forms/fields')) {
                    // customFormFieldsListPage
                    if (preg_match('#^/rz\\-admin/custom\\-forms/fields/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormFieldsListPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormFieldsController::listAction',));
                    }

                    // customFormFieldsEditPage
                    if (0 === strpos($pathinfo, '/rz-admin/custom-forms/fields/edit') && preg_match('#^/rz\\-admin/custom\\-forms/fields/edit/(?P<customFormFieldId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormFieldsEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormFieldsController::editAction',));
                    }

                    // customFormFieldsAddPage
                    if (0 === strpos($pathinfo, '/rz-admin/custom-forms/fields/add') && preg_match('#^/rz\\-admin/custom\\-forms/fields/add/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormFieldsAddPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormFieldsController::addAction',));
                    }

                    // customFormFieldsDeletePage
                    if (0 === strpos($pathinfo, '/rz-admin/custom-forms/fields/delete') && preg_match('#^/rz\\-admin/custom\\-forms/fields/delete/(?P<customFormFieldId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormFieldsDeletePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\CustomFormFieldsController::deleteAction',));
                    }

                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/search')) {
                // searchNodePage
                if ($pathinfo === '/rz-admin/search') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\SearchController::searchNodeAction',  '_route' => 'searchNodePage',);
                }

                // searchNodeSourcePage
                if (preg_match('#^/rz\\-admin/search/(?P<nodetypeId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'searchNodeSourcePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\SearchController::searchNodeSourceAction',));
                }

            }

            if (0 === strpos($pathinfo, '/rz-admin/newsletter')) {
                // newslettersIndexPage
                if ($pathinfo === '/rz-admin/newsletter') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\NewslettersController::listAction',  '_route' => 'newslettersIndexPage',);
                }

                // newslettersAddPage
                if (0 === strpos($pathinfo, '/rz-admin/newsletter/add') && preg_match('#^/rz\\-admin/newsletter/add/(?P<nodeTypeId>[^/]++)/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'newslettersAddPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NewslettersController::addAction',));
                }

                // newslettersEditPage
                if (0 === strpos($pathinfo, '/rz-admin/newsletter/edit') && preg_match('#^/rz\\-admin/newsletter/edit/(?P<newsletterId>[0-9]+)/(?P<translationId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'newslettersEditPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NewslettersController::editAction',));
                }

                // newslettersPreviewPage
                if (0 === strpos($pathinfo, '/rz-admin/newsletter/preview') && preg_match('#^/rz\\-admin/newsletter/preview/(?P<newsletterId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'newslettersPreviewPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NewslettersUtilsController::previewAction',));
                }

                // newslettersDuplicatePage
                if (0 === strpos($pathinfo, '/rz-admin/newsletter/duplicate') && preg_match('#^/rz\\-admin/newsletter/duplicate/(?P<newsletterId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'newslettersDuplicatePage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NewslettersUtilsController::duplicateAction',));
                }

                // newslettersExportPage
                if (0 === strpos($pathinfo, '/rz-admin/newsletter/export') && preg_match('#^/rz\\-admin/newsletter/export/(?P<newsletterId>[0-9]+)/(?P<inline>0|1)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'newslettersExportPage')), array (  '_controller' => 'Themes\\Rozier\\Controllers\\NewslettersUtilsController::exportAction',));
                }

            }

            // cssMainColor
            if ($pathinfo === '/rz-admin/css/main-color.css') {
                return array (  '_controller' => 'Themes\\Rozier\\RozierApp::cssAction',  '_route' => 'cssMainColor',);
            }

            if (0 === strpos($pathinfo, '/rz-admin/about')) {
                // aboutPage
                if ($pathinfo === '/rz-admin/about') {
                    return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::indexAction',  '_route' => 'aboutPage',);
                }

                if (0 === strpos($pathinfo, '/rz-admin/about/update')) {
                    // aboutUpdatePage
                    if ($pathinfo === '/rz-admin/about/update') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::updateAction',  '_route' => 'aboutUpdatePage',);
                    }

                    // aboutUpdateDownloadPage
                    if ($pathinfo === '/rz-admin/about/update/download') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::downloadAction',  '_route' => 'aboutUpdateDownloadPage',);
                    }

                    // aboutUpdateUnarchivePage
                    if ($pathinfo === '/rz-admin/about/update/unarchive') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::unarchiveAction',  '_route' => 'aboutUpdateUnarchivePage',);
                    }

                    // aboutUpdateMovePage
                    if ($pathinfo === '/rz-admin/about/update/move-files') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::moveFilesAction',  '_route' => 'aboutUpdateMovePage',);
                    }

                    // aboutUpdateClearCachePage
                    if ($pathinfo === '/rz-admin/about/update/clear-cache') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::clearCacheAction',  '_route' => 'aboutUpdateClearCachePage',);
                    }

                    // aboutUpdateSchemaPage
                    if ($pathinfo === '/rz-admin/about/update/update-schema') {
                        return array (  '_controller' => 'Themes\\Rozier\\Controllers\\AboutController::updateSchemaAction',  '_route' => 'aboutUpdateSchemaPage',);
                    }

                }

            }

        }

        if (0 === strpos($pathinfo, '/font')) {
            // FontFile
            if (0 === strpos($pathinfo, '/fonts/files') && preg_match('#^/fonts/files/(?P<filename>[a-zA-Z0-9\\-_]+)_(?P<variant>[0-9])\\.(?P<extension>[a-z0-9]+)$#s', $pathinfo, $matches)) {
                return $this->mergeDefaults(array_replace($matches, array('_route' => 'FontFile')), array (  '_controller' => '\\RZ\\Roadiz\\CMS\\Controllers\\AssetsController::fontFileAction',));
            }

            // FontFaceCSS
            if ($pathinfo === '/font-faces.css') {
                return array (  '_controller' => '\\RZ\\Roadiz\\CMS\\Controllers\\AssetsController::fontFacesAction',  '_route' => 'FontFaceCSS',);
            }

        }

        // interventionRequestProcess
        if (0 === strpos($pathinfo, '/assets') && preg_match('#^/assets/(?P<queryString>[a-zA-Z:0-9\\-]+)/(?P<filename>[a-zA-Z0-9\\-_\\./]+)$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'interventionRequestProcess')), array (  '_controller' => '\\RZ\\Roadiz\\CMS\\Controllers\\AssetsController::interventionRequestAction',));
        }

        // contactFormLocaleAction
        if (preg_match('#^/(?P<_locale>[a-z]{2}_?[A-Z]{0,2})/submit\\-form/contact$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'contactFormLocaleAction')), array (  '_controller' => '\\RZ\\Roadiz\\CMS\\Controllers\\EntryPointsController::contactFormAction',));
        }

        if (0 === strpos($pathinfo, '/custom-form')) {
            // customFormSendAction
            if (preg_match('#^/custom\\-form/(?P<customFormId>[0-9]+)$#s', $pathinfo, $matches)) {
                return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormSendAction')), array (  '_controller' => '\\RZ\\Roadiz\\CMS\\Controllers\\CustomFormController::addAction',));
            }

            // customFormSentAction
            if (preg_match('#^/custom\\-form/(?P<customFormId>[0-9]+)/sent$#s', $pathinfo, $matches)) {
                return $this->mergeDefaults(array_replace($matches, array('_route' => 'customFormSentAction')), array (  '_controller' => '\\RZ\\Roadiz\\CMS\\Controllers\\CustomFormController::sentAction',));
            }

        }

        // homePage
        if ($pathinfo === '/') {
            return array (  '_controller' => 'Themes\\KiosqueTheme\\KiosqueThemeApp::homeAction',  '_route' => 'homePage',);
        }

        // homePageLocale
        if (preg_match('#^/(?P<_locale>[a-z]{2})$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'homePageLocale')), array (  '_controller' => 'Themes\\KiosqueTheme\\KiosqueThemeApp::homeAction',));
        }

        // CssDynamicStyles
        if ($pathinfo === '/css/dynamic-styles.css') {
            return array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\CssController::stylesAction',  '_route' => 'CssDynamicStyles',);
        }

        // sitemap
        if ($pathinfo === '/sitemap.xml') {
            return array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\SitemapController::sitemapAction',  '_route' => 'sitemap',);
        }

        // defaultRemoveTrailingSlash
        if (preg_match('#^/(?P<url>.*/)$#s', $pathinfo, $matches)) {
            if (!in_array($this->context->getMethod(), array('GET', 'HEAD'))) {
                $allow = array_merge($allow, array('GET', 'HEAD'));
                goto not_defaultRemoveTrailingSlash;
            }

            return $this->mergeDefaults(array_replace($matches, array('_route' => 'defaultRemoveTrailingSlash')), array (  '_controller' => 'Themes\\KiosqueTheme\\KiosqueThemeApp::removeTrailingSlashAction',));
        }
        not_defaultRemoveTrailingSlash:

        // socialfeed
        if (0 === strpos($pathinfo, '/socialfeed') && preg_match('#^/socialfeed/(?P<accountId>[0-9]+)$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'socialfeed')), array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\Blocks\\MixedSocialFeedController::ajaxAction',));
        }

        // socialfeedLocale
        if (preg_match('#^/(?P<_locale>[a-z]{2})/socialfeed/(?P<accountId>[0-9]+)$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'socialfeedLocale')), array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\Blocks\\MixedSocialFeedController::ajaxAction',));
        }

        // issueZipLocale
        if (preg_match('#^/(?P<_locale>[a-z]{2})/issue/(?P<issueId>[0-9]+)/zip$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'issueZipLocale')), array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\IssueController::zipAction',));
        }

        // search
        if (0 === strpos($pathinfo, '/search') && preg_match('#^/search/(?P<terms>[^/]+)$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'search')), array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\Blocks\\IssueFeedController::searchAction',));
        }

        // searchLocale
        if (preg_match('#^/(?P<_locale>[a-z]{2})/search/(?P<terms>[^/]+)$#s', $pathinfo, $matches)) {
            return $this->mergeDefaults(array_replace($matches, array('_route' => 'searchLocale')), array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\Blocks\\IssueFeedController::searchAction',));
        }

        if (0 === strpos($pathinfo, '/rz-admin/kiosque/issues')) {
            // adminIssuesPage
            if ($pathinfo === '/rz-admin/kiosque/issues') {
                return array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\Admin\\AdminIssuesController::listAction',  '_route' => 'adminIssuesPage',);
            }

            // adminAddIssuePage
            if ($pathinfo === '/rz-admin/kiosque/issues/add') {
                return array (  '_controller' => 'Themes\\KiosqueTheme\\Controllers\\Admin\\AdminIssuesController::addIssueAction',  '_route' => 'adminAddIssuePage',);
            }

        }

        throw 0 < count($allow) ? new MethodNotAllowedException(array_unique($allow)) : new ResourceNotFoundException();
    }
}
