<?php
/*
 * Copyright REZO ZERO 2015
 *
 * KiosqueTheme main class.
 * Entry point for your theme logic and inheritance.
 *
 * @file KiosqueThemeApp.php
 * @copyright REZO ZERO 2015
 * @author Ambroise Maupate
 */
namespace Themes\KiosqueTheme;

use RZ\Roadiz\CMS\Controllers\FrontendController;
use RZ\Roadiz\Core\Bags\SettingsBag;
use RZ\Roadiz\Core\Entities\Node;
use RZ\Roadiz\Core\Entities\Translation;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Themes\KiosqueTheme\Services;
use Pimple\Container;

/**
 * KiosqueThemeApp class
 */
class KiosqueThemeApp extends FrontendController
{
    const VERSION = '1.0.5';

    protected static $themeName = 'Kiosque theme';
    protected static $themeAuthor = 'REZO ZERO';
    protected static $themeCopyright = 'REZO ZERO';
    protected static $themeDir = 'KiosqueTheme';
    protected static $backendTheme = false;
    protected static $specificNodesControllers = [
        // Put here your nodes which need a specific controller
        // instead of a node-type controller
    ];

    /**
     * {@inheritdoc}
     */
    public function homeAction(
        Request $request,
        $_locale = null
    ) {
        /*
         * If you use a static route for Home page
         * we need to grab manually language.
         *
         * Get language from static route
         */
        $translation = $this->bindLocaleFromRoute($request, $_locale);
        $home = $this->getHome($translation);

        /*
         * Use home page node-type to render it.
         */
        //return $this->handle($request, $home, $translation);

        /*
         * Render Homepage manually
         */
        $this->prepareThemeAssignation($home, $translation);

        return $this->render('types/kiosque.html.twig', $this->assignation);
    }

    /**
     * Return a Response with default backend 404 error page.
     *
     * @param string $message Additionnal message to describe 404 error.
     *
     * @return Symfony\Component\HttpFoundation\Response
     */
    public function throw404($message = '')
    {
        $this->translation = $this->getService('defaultTranslation');

        $this->prepareThemeAssignation(null, $this->translation);
        $this->getService('logger')->error($message);
        $this->assignation['errorMessage'] = $message;

        $this->getService('stopwatch')->start('twigRender');
        return new Response(
            $this->getTwig()->render('@' . static::getThemeDir() . '/404.html.twig', $this->assignation),
            Response::HTTP_NOT_FOUND,
            array('content-type' => 'text/html')
        );
    }

    /**
     * {@inheritdoc}
     */
    public function maintenanceAction(Request $request)
    {
        $translation = $this->bindLocaleFromRoute($request, $request->getLocale());
        $this->prepareThemeAssignation(null, $translation);
        return new Response(
            $this->renderView('@KiosqueTheme/maintenance.html.twig', $this->assignation),
            Response::HTTP_SERVICE_UNAVAILABLE,
            ['content-type' => 'text/html']
        );
    }

    /**
     * {@inheritdoc}
     */
    protected function extendAssignation()
    {
        parent::extendAssignation();

        /*
         * Register services
         */
        $this->themeContainer->register(new Services\NodeServiceProvider($this->getContainer(), $this->translation));
        $this->themeContainer->register(new Services\NodeTypeServiceProvider($this->getService('nodeTypeApi')));
        $this->themeContainer->register(new Services\TagServiceProvider($this->getService('tagApi')));
        $this->themeContainer->register(new Services\AssetsServiceProvider());

        $this->themeContainer['grunt'] = function ($c) {
            return include dirname(__FILE__) . '/static/public/config/assets.config.php';
        };

        $this->assignation['themeServices'] = $this->themeContainer;

        $this->assignation['head']['facebookUrl'] = SettingsBag::get('facebook_url');
        $this->assignation['head']['facebookClientId'] = SettingsBag::get('facebook_client_id');
        $this->assignation['head']['instagramUrl'] = SettingsBag::get('instagram_url');
        $this->assignation['head']['twitterUrl'] = SettingsBag::get('twitter_url');
        $this->assignation['head']['googleplusUrl'] = SettingsBag::get('googleplus_url');
        $this->assignation['head']['googleClientId'] = SettingsBag::get('google_client_id');
        $this->assignation['head']['mapsStyle'] = SettingsBag::get('maps_style');
        $this->assignation['head']['themeName'] = static::$themeName;
        $this->assignation['head']['themeVersion'] = static::VERSION;

        // Get session messages
        $this->assignation['session']['messages'] = $this->getService('session')->getFlashBag()->all();
    }

    /**
     * {@inheritdoc}
     */
    public static function setupDependencyInjection(Container $container)
    {
        parent::setupDependencyInjection($container);

        $container->extend('backoffice.entries', function (array $entries, $c) {

            /*
             * Add a test entry in your Backoffice
             * Remove this in your theme if you don’t
             * want to extend Back-office
             */
            $entries['issues'] = [
                'name' => 'issues',
                'path' => $c['urlGenerator']->generate('adminIssuesPage'),
                'icon' => 'uk-icon-bullhorn',
                'roles' => null,
                'subentries' => null,
            ];

            return $entries;
        });

        /*
         * Becareful you should extend instead of actually using twig.environment
         * as it will lock translator with default translation.
         */
        $container->extend('twig.environment', function ($twig, $c) {
            $twitter = new \Twig_SimpleFilter('tweet', function ($string) {

                $string = preg_replace(
                    "@(https?://([-\w\.]+)+(/([\w/_\.]*(\?\S+)?(#\S+)?)?)?)@",
                    '<a rel="nofollow" target="_blank" href="$1">$1</a>',
                    $string
                );
                $string = preg_replace(
                    "/@(\w+)/",
                    ' <a rel="nofollow" target="_blank" href="https://twitter.com/$1">@$1</a>',
                    $string
                );
                $string = preg_replace(
                    "/\s+#(\w+)/",
                    ' <a rel="nofollow" target="_blank" href="https://twitter.com/search?q=%23$1">#$1</a>',
                    $string
                );
                return $string;
            }, ['is_safe' => ['html']]);

            $parseLinks = new \Twig_SimpleFilter('parse_links', function ($string) {
                $string = preg_replace(
                    "@(https?://([-\w\.]+)+(/([\w/_\.]*(\?\S+)?(#\S+)?)?)?)@",
                    '<a rel="nofollow" target="_blank" href="$1">$1</a>',
                    $string
                );

                return $string;
            }, ['is_safe' => ['html']]);

            $twig->addFilter($parseLinks);
            $twig->addFilter($twitter);
            return $twig;
        });
    }
}
