/**
 * Nav
 */
var KiosqueSearch = function(){
    var _this = this;

    // console.log('Search');

    // Selectors

    // Methods
    _this.init();
};


/**
 * Init
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.init = function(){
    var _this = this;

    _this.$cont = $('#search-cont');
    _this.$openSearchBtn = $('#open-search');
    _this.$closeSearchBtn = $('#close-search');

    _this.$form = $('#form-search');
    _this.$input = $('#input-search');

    _this.$searchBack = null;

    _this.opened = false;

    // Events
    _this.initEvents();
};


/**
 * Init events
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.initEvents = function(){
    var _this = this;

    if (_this.$openSearchBtn.length) {
        _this.$openSearchBtn.on('click', $.proxy(_this.btnClick, _this));
    }
    if (_this.$closeSearchBtn.length) {
        _this.$closeSearchBtn.on('click', $.proxy(_this.btnClick, _this));
    }

    _this.$form.on('submit', $.proxy(_this.formSubmit, _this));
    Kiosque.$window.on('keyup', $.proxy(_this.onKeyUp, _this));
    Kiosque.$window.on('resize', debounce($.proxy(_this.resize, _this), 100, false));
};


/**
 * Destroy events
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.destroyEvents = function(){
    var _this = this;

    _this.$openSearchBtn.off('click', $.proxy(_this.btnClick, _this));
    _this.$closeSearchBtn.off('click', $.proxy(_this.btnClick, _this));

    _this.$form.off('submit', $.proxy(_this.formSubmit, _this));

    Kiosque.$window.off('keyup', $.proxy(_this.onKeyUp, _this));

    Kiosque.$window.off('resize', debounce($.proxy(_this.resize, _this), 100, false));
};


/**
 * Destroy
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.destroy = function(){
    var _this = this;

    // Events
    _this.destroyEvents();
};


/**
 * Btn click
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.btnClick = function(e){
    var _this = this;

    if(!_this.opened) _this.open();
    else _this.close();
};

/**
 * On key up
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.onKeyUp = function(e){
    var _this = this;

    if(e.keyCode == 27 && _this.opened) _this.close();
};


/**
 * Open
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.open = function(e){
    var _this = this;

    if(!_this.opened){

        _this.$cont[0].style.display = 'block';
        TweenLite.to(_this.$cont , 1.2, {opacity:1});

        _this.$input.focus();

        _this.opened = true;
    }
};

/**
 * Close
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.close = function(e){
    var _this = this;

    if(_this.opened){

        TweenLite.to(_this.$cont, 1.2, {opacity:0, onComplete:function(){
            _this.$cont[0].style.display = 'none';
        }});

        _this.opened = false;
    }
};


/**
 * Form submit
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.formSubmit = function(e){
    var _this = this;

    var searchValue = _this.$input[0].value;

    if (searchValue !== ''){

        var url = _this.$form[0].getAttribute('data-url');
        url = url.replace("terms", searchValue);

        window.location.href = url;

        // $.ajax({
        //     url: url,
        //     type: 'get',
        //     success: function(data){
        //         _this.appendSearch(data);
        //     }
        // });
    }

    return false;
};

/**
 * Append search
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.appendSearch = function(data){
    var _this = this;

    // var $issueFeedTemp = $('.issuefeed-temp'),
    //     $issueFeedContainer = $('.issuefeed-container');

    // if($issueFeedTemp){

    //     $issueFeedTemp[0].innerHTML = data;

    //     var $row = $issueFeedTemp.find('.search-issues'),
    //         $item = $issueFeedTemp.find('.issue-block');

    //     if ($item.length){

    //         TweenLite.to($issueFeedContainer, 0.6, {opacity:0});

    //         setTimeout(function(){
    //             $issueFeedContainer[0].innerHTML = $row[0].innerHTML;

    //             _this.$searchBack = $('.search-back');
    //             _this.$searchBack.on('click', $.proxy(_this.searchBackClick, _this));
    //         }, 600);

    //         TweenLite.to($issueFeedContainer, 0.8, {opacity:1});
    //     }
    // }
};

/**
 * Search back click
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.searchBackClick = function(e){
    var _this = this;

    // console.log('Search back click');

    // $.ajax({
    //     url: e.currentTarget.href,
    //     type: 'get',
    //     success: function(data){

    //         _this.searchBack(data);
    //     }
    // });

    e.preventDefault();

};

/**
 * Search back
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.searchBack = function(data){
    var _this = this;

    // var $issueFeedTemp = $('.issuefeed-temp'),
    //     $issueFeedContainer = $('.issuefeed-container');

    // if($issueFeedTemp){

    //     $issueFeedTemp[0].innerHTML = data;

    //     var $cont = $issueFeedTemp.find('.issuefeed-container'),
    //         $item = $issueFeedTemp.find('.issue-block');

    //     if ($item.length){

    //         TweenLite.to($issueFeedContainer, 0.6, {opacity:0});

    //         setTimeout(function(){
    //             $issueFeedContainer[0].innerHTML = $cont[0].innerHTML;

    //         }, 600);

    //         setTimeout(function(){

    //             $cont[0].innerHTML = '';

    //             _this.destroyEvents();
    //             _this.$searchBack.off('click', $.proxy(_this.searchBackClick, _this));
    //             _this.init();
    //         }, 800);

    //         TweenLite.to($issueFeedContainer, 0.8, {opacity:1});

    //         for(var indexBlock = 0; indexBlock < Kiosque.page.blockLength; indexBlock++) {
    //             if(Kiosque.page.blocks[indexBlock].type == 'issuefeed'){
    //                 Kiosque.page.blocks[indexBlock].backSearch();
    //                 break;
    //             }
    //         }
    //     }
    // }

};


/**
 * Window resize callback
 * @return {[type]} [description]
 */
KiosqueSearch.prototype.resize = function(){
    var _this = this;

    // console.log('-> Search resize');
};
