/**
 * Mixed Social Block
 */
var IssueFeedBlock = function(id, type){

    AbstractBlock.call(this, id, type);
};

$.extend(IssueFeedBlock.prototype, AbstractBlock.prototype);

/**
 * Init
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.init = function(id, type){
    var _this = this;

    AbstractBlock.prototype.init.call(this, id, type);

    // console.log('-> IssueFeedBlock init : '+id);

    // --- Filters --- //

    _this.hasFilters = _this.$cont[0].getAttribute('data-filters') == '1';

    if(_this.hasFilters){

        _this.$issueFeedTitleText = _this.$cont.find('.issuefeed-title-text');
        _this.$filtersButtons = _this.$cont.find('.filter-buttons');
        _this.$filterSelect = _this.$cont.find('.filter-select');
        _this.$filterReset = _this.$cont.find('.filter-reset');
        _this.$filters = _this.$cont.find('.issuefeed-filters');
        _this.$filtersInner = _this.$cont.find('.issuefeed-filters-inner');
        _this.$filterButton = _this.$filters.find('.filter-button');
        _this.$filterButtonType = _this.$filters.find('.filter-button-type');
        _this.$filterButtonTag = _this.$filters.find('.filter-button-tag');
        _this.filtersOpened = false;

        _this.filterType = null;
        _this.filterTag = null;

        _this.$filterButton.each(function(index, el) {

            if(el.className.indexOf('active') >= 0) {
                if(el.getAttribute('data-type') == 'type'){
                    _this.filterType = el.getAttribute('data-id');
                }
                else _this.filterTag = el.getAttribute('data-id');
            }
        });
    }


    _this.$issueContainer = _this.$cont.find('.issue-container');
    _this.$issueList = _this.$cont.find('.issue-list');
    _this.url = _this.$issueContainer[0].getAttribute('data-url');

    _this.$issue = _this.$cont.find('.issue-block');

    // --- Detail --- //

    _this.$detailCont = _this.$cont.find('.issue-detail-cont');
    _this.detail = null;
    _this.$itemsTemp = _this.$cont.find('.issuefeed-temp');
    _this.$moreLink = _this.$cont.find('.more-issues');

    if (typeof _this.$filters !== "undefined" &&
        _this.$filters.length &&
        _this.$filters.attr('data-filter-always-open') == 1) {
        _this.openFilters();
    }
};

/**
 * Init events
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.initEvents = function(){
    var _this = this;

    AbstractBlock.prototype.initEvents.call(_this);

    if(_this.hasFilters){
        _this.$filterSelect.on('click', $.proxy(_this.filterSelectClick, _this));
        _this.$filterReset.on('click', $.proxy(_this.filterResetClick, _this));
        _this.$filterButton.on('click', $.proxy(_this.filterButtonClick, _this));
    }

    _this.$issue.on('click', $.proxy(_this.issueClick, _this));

    _this.$moreLink.on('click', $.proxy(_this.moreLinkClick, _this));
};

/**
 * Destroy events
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.destroyEvents = function(){
    var _this = this;

    AbstractBlock.prototype.destroyEvents.call(_this);

    if(_this.hasFilters){
        _this.$filterSelect.off('click', $.proxy(_this.filterSelectClick, _this));
        _this.$filterReset.off('click', $.proxy(_this.filterResetClick, _this));
        _this.$filterButton.off('click', $.proxy(_this.filterButtonClick, _this));
    }

    _this.$issue.off('click', $.proxy(_this.issueClick, _this));

    _this.$moreLink.off('click', $.proxy(_this.moreLinkClick, _this));
};


/**
 * Filter select click
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.filterSelectClick = function(e){
    var _this = this;

    if(!_this.filtersOpened) _this.openFilters();
    else _this.closeFilters();

};

/**
 * Open filters
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.openFilters = function(e){
    var _this = this;

    addClass(_this.$filtersButtons[0],'filters-opened');

    var filtersHeight = _this.$filtersInner.actual('outerHeight');
    TweenLite.to(_this.$filters, 0.8, {height:filtersHeight});

    _this.filtersOpened = true;
};

/**
 * Close filters
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.closeFilters = function(e){
    var _this = this;

    TweenLite.to(_this.$filters, 0.8, {height:0});

    removeClass(_this.$filtersButtons[0],'filters-opened');

    _this.filtersOpened = false;
};


/**
 * Filter button click
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.filterButtonClick = function(e){
    var _this = this;

    var type = e.currentTarget.getAttribute('data-type'),
        id = e.currentTarget.getAttribute('data-id'),
        url = _this.url;

    if(type == 'type'){
        _this.filterType = (e.currentTarget.className.indexOf('active') == -1) ? id : null;
        _this.$filterButtonType.removeClass('active');

        if(_this.filterType !== null) addClass(e.currentTarget,'active');
    }
    else{
        _this.filterTag = (e.currentTarget.className.indexOf('active') == -1) ? id : null;
        _this.$filterButtonTag.removeClass('active');

        if(_this.filterTag !== null) addClass(e.currentTarget,'active');
    }

    if(_this.filterType !== null && _this.filterTag !== null){
        url += '?type='+_this.filterType+'&tag='+_this.filterTag;
    }
    else if(_this.filterType !== null && _this.filterTag === null){
        url += '?type='+_this.filterType;
    }
    else if(_this.filterType === null && _this.filterTag !== null){
        url += '?tag='+_this.filterTag;
    }

    if(_this.filterType !== null || _this.filterTag !== null){
        _this.$filterReset.removeClass('hidden');
    } else {
        _this.$filterReset.addClass('hidden');
    }

    $.ajax({
        url: url,
        type: 'get',
        success: function(data){
            _this.changeFilter(data);
        }
    });
};


/**
 * Filter reset click
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.filterResetClick = function(e){
    var _this = this;

    if(_this.filterType !== null || _this.filterTag !== null){

        _this.filterType = null;
        _this.filterTag = null;
        _this.$filterButton.removeClass('active');

        $.ajax({
            url: _this.url,
            type: 'get',
            success: function(data){
                _this.changeFilter(data);
                _this.$filterReset.addClass('hidden');
            }
        });
    }

    e.preventDefault();
};


/**
 * Change filter
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.changeFilter = function(data){
    var _this = this;

    TweenLite.to(_this.$issueContainer, 0.6, {opacity:0});

    _this.$itemsTemp[0].innerHTML = data;

    var $productions = _this.$itemsTemp.find('.issue-container'),
        $item = _this.$itemsTemp.find('.issue-block');

    setTimeout(function(){

        _this.$issueContainer[0].innerHTML = $productions[0].innerHTML;

        TweenLite.to(_this.$issueContainer, 1, {opacity:1});

        _this.destroyEvents();
        _this.$issue = _this.$cont.find('.issue-block');
        _this.$moreLink = _this.$cont.find('.more-issues');
        _this.initEvents();
    }, 600);
};


/**
 * Issue click
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.issueClick = function(e){
    var _this = this;

    var type = e.currentTarget.getAttribute('data-type');

    // Send analytics event
    if (typeof ga !== 'undefined'){

        ga('send', {
            hitType: 'event',
            eventCategory: Kiosque.issueClickTitle,
            eventAction: type,
            eventLabel: e.currentTarget.getAttribute('data-title')
        });
    }

    if(type == 'diaporama' || type == 'video'){

        $.ajax({
            url: e.currentTarget.href,
            type: 'get',
            success: function(data){

                _this.$detailCont[0].innerHTML = data;
                _this.detail = new IssueDetail(_this.$detailCont);
            }
        });

        e.preventDefault();
    }
};


/**
 * Back
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.backSearch = function(data){
    var _this = this;

    _this.destroyEvents();
    _this.init();
};


/**
 * More link click
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.moreLinkClick = function(e){
    var _this = this;

    $.ajax({
        url: e.currentTarget.href,
        type: 'get',
        success: function(data){

            _this.appendItems(data);
        }
    });

    e.preventDefault();
};

/**
 * Append items
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.appendItems = function(data){
    var _this = this;

    // console.log('Append items');

    _this.$itemsTemp[0].innerHTML = data;

    var $issueList = _this.$itemsTemp.find('.issue-list'),
        $item = _this.$itemsTemp.find('.issue-block'),
        $moreLink = _this.$itemsTemp.find('.more-issues');

    // Append items
    if($item.length){
        _this.$issueList.append($item);
    }

     // Check if next page is available
    if($moreLink.length){
        _this.$moreLink[0].href = $moreLink[0].href;
    }
    else _this.hideMoreLink();
};

/**
 * Hide more link
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.hideMoreLink = function(){
    var _this = this;

    if(_this.$moreLink.length){
        TweenLite.to(_this.$moreLink, 0.6, {opacity:0, onComplete:function(){
            _this.$moreLink[0].style.display = 'none';
        }});
    }
};


/**
 * Show more link
 * @return {[type]} [description]
 */
IssueFeedBlock.prototype.showMoreLink = function(){
    var _this = this;

    if(_this.$moreLink.length){
        _this.$moreLink[0].style.display = 'block';
        TweenLite.to(_this.$moreLink, 0.6, {opacity:1});
    }
};


/**
 * Resize
 */
IssueFeedBlock.prototype.resize = function(){
    var _this = this;

    if(_this.hasFilters &&
        _this.$issueFeedTitleText.length &&
        _this.$filtersButtons.length &&
            (_this.$filtersButtons.hasClass('with-overlay-search') ||
             _this.$filtersButtons.hasClass('with-filters-always-displayed'))) {
        if(isMediaMinMD()) {
            var titleText = _this.$issueFeedTitleText.actual('outerWidth'),
                buttonsPaddingLeft = (0.5*titleText + 10);
            _this.$filtersButtons[0].style.paddingLeft = buttonsPaddingLeft + 'px';
        }
        else _this.$filtersButtons[0].style.paddingLeft = '';
    }
};
