<?php
/**
 * Copyright REZO ZERO 2014
 *
 *
 *
 * @file TagServiceProvider.php
 * @copyright REZO ZERO 2014
 * @author Ambroise Maupate
 */
namespace Themes\KiosqueTheme\Services;

use Pimple\Container;
use Pimple\ServiceProviderInterface;
use RZ\Roadiz\CMS\Utils\TagApi;

/**
 * Node type services.
 */
class TagServiceProvider implements ServiceProviderInterface
{
    protected $api;

    public function __construct(TagApi $api)
    {
        $this->api = $api;
    }

    /**
     * @param Pimple\Container $container
     */
    public function register(Container $container)
    {

        $container['themesTags'] = function ($c) {
            return $this->api
            ->getBy(['parent' => $c['themesTag']]);
        };

        $container['themesTag'] = function ($c) {
            return $this->api
            ->getOneBy(['tagName' => 'thematiques']);
        };

        return $container;
    }
}
