<?php
/**
 * Copyright REZO ZERO 2014
 *
 *
 *
 * @file NodeTypeServiceProvider.php
 * @copyright REZO ZERO 2014
 * @author Ambroise Maupate
 */
namespace Themes\KiosqueTheme\Services;

use Pimple\Container;
use Pimple\ServiceProviderInterface;
use RZ\Roadiz\CMS\Utils\NodeTypeApi;

/**
 * Node type services.
 */
class NodeTypeServiceProvider implements ServiceProviderInterface
{
    protected $api;

    public function __construct(NodeTypeApi $api)
    {
        $this->api = $api;
    }

    /**
     * @param Pimple\Container $container
     */
    public function register(Container $container)
    {

        $container['typePage'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'Page']);
        };

        $container['typeKiosqueHeader'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'KiosqueHeader']);
        };

        $container['typeIssueFeed'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'IssueFeed']);
        };

        $container['typeIssue'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'Issue']);
        };

        $container['typeSocialFeed'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'MixedSocialFeed']);
        };

        $container['typeSocialAccount'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'SocialAccount']);
        };

        $container['typeSocialFooter'] = function ($c) {
            return $this->api
            ->getOneBy(['name' => 'SocialFooter']);
        };



        return $container;
    }
}
