<?php
/*
 * Copyright REZO ZERO 2014
 *
 * Issue
 *
 * @file IssueController.php
 * @copyright REZO ZERO 2015
 * @author Ambroise Maupate
 */

namespace Themes\KiosqueTheme\Controllers;

use RZ\Roadiz\Core\Entities\Node;
use RZ\Roadiz\Core\Entities\Translation;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Themes\KiosqueTheme\KiosqueThemeApp;

/**
 * IssueController class
 */
class IssueController extends KiosqueThemeApp
{
    /**
     * {@inheritdoc}
     */
    public function indexAction(
        Request $request,
        Node $node = null,
        Translation $translation = null
    ) {
        $this->prepareThemeAssignation($node, $translation);
        $this->assignation['home'] = $this->getHome();

        if ($this->nodeSource->getIssuetype() == 'diaporama' || $this->nodeSource->getIssuetype() == 'video') {

            return $this->render('types/issue.html.twig', $this->assignation);
        } else {
            return $this->throw404();
        }
    }


    /**
     *
     * @param  Request $request
     * @param  int  $issueId
     * @return Response
     */
    public function zipAction(Request $request, $issueId)
    {

        $issue = $this->getService('nodeSourceApi')
                        ->getOneBy(['id' => $issueId]);

        $images = [];
        if (null !== $issue->getImages()) {
            $images = array_merge($images, $issue->getImages());
        }

        if (count($images) > 0) {

            $tmpFileName = tempnam("/tmp", "issue_".$issueId."_");
            $zip = new \ZipArchive();
            $zip->open($tmpFileName, \ZipArchive::CREATE);

            foreach ($images as $document) {
                if (null !== $hd = $document->getRawDocument()) {
                    $zip->addFile($hd->getAbsolutePath(), $hd->getFilename());
                } else {
                    $zip->addFile($document->getAbsolutePath(), $document->getFilename());
                }
            }

            $zip->close();

            $response = new Response(
                file_get_contents($tmpFileName),
                Response::HTTP_OK,
                [
                    'content-control' => 'private',
                    'content-type' => 'application/zip',
                    'content-length' => filesize($tmpFileName),
                    'content-disposition' => 'attachment; filename='.$issue->getNode()->getNodeName().'.zip',
                ]
            );

            unlink($tmpFileName);

            return $response;

        }
        return $this->throw404();
    }
}
