<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('fr', array (
  'messages' => 
  array (
    'welcome.user.email.%site%' => 'Un compte utilisateur a été créé sur %site% pour vous.',
    'your.user.account' => 'Votre compte utilisateur',
    'username' => 'Nom d’utilisateur',
    'email' => 'Email',
    'password' => 'Mot de passe',
    'for.questions.email' => 'Des questions ? Contactez-nous à :',
    'contact.form' => 'Formulaire de contact',
    'new.contact.form.%site%' => 'Nouveau formulaire de contact sur %site%',
    'form.successfully.sent' => 'Votre formulaire a bien été envoyé',
    'form.has.errors' => 'Votre formulaire n’est pas valide, merci de remplir correctement les champs obligatoires.',
    '%field%.is.mandatory' => 'Le champ %field% est obligatoire',
    'email.not.valid' => 'Votre courriel n’est pas valide',
    'date' => 'Date',
    'ip.address' => 'Adresse IP',
    'submittedAt' => 'Envoyé le',
    'form.submit' => 'Envoyer',
    'answer.form' => 'Formulaire de réponse',
    'customForm.%name%.send' => 'Le formulaire «%name%» a bien été envoyé',
    'new.answer.form.%site%' => 'Nouvelle réponse sur «%site%»',
    'file.not.accepted' => 'Le fichier joint n’a pas été accepté.',
    'customForm.answer.sent' => 'Votre réponse a bien été envoyée.',
    'none' => 'Aucun',
    'reset.password.request' => 'Demande de réinitialisation du mot de passe',
    'you.asked.for.a.password.reset.on.%site%' => 'Vous avez demandé à changer le mot de passe de votre compte sur « %site% »',
    'you.need.to.choose.a.new.password.using.following.link' => 'Vous devez choisir une nouveau mot de passe à l’adresse suivante :',
    'as.a.reminder.here.are.your.credentials' => 'Pour rappel, voici vos identifiants publics actuels',
    'if.you.didnt.request.this.password.reset.ignore.this.email' => 'Si vous n’avez pas sollicité cet email, veuillez l’ignorer, votre mot de passe ne sera pas changé.',
    'reset_your_password' => 'Réinitialiser votre mot de passe',
    'you.need.to.fill.this.required.field' => 'Vous devez remplir ce champ requis',
    '*.required.fields' => '* Champs requis',
    'website.is.under.maintenance' => 'Le site est en maintenance',
    'website.is.under.maintenance.we.will.be.back.soon' => 'Le site est actuellement en maintenance, il sera à nouveau disponible d’ici quelques minutes.',
    'Node name' => 'Nom du nœud',
    'See tree' => 'Voir l’arborescence',
    '_username' => 'Nom d’utilisateur',
    '_password' => 'Mot de passe',
    'password.verify' => 'Vérifiez votre mot de passe',
    'delete' => 'Supprimer',
    'status' => 'État',
    'welcome.title' => 'Installation de Roadiz CMS',
    'welcome.subtitle' => 'Installation de Roadiz CMS',
    'welcome.message' => '<p>Bienvenue dans l\'assistant d\'installation de Roadiz CMS, quelques petites minutes de configuration et à vous de jouer</p>',
    'requirements.title' => 'Pré-requis',
    'requirements.message' => '<p>Pour pouvoir utiliser Roadiz, votre serveur a besoin de quelques pré-requis, notamment concernant PHP. Si vous avez accès au fichier de configuration (php.ini), vous devriez pouvoir en modifier certains.</p>',
    'requirements.spec' => 'Spécification',
    'requirements.requirement' => 'Requis',
    'requirements.actual_value' => 'Valeur actuelle',
    'database.title' => 'Base de données',
    'database.message' => '<p>Roadiz a besoin d\'une base de données pour stocker vos contenus de qualités. Vous pouvez même sélectionner votre moteur de base de données préféré!</p>',
    'database.cannot_connect' => 'Connexion à la base de données impossible',
    'database.build' => 'Construire la base de données',
    'database_done.title' => 'Base de données installée',
    'database_done.message' => '<p>La base de donnée a bien été installée. Maintenant, nous allons importer des contenus et paramètres de base pour mettre en route votre site.</p>',
    'database_fail.title' => 'Erreur de base de données',
    'database_fail.message' => '<p>La base de données n’a pas pu être installée. Veuillez vérifier si les identifiants sont corrects ou si la base n’a pas déjà été installée.</p>',
    'import.title' => 'Importation',
    'import.message' => '<p>Si vous le souhaitez vous pouvez importer des paramètres, des rôles et des groupes d\'utilisateur de base.',
    'import.step_name' => 'Étape',
    'user.title' => 'Création d\'un utilisateur',
    'user.message' => '<p>Créer un utilisateur pour accéder à l\'espace d’administration de votre site</p>',
    'user.create' => 'Créer un utilisateur',
    'user.name' => 'Nom d’utilisateur',
    'user.email' => 'Email',
    'user.create_another' => 'Créer un autre utilisateur',
    'user_summary.title' => 'Utilisateur créé avec succès',
    'themes.title' => 'Informations',
    'themes.message' => '<p>Remplissez les informations de base de votre site</p>',
    'themes.save_informations' => 'Sauvegarder les informations',
    'themes.frontend.description' => 'Vous pouvez installer un thème et ses contenus par défaut pour votre CMS.',
    'import_node_type.title' => 'Importation de contenu type',
    'import_node_type.message' => 'Types de nœud',
    'import_node_type.node_type' => 'Type de nœud',
    'import_node_type.node' => 'Nœud',
    'import_tags' => 'Étiquettes',
    'success.title' => 'Bravo!',
    'success.message' => '<p>Votre site est prêt à être utilisé. Amusez-vous bien !</p>',
    'success.quit_install' => 'Quitter l\'installation',
    'goto.requirements' => 'Pré-requis',
    'goto.welcome' => 'Retour à l\'accueil',
    'goto.database' => 'Base de données',
    'goto.import' => 'Importation',
    'goto.user' => 'Utilisateur',
    'goto.theme' => 'Informations du site',
    'goto.informations' => 'Informations',
    'skip.user.goto.theme' => 'Passer',
    'skip.user.goto.done' => 'Fin',
    'skip.database.goto.import' => 'Passer',
    'choose.language' => 'Choisir la langue',
    'choose.a.language' => 'Veuillez choisir la langue d’installation.',
    'skip.database.goto.theme' => 'Passer',
    'theme.summary.title' => 'Validation du thème',
    'check.version' => 'Version',
    'theme.name' => 'Nom',
    'theme.version' => 'Version',
    'cms.version' => 'Version du CMS',
    'theme.supportedLocale' => 'Locale disponible',
    'cms.locale' => 'Locale du CMS',
    'name' => 'Nom',
    'filename' => 'Nom du fichier',
    'nodetypes' => 'Types de nœud',
    'nodes' => 'Nœuds',
    'install.theme' => 'Lancer l’installation',
    'import.theme.content.title' => 'Importation du thème',
    'step.name' => 'Étape',
    'goto.done' => 'Terminer',
    'import_roles' => 'Rôles',
    'import_groups' => 'Groupes de rôles',
    'import_settings' => 'Paramètres',
    'theme.selector' => 'Thèmes disponibles',
    'check.locale' => 'Locale',
    'check.import.files' => 'Fichiers à importer',
    'password.must_match' => 'Les mots de passe doivent correspondre',
    'site_name' => 'Nom du site',
    'email_sender' => 'Email expéditeur',
    'email_sender_name' => 'Nom de l’expéditeur des emails',
    'meta_description' => 'Méta description',
    'timezone' => 'TImezone',
    'install_theme' => 'Installer un thème ?',
    'driver' => 'Moteur de base de donnée',
    'host' => 'Hôte',
    'port' => 'Port',
    'unix_socket' => 'Socket UNIX',
    'path' => 'Chemin',
    'user' => 'Utilisateur',
    'dbname' => 'Nom de la base',
    'error.locale.message' => 'La locale du thème n’existe pas sur votre système.',
    'error.modal.title' => 'Veuillez corriger les problèmes suivants avant de continuer.',
    'error.version.message' => 'Le thème nécessite une version plus récente de Roadiz.',
    'warning.theme.continue' => 'Vous pouvez ignorer ces messages et continuer tout de même.',
    'now_you_can_delete_install_file_and_use_roadiz' => 'L’installation de Roadiz est maintenant terminée, vous pouvez supprimer le fichier install.php et commencer à utiliser votre tout nouveau site web.',
    'node.%name%.updated' => 'Le nœud %name% a été mis à jour.',
    'node.%nodeId%.not_exists' => 'Le nœud %nodeId% n’existe pas.',
    'node.%name%.status.%field%.updated' => 'Le statut (%field%) du nœud %name% a été mis à jour.',
    'node.has_no.field.%field%' => 'Le nœud ne possède aucun champ %field%.',
    'node.id.not_specified' => 'L’id du nœud n’a pas été spécifié.',
    'document.%name%.updated' => 'Le document %name% a été mis à jour.',
    'document.%name%.deleted' => 'Le document %name% a été supprimé.',
    'document.%name%.cannot_delete' => 'Le document %name% n’a pas pu être supprimé.',
    'document.%name%.uploaded' => 'Le document %name% a été téléversé.',
    'document.cannot_persist' => 'Impossible d’enregistrer le document.',
    'description' => 'Description',
    'copyright' => 'Copyright',
    'private' => 'Privé',
    'choose.documents.to_upload' => 'Choisissez les documents à téléverser.',
    'cache.deleted' => 'Le cache a bien été vidé.',
    'group.%name%.created' => 'Le groupe %name% a été créé.',
    'group.%name%.deleted' => 'Le groupe %name% a été supprimé.',
    'group.%name%.updated' => 'Le groupe %name% a été mis à jour.',
    'role.%role%.linked_group.%group%' => 'Le rôle «%role%» a été ajouté au groupe «%group%».',
    'role.%role%.removed_from_group.%group%' => 'Le rôle «%role%» a été retiré du groupe «%group%».',
    'user.%user%.linked.group.%group%' => 'L’utilisateur «%user%» a été ajouté au groupe «%group».',
    'user.%user%.removed_from_group.%group%' => 'L’utilisateur «%user%» a été retiré du groupe «%group».',
    'group.name' => 'Nom du groupe',
    'choose.role' => 'Choisissez un rôle',
    'choose.user' => 'Choisissez un utilisateur',
    'group.name.already.exists' => 'Ce nom de groupe est déjà utilisé.',
    'theme.%name%.created' => 'Le thème (%name%) a été créé.',
    'theme.%name%.updated' => 'Le thème (%name%) a été mis à jour.',
    'theme.%name%.deleted' => 'Le thème (%name%) a été supprimé.',
    'themeClass' => 'Classe du thème',
    'available' => 'Disponible',
    'hostname' => 'Nom d’hôte',
    'backendTheme' => 'Thème de back-office',
    'theme.%name%.no_creation.already_exists' => 'Le thème %name% n’a pas été créé car il existe déjà.',
    'user.%name%.updated' => 'Le compte d’utilisateur %name% a été mis à jour.',
    'user.%user%.role.%role%.linked' => 'Le rôle «%role%» a été assigné à l’utilisateur %user%.',
    'user.%name%.role_removed' => 'Un rôle a été retiré de l’utilisateur %name%.',
    'user.%user%.group.%group%.linked' => 'L’utilisateur %user% a rejoint le groupe %group%.',
    'user.%user%.group.%group%.removed' => 'L’utilisateur %user% a été retiré du groupe %group%.',
    'user.%name%.created' => 'Le compte utilisateur «%name%» a été créé.',
    'user.%name%.deleted' => 'Le compte utilisateur «%name%» a été supprimé.',
    'user.facebook_name.%name%._does_not_exist' => 'L’identifiant utilisateur Facebook «%name%» n’existe pas.',
    'passwordVerify' => 'Confirmer le mot de passe',
    'firstName' => 'Prénom',
    'lastName' => 'Nom',
    'phone' => 'Téléphone',
    'company' => 'Société',
    'job' => 'Poste',
    'birthday' => 'Date de naissance',
    'facebookName' => 'Identifiant utilisateur Facebook',
    'role.%name%.created' => 'Le rôle «%name%» a été créé.',
    'role.%name%.deleted' => 'Le rôle «%name%» a été supprimé.',
    'role.%name%.updated' => 'Le rôle «%name%» a été mis à jour.',
    'role.name.must_comply_with_standard' => 'Le nom du rôle doit être écrit en capitales et être préfixé de «ROLE_».',
    'role.name.already.exists' => 'Ce rôle existe déjà dans la base de donnée.',
    'role.required.cannot_be_updated' => 'Le rôle ne peut être mis à jour car il est requis par le système.',
    'role.is.required' => 'Rôle requis',
    'nodeType.imported.created' => 'Le type de nœud a été importé et enregistré.',
    'nodeType.imported.updated' => 'Le type de nœud a été importé et mis à jour.',
    'file.format.not_valid' => 'Le format du fichier n’est pas valide.',
    'file.not_uploaded' => 'Le fichier n’a pas été téléversé.',
    'nodeType.file' => 'Fichier du type de nœud',
    'tag.%name%.updated' => 'L’étiquette «%name%» a été mise à jour.',
    'tag.%name%.created' => 'L’étiquette «%name%» a été créée.',
    'tag.%name%.deleted' => 'L’étiquette «%name%» a été supprimée.',
    'child.tag.%name%.created' => 'L’étiquette enfante «%name%» a été créée.',
    'locked' => 'Verrouillé',
    'visible' => 'Visible',
    'invisible' => 'Invisible',
    'parent_tagId' => 'Id de l’étiquette parente',
    'tagName' => 'Identifiant unique de l’étiquette',
    'node.seo.updated' => 'Le référencement du nœud a été mis à jour.',
    'node.seo.not.updated' => 'Le référencement du nœud n’a pas pu être mis à jour.',
    'url_alias.%alias%.updated' => 'L’alias d’URL «%alias%» a été mis à jour.',
    'url_alias.%alias%.no_update.already_exists' => 'L’alias d’URL «%alias%» n’a pas été mis à jour car le nom utilisé existe déjà.',
    'url_alias.%alias%.deleted' => 'L’alias d’URL «%alias%» a été supprimé.',
    'url_alias.%alias%.created.%translation%' => 'L’alias d’URL «%alias%» a été créé pour la traduction %translation%.',
    'url_alias.%alias%.no_creation.already_exists' => 'L’alias d’URL «%alias%» n’a pas été créé car le nom utilisé existe déjà.',
    'url_alias.no_translation.%translation%' => 'L’alias d’URL n’a pas été créé car la traduction %translation% n’existe pas.',
    'urlAlias' => 'Alias d’URL',
    'translation' => 'Traduction',
    'metaTitle' => 'Titre « méta »',
    'metaKeywords' => 'Mots-clef « méta »',
    'metaDescription' => 'Description « méta »',
    'nodeTypeField.%name%.updated' => 'Le champ «%name%» de type de nœud a été mis à jour.',
    'nodeTypeField.%name%.created' => 'Le champ «%name%» de type de nœud a été créé.',
    'nodeTypeField.%name%.deleted' => 'Le champ «%name%» de type de nœud a été supprimé.',
    'label' => 'Label',
    'type' => 'Type',
    'indexed' => 'Indexé',
    'defaultValues' => 'Valeur(s) par défaut',
    'enter_values_comma_separated' => 'Entrez les valeurs séparées par des virgules…',
    'node.%name%.translated' => 'Le nœud «%name%» a été traduit.',
    'node_source.%node_source%.updated.%translation%' => 'La source de nœud «%node_source%» a été mise à jour pour la traduction «%translation%».',
    'node.%node%.linked.tag.%tag%' => 'Le nœud «%node%» a été étiqueté «%tag%».',
    'tag.%name%.removed' => 'L’étiquette «%name%» a été retirée.',
    'node.%name%.created' => 'Le nœud «%name%» a été créé.',
    'child_node.%name%.created' => 'Le nœud enfant «%name%» a été créé.',
    'node.%name%.deleted' => 'Le nœud «%name%» a été supprimé.',
    'nodeName' => 'Nom du nœud',
    'nodeType' => 'Type de nœud',
    'priority' => 'Priorité',
    'node.isHome' => 'Utiliser ce nœud comme page d\'accueil',
    'choose.tag' => 'Choisir les étiquettes',
    'nodeType.%name%.updated' => 'Le type de nœud «%name%» a été mis à jour.',
    'nodeType.%name%.created' => 'Le type de nœud «%name%» a été créé.',
    'nodeType.%name%.deleted' => 'Le type de nœud «%name%» a été supprimé.',
    'nodeType.displayName' => 'Nom affiché',
    'nodeType.newsletterType' => 'Réservé aux newsletters ?',
    'nodeType.hidingNodes' => 'Cache ses nœuds ?',
    'role.imported' => 'Un rôle a été importé',
    'role.file' => 'Fichier de rôles',
    'setting.%name%.updated' => 'Le paramètre «%name%» a été mis à jour.',
    'setting.%name%.created' => 'Le paramètre «%name%» a été créé.',
    'setting.%name%.deleted' => 'Le paramètre «%name%» a été supprimé.',
    'setting.%name%.no_update.already_exists' => 'Le paramètre «%name%» n’a pas été mis à jour car le nom utilisé existe déjà.',
    'setting.%name%.no_creation.already_exists' => 'Le paramètre «%name%» n’a pas été créé car le nom utilisé existe déjà.',
    'value' => 'Valeur',
    'setting.group' => 'Groupe',
    'database.schema.updated' => 'Le schéma de la base de données a été mis à jour.',
    'database.schema.cannot_updated' => 'Le schéma de la base de données n’a pas pu être mis à jour.',
    'group.imported.updated' => 'Le groupe a été importé et mis à jour.',
    'group.file' => 'Fichier de groupe',
    'font.%name%.created' => 'La fonte «%name%» a été créée',
    'font.%name%.deleted' => 'La fonte «%name%» a été supprimée.',
    'font.%name%.updated' => 'La fonte «%name%» a été mise à jour.',
    'font.name' => 'Nom',
    'font.variant' => 'Variante',
    'font.hash' => 'Identifiant CSS de la fonte',
    'font.eotFile' => 'Fichier EOT',
    'font.woffFile' => 'Fichier WOFF',
    'font.woff2File' => 'Fichier WOFF2',
    'font.otfFile' => 'Fichier OTF/TTF',
    'font.svgFile' => 'Fichier SVG',
    'setting.imported' => 'Le paramètre a bien été importé.',
    'settingFile' => 'Fichier de paramètre',
    'translation.%name%.made_default' => 'La traduction «%name%» est à présent la langue principale.',
    'translation.%name%.updated' => 'La traduction «%name%» a été mise à jour.',
    'translation.%name%.created' => 'La traduction «%name%» a été créée.',
    'translation.%name%.deleted' => 'La traduction «%name%» a été supprimée.',
    'translation.%name%.cannot_delete_default_translation' => 'La traduction «%name%» ne être supprimée car il s’agit de la langue principale.',
    'locale' => 'Locale',
    'add.tag' => 'Ajouter l’étiquette',
    'add.child.tag' => 'Ajouter l’étiquette enfante',
    'tags' => 'Étiquettes',
    'id' => 'Id',
    'actions' => 'Actions',
    'notranslation_available.tag' => 'Aucune traduction disponible pour cette étiquette.',
    'edit.node.%name%.seo' => '%name%',
    'edit.node.seo' => 'Éditer le référencement du nœud',
    'save' => 'Sauvegarder',
    'add.urlAlias' => 'Ajouter l’alias d’Url',
    'unlink.tag.%name%' => 'Délier l’étiquette «%name%»',
    'are_you_sure.unlink.tag' => 'Êtes-vous sûr(e) de vouloir délier l’étiquette ?',
    'cancel' => 'Annuler',
    'edit.nodeType.%name%' => '%name%',
    'edit.tag.%name%' => '%name%',
    'edit.tag' => 'Éditer l’étiquette',
    'add.tag.%name%.child' => 'Ajouter une sous-étiquette dans «%name%»',
    'delete.tag.%name%' => 'Supprimer l’étiquette «%name%»',
    'delete.tag' => 'Supprimer l’étiquette',
    'edit.user.%name%.groups' => '%name%',
    'group' => 'Groupe',
    'unlink' => 'Délier',
    'add.group' => 'Ajouter le groupe',
    'add.user' => 'Ajouter l’utilisateur',
    'back_to.users' => 'Retourner à la liste des utilisateurs',
    'edit.group.%name%' => '%name%',
    'Welcome' => 'Bienvenue',
    'edit.user.%name%' => '%name%',
    'import.setting' => 'Importer',
    'import' => 'Importer',
    'hello.%name%' => 'Salut %name% !',
    'back_to.tags' => 'Retourner à la liste des étiquettes',
    'edit' => 'Éditer',
    'edit.setting.%name%' => '%name%',
    'back_to.settings' => 'Retourner à la liste des paramètres',
    'are_you_sure.delete.tag' => 'Êtes-vous sûr(e) de vouloir supprimer cette étiquette ?',
    'search' => 'Rechercher',
    'goto.page' => 'Aller à la page',
    'prev' => 'Préc.',
    'next' => 'Suiv.',
    'delete.user.%name%' => 'Supprimer l’utilisateur «%name%»',
    'are_you_sure.delete.user' => 'Êtes-vous sûr(e) de vouloir supprimer cet utilisateur ?',
    'edit.group.%name%.roles' => '%name%',
    'role' => 'Rôle',
    'unlink.role' => 'Délier le rôle',
    'add.role' => 'Ajouter le rôle',
    'delete.user' => 'Supprimer l’utilisateur',
    'translations' => 'Traductions',
    'add.translation' => 'Ajouter la traduction',
    'translation.locale' => 'Locale',
    'not_available' => 'Non disponible',
    'set.default' => 'Rendre principale',
    'edit.nodeSource.%name%' => '%name%',
    'back_to.documents' => 'Retourner à la liste des documents',
    'delete.document' => 'Supprimer le document',
    'edit.nodeTypeFields.for.nodeType.%name%' => '%name%',
    'back_to.nodeTypes' => 'Retourner à la liste des types de nœud',
    'add.nodeTypeField' => 'Ajouter le champ de type de nœud',
    'remove.user.%name%.from.group.%group%' => 'Retirer l’utilisateur «%name%» du groupe «%group%».',
    'are_you_sure.remove.user.from.group' => 'Êtes-vous sûr(e) de vouloir retirer l’utilisateur du groupe ?',
    'edi.user.%name%.roles' => '%name%',
    'specific.roles' => 'Rôles spécifiques',
    'inherited.roles' => 'Rôles hérités',
    'add.specific.role' => 'Ajouter le rôle spécifique',
    'import.role' => 'Importer',
    'edit.node.%name%.tags' => '%name%',
    'back_to.groups' => 'Retourner à la liste des groupes',
    'delete.group' => 'Supprimer le groupe',
    'user.edit' => 'Informations',
    'user.roles' => 'Rôles',
    'user.groups' => 'Groupes',
    'user.history' => 'Historique',
    'delete.document.%name%' => 'Supprimer le document «%name%»',
    'are_you_sure.delete.document' => 'Êtes-vous sûr(e) de vouloir supprimer ce document ?',
    'group.edit' => 'Informations',
    'group.roles' => 'Rôles',
    'group.users' => 'Utilisateurs',
    'remove.user.%name%.role.%role%' => 'Retirer le rôle «%role%» de l’utilisateur «%name%»',
    'are_you_sure.remove.user.role' => 'Êtes-vous sûr(e) de vouloir retirer le rôle à l’utilisateur ?',
    'add.theme' => 'Ajouter le thème',
    'back_to.themes' => 'Retourner à la liste des thèmes',
    'unlink.user.%name%' => 'Délier l’utilisateur «%name%»',
    'add.node' => 'Ajouter le nœud',
    'In' => 'Dans',
    'back_to.nodes' => 'Retourner à la liste des nœuds',
    'nodeTree' => 'Arborescence',
    'dashboard' => 'Tableau de bord',
    'history' => 'Historique',
    'comments' => 'Commentaires',
    'themes' => 'Thèmes',
    'theme' => 'Thème',
    'theme.classname' => 'Nom de la classe',
    'theme.host' => 'Domaine',
    'all.hostnames' => 'Tous les noms de domaines',
    'theme.disabled' => 'Désactivé',
    'theme.backend' => 'Back-office',
    'roles' => 'Rôles',
    'export.all.roles' => 'Exporter tout',
    'export' => 'Exporter',
    'role.required' => 'Rôle requis',
    'welcome' => 'Bienvenue',
    'back_to.roles' => 'Retourner à la liste des rôles',
    'delete.role' => 'Supprimer le rôle',
    'add' => 'Ajouter',
    'tag.%name%.tree' => 'Arborescence de «%name%»',
    'edit.role.%name%' => '%name%',
    'settings' => 'Paramètres',
    'add.setting' => 'Ajouter le paramètre',
    'Delete' => 'Supprimer',
    'create.node' => 'Créer le nœud',
    'node.type' => 'Type de nœud',
    'node.status' => 'État',
    'last.modification' => 'Dernière modification',
    'node.not.published' => 'Non publié',
    'see.nodetree' => 'Voir l’arborescence',
    'import.group' => 'Importer',
    'purge.cache' => 'Purger les caches',
    'are_you_sure.purge.cache' => 'Êtes-vous sûr(e) de vouloir purger les caches ?',
    'clear' => 'Effacer',
    'fonts' => 'Fontes',
    'add.font' => 'Ajouter la fonte',
    'font.files' => 'Fichiers',
    'font.cssfamily' => 'Famille CSS',
    'download' => 'Télécharger',
    'unlink.role.%name%' => 'Délier le rôle «%name%»',
    'are_you_sure.remove.role.from.group' => 'Êtes-vous sûr(e) de vouloir retirer le rôle du groupe ?',
    'users' => 'Utilisateurs',
    'user.username' => 'Nom d’utilisateur',
    'edit.theme' => 'Éditer le thème',
    'edit.tag.%name%.settings' => 'Paramètres',
    'delete.font.%name%' => 'Supprimer la fonte «%name%»',
    'are_you_sure.delete.font' => 'Êtes-vous sûr(e) de vouloir supprimer la fonte ?',
    'search.node' => 'Rechercher un nœud',
    'edit.nodeTypeField.%name%' => '%name%',
    'delete.caches' => 'Purger les caches',
    'logout' => 'Se déconnecter',
    'dev_mode.activated' => 'Mode développement activé',
    'help' => 'Aide',
    'datetime' => 'Date et heure',
    'level' => 'Niveau',
    'message' => 'Message',
    'back_to.nodeTypeFields' => 'Retourner à la liste des champs du type de nœud',
    'delete.nodeTypeField' => 'Supprimer le champ de type de nœud',
    'edit.node.%name%' => '%name%',
    'edit.node' => 'Éditer le nœud',
    'add.node.%name%.child' => 'Ajouter un nœud enfant à «%name%»',
    'add.child.node' => 'Ajouter le nœud enfant',
    'delete.node.%name%' => 'Supprimer le nœud «%name%»',
    'delete.node' => 'Supprimer le nœud',
    'see.page' => 'Voir la page',
    'preview.page' => 'Prévisualiser la page',
    'duplicate' => 'Dupliquer',
    'add.child' => 'Ajouter un enfant',
    'statuses' => 'Statuts',
    'visibility' => 'Visible',
    'published' => 'Publié',
    'hiding-children' => 'Conteneur',
    'lock-status' => 'Verrouillé',
    'sterile-status' => 'Stérile',
    'archive-status' => 'Archivage',
    'edit.document.%name%' => '%name%',
    'delete.nodeTypeField.%name%' => 'Supprimer le champ «%name%» du type de nœud',
    'arz_you_sure.delete.nodeTypeField' => 'Êtes-vous sûr(e) de vouloir supprimer le champ de type de nœud ?',
    'delete.theme.%name%' => 'Supprimer le thème «%name%»',
    'are_you_sure.delete.theme' => 'Êtes-vous sûr(e) de vouloir supprimer ce thème ?',
    'edit.group.%name%.users' => '%name%',
    'unlink.user' => 'Délier l’utilisateur',
    'delete.group.%name%' => 'Supprimer le groupe «%name%»',
    'are_you_sure.delete.group' => 'Êtes-vous sûr(e) de vouloir supprimer ce groupe ?',
    'see.website' => 'Voir le site web',
    'minify.tree.panel' => 'Replier le panneau d’arborescence',
    'interactions' => 'Interactions',
    'manage.surveys' => 'Formulaires personalisés',
    'manage.newsletters' => 'Newsletters',
    'manage.subscribers' => 'Abonnés',
    'manage.comments' => 'Commentaires',
    'manage.tags' => 'Étiquettes',
    'manage.documents' => 'Documents',
    'construction' => 'Construction',
    'manage.nodes' => 'Nœuds',
    'manage.nodeTypes' => 'Types de nœud',
    'manage.translations' => 'Traductions',
    'manage.themes' => 'Thèmes',
    'manage.fonts' => 'Fontes',
    'user.system' => 'Système d’utilisateurs',
    'manage.users' => 'Utilisateurs',
    'manage.roles' => 'Rôles',
    'manage.groups' => 'Groupes d’utilisateurs',
    'site.settings' => 'Paramètres du site',
    'Translate' => 'Traduire',
    'are_you_sure.delete.node.and.data' => 'Êtes-vous sûr(e) de vouloir supprimer ce nœud, ses enfants et toutes ses données ?',
    'node.content' => 'Contenu',
    'node.parameters' => 'Paramètres',
    'seo' => 'Référencement',
    'tree' => 'Arborescence',
    'back_to.fonts' => 'Retourner à la liste des fontes',
    'import.nodeType' => 'Importer',
    'back_office' => 'Backstage',
    'login' => 'Se connecter',
    'view.site' => 'Voir le site web',
    'forgot.password' => 'Mot de passe oublié ?',
    'nodeTypes' => 'Types de nœud',
    'add.nodeType' => 'Ajouter le type de nœud',
    'nodeType.entityName' => 'Nom de l’entité',
    'fields' => 'Champs',
    'manage.nodeTypeFields' => 'Champs du type de nœud',
    'delete.nodeType' => 'Supprimer le type de nœud',
    'edit.translation.%name%' => '%name%',
    'back_to.translations' => 'Retourner à la liste des traductions',
    'delete.translation' => 'Supprimer la traduction',
    'edit.node.%name%.tree' => '%name%',
    'tag.color' => 'Couleur',
    'tag.tree' => 'Arborescence',
    'tag.content' => 'Contenu',
    'tag.settings' => 'Paramètres',
    'tag.nodes' => 'Nœuds',
    'tagged.nodes' => 'Nœuds étiquetés',
    'groups' => 'Groupes',
    'export.all.groups' => 'Exporter tout',
    'group.required' => 'Groupe requis',
    'delete.nodeType.%name%' => 'Supprimer le type de nœud «%name%»',
    'are_you_sure.delete.nodeType.and.nodes.newsletters' => 'Êtes-vous sûr(e) de vouloir supprimer ce type de nœud ? Cela supprimera la totalité des nœuds, contenus et des newsletters liés. Nous vous conseillons d’effectuer une sauvegarde avant de continuer.',
    'upload.document' => 'Téléverser',
    'upload' => 'Téléverser',
    'edit.font.%name%' => '%name%',
    'edit.font' => 'Éditer la fonte',
    'edit.document' => 'Éditer le document',
    'unlink.document' => 'Délier le document',
    'delete.role.%name%' => 'Supprimer le rôle «%name%»',
    'are_you_sure.delete.role' => 'Êtes-vous sûr(e) de vouloir supprimer ce rôle ?',
    'wait_for.authentification' => 'En attente d’authentification…',
    'documents' => 'Documents',
    'document.thumbnail' => 'Aperçu',
    'document.filename' => 'Nom du fichier',
    'document.createdAt' => 'Date de création',
    'documents.toggle-explorer' => 'Explorateur',
    'documents.toggle-uploader' => 'Téléverseur',
    'documents.toggle-embedder' => 'Intégrateur',
    'delete.translation.%name%' => 'Supprimer la traduction «%name%»',
    'are_you_sure.delete.translation.and.node.data' => 'Êtes-vous sûr(e) de vouloir supprimer cette traduction ? Cela supprimera la totalité des contenus traduits. Nous vous conseillons d’effectuer une sauvegarde avant de continuer.',
    'delete.setting.%name%' => 'Supprimer le paramètre «%name%»',
    'are_you_sure.delete.setting' => 'Êtes-vous sûr(e) de vouloir supprimer le paramètre ?',
    'translate' => 'Traduire',
    'translate.node' => 'Traduire le nœud',
    'title' => 'Titre',
    'page' => 'Page',
    'choose.value' => 'Choisissez une valeur',
    '{0} no.item|{1} 1.item|]1,Inf] %count%.items' => '{0} Aucun objet|{1} <span>1</span> objet|]1,Inf] <span>%count%</span> objets',
    '1.item' => '1 objet',
    '%count%.items' => '%count% objets',
    '{0} no.role|{1} 1.role|]1,Inf] %count%.roles' => '{0} Aucun rôle|{1} 1 rôle|]1,Inf] %count% rôles',
    '1.role' => '1 rôle',
    '%count%.roles' => '%count% rôles',
    '{0} no.group|{1} 1.group|]1,Inf] %count%.groups' => '{0} Aucun groupe|{1} 1 groupe|]1,Inf] %count% groupes',
    '1.group' => '1 groupe',
    '%count%.groups' => '%count% groupes',
    '{0} no.user|{1} 1.user|]1,Inf] %count%.users' => '{0} Aucun utilisateur|{1} 1 utilisateur|]1,Inf] %count% utilisateurs',
    '1.user' => '1 utilisateur',
    '%count%.users' => '%count% utilisateurs',
    '{0} no.tag|{1} 1.tag|]1,Inf] %count%.tags' => '{0} Aucune étiquette|{1} 1 étiquette|]1,Inf] %count% étiquettes',
    '1.tag' => '1 étiquette',
    '%count%.tags' => '%count% étiquettes',
    '{0} no.document|{1} 1.document|]1,Inf] %count%.documents' => '{0} Aucun document|{1} 1 document|]1,Inf] %count% documents',
    '1.document' => '1 document',
    '%count%.documents' => '%count% documents',
    '{0} no.node|{1} 1.node|]1,Inf] %count%.nodes' => '{0} Aucun nœud|{1} 1 nœud|]1,Inf] %count% nœuds',
    '1.node' => '1 nœud',
    '%count%.nodes' => '%count% nœuds',
    '{0} no.nodeTypeField|{1} 1.nodeTypeField|]1,Inf] %count%.nodeTypeFields' => '{0} Aucun champ|{1} 1 champ|]1,Inf] %count% champs',
    '1.nodeTypeField' => '1 champ',
    '%count%.nodeTypeFields' => '%count% champs',
    'string.type' => 'Chaîne de caractères',
    'date-time.type' => 'Date et heure',
    'date.type' => 'Date',
    'text.type' => 'Texte',
    'markdown.type' => 'Markdown',
    'json.type' => 'Code JSON',
    'css.type' => 'Code CSS',
    'boolean.type' => 'Booléen',
    'integer.type' => 'Nombre entier',
    'decimal.type' => 'Nombre décimal',
    'email.type' => 'Email',
    'single-choice.type' => 'Choix simple',
    'multiple-choice.type' => 'Choix multiple',
    'documents.type' => 'Documents',
    'children-nodes.type' => 'Nœuds enfants',
    'add.a.%nodeType%' => 'Ajouter un(e) %nodeType%',
    'bad.request' => 'Mauvaise requête',
    'document.platform' => 'Plateforme',
    'document.embedId' => 'Identifiant du média',
    '%field%.is.reserved.word' => 'Le nom «%field%» est un mot réservé.',
    'settingGroup' => 'Groupe de paramètres',
    '%group%.settings' => 'Paramètres',
    'settingGroup.%name%.updated' => 'Le groupe de paramètres «%name%» a été mis à jour.',
    'settingGroup.%name%.created' => 'Le groupe de paramètres «%name%» a été crée.',
    'settingGroup.%name%.deleted' => 'Le groupe de paramètres «%name%» a été supprimé.',
    'settingGroup.%name%.no_update.already_exists' => 'Le groupe de paramètres «%name%» n’a pas été mis à jour car le nom utilisé existe déjà.',
    'settingGroup.%name%.no_creation.already_exists' => 'Le groupe de paramètres «%name%» n’a pas été créé car le nom utilisé existe déjà.',
    'settingGroup.in.menu' => 'Affiché dans le menu ?',
    'see.settings' => 'Voir les paramètres',
    'add.settingGroup' => 'Ajouter le groupe de paramètres',
    'edit.settingGroup.%name%' => '%name%',
    'save.settingGroup' => 'Sauvegarder',
    'are_you_sure.delete.settingGroup' => 'Êtes-vous sûr(e) de vouloir supprimer le groupe de paramètres ?',
    'delete.settingGroup.%name%' => 'Supprimer le groupe de paramètres «%name%»',
    'delete.settingGroup' => 'Supprimer le groupe de paramètres',
    'back_to.settingGroups' => 'Retourner à la liste des groupes de paramètres',
    'all.settings' => 'Tous les paramètres',
    'setting.groups' => 'Groupes de paramètres',
    'settingGroups' => 'Groupes de paramètres',
    'display_debug_panel' => 'Afficher le panneau de déboguage',
    'soundcloud_client_id' => 'Soundcloud : Id client',
    'google_client_id' => 'Google API - Clef navigateur',
    'google_server_id' => 'Google API - Clef serveur',
    'twitter_client_id' => 'Twitter : Id client',
    'facebook_client_id' => 'Facebook : Id client',
    'seo_description' => 'Description de référencement',
    'site_copyright' => 'Copyright du site',
    'maintenance_mode' => 'Mode de maintenance',
    'universal_analytics_id' => 'Code de suivi Universal Analytics',
    'facebook_url' => 'Url Facebook',
    'instagram_url' => 'Url Instagram',
    'twitter_url' => 'Url Twitter',
    'twitter_account' => 'Compte Twitter',
    'recaptcha_public_key' => 'Clef publique Recaptcha (sitekey)',
    'recaptcha_private_key' => 'Clef privée Recaptcha (secret)',
    'you_must_show_youre_not_robot' => 'Vous devez valider le Recaptcha pour vérifier que vous n’êtes pas un robot.',
    'recaptcha_is_invalid.try_again' => 'Le Recaptcha est invalide, veuillez réessayer.',
    'document.%name%.usage' => 'Utilisation',
    'usage.fieldName' => 'Utilisé pour le champ',
    'nodeType.name' => 'Type de nœud',
    'document.usage' => 'Utilisation',
    'document.edit' => 'Édition',
    'document.preview' => 'Aperçu',
    'all.nodes' => 'Tous les nœuds',
    'draft.nodes' => 'Brouillons',
    'pending.nodes' => 'En attente de validation',
    'archived.nodes' => 'Archivés',
    'deleted.nodes' => 'Supprimés',
    'node.draft' => 'Brouillon',
    'node.pending.validation' => 'En attente de validation',
    'node.archived' => 'Archivé',
    'node.deleted' => 'Supprimé',
    'draft' => 'Brouillon',
    'pending' => 'En attente de validation',
    'archived' => 'Archivé',
    'deleted' => 'Supprimé',
    'undelete' => 'Sortir de la corbeille',
    'are_you_sure.undelete.node.and.data' => 'Êtes-vous sûr(e) de vouloir remettre ce nœud et ses données à leur place initiale ?',
    'undelete.node.%name%' => 'Sortir le nœud «%name%» de la corbeille',
    'parameters' => 'Paramètres',
    'embed.document' => 'Intégrer',
    'embed' => 'Intégrer',
    'tagTree' => 'Étiquettes',
    'node.%node%.linked.tags' => 'Le nœud «%node%» a été étiqueté.',
    'list.tags.to_link' => 'Lister les étiquettes à lier au nœud…',
    'use.new_or_existing.tags_with_hierarchy' => 'Utiliser une étiquette nouvelle ou existante en tenant compte de l’arborescence…',
    'add.stack.type' => 'Ajouter le type de pile',
    'stack.types' => 'Types de pile',
    'remove' => 'Retirer',
    'stack_node.%name%.has_new_type.%type%' => 'La pile de nœuds «%name%» est liée à un nouveau type «%type%».',
    'field.%name%.updated' => 'Le champ %name% a été mis à jour.',
    'field.%nodeTypeFieldId%.not_exists' => 'Le champ %nodeTypeFieldId% n’existe pas.',
    'created.at' => 'Date de création',
    'updated.at' => 'Date de modification',
    'position' => 'Position',
    'empty.node.trash' => 'Vider la corbeille de nœuds',
    'node.trash.emptied' => 'La corbeille de nœuds a été vidée.',
    'empty.trash' => 'Vider la corbeille',
    'are_you_sure.empty.node.and.data.trash' => 'Êtes-vous sûr(e) de vouloir vider la corbeille de nœuds ? Toutes les données seront définitivement perdues.',
    'random.document' => 'J’ai de la chance…',
    'document.format.unknown' => 'Le format du document est inconnu.',
    'no.embed.document.found' => 'Aucun document à intégrer n’a été trouvé.',
    'embed.document.already_exists' => 'Le document à intégrer existe déjà.',
    'document.metas' => 'Méta-données',
    'delete.document.translation.%name%' => 'Supprimer les méta-données du document pour la traduction «%name%».',
    'are_you_sure.delete.document.translation' => 'Êtes-vous sûr(e) de vouloir supprimer les méta-données du document ?',
    'document.translation.%name%.updated' => 'Les méta-données du document «%name%» ont été mises à jour.',
    'document.translation.%name%.deleted' => 'Les méta-données du document «%name%» ont été supprimées.',
    'document.translation.%name%.cannot_delete' => 'Les méta-données du document «%name%» ne peuvent pas être supprimées.',
    'folderTree' => 'Dossiers de documents',
    'add.folder' => 'Ajouter le dossier',
    'add.child.folder' => 'Ajouter le sous-dossier',
    'edit.folder' => 'Éditer le dossier',
    'delete.folder' => 'Supprimer le dossier',
    'back_to.folders' => 'Retourner à la liste des dossiers',
    'delete.folder.%name%' => 'Supprimer le dossier «%name%»',
    'are_you_sure.delete.folder' => 'Êtes-vous sûr(e) de vouloir supprimer ce dossier ?',
    'edit.folder.%name%' => '%name%',
    'folders' => 'Dossiers de documents',
    'default.translation' => 'Traduction principale',
    'nodeTypeField.minLength' => 'Longueur minimale',
    'nodeTypeField.maxLength' => 'Longueur maximale',
    'export.all.nodes' => 'Exporter tout',
    'drop.files.here.to.upload.or.click.to.open.your.explorer' => 'Déposer ici les fichiers à téléverser ou cliquer pour ouvrir l’explorateur.',
    'your.browser.does.not.support.dragndrop.file.uploads' => 'Votre navigateur ne prend pas en charge le téléversement de fichier par glisser-déposer.',
    'please.use.the.fallback.form.below.to.upload.your.files.like.in.the.olden.days' => 'Veuillez utiliser le formulaire classique ci-dessous pour téléverser vos fichiers comme à l’ancien temps.',
    'file.is.too.big.({{filesize}}mib).max.filesize.{{maxFilesize}}.mib' => 'Le fichier est trop lourd ({{filesize}} Mo). La taille maximale est de {{maxFilesize}} Mo.',
    'you.cant.upload.files.of.this.type' => 'Vous ne pouvez pas téléverser de fichiers de ce type.',
    'server.responded.with.{{statuscode}}.code' => 'Le serveur a répondu avec le code {{statuscode}}.',
    'cancel.upload' => 'Annuler le téléversement',
    'are.you.sure.you.want.to.cancel.this.upload' => 'Êtes-vous de vouloir annuler ce transfert ?',
    'remove.file' => 'Retirer le fichier',
    'you.can.not.upload.any.more.files' => 'Vous ne pouvez plus téléverser de fichiers.',
    'headline.2' => 'Titre de niveau 2',
    'headline.3' => 'Titre de niveau 3',
    'headline.4' => 'Titre de niveau 4',
    'headline.5' => 'Titre de niveau 5',
    'headline.6' => 'Titre de niveau 6',
    'fullscreen' => 'Plein-écran',
    'bold' => 'Gras',
    'italic' => 'Italique',
    'strikethrough' => 'Barré',
    'blockquote' => 'Citation',
    'link' => 'Lien',
    'image' => 'Image',
    'unordered.list' => 'Liste non-ordonnée',
    'ordered.list' => 'Liste ordonnée',
    'back' => 'Retour',
    'separator' => 'Séparateur',
    'non_breaking.space' => 'Espace insécable',
    'forbidden.page' => 'Page non autorisée',
    'see_all' => 'Voir tout',
    'search.documents' => 'Rechercher des documents',
    'search.nodes' => 'Rechercher des nœuds',
    'nodes.toggle-explorer' => 'Explorateur',
    'folder.name' => 'Nom du dossier',
    'nodeType.color' => 'Couleur',
    'nodeType.numberFields' => 'Nombre de champs',
    'back_to.top' => 'Haut de page',
    'no.customFormField' => 'Aucune question',
    'add.customForm' => 'Ajouter le formulaire personnalisé',
    'customForm' => 'Formulaires personnalisés',
    'customForm.displayName' => 'Titre affiché',
    '%count%.customFormFields' => '%count% questions',
    'manage.customFormFields' => 'Voir les questions',
    'customForm.answers' => 'Voir les réponses',
    'customForm.show' => 'Afficher le formulaire',
    'are_you_sure.delete.customFormAnswer' => 'Êtes-vous sûr(e) de vouloir supprimer ce formulaire personnalisé ?',
    'delete.customFormAnswer.%name%' => 'Supprimer la réponse «%name%»',
    'back_to.customFormAnswers' => 'Retourner aux réponses',
    'customFormAnswer' => 'Réponse du formulaire personnalisé',
    'back_to.customForms' => 'Retourner aux formulaires personnalisés',
    'submitted.date' => 'Date d’envoi',
    'customFormAnswer.answers' => 'Réponses',
    'customFormFieldAttribute' => 'Élement de réponse',
    'delete.customFormField' => 'Supprimer la question',
    'add.customFormField' => 'Ajouter la question',
    'back_to.customFormFields' => 'Retourner aux questions',
    'delete.customFormField.%name%' => 'Supprimer la question «%name%»',
    'are_you_sure.delete.customFormField' => 'Êtes-vous sûr(e) de vouloir supprimer cette question ?',
    'edit.customFormField.%name%' => '%name%',
    'edit.customFormFields.for.customForm.%name%' => 'Questions du formulaire «%name%»',
    'delete.customForm' => 'Supprimer le formulaire personnalisé',
    'delete.customForm.%name%' => 'Supprimer le formulaire personnalisé «%name%»',
    'are_you_sure.delete.customForm' => 'Êtes-vous sûr(e) de vouloir supprimer ce formulaire personnalisé ?',
    'edit.customForm.%name%' => '%name%',
    '{0} no.customFormField|{1} 1.customFormField|]1,Inf] %count%.customFormFields' => '{0} Aucune question|{1} 1 question|]1,Inf] %count% questions',
    'create.a.node' => 'Créer un nœud',
    'add.a.node' => 'Ajouter un nœud',
    'add.a.tag' => 'Ajouter une étiquette',
    'add.a.urlAlias' => 'Ajouter un alias d’Url',
    'add.a.child.node' => 'Ajouter un nœud enfant',
    'add.a.child.tag' => 'Ajouter une étiquette enfant',
    'add.a.nodeType' => 'Ajouter un type de noeud',
    'add.a.nodeTypeField' => 'Ajouter un champ de type de nœud',
    'add.a.translation' => 'Ajouter une traduction',
    'add.a.theme' => 'Ajouter un thème',
    'add.a.font' => 'Ajouter une fonte',
    'add.a.user' => 'Ajouter un utilisateur',
    'add.a.specific.role' => 'Ajouter un rôle spécifique',
    'add.a.group' => 'Ajouter un groupe',
    'add.a.role' => 'Ajouter un rôle',
    'add.a.setting' => 'Ajouter un paramètre',
    'add.a.settingGroup' => 'Ajouter un groupe de paramètres',
    'delete.font' => 'Supprimer la fonte',
    'add.a.customForm' => 'Ajouter un formulaire personnalisé',
    'customForm.color' => 'Couleur',
    'manage.customForms' => 'Formulaires personnalisés',
    'customForm.open' => 'Ouvert',
    'customForm.closeDate' => 'Date de fin',
    'add.a.customFormField' => 'Ajouter une question',
    'edit.customFormFields' => 'Éditer la question',
    'add.a.folder' => 'Ajouter un dossier',
    'node.hidden' => 'Caché',
    'required' => 'Requis',
    'delete.documents' => 'Supprimer les documents',
    'are_you_sure.delete.these.documents' => 'Êtes-vous sûr(e) de vouloir supprimer ces documents ?',
    'bulk.delete.documents' => 'Supprimer les documents sélectionnés',
    'main_color' => 'Couleur principale du back-office',
    'colour.type' => 'Couleur',
    'nodes.type' => 'Références de nœuds',
    'embed.preview' => 'Aperçu du média',
    'customFormAnswer.%id%.deleted' => 'La réponse #%id% a été supprimée',
    'customFormField.%name%.updated' => 'La question «%name%» a été mise à jour',
    'customFormField.%name%.created' => 'La question «%name%» a été créée',
    'customFormField.%name%.deleted' => 'La question «%name%» a été supprimée',
    'duplicated.node.%name%' => 'Le nœud «%name%» a bien été dupliqué',
    'impossible.duplicate.node.%name%' => 'Impossible de dupliquer le nœud «%name%»',
    'list.folders.to_link' => 'Lister les dossiers (existants ou non)',
    'bulk.fold.documents' => 'Lier les documents sélectionnés',
    'documents.linked_to.folders' => 'Les documents ont bien été liés aux dossiers',
    'no_documents.linked_to.folders' => 'Aucun document n’a été lié aux dossiers',
    'wrong.request' => 'Mauvaise requête',
    'delete.nodes' => 'Supprimer les nœuds sélectionnés',
    'are_you_sure.delete.these.nodes' => 'Êtes-vous sûr(e) de vouloir supprimer ces nœuds ?',
    'delete.all' => 'Tout supprimer',
    'bulk.delete.nodes' => 'Supprimer la sélection',
    'link.tags' => 'Étiqueter la sélection',
    'unlink.tags' => 'Désétiqueter la sélection',
    'list.tags.to_link.or_unlink' => 'Lister les étiquettes à lier ou à délier…',
    'nodes.bulk.deleted' => 'La sélection de nœuds a été supprimée',
    'nodes.bulk.not_tagged' => 'Impossible d’étiqueter la sélection',
    'nodes.bulk.tagged' => 'La sélection de nœuds a été étiquetée',
    'nodes.bulk.not_untagged' => 'Impossible de désétiqueter la sélection',
    'nodes.bulk.untagged' => 'La sélection de nœuds a été désétiquetée',
    'bulk.actions' => 'Actions groupées',
    'reset.marker' => 'Supprimer le marqueur',
    'geotag.type_an_address.then_type_enter' => 'Écrire une adresse puis taper «Entrer»…',
    'geographic.coordinates.type' => 'Coordonnées géographiques',
    'multiple.geographic.coordinates.type' => 'Coordonnées géographiques multiples',
    'link.folders' => 'Lier au(x) dossier(s)',
    'unlink.folders' => 'Délier du/des dossier(s)',
    'bulk.download.documents' => 'Télécharger les documents sélectionnés',
    'download.documents' => 'Télécharger les documents',
    'are_you_sure.download.these.documents' => 'Êtes-vous sûr(e) de vouloir télécharger ces documents ?',
    'purge.generated_images.cache' => 'Purger le cache des images',
    'are_you_sure.purge.generated_images.cache' => 'Êtes-vous sûr(e) de vouloir purger le cache des images ?',
    'delete.generated_images.cache' => 'Purger le cache des images',
    'more.documents' => 'Plus de documents',
    'more.nodes' => 'Plus de nœuds',
    'more.custom_forms' => 'Plus de formulaires',
    'search.custom_forms' => 'Rechercher un formulaire',
    'custom-forms.toggle-explorer' => 'Explorateur',
    'edit.account' => 'Modifier votre profil',
    'NodeType' => 'Type de nœud',
    'select.nodetype' => 'Filtrer',
    'ignore' => 'Indifférent',
    'true' => 'Oui',
    'false' => 'Non',
    'node.name' => 'Nom du nœud',
    'node.id.parent' => 'Identifiant du nœud parent',
    'node.datetime.operator' => 'Opérateur',
    'node.datetime.value' => 'Date de création',
    'node.limit.result' => 'Limite de résultats',
    'node.tags' => 'Étiquettes',
    'node.tag.exclusive' => 'Sélection d\'étiquettes exclusive',
    'nodetypefield' => 'Champs du type de nœud',
    'search.a.node' => 'Rechercher un nœud',
    'export.all.nodesSource' => 'Exporter les contenus des nœuds',
    'role.cannot.update.status' => 'Droits insuffisants pour appliquer ce statut',
    'node.%name%.%field%.updated' => 'Le champ "%field%" du nœud %name% a été mis à jour.',
    'added.node.%name%' => 'Le nœud « %name% » a été créé.',
    'custom-forms.type' => 'Formulaire personnalisé',
    'Bad credentials.' => 'Identifiants non reconnus',
    'User account has expired.' => 'Votre compte utilisateur a expiré.',
    'User account is locked.' => 'Votre compte utilisateur est bloqué.',
    'User credentials have expired.' => 'Vos identifiants de session ont expiré.',
    'User account is disabled.' => 'Votre compte utilisateur est désactivé.',
    'change.nodes.status' => 'Changement de statut groupé',
    'change.nodes.status.all' => 'Changer pour les nœuds sélectionnés',
    'are_you_sure.change-status.these.nodes' => 'Êtes-vous sûr(e) de vouloir changer le statut de ces nœuds ?',
    'nodes.status' => 'Statut de la sélection',
    'nodes.bulk.status.changed' => 'Le statut de la sélection a bien été changé.',
    'staticTheme' => 'Thème statique',
    'staticTheme.does_not.allow.node_url_routes' => 'Un « thème statique » signifie qu’il ne répondra pas aux requêtes provenant d’URL dynamiques des nœuds, seulement des routes statiques.',
    'theme.is_static' => 'Statique',
    'password.must.match' => 'Les mots de passe doivent correspondre',
    'passwords.must.match' => 'Les mots de passe doivent correspondre',
    'no.nodeType.available.create_one_first' => 'Aucun type de nœud n’est présent sur votre site. Veuillez en créer un avant d’ajouter de nouveaux nœuds.',
    'node.%name%.no_creation.already_exists' => 'Le nœud « %name% » ne peut pas être créé car son nom est déjà utilisé.',
    'node.dynamicNodeName' => 'Le nom du nœud est dynamique',
    'nodeType.status' => 'Statut',
    'nodeType.not_visible' => 'Type de nœud invisible',
    'newsletter.nodeType' => 'Type réservé aux newsletters',
    'nodeType.hiding_nodes' => 'Type cachant son arborescence',
    'newsletter.%name%.created' => 'La newsletter «%name%» a été créé.',
    'newsletter.%newsletter%.updated.%translation%' => 'La newsletter «%name%» a été mise à jour pour la traduction %translation%',
    'duplicated.newsletter.%name%' => 'La newsletter «%name%» a bien été dupliquée',
    'impossible.duplicate.newsletter.%name%' => 'Impossible de dupliquer la newsletter «%name%»',
    'see.newsletter' => 'Voir la newsletter',
    'add.a.newsletter' => 'Ajouter une newsletter',
    'edit.newsletter.%name%' => '%name%',
    'newsletter' => 'Newsletter',
    'newsletter.type' => 'Type de newsletter',
    'back_to.newsletter' => 'Retourner à la liste des newsletters',
    'create.a.newsletter' => 'Créer une newsletter',
    'export.html' => 'Exporter en HTML',
    'export.html.inline' => 'Exporter en HTML (CSS incorporé)',
    'start.test.user.right' => 'Prendre les privilèges',
    'stop.test.user.right' => 'Retourner à son utilisateur',
    'overwrite.document' => 'Mettre à jour le fichier',
    'document.file.%name%.updated' => 'Le fichier «%name%» a été mis à jour',
    'are_you_sure.delete.nodeSource' => 'Êtes-vous sûr(e) de vouloir supprimer cette traduction de nœud ?',
    'node_source.%node_source%.%translation%.cant.deleted' => 'La suppression de «%node_source%» en «%translation%» n\'est pas possible',
    'node_source.%node_source%.deleted.%translation%' => 'La suppression de «%node_source%» en «%translation%» n\'est pas possible',
    'delete.nodesource' => 'Supprimer la source du noeud',
    'latest.node-sources.updates' => 'Dernières sources modifiées',
    'customForm.%name%.updated' => 'Le formulaire personnalisé « %name% » a bien été mis à jour.',
    'customForm.%name%.created' => 'Le formulaire personnalisé « %name% » a bien été créé.',
    'customForm.%name%.deleted' => 'Le formulaire personnalisé « %name% » a bien été supprimé.',
    'customForm.%name%.cannot_rename_already_exists' => 'Le formulaire personnalisé « %name% » ne peut être renommé, le nom utilisé existe déjà.',
    'customForm.%name%.already_exists' => 'Le formulaire personnalisé « %name% » existe déjà.',
    'select.all' => 'Tout sélectionner',
    'deselect.all' => 'Tout désélectionner',
    'edit.user.%name%.roles' => 'Rôles de %name%',
    'history.for.%name%' => 'Historique de %name%',
    'admin_image' => 'Image/Logo de l’administration',
    'chroot.limited.one' => 'Vous ne pouvez choisir qu\'un seul nœud racine',
    'chroot' => 'Nœud racine',
    'node.noCreation.alreadyExists' => 'Le nœud n’a pas été créé car il existe déjà.',
    'maps_style' => 'Style par défaut Google Maps',
    'user.status' => 'Statut',
    'user.enabled' => 'Compte activé',
    'user.disabled' => 'Compte désactivé',
    'user.locked' => 'Compte verrouillé',
    'user.expired' => 'Compte expiré',
    'user.expiresAt' => 'Le compte s’expire le :',
    'user.force.expired' => 'Forcer l’expiration du compte',
    'user.credentialsExpiresAt' => 'Les identifiants du compte expirent le :',
    'user.force.credentialsExpired' => 'Forcer l’expiration des identifiants du compte',
    'edit.user.%name%.security' => 'Sécurité de « %name% »',
    'user.%name%.security.updated' => 'Les paramètres de sécurité du compte « %name% » ont été mis à jour.',
    'user.account.has-expired' => 'Le compte utilisateur a expiré.',
    'user.crendentials.has-expired' => 'Les identifiants du compte utilisateur ont expiré.',
    'user.last-login' => 'Date de la dernière connexion',
    'user.password-requested-at' => 'Date de la dernière demande de mot de passe',
    'never.requested' => 'Jamais',
    'year' => 'Année',
    'month' => 'Mois',
    'day' => 'Jour',
    'hour' => 'Heure',
    'minute' => 'Min.',
    'user.security' => 'Sécurité',
    'your.account.email' => 'Email lié à votre compte',
    '%email%.email.does.not.exist.in.user.account.database' => 'L’email « %email% » n’a pas été trouvé dans la base de donnée.',
    'to.get.new.password.enter.your.account.email' => 'Pour obtenir un nouveau mot de passe, veuillez entrer l’adresse email liée à votre compte utilisateur.',
    'request.new.password' => 'Envoyer la demande',
    'back_to.login' => 'Revenir à la page de connexion',
    'a.personal.password.reset.link.has.been.sent.to.your.account.email' => 'Un lien personnel de réinitialisation de mot de passe vous a été envoyé par email. N’attendez pas trop longtemps, ce lien expirera automatiquement.',
    'confirmation.token.is.invalid' => 'Le jeton de confirmation est invalide.',
    'confirmation.token.has.expired' => 'Le jeton de confirmation a expiré.',
    'choose.a.new.password' => 'Choisissez un nouveau mot de passe',
    'save.new.password' => 'Valider votre mot de passe',
    'your.new.password.has.been.saved' => 'Votre nouveau mot de passe a bien été enregistré.',
    'go_back_to.login.page.to.connect' => 'Vous pouvez revenir à la page de connexion.',
    'a.confirmation.email.has.already.be.sent' => 'Un email de confirmation vous a déjà été envoyé, veuillez vérifier dans vos courriers indésirables.',
    'email.invalid' => 'L’email est invalide ou n’existe pas.',
    'resultCache' => 'Cache des résultats',
    'hydratationCache' => 'Cache d’hydratation',
    'queryCache' => 'Cache de requêtes',
    'metadataCache' => 'Cache des méta-données',
    'no.cache.available' => 'Aucune implémentation de cache trouvée.',
    'homeNode.limited.one' => 'Vous ne pouvez choisir qu\'un seul nœud d\'accueil',
    'homeNode' => 'Nœud d\'accueil',
    'theme.root.limited.one' => 'Vous ne pouvez choisir qu\'un seul nœud racine',
    'themeRoot' => 'Nœud racine',
    'about.cms' => 'À propos de Roadiz',
    'news.version.release' => 'Une nouvelle version de Roadiz est dans les bacs',
    'lastest.version.installed' => 'Roadiz est à jour.',
    'current.version' => 'Version actuelle',
    'last.version' => 'Dernière version',
    'changelog' => 'Notes de mise à jour',
    'download.folder.content' => 'Télécharger le contenu du dossier',
    'not.valid.facebook.name' => 'Ce n’est pas un ID Facebook valide, vous pouvez aller sur http://lookup-id.com/ pour le retrouver.',
    'routePrefix' => 'Préfixe des routes statiques',
    'current.document.is.private.you.cannot.preview.it' => 'Le document actuel est marqué comme privé, vous ne pouvez pas afficher son aperçu.',
    'document.public_url' => 'URL publique',
    'document.filepath' => 'Chemin absolu du fichier',
    'download.document' => 'Télécharger le document',
    'static_domain_name' => 'Nom de domaine statique',
    'item-per-page.display.count' => 'Afficher :',
    'move.node.to.first.position' => 'Déplacer en début de liste',
    'move.node.to.last.position' => 'Déplacer en fin de liste',
    'node.hide' => 'Cacher',
    'node.show' => 'Rendre visible',
    'node.publish' => 'Publier',
    'node.unpublish' => 'Dépublier',
    'node.duplicate' => 'Dupliquer',
    'string.should.only.contain.latin.characters' => 'La chaîne de caractères ne devrait contenir que des caractères latins non-accentués',
    'string.should.not.be.a.sql.reserved.word' => 'La chaîne de caractères ne devrait pas être un mot réservé pour SQL',
    'This value should not be blank.' => 'Cette valeur ne devrait pas être vide.',
    'This value is not valid.' => 'Cette valeur n\'est pas valide.',
    'font_variant.regular' => 'Normal',
    'font_variant.italic' => 'Italique',
    'font_variant.bold' => 'Gras',
    'font_variant.bold.italic' => 'Gras italique',
    'font_variant.light' => 'Light',
    'font_variant.light.italic' => 'Light italique',
    'update.roadiz' => 'Mettre à jour Roadiz',
    'update.please_wait' => 'Mise à jour en cours, veuillez patienter…',
    'update.done.back_to_home' => 'Revenir à l’accueil',
    'update_roadiz.download_archive' => 'Roadiz est en train de télécharger la dernière archive disponible…',
    'update_roadiz.unarchive' => 'Roadiz est en train de décompresser l’archive de mise à jour…',
    'update_roadiz.move_new_files' => 'Roadiz jongle avec ses fichiers pour mettre à jour votre CMS favori…',
    'update_roadiz.clear_cache' => 'Roadiz est en train de vider son cache…',
    'update_roadiz.update_schema' => 'Roadiz est en train de migrer le schéma de sa base de données…',
    'update_roadiz.update_complete' => 'La mise à jour de Roadiz est maintenant terminée !',
    'automatic.upgrade' => 'Mise à jour automatisée',
    'always.make.a.database.backup.before.upgrade' => 'Vous devriez toujours effectuer une sauvegarde de la base de donnée avant d’utiliser la mise à jour automatisée.',
    'cannot_update_roadiz.using_git' => 'Impossible de mettre à jour Roadiz, vous l’avez installé avec Git. Veuillez mettre à jour manuellement…',
    'cannot_update_roadiz.using_symlink' => 'Impossible de mettre à jour Roadiz, vous l’avez installé en utilisant des liens symboliques. Veuillez le mettre à jour manuellement…',
    'cannot_update_roadiz.no_release_available' => 'Impossible de mettre à jour Roadiz, aucune mise à jour n’est disponible…',
    'cannot_update_roadiz.no_archive_to_download' => 'Impossible de mettre à jour Roadiz, il n’y a aucune archive à télécharger…',
    'cannot_update_roadiz.temp_archive_does_not_exist' => 'Impossible de mettre à jour Roadiz, l’archive temporaire est introuvable…',
    'cannot_update_roadiz.cant_open_archive' => 'Impossible de mettre à jour Roadiz, l’archive ne peut pas être décompressée…',
    'cannot_update_roadiz.cant_create_temp_dir' => 'Impossible de mettre à jour Roadiz, il ne peut pas créer de dossier temporaire…',
    'cannot_update_roadiz.destination_folder_does_not_exist' => 'Impossible de mettre à jour Roadiz, le dossier de destination n’existe pas…',
    'cannot_update_roadiz.destination_folder_is_not_writable' => 'Impossible de mettre à jour Roadiz, le dossier de destination n’est pas inscriptible…',
    'nodeName.alreadyExists' => 'Ce nom de nœud est déjà utilisé',
    'nodeName.alreadyExists.as.urlAlias' => 'Ce nom de nœud est déjà utilisé en tant qu’alias d’url',
    'new.version.available' => 'Nouvelle version disponible',
    'node.childrenOrder' => 'Les nœuds enfant sont ordonnés par',
    'node.childrenOrderDirection' => 'Direction de l’ordre des nœuds enfants',
    'createdAt' => 'Date de création',
    'updatedAt' => 'Date de mise à jour',
    'ascendant' => 'Ascendant',
    'descendant' => 'Descendant',
    'email.alreadyExists' => 'L’adresse email est déjà utilisée',
    'username.alreadyExists' => 'Le nom d’utilisateur est déjà utilisé',
    'tagName.alreadyExists' => 'Ce nom d‘étiquette est déjà utilisé',
    'nodeTypeField.name.alreadyExists' => 'Le nom du champ de type de nœud est déjà utilisé',
    'nodeType.name.alreadyExists' => 'Le nom du type de nœud est déjà utilisé',
    'color.should.be.formatted.in.hexadecimal' => 'La couleur doit être écrite en notation hexadécimale',
    'customFormField.name.alreadyExists' => 'Le nom du champ de formulaire personnalisé est déjà utilisé',
    'customForm.name.alreadyExists' => 'Le nom du formulaire personnalisé est déjà utilisé',
    'ip' => 'IP',
    'font.variant.alreadyExists' => 'La variante de fonte existe déjà',
    'file.is_not_a.valid.font.file' => 'Ce fichier n’est pas un fichier de fonte valide',
    'folder.%name%.updated' => 'Le dossier « %name% » a été mis à jour.',
    'folder.alreadyExists' => 'Le dossier existe déjà.',
    'folder.%name%.deleted' => 'Le dossier « %name% » a été supprimé',
    'no.folder.found' => 'Aucun dossier trouvé',
    'folder.does_not_exist' => 'Le dossier n’existe pas',
    'pinterest_url' => 'Url Pinterest',
    'use_cdn' => 'Utiliser un CDN pour les ressources',
    'force_locale' => 'Forcer la locale dans les Url',
    'nodeSourcesUrlsCache' => 'Cache des URL des sources de nœud',
    'translation.locale.alreadyExists' => 'Cette locale de traduction est déjà utilisée',
    'translation.override_locale.alreadyExists' => 'Cette locale de remplacement est déjà utilisée',
    'overrideLocale' => 'Locale de remplacement',
    'keep_me_logged_in' => 'Garder ma session active',
    'setting.theme' => 'Paramètres du thème',
    'unused_documents' => 'Documents non-utilisés',
    'node.offspring.published' => 'La descendance du nœud a été publiée',
    'are_you_sure.publish.node.offspring' => 'Êtes-vous sûr(e) de vouloir publier toute la descendance de ce nœud ?',
    'publish.node.%name%.offspring' => 'Publier la descendance de “%name%”',
    'publish_node_offspring' => 'Publier la descendance',
    'publish-all' => 'Publier la descendance',
    'groupName' => 'Nom du groupe',
    'embedId.does_not_exist' => 'L’identifiant de média externe n’existe pas.',
    'YoutubeEmbedFinder needs a Google server key.' => 'YoutubeEmbedFinder a besoin d’une clef serveur Google.',
    'edit.user_details.%name%' => '%name%',
    'user.edit_details' => 'Détails',
    'new.version.release' => 'Une nouvelle version est disponible !',
    'no_valid_class_found' => 'Aucune classe valide disponible !',
    'duplicated.custom.form.%name%' => 'Le formulaire personnalisé «%name%» a bien été dupliqué',
    'impossible.duplicate.custom.form.%name%' => 'Impossible de dupliquer le formulaire personnalisé «%name%»',
    'customForm.duplicate' => 'Dupliquer',
    'transtype' => 'Transtyper',
    'transtype.node' => 'Transtyper le nœud',
    'transtype_will_copy_data_from_fields_existing_in_both_types_not_others' => 'L’opération de transtypage essaiera de préserver les contenus similaires en les copiant d’un type à l’autre. Le reste sera supprimé.',
    'transtype.a.node' => 'Transtyper un nœud',
    '%node%.transtyped_to.%type%' => 'Le nœud « %node% » a été transtypé en %type%.',
    'add_all' => 'Tout ajouter',
    'add.multiple.tags' => 'Ajouter plusieurs étiquettes',
    'write.every.tags.names.comma.separated' => 'Notez le nom de chaque étiquette à créer en les séparant par des virgules.',
    'tags.names' => 'Noms des étiquettes',
    'add.tags' => 'Ajouter des étiquettes',
    'download.raw.document' => 'Télécharger le document non traité',
    'document.raw_document' => 'Document non traité',
    'export_format.rzn' => 'Format de fichier RZN',
    'export_format.excel.%language%' => 'Format de fichier Excel (%language%)',
    'delete.tags' => 'Supprimer les étiquettes',
    'are_you_sure.delete.these.tags' => 'Êtes-vous sûr(e) de vouloir supprimer ces étiquettes ?',
    'bulk.delete.tags' => 'Supprimer les étiquettes sélectionnées',
    'tags.bulk.deleted' => 'Les étiquettes sélectionnées ont été supprimées',
    'tag.childrenOrder' => 'Les étiquettes enfantes sont ordonnées par',
    'tag.childrenOrderDirection' => 'Direction de l’ordre des étiquettes enfantes',
    'node.%name%.status_changed_to.%status%' => 'Le statut du nœud « %name% »a été changé à : %status%.',
    'node.%name%.visibility_changed_to.%visible%' => 'La visibilité du nœud « %name% » a été changée à : %visible%.',
    'cookie_choice.consent_message' => 'En poursuivant votre navigation sur ce site, vous acceptez l’utilisation de cookies à des fins de mesures d’audience.',
    'cookie_choice.close_message' => 'Fermer',
    'cookie_choice.find_out_more_message' => 'En savoir plus',
    'no_javascript_message' => 'JavaScript est désactivé sur votre navigateur ou celui-ci ne supporte pas cette technologie. Veuillez l\'activez ou mettre à jour votre navigateur pour une meilleure expérience de navigation.',
    'browser_update.message' => 'Votre navigateur est périmé. Il contient des failles de sécurité et pourrait ne pas afficher certaines fonctionalités de ce site internet.',
    'browser_update.link' => 'Découvrez comment mettre votre navigateur à jour',
    'error404.title' => 'Erreur 404',
    'error404.message' => 'Page introuvable.',
    'language' => 'Langues',
    'back.to.site' => 'Retour au site',
    'back.to.homepage' => 'Retour à l\'accueil',
    'reset_filters' => 'Réinitialiser',
    'filters' => 'Filtres',
    'emag' => 'Emag',
    'pdf' => 'Communiqués',
    'video' => 'Vidéo',
    'diaporama' => 'Diaporama',
    'your_search' => 'Votre recherche',
    'more_issues' => 'Plus de publications',
    'no_issues' => 'Pas de publications',
    'issue.click.title' => 'Clic publication',
    'back_to_top' => 'Haut',
    'ext_link' => 'Liens externes',
    'search.results' => '{1}<span class="search-results-number">1</span><span class="search-results-title-text">Résultat de recherche</span> |]1,Inf]<span class="search-results-number">%count%</span><span class="search-results-title-text">Résultats de recherche</span>',
    'no.search.results' => 'Pas de résultats',
    'create.a.issue' => 'Créer une parution',
    'create.issue' => 'Créer la parution',
    'issues' => 'Parutions',
    'edit.issue' => 'Éditer',
    'back_to.issues' => 'Retour aux parutions',
  ),
));


return $catalogue;
