<?php

use Symfony\Component\Routing\Exception\MethodNotAllowedException;
use Symfony\Component\Routing\Exception\ResourceNotFoundException;
use Symfony\Component\Routing\RequestContext;

/**
 * StaticUrlMatcher.
 *
 * This class has been auto-generated
 * by the Symfony Routing Component.
 */
class StaticUrlMatcher extends Symfony\Component\Routing\Matcher\UrlMatcher
{
    /**
     * Constructor.
     */
    public function __construct(RequestContext $context)
    {
        $this->context = $context;
    }

    public function match($pathinfo)
    {
        $allow = array();
        $pathinfo = rawurldecode($pathinfo);
        $context = $this->context;
        $request = $this->request;

        // installHomePage
        if ($pathinfo === '/') {
            return array (  '_controller' => 'Themes\\Install\\InstallApp::indexAction',  '_route' => 'installHomePage',);
        }

        if (0 === strpos($pathinfo, '/install')) {
            // installHomePageRedirect
            if ($pathinfo === '/install') {
                return array (  '_controller' => 'Themes\\Install\\InstallApp::redirectIndexAction',  '_route' => 'installHomePageRedirect',);
            }

            // installCheckPage
            if ($pathinfo === '/install/check-requirements') {
                return array (  '_controller' => 'Themes\\Install\\InstallApp::requirementsAction',  '_route' => 'installCheckPage',);
            }

            if (0 === strpos($pathinfo, '/install/database')) {
                // installDatabasePage
                if ($pathinfo === '/install/database') {
                    return array (  '_controller' => 'Themes\\Install\\Controllers\\DatabaseController::databaseAction',  '_route' => 'installDatabasePage',);
                }

                // installDatabaseSchemaPage
                if ($pathinfo === '/install/database/schema') {
                    return array (  '_controller' => 'Themes\\Install\\Controllers\\DatabaseController::databaseSchemaAction',  '_route' => 'installDatabaseSchemaPage',);
                }

                // installDatabaseFixturesPage
                if ($pathinfo === '/install/database/fixtures') {
                    return array (  '_controller' => 'Themes\\Install\\Controllers\\DatabaseController::databaseFixturesAction',  '_route' => 'installDatabaseFixturesPage',);
                }

            }

            if (0 === strpos($pathinfo, '/install/import')) {
                // installImportSettings
                if (0 === strpos($pathinfo, '/install/import/settings') && preg_match('#^/install/import/settings(?:/(?P<themeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportSettings')), array (  '_controller' => 'RZ\\Roadiz\\CMS\\Controllers\\ImportController::importSettingsAction',  'themeId' => NULL,));
                }

                // installImportGroups
                if (0 === strpos($pathinfo, '/install/import/groups') && preg_match('#^/install/import/groups(?:/(?P<themeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportGroups')), array (  '_controller' => 'RZ\\Roadiz\\CMS\\Controllers\\ImportController::importGroupsAction',  'themeId' => NULL,));
                }

                // installImportRoles
                if (0 === strpos($pathinfo, '/install/import/roles') && preg_match('#^/install/import/roles(?:/(?P<themeId>[0-9]+))?$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportRoles')), array (  '_controller' => 'RZ\\Roadiz\\CMS\\Controllers\\ImportController::importRolesAction',  'themeId' => NULL,));
                }

                if (0 === strpos($pathinfo, '/install/import/node')) {
                    // installImportNodes
                    if (0 === strpos($pathinfo, '/install/import/nodes') && preg_match('#^/install/import/nodes(?:/(?P<themeId>[^/]++))?$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportNodes')), array (  '_controller' => 'RZ\\Roadiz\\CMS\\Controllers\\ImportController::importNodesAction',  'themeId' => NULL,));
                    }

                    // installImportNodeTypes
                    if (0 === strpos($pathinfo, '/install/import/nodetypes') && preg_match('#^/install/import/nodetypes/(?P<themeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportNodeTypes')), array (  '_controller' => 'RZ\\Roadiz\\CMS\\Controllers\\ImportController::importNodeTypesAction',));
                    }

                }

                if (0 === strpos($pathinfo, '/install/import/t')) {
                    // installImportTags
                    if (0 === strpos($pathinfo, '/install/import/tags') && preg_match('#^/install/import/tags/(?P<themeId>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportTags')), array (  '_controller' => 'RZ\\Roadiz\\CMS\\Controllers\\ImportController::importTagsAction',));
                    }

                    // installImportThemePage
                    if (0 === strpos($pathinfo, '/install/import/theme') && preg_match('#^/install/import/theme/(?P<id>[0-9]+)$#s', $pathinfo, $matches)) {
                        return $this->mergeDefaults(array_replace($matches, array('_route' => 'installImportThemePage')), array (  '_controller' => 'Themes\\Install\\Controllers\\ThemeController::importThemeAction',));
                    }

                }

            }

            if (0 === strpos($pathinfo, '/install/user')) {
                // installUserPage
                if ($pathinfo === '/install/user') {
                    return array (  '_controller' => 'Themes\\Install\\InstallApp::userAction',  '_route' => 'installUserPage',);
                }

                // installUserSummaryPage
                if (0 === strpos($pathinfo, '/install/user/summary') && preg_match('#^/install/user/summary/(?P<userId>[0-9]+)$#s', $pathinfo, $matches)) {
                    return $this->mergeDefaults(array_replace($matches, array('_route' => 'installUserSummaryPage')), array (  '_controller' => 'Themes\\Install\\InstallApp::userSummaryAction',));
                }

            }

            if (0 === strpos($pathinfo, '/install/themes')) {
                // installThemesPage
                if ($pathinfo === '/install/themes') {
                    return array (  '_controller' => 'Themes\\Install\\Controllers\\ThemeController::themesAction',  '_route' => 'installThemesPage',);
                }

                // installThemeSummaryPage
                if ($pathinfo === '/install/themes/summary') {
                    return array (  '_controller' => 'Themes\\Install\\Controllers\\ThemeController::themeSummaryAction',  '_route' => 'installThemeSummaryPage',);
                }

                // installThemeBasePage
                if ($pathinfo === '/install/themes/base') {
                    return array (  '_controller' => 'Themes\\Install\\Controllers\\ThemeController::themeInstallAction',  '_route' => 'installThemeBasePage',);
                }

            }

            if (0 === strpos($pathinfo, '/install/done')) {
                // installDonePage
                if ($pathinfo === '/install/done') {
                    return array (  '_controller' => 'Themes\\Install\\InstallApp::doneAction',  '_route' => 'installDonePage',);
                }

                // installAfterDonePage
                if ($pathinfo === '/install/done/end') {
                    return array (  '_controller' => 'Themes\\Install\\InstallApp::afterDoneAction',  '_route' => 'installAfterDonePage',);
                }

            }

            // installFailedPage
            if ($pathinfo === '/install/failed') {
                return array (  '_controller' => 'Themes\\Install\\InstallApp::failedAction',  '_route' => 'installFailedPage',);
            }

            // installClearCacheSchema
            if ($pathinfo === '/install/clear-cache') {
                return array (  '_controller' => 'Themes\\Install\\Controllers\\DatabaseController::clearDoctrineCacheAction',  '_route' => 'installClearCacheSchema',);
            }

            // installUpdateSchema
            if ($pathinfo === '/install/update') {
                return array (  '_controller' => 'Themes\\Install\\Controllers\\DatabaseController::updateSchemaAction',  '_route' => 'installUpdateSchema',);
            }

        }

        // removeTrailingSlash
        if (preg_match('#^/(?P<url>.*/)$#s', $pathinfo, $matches)) {
            if (!in_array($this->context->getMethod(), array('GET', 'HEAD'))) {
                $allow = array_merge($allow, array('GET', 'HEAD'));
                goto not_removeTrailingSlash;
            }

            return $this->mergeDefaults(array_replace($matches, array('_route' => 'removeTrailingSlash')), array (  '_controller' => 'Themes\\Install\\InstallApp::removeTrailingSlashAction',));
        }
        not_removeTrailingSlash:

        throw 0 < count($allow) ? new MethodNotAllowedException(array_unique($allow)) : new ResourceNotFoundException();
    }
}
