<?php
/**
 * Copyright REZO ZERO 2014
 *
 *
 *
 * @file NodeServiceProvider.php
 * @copyright REZO ZERO 2014
 * @author Ambroise Maupate
 */
namespace Themes\KiosqueTheme\Services;

use Pimple\Container;
use Pimple\ServiceProviderInterface;
use RZ\Roadiz\Core\Entities\Translation;

/**
 * Node services.
 */
class NodeServiceProvider implements ServiceProviderInterface
{
    protected $translation;
    protected $coreServices;

    public function __construct(Container $coreServices, Translation $translation = null)
    {
        $this->coreServices = $coreServices;
        $this->translation = $translation;
    }

    /**
     * @param Pimple\Container $container
     */
    public function register(Container $container)
    {
        $container['nodeSourceFooter'] = function ($c) {
            if ($this->translation === null) {
                $this->translation = $this->coreServices['em']
                     ->getRepository('RZ\Roadiz\Core\Entities\Translation')
                     ->findDefault();
            }

            return $this->coreServices['nodeSourceApi']
                        ->getOneBy([
                            'node.nodeType.name' => 'KiosqueFooter',
                            'translation' => $this->translation
                        ]);
        };

        return $container;
    }
}
